/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CapitalTypeEnum;
import com.kingdee.eas.fi.cas.CasContrastGLInfo;
import com.kingdee.eas.fi.cas.CashBankContrastGLFactory;
import com.kingdee.eas.fi.cas.ICashBankContrastGL;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;

public class CashContrastGLSumUIHandler {
    private final String[] rowKeys = new String[]{"beginBalance", "debitAmount", "creditAmount", "endBalance"};
    private final String[] columnKeys = new String[]{"cashMgmt", "glMgmt", "diffAmt", "bankStatBal"};
    private final String[] keys = new String[]{"byCAS", "byGL", "byDiff", "byBal"};
    private static final String resource = "com.kingdee.eas.fi.cas.CasResources";

    public void loadField(KDTable table, Set<String> companySet, CurrencyInfo currency, PeriodInfo period, boolean cancleAccountBank, boolean unBalance, boolean unTranVoucher) throws BOSException, EASBizException {
        table.checkParsed();
        table.removeRows();
        this.setTableStyleAttributes(table, currency);
        ICashBankContrastGL iCashGL = CashBankContrastGLFactory.getRemoteInstance();
        Map result = iCashGL.getAllBankAcctCasContrastGLSumData(companySet, currency, period, cancleAccountBank, unBalance, unTranVoucher);
        Map data = (Map)result.get("data");
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companySet.size()];
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo companyInfo = coll.get(i);
            Map acctViewMap = (Map)result.get(companyInfo.getId().toString() + "_acctView");
            for (String key : acctViewMap.keySet()) {
                Map tmp = (Map)acctViewMap.get(key);
                IRow row = table.addRow();
                row.getCell("companyID").setValue((Object)companyInfo.getId().toString());
                row.getCell("capitalTypeEnum").setValue((Object)CapitalTypeEnum.CASH);
                row.getCell("companyName").setValue((Object)companyInfo.getName());
                AccountViewInfo info = (AccountViewInfo)data.get(key);
                row.getCell("ID").setValue((Object)info.getId().toString());
                row.getCell("acctView").setValue((Object)info.getName());
                CasContrastGLInfo casContrastGLInfo = null;
                casContrastGLInfo = (CasContrastGLInfo)((Object)tmp.get(this.keys[0]));
                BigDecimal amount = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                row.getCell("cash_beginBalance").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                row.getCell("cash_debitAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                row.getCell("cash_creditAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                row.getCell("cash_endBalance").setValue((Object)this.getBigDecimal(amount));
                casContrastGLInfo = (CasContrastGLInfo)((Object)tmp.get(this.keys[1]));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                row.getCell("general_beginBalance").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                row.getCell("general_debitAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                row.getCell("general_creditAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                row.getCell("general_endBalance").setValue((Object)this.getBigDecimal(amount));
                boolean isBalance = true;
                casContrastGLInfo = (CasContrastGLInfo)((Object)tmp.get(this.keys[2]));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                if (amount != null && amount.compareTo(new BigDecimal("0")) != 0) {
                    isBalance = false;
                }
                row.getCell("dif_beginBalance").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                if (amount != null && amount.compareTo(new BigDecimal("0")) != 0) {
                    isBalance = false;
                }
                row.getCell("dif_debitAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                if (amount != null && amount.compareTo(new BigDecimal("0")) != 0) {
                    isBalance = false;
                }
                row.getCell("dif_creditAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                if (amount != null && amount.compareTo(new BigDecimal("0")) != 0) {
                    isBalance = false;
                }
                row.getCell("dif_endBalance").setValue((Object)this.getBigDecimal(amount));
                if (isBalance) {
                    row.getCell("result").setValue((Object)EASResource.getString((String)resource, (String)"balance"));
                    if (!unBalance) continue;
                    row.getStyleAttributes().setHided(true);
                    continue;
                }
                row.getCell("result").setValue((Object)EASResource.getString((String)resource, (String)"unBalance"));
            }
            Map acctMap = (Map)result.get(companyInfo.getId().toString() + "_acct");
            for (String key : acctMap.keySet()) {
                Map tmp = (Map)acctMap.get(key);
                IRow row = table.addRow();
                row.getCell("companyID").setValue((Object)companyInfo.getId().toString());
                row.getCell("capitalTypeEnum").setValue((Object)CapitalTypeEnum.BANK);
                row.getCell("companyName").setValue((Object)companyInfo.getName());
                AccountBankInfo info = (AccountBankInfo)data.get(key);
                row.getCell("bank").setValue((Object)info.getBank().getName());
                row.getCell("bankAcct").setValue((Object)info.getName());
                row.getCell("ID").setValue((Object)info.getId().toString());
                if (tmp.containsKey("actualAcctBank") && CheckUtils.same((Object)info, tmp.get("actualAcctBank"))) {
                    row.getCell("acctView").setValue(ConvertUtils.PROPL((String)"actualAcctBank.account.name", (Object)tmp));
                } else {
                    row.getCell("acctView").setValue((Object)info.getAccount().getName());
                }
                CasContrastGLInfo casContrastGLInfo = null;
                casContrastGLInfo = (CasContrastGLInfo)((Object)tmp.get(this.keys[0]));
                BigDecimal amount = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                row.getCell("cash_beginBalance").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                row.getCell("cash_debitAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                row.getCell("cash_creditAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                row.getCell("cash_endBalance").setValue((Object)this.getBigDecimal(amount));
                casContrastGLInfo = (CasContrastGLInfo)((Object)tmp.get(this.keys[1]));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                row.getCell("general_beginBalance").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                row.getCell("general_debitAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                row.getCell("general_creditAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                row.getCell("general_endBalance").setValue((Object)this.getBigDecimal(amount));
                boolean isBalance = true;
                casContrastGLInfo = (CasContrastGLInfo)((Object)tmp.get(this.keys[2]));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                if (amount != null && amount.compareTo(new BigDecimal("0")) != 0) {
                    isBalance = false;
                }
                row.getCell("dif_beginBalance").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                if (amount != null && amount.compareTo(new BigDecimal("0")) != 0) {
                    isBalance = false;
                }
                row.getCell("dif_debitAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                if (amount != null && amount.compareTo(new BigDecimal("0")) != 0) {
                    isBalance = false;
                }
                row.getCell("dif_creditAmount").setValue((Object)this.getBigDecimal(amount));
                amount = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                if (amount != null && amount.compareTo(new BigDecimal("0")) != 0) {
                    isBalance = false;
                }
                row.getCell("dif_endBalance").setValue((Object)this.getBigDecimal(amount));
                if (isBalance) {
                    row.getCell("result").setValue((Object)EASResource.getString((String)resource, (String)"balance"));
                    if (!unBalance) continue;
                    row.getStyleAttributes().setHided(true);
                    continue;
                }
                row.getCell("result").setValue((Object)EASResource.getString((String)resource, (String)"unBalance"));
            }
        }
    }

    private void setTableStyleAttributes(KDTable table, CurrencyInfo currency) {
        String numberFmt = "00.00";
        numberFmt = FMClientHelper.getNumberFtm((BOSUuid)currency.getId());
        table.getColumn("cash_beginBalance").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("cash_debitAmount").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("cash_creditAmount").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("cash_endBalance").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("cash_beginBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("cash_debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("cash_creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("cash_endBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("general_beginBalance").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("general_debitAmount").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("general_creditAmount").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("general_endBalance").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("general_beginBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("general_debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("general_creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("general_endBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("dif_beginBalance").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("dif_debitAmount").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("dif_creditAmount").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("dif_endBalance").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("dif_beginBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("dif_debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("dif_creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("dif_endBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("result").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
    }

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? new BigDecimal("0") : big;
    }
}

