/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class CashCountFilterParam
implements FilterParam {
    private static final long serialVersionUID = 3667783506422710448L;
    private String currencyId;
    private boolean isFrozenAccount;
    private Date beginDate;
    private Date endDate;
    private boolean isByDate;

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isByDate() {
        return this.isByDate;
    }

    public void setByDate(boolean isByDate) {
        this.isByDate = isByDate;
    }

    public boolean isFrozenAccount() {
        return this.isFrozenAccount;
    }

    public void setFrozenAccount(boolean isFrozenAccount) {
        this.isFrozenAccount = isFrozenAccount;
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        items.add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
        if (!EmptyUtil.isEmpty((Object)this.beginDate)) {
            items.add(new FilterItemInfo("countedDate", (Object)DateTimeUtils.truncateDate((Date)this.beginDate), CompareType.GREATER_EQUALS));
        }
        if (!EmptyUtil.isEmpty((Object)this.endDate)) {
            items.add(new FilterItemInfo("countedDate", (Object)DateTimeUtils.truncateDate((Date)this.endDate), CompareType.LESS_EQUALS));
        }
        if (!this.isFrozenAccount) {
            items.add(new FilterItemInfo("account.isCFreeze", (Object)"0"));
            items.add(new FilterItemInfo("account.isGFreeze", (Object)"0"));
        }
        if (this.getCurrencyId() != null) {
            items.add(new FilterItemInfo("currency.id", (Object)this.getCurrencyId()));
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection items = new SorterItemCollection();
        if (this.isByDate) {
            items.add(new SorterItemInfo("counteddate"));
            items.add(new SorterItemInfo("account.number"));
        } else {
            items.add(new SorterItemInfo("account.number"));
            items.add(new SorterItemInfo("counteddate"));
        }
        return items;
    }
}

