/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTAbstractAction;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.DenominationCollection;
import com.kingdee.eas.basedata.assistant.DenominationFactory;
import com.kingdee.eas.basedata.assistant.DenominationInfo;
import com.kingdee.eas.basedata.assistant.IDenomination;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashCountCollection;
import com.kingdee.eas.fi.cas.CashCountEntryCollection;
import com.kingdee.eas.fi.cas.CashCountEntryInfo;
import com.kingdee.eas.fi.cas.CashCountFactory;
import com.kingdee.eas.fi.cas.CashCountInfo;
import com.kingdee.eas.fi.cas.ICashCount;
import com.kingdee.eas.fi.cas.client.AbstractCashCountUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CashCountUI
extends AbstractCashCountUI {
    protected static final String STATUS_COPY = "COPY";
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    private static BigDecimal HUNDRED = new BigDecimal("100");
    private static BigDecimal TWENTY = new BigDecimal("20");
    private static BigDecimal BD_ZERO = new BigDecimal("0");
    private static int CELLDENOMINATION = 0;
    private static int CELLHUNDREDS = 1;
    private static int CELLTWENTIES = 2;
    private static int CELLMANTISSA = 3;
    private static int CELLSUBTOTAL = 4;
    public final String SUBTOTAL_COL = "subTotal";
    public final String HUNDREDS_COL = "hundreds";
    public final String TWENTIES_COL = "twenties";
    public final String MANTISSA_COL = "Mantissa";
    private BigDecimal _countAmount = BD_ZERO;

    @Override
    public void loadFields() {
        if (this.editData == null) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = this.editData.getCompany();
        this.bizPromptCompany.setData((Object)this.editData.getCompany());
        if (companyInfo.getInvalidDate() != null && companyInfo.getInvalidDate().before(new Date())) {
            this.setBtnsStatus(false);
        }
        this.dateCountedDate.setValue((Object)this.editData.getCountedDate());
        this.txtComment.setText(this.editData.getComment());
        if (this.getOprtState().equalsIgnoreCase(STATUS_COPY)) {
            this.removeOldDataIDs(this.editData);
            UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            this.editData.setCounter(userInfo);
            this.setOprtState(OprtState.ADDNEW);
        }
        if (this.editData.getAccount() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboAccount, (Object)this.editData.getAccount());
            if (this.editData.getAccount().isIsCFreeze() || this.editData.getAccount().isIsGFreeze()) {
                this.setBtnsStatus(false);
            }
        }
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        }
        if (this.editData.getCounter() != null) {
            this.txtCounter.setUserObject((Object)this.editData.getCounter());
            this.txtCounter.setText(this.editData.getCounter().getName());
        }
        this._countAmount = this.editData.getSubTotal();
        this.bindDataToTable(this.kdtEntries, (IObjectCollection)this.editData.getEntries());
        this.formatAmtCells();
        if (this.comboCurrency.getSelectedItem() != null && "ADDNEW".equals(this.getOprtState()) && this.kdtEntries.getRowCount() < 1) {
            CurrencyInfo currInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            try {
                this.setDenomination(currInfo.getId(), true);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.appendAmountRow();
        this.sum();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public IObjectValue createNewData() {
        CashCountInfo countInfo = new CashCountInfo();
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        countInfo.setCompany(companyInfo);
        countInfo.setCounter(userInfo);
        countInfo.setCountedDate(DateTimeUtils.truncateDate((Date)new Date(System.currentTimeMillis())));
        if (companyInfo.getBaseCurrency() != null) {
            countInfo.setCurrency(companyInfo.getBaseCurrency());
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isCash", (Object)"1"));
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
        items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        items.add(new FilterItemInfo("CompanyID", (Object)companyInfo.getId().toString()));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4");
        try {
            AccountViewCollection accounts = AccountUtils.getAccountViewCByCompany(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (FilterInfo)filter);
            if (accounts != null && !accounts.isEmpty()) {
                countInfo.setAccount(accounts.get(0));
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return countInfo;
    }

    public ICoreBase getBizInterface() throws BOSException {
        ICashCount iCashCount = CashCountFactory.getRemoteInstance();
        return iCashCount;
    }

    private void setDenomination(BOSUuid oCurrencyId, boolean fOnLoad) throws BOSException {
        String sCurrencyId = "";
        if (oCurrencyId == null) {
            return;
        }
        sCurrencyId = oCurrencyId.toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)sCurrencyId));
        filter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)"0"));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("coefficient");
        sorterItemInfo.setSortType(SortType.DESCEND);
        entityView.getSorter().add(sorterItemInfo);
        IDenomination iDenomination = DenominationFactory.getRemoteInstance();
        DenominationCollection denominationColl = iDenomination.getDenominationCollection(entityView);
        this.kdtEntries.removeRows();
        if (denominationColl == null || denominationColl.size() == 0) {
            this.setBtnsStatus(false);
            return;
        }
        this.setBtnsStatus(true);
        BigDecimal oCoefficient = BD_ZERO;
        DenominationInfo denominationInfo = null;
        IRow row = null;
        int iSize = denominationColl.size();
        for (int i = 0; i < iSize; ++i) {
            denominationInfo = denominationColl.get(i);
            row = this.kdtEntries.addRow(i);
            row.getCell(CELLDENOMINATION).setValue((Object)denominationInfo.getValue());
            row.getCell(0).setUserObject((Object)denominationInfo);
            oCoefficient = denominationInfo.getCoefficient();
            CashCountEntryInfo entryInfo = new CashCountEntryInfo();
            entryInfo.setDenominator(denominationInfo);
            row.setUserObject((Object)entryInfo);
            this.setUneditCells(row);
        }
        if (!fOnLoad) {
            this.appendAmountRow();
        }
    }

    private void setUneditCells(IRow row) {
        row.getCell(CELLDENOMINATION).getStyleAttributes().setLocked(true);
        row.getCell(CELLSUBTOTAL).getStyleAttributes().setLocked(true);
    }

    private void appendAmountRow() {
        IRow row = null;
        row = this.kdtEntries.addRow();
        row.getCell(CELLDENOMINATION).setValue((Object)EASResource.getString((String)resourcePath, (String)"CashCountAmountLabel"));
        row.getStyleAttributes().setLocked(true);
    }

    protected void calcSubtotal(int iRowIndex, BigDecimal oCoefficient) {
        IRow row = this.kdtEntries.getRow(iRowIndex);
        BigDecimal oHundredAmount = BD_ZERO;
        BigDecimal oTwentyAmount = BD_ZERO;
        BigDecimal oMantissaAmount = BD_ZERO;
        BigDecimal oSubtotal = BD_ZERO;
        if (row.getCell(CELLHUNDREDS).getValue() != null) {
            oHundredAmount = new BigDecimal(row.getCell(CELLHUNDREDS).getValue().toString()).multiply(oCoefficient).multiply(HUNDRED);
        }
        if (row.getCell(CELLTWENTIES).getValue() != null) {
            oTwentyAmount = new BigDecimal(row.getCell(CELLTWENTIES).getValue().toString()).multiply(oCoefficient).multiply(TWENTY);
        }
        if (row.getCell(CELLMANTISSA).getValue() != null) {
            oMantissaAmount = new BigDecimal(row.getCell(CELLMANTISSA).getValue().toString()).multiply(oCoefficient);
        }
        if (oHundredAmount != null) {
            oSubtotal = oSubtotal.add(oHundredAmount);
        }
        if (oTwentyAmount != null) {
            oSubtotal = oSubtotal.add(oTwentyAmount);
        }
        if (oMantissaAmount != null) {
            oSubtotal = oSubtotal.add(oMantissaAmount);
        }
        if (oSubtotal.compareTo(BD_ZERO) == 1) {
            row.getCell(CELLSUBTOTAL).setValue((Object)oSubtotal.setScale(this.getScale(), 4));
        } else {
            row.getCell(CELLSUBTOTAL).setValue((Object)CasConstants.ZERO);
        }
        this.sum();
    }

    private void sum() {
        IRow row = null;
        BigDecimal oAmount = BD_ZERO;
        int iRows = this.kdtEntries.getRowCount();
        BigDecimal oRowAmount = BD_ZERO;
        int n = iRows - 1;
        for (int i = 0; i < n; ++i) {
            row = this.kdtEntries.getRow(i);
            if (row.getCell(CELLSUBTOTAL).getValue() == null) continue;
            oRowAmount = new BigDecimal(row.getCell(CELLSUBTOTAL).getValue().toString());
            oAmount = oAmount.add(oRowAmount);
        }
        if (oAmount.compareTo(BD_ZERO) == 1) {
            this.kdtEntries.getRow(iRows - 1).getCell(CELLSUBTOTAL).setValue((Object)oAmount.setScale(this.getScale(), 4));
            this._countAmount = oAmount;
        } else {
            this.kdtEntries.getRow(iRows - 1).getCell(CELLSUBTOTAL).setValue(null);
            this._countAmount = BD_ZERO;
        }
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getKey();
            if (StringUtils.isEmpty((String)bindField) || bindField.indexOf(".") != -1) continue;
            if (row.getCell(i).getValue() != null) {
                obj.put(bindField, row.getCell(i).getValue());
                continue;
            }
            obj.put(bindField, (Object)CasConstants.ZERO);
        }
    }

    protected void bindTableToData(KDTable table, IObjectCollection collection) {
        collection.clear();
        int n = table.getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            IRow row = table.getRow(i);
            Object obj = (IObjectValue)row.getUserObject();
            if (obj == null) {
                obj = new CashCountEntryInfo();
            }
            if (!collection.addObject(obj)) continue;
            this.storeLineFields(table, row, (IObjectValue)obj);
        }
    }

    protected void bindDataToTable(KDTable table, IObjectCollection collection) {
        if (collection == null) {
            return;
        }
        table.setUserObject((Object)collection);
        table.removeRows();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue obj = collection.getObject(i);
            IRow row = table.addRow(i);
            this.loadLineFields(table, row, obj);
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getKey();
            if (StringUtils.isEmpty((String)bindField)) continue;
            if (bindField.indexOf(".") >= 0) {
                if (((CashCountEntryInfo)obj).getDenominator() == null) continue;
                row.getCell(i).setValue((Object)((CashCountEntryInfo)obj).getDenominator().getValue());
                row.getCell(i).setUserObject((Object)((CashCountEntryInfo)obj).getDenominator());
                continue;
            }
            if (obj.get(bindField) == null) continue;
            row.getCell(i).setValue(obj.get(bindField));
        }
        this.setUneditCells(row);
    }

    @Override
    public void storeFields() {
        if (this.editData == null) {
            return;
        }
        this.editData.setCompany((CompanyOrgUnitInfo)this.bizPromptCompany.getData());
        this.editData.setCountedDate(DateTimeUtils.truncateDate((Date)((Date)this.dateCountedDate.getValue(Date.class))));
        this.editData.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
        this.editData.setComment(this.txtComment.getText());
        this.editData.setSubTotal(this._countAmount);
        if (this.comboAccount.getSelectedItem() != null) {
            AccountViewInfo view = (AccountViewInfo)this.comboAccount.getSelectedItem();
            this.editData.setAccount(view);
        }
        this.bindTableToData(this.kdtEntries, (IObjectCollection)this.editData.getEntries());
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        this.onTableValueChanged(e.getRowIndex(), e.getColIndex());
    }

    protected void onTableValueChanged(int iRow, int iCol) {
        IRow eventRow = this.kdtEntries.getRow(iRow);
        if (eventRow.getCell(CELLDENOMINATION).getUserObject() != null) {
            try {
                int iVal;
                Object editVal = eventRow.getCell(iCol).getValue();
                if (editVal != null && (iVal = Integer.parseInt(editVal.toString())) < 0) {
                    eventRow.getCell(iCol).setValue((Object)CasConstants.ZERO);
                }
            }
            catch (NumberFormatException ex) {
                eventRow.getCell(iCol).setValue(null);
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                this.showMessage();
            }
            DenominationInfo denominationInfo = (DenominationInfo)eventRow.getCell(CELLDENOMINATION).getUserObject();
            if (denominationInfo.getCoefficient() != null) {
                this.calcSubtotal(iRow, denominationInfo.getCoefficient());
            }
        }
    }

    public CashCountInfo getPrevCashCounInfo() throws Exception {
        CashCountInfo countInfo = null;
        if (this.comboCurrency.getSelectedItem() != null && this.comboAccount.getSelectedItem() != null && this.bizPromptCompany.getData() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.bizPromptCompany.getData();
            items.add(new FilterItemInfo("company", (Object)companyInfo.getId().toString()));
            CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            items.add(new FilterItemInfo("currency", (Object)currencyInfo.getId().toString()));
            AccountViewInfo accountInfo = (AccountViewInfo)this.comboAccount.getSelectedItem();
            items.add(new FilterItemInfo("account", (Object)accountInfo.getId().toString()));
            items.add(new FilterItemInfo("counteddate", (Object)this.dateCountedDate.getSqlDate().toString(), CompareType.LESS));
            view.setFilter(filter);
            SorterItemInfo sorter = new SorterItemInfo("counteddate");
            sorter.setSortType(SortType.DESCEND);
            view.getSorter().add(sorter);
            SelectorItemCollection selectors = view.getSelector();
            selectors.add(new SelectorItemInfo("countedDate"));
            selectors.add(new SelectorItemInfo("company.id"));
            selectors.add(new SelectorItemInfo("company.name"));
            selectors.add(new SelectorItemInfo("company.number"));
            selectors.add(new SelectorItemInfo("account.id"));
            selectors.add(new SelectorItemInfo("account.number"));
            selectors.add(new SelectorItemInfo("account.name"));
            selectors.add(new SelectorItemInfo("account.currencyID"));
            selectors.add(new SelectorItemInfo("currency.id"));
            selectors.add(new SelectorItemInfo("currency.name"));
            selectors.add(new SelectorItemInfo("entries.hundreds"));
            selectors.add(new SelectorItemInfo("entries.twenties"));
            selectors.add(new SelectorItemInfo("entries.Mantissa"));
            selectors.add(new SelectorItemInfo("entries.subTotal"));
            selectors.add(new SelectorItemInfo("entries.denominator.id"));
            selectors.add(new SelectorItemInfo("entries.denominator.value"));
            selectors.add(new SelectorItemInfo("entries.denominator.coefficient"));
            ICashCount iCashCount = CashCountFactory.getRemoteInstance();
            CashCountCollection coll = iCashCount.getCashCountCollection(view);
            if (coll != null && coll.size() >= 1) {
                countInfo = coll.get(0);
                this.sortFormEntries(countInfo);
                this.removeOldDataIDs(countInfo);
            }
        }
        if (countInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CashCount_NONE_PREV_INFO"));
            SysUtil.abort();
        }
        return countInfo;
    }

    private void removeOldDataIDs(CashCountInfo countInfo) {
        countInfo.remove("id");
        CashCountEntryCollection entries = countInfo.getEntries();
        int n = entries.size();
        for (int i = 0; i < n; ++i) {
            entries.get(i).remove("id");
            entries.get(i).remove("cashcount");
        }
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        IObjectValue value = super.getValue(pk);
        this.sortFormEntries((CashCountInfo)value);
        return value;
    }

    public void sortFormEntries(CashCountInfo info) {
        CashCountEntryCollection coll = info.getEntries();
        Object[] collAry = coll.toArray();
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                CashCountEntryInfo new01 = (CashCountEntryInfo)o1;
                CashCountEntryInfo new02 = (CashCountEntryInfo)o2;
                if (new01.getDenominator().getCoefficient() == null) {
                    new01.getDenominator().setCoefficient(BD_ZERO);
                }
                if (new02.getDenominator().getCoefficient() == null) {
                    new02.getDenominator().setCoefficient(BD_ZERO);
                }
                return new02.getDenominator().getCoefficient().compareTo(new01.getDenominator().getCoefficient());
            }
        };
        Arrays.sort(collAry, c);
        info.getEntries().clear();
        for (int i = 0; i < collAry.length; ++i) {
            info.getEntries().add((CashCountEntryInfo)collAry[i]);
        }
    }

    @Override
    public void actionGetPrevValue_actionPerformed(ActionEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null || this.comboAccount.getSelectedItem() == null || this.bizPromptCompany.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CashCount_Alert"));
            SysUtil.abort();
        }
        CashCountInfo countInfo = this.getPrevCashCounInfo();
        this.bizPromptCompany.setUserObject((Object)countInfo.getCompany());
        this.comboAccount.setSelectedItem((Object)countInfo.getAccount());
        this.comboCurrency.setSelectedItem((Object)countInfo.getCurrency());
        this.bindDataToTable(this.kdtEntries, (IObjectCollection)countInfo.getEntries());
        this.formatAmtCells();
        this.appendAmountRow();
        this.sum();
    }

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        this.btnCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.initUI();
        super.onLoad();
        this.kdtEntries.setActiveCellStatus(1);
        this.btnGetPrev.setIcon(EASResource.getIcon((String)"imgTbtn_getlastcheck"));
        this.kdtEntries.getActionMap().put("Delete", (Action)new KDTAbstractAction(this.kdtEntries){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == CashCountUI.this.kdtEntries) {
                    CashCountUI.this.kdtEntries.getEditHelper().delete();
                    KDTSelectManager sm = CashCountUI.this.kdtEntries.getSelectManager();
                    CashCountUI.this.onTableValueChanged(sm.getActiveRowIndex(), sm.getActiveColumnIndex());
                }
            }
        });
        this.actionPrint.setEnabled(true);
        this.actionCopy.setVisible(false);
        if (this.getOprtState().equals("VIEW")) {
            this.actionSubmit.setEnabled(false);
            this.actionSubmit.setVisible(false);
            this.btnSubmit.setVisible(false);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    private void initUI() throws Exception {
        ClientUtils.setCurrencyList(this.comboCurrency, false);
        ClientUtils.setCompanyF7(this.bizPromptCompany, (IUIObject)this, false);
        this.comboAccount.removeAllItems();
        AccountViewCollection accountCol = FMHelper.getAcctViewCollection((String)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString(), null, (AccountTypeEnum)AccountTypeEnum.CASHACCOUNT);
        if (accountCol == null || accountCol.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"NoAccountView"));
            SysUtil.abort();
        }
        this.comboAccount.addItems(accountCol.toArray());
        this.txtComment.setMaxLength(180);
        this.kdtEntries.getColumn("subTotal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (this.comboCurrency.getSelectedItem() != null) {
            FMClientHelper.setNumberFormat((KDTable)this.kdtEntries, (String)"subTotal", (String)((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        }
        this.kdtEntries.getColumn("hundreds").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn("twenties").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn("Mantissa").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField formattedPriceField = new KDFormattedTextField();
        formattedPriceField.setDataType(0);
        this.kdtEntries.getColumn("hundreds").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedPriceField));
        this.kdtEntries.getColumn("twenties").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedPriceField));
        this.kdtEntries.getColumn("Mantissa").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedPriceField));
    }

    private void formatAmtCells() {
        int colAmt = 4;
        Object amt = null;
        int scale = this.getScale();
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            amt = this.kdtEntries.getRow(i).getCell(colAmt).getValue();
            if (amt == null) continue;
            this.kdtEntries.getRow(i).getCell(colAmt).setValue((Object)((BigDecimal)amt).setScale(scale, 4));
        }
    }

    @Override
    protected void comboAccount_itemStateChanged(ItemEvent e) throws Exception {
        AccountViewInfo accountInfo = null;
        if (this.comboAccount.getSelectedItem() != null) {
            accountInfo = (AccountViewInfo)this.comboAccount.getSelectedItem();
            if (accountInfo.isIsCFreeze() || accountInfo.isIsGFreeze()) {
                this.btnSubmit.setEnabled(false);
            } else {
                this.btnSubmit.setEnabled(true);
            }
        }
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() != null) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            this.setDenomination(currencyInfo.getId(), false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.isCFreeze"));
        sic.add(new SelectorItemInfo("account.isGFreeze"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("counter.id"));
        sic.add(new SelectorItemInfo("counter.name"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.denominator.value"));
        sic.add(new SelectorItemInfo("entries.denominator.coefficient"));
        return sic;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.setPrintPage();
        this.kdtEntries.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.setPrintPage();
        this.kdtEntries.getPrintManager().printPreview();
    }

    private void setPrintPage() {
        String sCom = this.labCompany.getBoundLabelText() + "  " + ((CompanyOrgUnitInfo)this.bizPromptCompany.getData()).getName();
        String sDate = this.labCountedDate.getBoundLabelText() + "  " + this.dateCountedDate.getSqlDate();
        String sAcct = this.labAccount.getBoundLabelText() + "  " + ((AccountViewInfo)this.comboAccount.getSelectedItem()).toString();
        String sCurr = this.labCurrency.getBoundLabelText() + "  " + ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getName();
        String sRemark = this.labComment.getBoundLabelText() + "  " + this.txtComment.getText();
        String sCounter = this.labCounter.getBoundLabelText() + "  " + this.txtCounter.getText();
        HeadFootModel header = new HeadFootModel();
        header.addRow(sCom + "&|" + sDate);
        header.addRow(sAcct + "&|" + sCurr);
        HeadFootModel foot = new HeadFootModel();
        foot.addRow(sRemark + "&| &|");
        foot.addRow(sCounter + "&| &|");
        Page headP = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)header);
        Page footP = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)foot);
        this.kdtEntries.getPrintManager().setHeaderFooter(headP, footP);
    }

    private int getScale() {
        int scale = 0;
        if (this.comboCurrency.getSelectedItem() == null) {
            scale = 2;
        } else {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            scale = currencyInfo.getPrecision();
        }
        return scale;
    }

    private void setBtnsStatus(boolean fStatus) {
        this.actionSubmit.setEnabled(fStatus);
        this.actionCopy.setEnabled(fStatus);
        this.actionGetPrev.setEnabled(fStatus);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        IObjectPK pk = this.runSubmit();
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.setOprtState(OprtState.EDIT);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.editData.getComment() != null && this.editData.getComment().length() > 199) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"276_CashCountUI"));
            this.txtComment.requestFocus(true);
            SysUtil.abort();
        }
    }

    public boolean isModify() {
        if (!this.actionSubmit.isEnabled()) {
            return false;
        }
        return super.isModify();
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal result;
        CalculatorDialog calc = new CalculatorDialog((Container)((Object)this));
        int pre = 2;
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency != null) {
            pre = currency.getPrecision();
        }
        if ((result = calc.showDialog(pre, true)) == null) {
            return;
        }
        if (result.compareTo(FMConstants.MAX_VALUE) == 1) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.showMessage();
            return;
        }
        IRow row = this.kdtEntries.getRow(this.kdtEntries.getSelectManager().getActiveRowIndex());
        int activeColumnIndex = this.kdtEntries.getSelectManager().getActiveColumnIndex();
        if (row == null || activeColumnIndex == -1 || row.getCell(activeColumnIndex).getStyleAttributes().isLocked()) {
            return;
        }
        if (this.kdtEntries.getColumnKey(activeColumnIndex).equals("hundreds")) {
            if (result != null && result.compareTo(FMConstants.ZERO) != 0) {
                row.getCell("hundreds").setValue((Object)result);
            }
        } else if (this.kdtEntries.getColumnKey(activeColumnIndex).equals("twenties")) {
            if (result != null && result.compareTo(FMConstants.ZERO) != 0) {
                row.getCell("twenties").setValue((Object)result);
            }
        } else if (this.kdtEntries.getColumnKey(activeColumnIndex).equals("Mantissa") && result != null && result.compareTo(FMConstants.ZERO) != 0) {
            row.getCell("Mantissa").setValue((Object)result);
        }
        this.onTableValueChanged(this.kdtEntries.getSelectManager().getActiveRowIndex(), activeColumnIndex);
    }
}

