/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class CashJournalFilterParam
implements FilterParam {
    private static final long serialVersionUID = 641112222771911419L;
    private boolean isByDay;
    private int beginYear;
    private int endYear;
    private int beginMonth;
    private int endMonth;
    private Date fromDate;
    private Date toDate;
    private boolean isShowForbiddenAccount;
    private boolean isShowBeginBalance;
    private boolean isShowDayTotal;
    private boolean isShowMonthTotal;
    private boolean isShowYearTotal;
    private String acctTableId;

    public int getBeginMonth() {
        return this.beginMonth;
    }

    public void setBeginMonth(int beginMonth) {
        this.beginMonth = beginMonth;
    }

    public int getBeginYear() {
        return this.beginYear;
    }

    public void setBeginYear(int beginYear) {
        this.beginYear = beginYear;
    }

    public int getEndMonth() {
        return this.endMonth;
    }

    public void setEndMonth(int endMonth) {
        this.endMonth = endMonth;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public boolean isByDay() {
        return this.isByDay;
    }

    public void setByDay(boolean isByDay) {
        this.isByDay = isByDay;
    }

    public boolean isShowBeginBalance() {
        return this.isShowBeginBalance;
    }

    public void setShowBeginBalance(boolean isShowBeginBalance) {
        this.isShowBeginBalance = isShowBeginBalance;
    }

    public boolean isShowDayTotal() {
        return this.isShowDayTotal;
    }

    public void setShowDayTotal(boolean isShowDayTotal) {
        this.isShowDayTotal = isShowDayTotal;
    }

    public boolean isShowForbiddenAccount() {
        return this.isShowForbiddenAccount;
    }

    public void setShowForbiddenAccount(boolean isShowForbiddenAccount) {
        this.isShowForbiddenAccount = isShowForbiddenAccount;
    }

    public boolean isShowMonthTotal() {
        return this.isShowMonthTotal;
    }

    public void setShowMonthTotal(boolean isShowMonthTotal) {
        this.isShowMonthTotal = isShowMonthTotal;
    }

    public boolean isShowYearTotal() {
        return this.isShowYearTotal;
    }

    public void setShowYearTotal(boolean isShowYearTotal) {
        this.isShowYearTotal = isShowYearTotal;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1), CompareType.EQUALS));
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId(), CompareType.EQUALS));
        if (this.isByDay) {
            if (this.toDate != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("createDate", (Object)DateTimeUtils.truncateDate((Date)this.toDate), CompareType.LESS_EQUALS));
            }
            if (this.fromDate != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("createDate", (Object)DateTimeUtils.truncateDate((Date)this.fromDate), CompareType.GREATER_EQUALS));
            }
        } else {
            String periodTypeId = companyInfo.getAccountPeriodType().getId().toString();
            String sql = PeriodHelper.getPeriodCollSQL(periodTypeId, this.beginYear, this.beginMonth, this.endYear, this.endMonth);
            filterInfo.getFilterItems().add(new FilterItemInfo("period.id", (Object)sql, CompareType.INNER));
        }
        return filterInfo;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    public String getAcctTableId() {
        return this.acctTableId;
    }

    public void setAcctTableId(String acctTableId) {
        this.acctTableId = acctTableId;
    }
}

