/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashAccountTool;
import com.kingdee.eas.fi.cas.CashJournalFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.client.AbstractCashJournalFilterUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.CashJournalFilterParam;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CashJournalFilterUI
extends AbstractCashJournalFilterUI {
    private static Logger logger = Logger.getLogger((String)CashJournalFilterUI.class.getName());
    public static final String RESOURCEPATH = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    String actualAcctTableId = null;
    private Map paramMap;
    private Map verifyMap;

    public CashJournalFilterUI() throws Exception {
    }

    public CashJournalFilterUI(Map paramMap1) throws Exception {
        this.paramMap = paramMap1;
        this.initStartPeriod(this.paramMap);
    }

    protected void initStartPeriod(Map paramMap) throws Exception {
        PeriodCollection colls = PeriodHelper.getPeriodc(this.currentCompany);
        PeriodInfo startPeriod = (PeriodInfo)paramMap.get("startPeriod");
        PeriodInfo currentPeriod = (PeriodInfo)paramMap.get("currentPeriod");
        PeriodInfo tempPeriod = colls.get(0);
        for (int index = 0; index < colls.size(); ++index) {
            PeriodInfo period = colls.get(index);
            if (!PeriodUtils.PeriodCompare((PeriodInfo)tempPeriod, (PeriodInfo)period)) continue;
            tempPeriod = period;
        }
        if (EmptyUtil.isEmpty(paramMap.get("currentCompany"))) {
            paramMap.put("currentCompany", this.currentCompany);
        }
        if (PeriodUtils.PeriodCompare((PeriodInfo)tempPeriod, (PeriodInfo)startPeriod)) {
            startPeriod = tempPeriod;
        }
        if (PeriodUtils.PeriodCompare((PeriodInfo)startPeriod, (PeriodInfo)currentPeriod)) {
            currentPeriod = startPeriod;
        }
        paramMap.put("startPeriod", startPeriod);
        paramMap.put("currentPeriod", currentPeriod);
    }

    @Override
    protected void btnByPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.pnlByDate.setVisible(false);
        this.pnlByPeriod.setVisible(false);
        if (this.btnByPeriod.isSelected()) {
            this.pnlByPeriod.setVisible(true);
        } else {
            this.pnlByDate.setVisible(true);
        }
    }

    protected void init() throws Exception {
        if (this.paramMap.get("currentCompany") == null && this.paramMap.get("currentPeriod") == null && this.paramMap.get("startPeriod") == null) {
            PeriodHelper.initPeriodSpinner(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        } else {
            PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.paramMap.get("currentCompany"), (PeriodInfo)this.paramMap.get("currentPeriod"), (PeriodInfo)this.paramMap.get("startPeriod"), this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.paramMap.get("currentCompany");
        PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(company, SystemEnum.CASHMANAGEMENT));
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth, (boolean)false, (boolean)false);
        PeriodInfo period = (PeriodInfo)this.paramMap.get("currentPeriod");
        this.spiBeginYear.setValue((Object)new Integer(period.getPeriodYear()));
        this.spiBeginMonth.setValue((Object)new Integer(period.getPeriodNumber()));
        this.spiEndYear.setValue((Object)new Integer(period.getPeriodYear()));
        this.spiEndMonth.setValue((Object)new Integer(period.getPeriodNumber()));
    }

    public void clear() {
        super.clear();
        try {
            PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.paramMap.get("currentCompany"), (PeriodInfo)this.paramMap.get("currentPeriod"), (PeriodInfo)this.paramMap.get("startPeriod"), this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
            this.dtpToDate.setValue((Object)DateHelper.getDayBegin());
            this.dtpFromDate.setValue((Object)DateHelper.getDayBegin());
            this.btnByDate.setSelected(true);
            this.btnByPeriod.setSelected(true);
            this.chkIsShowForbiddenAccount.setSelected(false);
            this.chkIsShowBeginBalance.setSelected(true);
            this.chkIsShowDayTotal.setSelected(true);
            this.chkIsShowMonthTotal.setSelected(true);
            this.chkIsShowYearTotal.setSelected(true);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public Object getParam() {
        CashJournalFilterParam para = new CashJournalFilterParam();
        para.setToDate(this.dtpToDate.getSqlDate());
        para.setFromDate(this.dtpFromDate.getSqlDate());
        para.setShowForbiddenAccount(this.chkIsShowForbiddenAccount.isSelected());
        para.setShowBeginBalance(this.chkIsShowBeginBalance.isSelected());
        para.setShowDayTotal(this.chkIsShowDayTotal.isSelected());
        para.setShowMonthTotal(this.chkIsShowMonthTotal.isSelected());
        para.setShowYearTotal(this.chkIsShowYearTotal.isSelected());
        para.setByDay(this.btnByDate.isSelected());
        para.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        para.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        if (this.actualAcctTableId == null) {
            this.getAcctTableID();
        }
        para.setAcctTableId(this.actualAcctTableId);
        return para;
    }

    @Override
    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        CashJournalFilterParam filterParam = (CashJournalFilterParam)param;
        this.dtpToDate.setValue((Object)filterParam.getToDate());
        this.dtpFromDate.setValue((Object)filterParam.getFromDate());
        if (filterParam.isByDay()) {
            this.btnByDate.setSelected(true);
        } else {
            this.btnByPeriod.setSelected(true);
        }
        this.spiBeginYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiBeginMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiEndYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.chkIsShowForbiddenAccount.setSelected(filterParam.isShowForbiddenAccount());
        this.chkIsShowBeginBalance.setSelected(filterParam.isShowBeginBalance());
        this.chkIsShowDayTotal.setSelected(filterParam.isShowDayTotal());
        this.chkIsShowMonthTotal.setSelected(filterParam.isShowMonthTotal());
        this.chkIsShowYearTotal.setSelected(filterParam.isShowYearTotal());
    }

    public boolean verify() {
        CashClientHelper.verifyEmpty((CoreUIObject)this, RESOURCEPATH, this.dtpToDate, "cm63");
        CashClientHelper.verifyEmpty((CoreUIObject)this, RESOURCEPATH, this.dtpFromDate, "cm63");
        if (this.btnByPeriod.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiEndYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth)) {
                this.spiBeginYear.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndPeriodBeforeBeginPeriod"));
                SysUtil.abort();
            }
        } else {
            if (DateTimeUtils.truncateDate((java.util.Date)this.dtpToDate.getSqlDate()).before(DateTimeUtils.truncateDate((java.util.Date)this.dtpFromDate.getSqlDate()))) {
                this.dtpFromDate.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndDateBeforeBeginDate"));
                SysUtil.abort();
            }
            try {
                PeriodInfo startPeriod = null;
                if (this.paramMap.get("startPeriod") == null) {
                    CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                    startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                } else {
                    startPeriod = (PeriodInfo)this.paramMap.get("startPeriod");
                }
                if (DateTimeUtils.truncateDate((java.util.Date)this.dtpToDate.getSqlDate()).before(startPeriod.getBeginDate())) {
                    this.dtpToDate.requestFocus(true);
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndDateBeforeStartPeriod"));
                    SysUtil.abort();
                }
                java.util.Date startDate = this.dtpFromDate.getSqlDate();
                Date endDate = this.dtpToDate.getSqlDate();
                if (DateTimeUtils.dayBefore((java.util.Date)startDate, (java.util.Date)startPeriod.getBeginDate())) {
                    startDate = new java.util.Date(startPeriod.getBeginDate().getTime());
                    this.dtpFromDate.setValue((Object)startDate);
                }
                if (DateTimeUtils.dayBefore((java.util.Date)endDate, (java.util.Date)startDate)) {
                    this.dtpToDate.setValue((Object)startDate);
                }
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
        boolean beginYear = false;
        boolean beginMonth = false;
        boolean endYear = false;
        boolean endMonth = false;
        this.verifyMap = new HashMap();
        this.verifyMap.put("btnByPeriod", this.btnByPeriod.isSelected());
        this.verifyMap.put("beginYear", (Integer)this.spiBeginYear.getValue());
        this.verifyMap.put("endYear", (Integer)this.spiEndYear.getValue());
        this.verifyMap.put("beginPeriod", (Integer)this.spiBeginMonth.getValue());
        this.verifyMap.put("endPeriod", (Integer)this.spiEndMonth.getValue());
        this.verifyMap.put("btnByDate", this.btnByDate.isSelected());
        this.verifyMap.put("dateFrom", DateTimeUtils.truncateDate((java.util.Date)this.dtpFromDate.getSqlDate()));
        this.verifyMap.put("dateTo", DateTimeUtils.truncateDate((java.util.Date)this.dtpToDate.getSqlDate()));
        try {
            this.verifyMap = CashJournalFetchParamFacadeFactory.getRemoteInstance().fetchParamForFilterUIVerify(this.verifyMap);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.getAcctTableID();
        this.paramMap.put("actualAcctTableId", this.verifyMap.get("actualAcctTableId"));
        this.paramMap.put("beginPeriodParam", this.verifyMap.get("beginPeriodParam"));
        this.paramMap.put("endPeriodParam", this.verifyMap.get("endPeriodParam"));
        return true;
    }

    private void getAcctTableID() {
        if (this.btnByPeriod.isSelected()) {
            int beginYear = AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear);
            int beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth);
            int endYear = AccessHelper.getSpiValue((KDSpinner)this.spiEndYear);
            int endMonth = AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth);
            try {
                this.actualAcctTableId = CashAccountTool.getDisplayAcctTable(null, null, beginYear, beginMonth, endYear, endMonth);
            }
            catch (EASBizException e) {
                this.handUIException(e);
                e.printStackTrace();
            }
            catch (BOSException e) {
                this.handUIException(e);
                e.printStackTrace();
            }
        }
        if (this.btnByDate.isSelected()) {
            java.util.Date beginDate = DateTimeUtils.truncateDate((java.util.Date)this.dtpFromDate.getSqlDate());
            java.util.Date endDate = DateTimeUtils.truncateDate((java.util.Date)this.dtpToDate.getSqlDate());
            this.actualAcctTableId = FMClientHelper.getActualAcctTable((java.util.Date)beginDate, (java.util.Date)endDate);
        }
    }

    protected Class getParamClass() {
        return CashJournalFilterParam.class;
    }
}

