/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashJournalFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.JournalBaseInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.AbstractCashJournalListUI;
import com.kingdee.eas.fi.cas.client.CasJournalQueryProcessor;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.CashJournalAddBatchUI;
import com.kingdee.eas.fi.cas.client.CashJournalFilterParam;
import com.kingdee.eas.fi.cas.client.CashJournalFilterUI;
import com.kingdee.eas.fi.cas.client.CashJournalHandler;
import com.kingdee.eas.fi.cas.client.CashJournalPrintParame;
import com.kingdee.eas.fi.cas.client.CashJournalUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.JournalDataProvider;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CashJournalListUI
extends AbstractCashJournalListUI {
    private static Logger logger = Logger.getLogger((String)CashJournalListUI.class.getName());
    public static final String CASH_FILENAME = "/FI/CAS";
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private CashJournalFilterUI filterUI;
    private CashJournalHandler handler = new CashJournalHandler();
    CashJournalPrintParame editParame = CashJournalPrintParame.getInstance();
    String acctTableId = null;
    private Map paramMap;
    public static final String CASH_FILENAME_NEW = "/FI/CAS/BANKDEPOSIT";

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        CalculatorDialog calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        calc.setInitValue(null);
        calc.showDialog(2, true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.setOprtState("REMOVE");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        String id = null;
        if (selectBlock != null) {
            Date beginDate;
            JournalSourceEnum source;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            id = (String)row.getCell("id").getValue();
            if (row.getCell("id").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"SelectValidRecord"));
                SysUtil.abort();
            }
            if ((source = (JournalSourceEnum)row.getCell("source").getValue()) == JournalSourceEnum.BYBILL || source == JournalSourceEnum.BYVOUCHER) {
                MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"BillOrVoucherBook"));
                return;
            }
            Date date = ClientUtils.stringToDate((String)row.getCell("createDate").getValue());
            if (date.before(beginDate = CashClientHelper.getCurrentPeriod(ContextHelperFactory.getRemoteInstance().getCurrentCompany()).getBeginDate())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"CheckOutNoEdit"));
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)id);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    @Override
    public void actionInputMany_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"account", this.cboAccount.getSelectedItem());
        uiContext.put((Object)"currency", this.cboCurrency.getSelectedItem());
        IUIFactory fy = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)this));
        IUIWindow wnd = fy.create(CashJournalAddBatchUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        wnd.show();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"account", this.cboAccount.getSelectedItem());
        uiContext.put((Object)"currency", this.cboCurrency.getSelectedItem());
        IUIFactory fy = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)this));
        IUIWindow wnd = fy.create(CashJournalUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        wnd.show();
    }

    @Override
    public void actionInputOne_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"account", this.cboAccount.getSelectedItem());
        uiContext.put((Object)"currency", this.cboCurrency.getSelectedItem());
        IUIFactory fy = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)this));
        IUIWindow wnd = fy.create(CashJournalUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        wnd.show();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog qDlg = this.getQueryDlg();
        if (!qDlg.show()) {
            SysUtil.abort();
        }
        this.doQuery(qDlg);
        Object obj = this.getFilterUI().getParam();
        FilterParam param = (FilterParam)obj;
        this.tblMain.checkParsed();
        this.executeQuery(param);
    }

    @Override
    public void actionRegisterVoucher_actionPerformed(ActionEvent e) throws Exception {
        JournalInfo journalInfo;
        int i;
        HashSet<String> ids = new HashSet<String>();
        KDTSelectBlock selectBlock = null;
        IRow row = null;
        for (int i2 = 0; i2 < this.tblMain.getSelectManager().size(); ++i2) {
            selectBlock = this.tblMain.getSelectManager().get(i2);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                JournalSourceEnum source;
                row = this.tblMain.getRow(j);
                String id = (String)row.getCell("id").getValue();
                if (id == null || (source = (JournalSourceEnum)row.getCell("source").getValue()) != JournalSourceEnum.BYBILL) continue;
                ids.add(id);
            }
        }
        if (ids.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        JournalCollection journals = JournalFactory.getRemoteInstance().getJournalCollection(view);
        int count = 0;
        StringBuffer sb1 = null;
        ArrayList<String> array = new ArrayList<String>();
        for (i = 0; i < journals.size(); ++i) {
            journalInfo = journals.get(i);
            String billId = null;
            VoucherInfo voucherInfo = null;
            CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
            int billType = journalInfo.getBillType().getValue();
            String billNumber = journalInfo.getBillNumber();
            String[] billNumArray = billNumber.split(";");
            if (billNumArray.length == 1) {
                billId = journalInfo.getBillId();
                voucherInfo = CashClientHelper.getVoucherInfo(null, billId);
                if (voucherInfo == null || voucherInfo.getBizStatus().getValue() == 0) continue;
                journalInfo.setVoucherId(voucherInfo.getId().toString());
                journalInfo.setVoucherNumber(voucherInfo.getNumber());
                journalInfo.setVoucherType(voucherInfo.getVoucherType());
                this.setOppAccount(journalInfo, voucherInfo);
                IJournal iEntry = JournalFactory.getRemoteInstance();
                iEntry.registerVoucher((IObjectPK)new ObjectUuidPK(journalInfo.getId()), journalInfo);
                ++count;
                continue;
            }
            sb1 = new StringBuffer();
            for (int j = 0; j < billNumArray.length; ++j) {
                billId = this.getBillIdByBillNumber(billNumArray[j], curCompany, billType);
                voucherInfo = CashClientHelper.getVoucherInfo(null, billId);
                if (voucherInfo == null || voucherInfo.getBizStatus().getValue() == 0 || array.contains(voucherInfo.getNumber())) continue;
                array.add(voucherInfo.getNumber());
                sb1.append(voucherInfo.getNumber() + ";");
                ++count;
            }
            String tempString = "";
            if (sb1.length() > 0) {
                tempString = sb1.substring(0, sb1.length() - 1);
            }
            array.clear();
            journalInfo.setVoucherNumber(tempString);
            IJournal iEntry = JournalFactory.getRemoteInstance();
            iEntry.registerVoucher((IObjectPK)new ObjectUuidPK(journalInfo.getId()), journalInfo);
        }
        if (count == 0) {
            for (i = 0; i < journals.size(); ++i) {
                journalInfo = journals.get(i);
                if (journalInfo.getVoucherNumber() == null) continue;
                journalInfo.setVoucherId(null);
                journalInfo.setVoucherNumber(null);
                journalInfo.setVoucherType(null);
                IJournal iEntry = JournalFactory.getRemoteInstance();
                iEntry.registerVoucher((IObjectPK)new ObjectUuidPK(journalInfo.getId()), journalInfo);
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoVoucherReg"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RegisterVoucher_Success"));
        }
        this.fillData();
    }

    public String getBillIdByBillNumber(String billNum, CompanyOrgUnitInfo curCompany, int billType) throws Exception {
        IReceivingBill iReceivingBill;
        ReceivingBillCollection receivingBillCollection;
        Iterator iter;
        IPaymentBill iPaymentBill;
        PaymentBillCollection paymentBillCollection;
        String billId = null;
        String str = curCompany.getName();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("number", (Object)billNum));
        items.add(new FilterItemInfo("company.name", (Object)str));
        view.setFilter(filter);
        if (billType == 16 && (paymentBillCollection = (iPaymentBill = PaymentBillFactory.getRemoteInstance()).getPaymentBillCollection(view)) != null && paymentBillCollection.size() > 0 && (iter = paymentBillCollection.iterator()).hasNext()) {
            PaymentBillInfo paymentBillInfo = (PaymentBillInfo)iter.next();
            billId = paymentBillInfo.getId().toString();
        }
        if (billType == 15 && (receivingBillCollection = (iReceivingBill = ReceivingBillFactory.getRemoteInstance()).getReceivingBillCollection(view)) != null && receivingBillCollection.size() > 0 && (iter = receivingBillCollection.iterator()).hasNext()) {
            ReceivingBillInfo receivingBillInfo = (ReceivingBillInfo)iter.next();
            billId = receivingBillInfo.getId().toString();
        }
        return billId;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int i;
        try {
            this.setOprtState("REMOVE");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
        if (this.tblMain.getSelectManager().size() == 0 || this.tblMain.getSelectManager() == null) {
            return;
        }
        if (MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        KDTSelectBlock selectBlock = null;
        IRow row = null;
        for (i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                row = this.tblMain.getRow(j);
                String id = (String)row.getCell("id").getValue();
                if (id == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"SelectValidRecord"));
                    return;
                }
                JournalSourceEnum source = (JournalSourceEnum)row.getCell("source").getValue();
                if (source == JournalSourceEnum.BYBILL || source == JournalSourceEnum.BYVOUCHER) continue;
                CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                int currYear = currPeriodInfo.getPeriodYear();
                int currPeriodNumber = currPeriodInfo.getPeriodNumber();
                Integer year = (Integer)this.tblMain.getRow(j).getCell("year").getValue();
                Integer period = (Integer)this.tblMain.getRow(j).getCell("period").getValue();
                if (year < currYear || year == currYear && period < currPeriodNumber) {
                    String stru = EASResource.getString((String)resourcePath, (String)"cm79");
                    MsgBox.showInfo((Component)((Object)this), (String)stru);
                    return;
                }
                ids.add(id);
            }
        }
        for (i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            IJournal iJournal = JournalFactory.getRemoteInstance();
            iJournal.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        }
        this.fillData();
        String strDeleteSuccessfully = EASResource.getString((String)resourcePath, (String)"cm44");
        MsgBox.showInfo((Component)((Object)this), (String)strDeleteSuccessfully);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        String id = null;
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            id = (String)row.getCell("id").getValue();
            if (row.getCell("id").getValue() == null) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)id);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)this)).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int rowIndex = selectBlock.getTop();
        String id = (String)this.tblMain.getRow(rowIndex).getCell("id").getValue();
        if (id == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"SelectValidRecord"));
            return;
        }
        JournalInfo journalInfo = JournalFactory.getRemoteInstance().getJournalInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        String billId = journalInfo.getBillId();
        if (journalInfo.getSource().equals((Object)JournalSourceEnum.BYHAND)) {
            billId = CashClientHelper.getBillIdByNumber((JournalBaseInfo)journalInfo);
            if (FMHelper.isEmpty((String)billId)) {
                this.showMessage(EASResource.getString((String)resourcePath, (String)"CreateByHand"));
                this.abort();
            }
            FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        } else if (journalInfo.getSource().equals((Object)JournalSourceEnum.BYBILL)) {
            Set billIdSet = CashClientHelper.getBillIdSetByID((JournalBaseInfo)journalInfo);
            if (EmptyUtil.isEmpty((Collection)billIdSet)) {
                this.showMessage(EASResource.getString((String)resourcePath, (String)"No_Match"));
                this.abort();
            }
            Object[] objects = billIdSet.toArray();
            String[] billIds = new String[objects.length];
            System.arraycopy(objects, 0, billIds, 0, objects.length);
            FMClientHelper.viewDetailBill((CoreUIObject)this, (String[])billIds, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        } else {
            FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        }
    }

    public void changeCurrencyByAccount() throws Exception {
        AccountViewInfo account = (AccountViewInfo)this.cboAccount.getSelectedItem();
        if (account == null) {
            this.tblMain.removeRows();
            return;
        }
        int i = account.getAccountCurrency().size();
        Map listenerMap = null;
        try {
            listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CurrencyCollection currencyColl = (CurrencyCollection)this.paramMap.get("currencyCollection");
        if (currencyColl == null) {
            CashHelper.initCombCurrency(this.cboCurrency, false);
        } else {
            CashHelper.initCombCurrency(this.cboCurrency, currencyColl, false);
        }
        FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
        if (i != 1) {
            if (i == 0) {
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.company.getBaseCurrency(), (boolean)false);
                this.cboCurrency.setEnabled(true);
            } else {
                this.cboCurrency.removeAllItems();
                for (int j = 0; j < i; ++j) {
                    BOSUuid bu = account.getAccountCurrency().get(j).getCurrency().getId();
                    ObjectUuidPK pk = new ObjectUuidPK(bu);
                    CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk);
                    this.cboCurrency.addItem((Object)currency);
                }
                this.cboCurrency.setEnabled(true);
            }
        } else {
            CurrencyInfo currency = account.getAccountCurrency().get(0).getCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currency, (boolean)false);
            this.cboCurrency.setEnabled(false);
        }
    }

    @Override
    protected void cboAccount_actionPerformed(ActionEvent e) throws Exception {
        this.changeCurrencyByAccount();
        this.fillData();
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    @Override
    protected void prmtCashier_dataChanged(DataChangeEvent e) throws Exception {
        this.fillData();
    }

    protected void execQuery() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        CashJournalFilterParam para = null;
        try {
            para = (CashJournalFilterParam)this.getFilterParam();
            para.setAcctTableId(this.getAcctTableId(para));
            this.handler.initCombAccountBank(this.cboAccount, this.company, para.getAcctTableId(), para.isShowForbiddenAccount(), (AccountViewCollection)this.paramMap.get("accountViews"));
        }
        catch (Exception e1) {
            this.tblMain.removeRows();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoAccountView"));
            logger.error((Object)e1);
            SysUtil.abort((Throwable)e1);
        }
        String datePeriod = "";
        if (para.isByDay()) {
            datePeriod = Constants.FORMAT_DAY.format(para.getFromDate()) + " - " + Constants.FORMAT_DAY.format(para.getToDate());
        } else {
            Object[] args = new String[]{String.valueOf(para.getBeginYear()), String.valueOf(para.getBeginMonth()), String.valueOf(para.getEndYear()), String.valueOf(para.getEndMonth())};
            datePeriod = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_PeriodRange"), args);
        }
        this.txtPeriod.setText(datePeriod);
        this.txtPeriod.setEditable(false);
        try {
            this.fillData();
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            SysUtil.abort((Throwable)e1);
        }
    }

    private String getAcctTableId(CashJournalFilterParam param) {
        if (!EmptyUtil.isEmpty((String)param.getAcctTableId())) {
            this.acctTableId = param.getAcctTableId();
            return param.getAcctTableId();
        }
        if (param.isByDay()) {
            Date beginDate = param.getFromDate();
            Date endDate = param.getToDate();
            this.acctTableId = FMClientHelper.getActualAcctTable((Date)beginDate, (Date)endDate);
        } else {
            int beginYear = param.getBeginYear();
            int beginMonth = param.getBeginMonth();
            int endYear = param.getEndYear();
            int endMonth = param.getEndMonth();
            this.acctTableId = FMClientHelper.getActualAcctTable((int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        }
        return this.acctTableId;
    }

    public void fillData() throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        AccountViewInfo accountBank = (AccountViewInfo)this.cboAccount.getSelectedItem();
        if (currency == null || accountBank == null) {
            this.tblMain.removeRows();
            return;
        }
        Object cashier = this.prmtCashier.getData();
        Set cashierIDSet = FMHelper.Array2Set((String[])AccessHelper.getIds((Object)cashier));
        CashJournalFilterParam para = (CashJournalFilterParam)this.getFilterParam();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean GL_005 = ContextHelperFactory.getRemoteInstance().getBooleanParam("GL_005", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        this.handler.setGlDc(GL_005);
        IRowSet rs = this.handler.getRowset(this.mainQueryPK, this.mainQuery, currency.getId(), accountBank.getId(), cashierIDSet, para);
        this.tblMain.removeRows();
        this.handler.setColumnFormat(this.tblMain, currency.getId());
        String numberFtm = "%r-[ ]0.6n";
        this.tblMain.getColumn("exchange").getStyleAttributes().setNumberFormat(numberFtm);
        this.handler.fillData_New(this.tblMain, rs, currency, accountBank.getNumber(), accountBank.getId().toString(), para, CashDataSourceEnum.C, this.paramMap, cashierIDSet, accountBank.getDC());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return JournalFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return CashJournalUI.class.getName();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CashJournalFilterUI(this.paramMap);
        }
        return this.filterUI;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dialog = super.getQueryDlg();
        dialog.setShowFilter(true);
        dialog.setShowSorter(true);
        return dialog;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new CasJournalQueryProcessor((IUIObject)this);
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionInputOne.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addsinglefile"));
        this.actionInputMany.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.btnTDPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnTDPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.btnRegisterVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_addcredence"));
        this.actionExport.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_output"));
        this.actionExitCurrent.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_quit"));
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionRegisterVoucher.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addcredence"));
        this.actionCalculator.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_counter"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionTDPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        int bookType = -1;
        if (this.paramMap.get("bookType") == null) {
            String company = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            try {
                bookType = CashHelper.getBookType(company);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
        } else {
            bookType = (Integer)this.paramMap.get("bookType");
        }
        this.actionInputOne.setVisible(true);
        this.actionInputOne.setEnabled(true);
        this.actionAddNew.setEnabled(true);
        this.actionInputMany.setVisible(true);
        this.actionRemove.setVisible(true);
        this.actionEdit.setVisible(true);
        this.kDSeparator4.setVisible(false);
        this.actionViewDetail.setVisible(true);
        if (bookType == 0) {
            this.actionRegisterVoucher.setEnabled(true);
            this.actionRegisterVoucher.setVisible(true);
        } else {
            this.actionRegisterVoucher.setEnabled(false);
            this.actionRegisterVoucher.setVisible(false);
        }
    }

    private void preProcess() throws Exception {
        this.paramMap = new HashMap();
        this.paramMap.put("isShowLocalCurrency", null);
        this.paramMap.put("currentCompany", null);
        this.paramMap.put("currentPeriod", null);
        this.paramMap.put("currencyCollection", null);
        this.paramMap.put("bookType", null);
        this.paramMap.put("startPeriod", null);
        this.paramMap.put("CS003", null);
        this.paramMap.put("mainQueryPK", this.mainQueryPK.getFullName());
        this.paramMap.put("uiClassName", this.getMetaDataPK().getFullName());
        this.paramMap = CashJournalFetchParamFacadeFactory.getRemoteInstance().fetchParam(this.paramMap);
        this.dsPrepare = (QuerySolutionInfo)this.paramMap.get("DefaultSolution");
    }

    public void onLoad() throws Exception {
        this.preProcess();
        ClientUtils.checkCompanyAndPeriod((Component)((Object)this), this.paramMap);
        ActionListener[] actionListener = this.cboCurrency.getActionListeners();
        for (int i = 0; i < actionListener.length; ++i) {
            this.cboCurrency.removeActionListener(actionListener[i]);
        }
        CurrencyCollection currencyColl = (CurrencyCollection)this.paramMap.get("currencyCollection");
        if (currencyColl == null) {
            CashHelper.initCombCurrency(this.cboCurrency, false);
        } else {
            CashHelper.initCombCurrency(this.cboCurrency, currencyColl, false);
        }
        for (int i = 0; i < actionListener.length; ++i) {
            this.cboCurrency.addActionListener(actionListener[i]);
        }
        this.tblMain.getViewManager().setFreezeView(0, 2);
        KDMenuItem menuChangeSource = new KDMenuItem();
        menuChangeSource.setVisible(false);
        menuChangeSource.setAction((Action)((Object)new ActionChangeSource((IUIObject)this)));
        this.menuView.add((JMenuItem)menuChangeSource);
        menuChangeSource.setVisible(false);
        this.menuEdit.add((JMenuItem)new AbstractHidedMenuItem("shift ctrl alt F8"){

            public void action_actionPerformed() {
                CashJournalFilterParam para = (CashJournalFilterParam)CashJournalListUI.this.getFilterParam();
                Date fromDate = null;
                Date toDate = null;
                try {
                    CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                    if (para.isByDay()) {
                        fromDate = para.getFromDate();
                        toDate = para.getToDate();
                    } else {
                        PeriodInfo beginPeriod = null;
                        PeriodInfo endPeriod = null;
                        beginPeriod = PeriodHelper.getPeriodInfo(para.getBeginYear(), para.getBeginMonth(), companyInfo);
                        endPeriod = PeriodHelper.getPeriodInfo(para.getEndYear(), para.getEndMonth(), companyInfo);
                        fromDate = beginPeriod.getBeginDate();
                        toDate = endPeriod.getEndDate();
                    }
                    JournalFactory.getRemoteInstance().reCalculateSummary(GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo) ? null : companyInfo.getId().toString(), fromDate, toDate);
                    CashJournalListUI.this.fillData();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    SysUtil.abort((Throwable)e);
                }
            }
        });
        super.onLoad();
        this.changeCurrencyByAccount();
        String currencyId = ((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString();
        boolean flag1 = currencyId.equals(this.company.getBaseCurrency().getId().toString());
        boolean flag2 = (Boolean)this.paramMap.get("isShowLocalCurrency");
        if (!flag2 || flag1) {
            this.tblMain.getColumn("localDebit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("localCredit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("localBalance").getStyleAttributes().setHided(true);
            boolean showLocal = ConvertUtils.BOOL(this.paramMap.get("CS003"));
            if (showLocal) {
                this.tblMain.getColumn("localDebit").getStyleAttributes().setHided(false);
                this.tblMain.getColumn("localCredit").getStyleAttributes().setHided(false);
                this.tblMain.getColumn("localBalance").getStyleAttributes().setHided(false);
            }
        }
        this.tblMain.getColumn("debit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("credit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("localBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("localDebit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("localCredit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDMenuItemPrint.setVisible(true);
        this.kDMenuItemPreview.setVisible(true);
        this.kDMenuItemPrint.setEnabled(true);
        this.kDMenuItemPreview.setEnabled(true);
        this.actionTDPreview.setEnabled(true);
        this.actionTDPreview.setVisible(true);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrint.setVisible(true);
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.actionImportData.setVisible(true);
        this.actionImportData.setEnabled(true);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemImportData.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.tblMain.getColumn("createDate").getStyleAttributes().setNumberFormat(ClientUtils.getDateFormatString());
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(ClientUtils.getDateFormatString());
    }

    protected boolean isAutoSetTitle() {
        return false;
    }

    protected String getTitle() throws Exception {
        CompanyOrgUnitInfo curC = null;
        curC = this.paramMap.get("currentCompany") == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : (CompanyOrgUnitInfo)this.paramMap.get("currentCompany");
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curC)) {
            return null;
        }
        PeriodInfo curP = null;
        curP = this.paramMap.get("currentPeriod") == null ? CashClientHelper.getCurrentPeriod(curC) : (PeriodInfo)this.paramMap.get("currentPeriod");
        if (curP == null) {
            return null;
        }
        String msgStr = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"128_BankJournalListUI"), curP.getPeriodYear(), curP.getPeriodNumber());
        return msgStr;
    }

    private void setOppAccount(JournalInfo entryInfo, VoucherInfo voucherInfo) {
        HashMap mapDebit = new HashMap();
        HashMap mapCredit = new HashMap();
        CashHelper.analysisVoucher(voucherInfo, mapDebit, mapCredit);
        VoucherEntryInfo oppVoucherInfo = null;
        if (entryInfo.isIsDebit()) {
            Object[] voucherEntryCol = mapCredit.values().toArray();
            if (voucherEntryCol.length > 0) {
                oppVoucherInfo = (VoucherEntryInfo)voucherEntryCol[0];
            }
        } else {
            Object[] voucherEntryCol = mapDebit.values().toArray();
            if (voucherEntryCol.length > 0) {
                oppVoucherInfo = (VoucherEntryInfo)voucherEntryCol[0];
            }
        }
        if (oppVoucherInfo != null) {
            entryInfo.setOppAccountView(oppVoucherInfo.getAccount());
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        AccountViewInfo accountBank = (AccountViewInfo)this.cboAccount.getSelectedItem();
        if (currency == null || accountBank == null) {
            return;
        }
        String companyString = EASResource.getString((String)resourcePath, (String)"TblCol_Company") + "\uff1a&[company]";
        String periodRangeString = EASResource.getString((String)resourcePath, (String)"cm25") + "\uff1a&[PeriodRange]";
        String accountString = EASResource.getString((String)resourcePath, (String)"cm53") + "\uff1a&[accountBankNumber] &[accountBankName]";
        String currencyString = EASResource.getString((String)resourcePath, (String)"Currency") + "\uff1a&[currency]";
        String headString = companyString + "&|" + periodRangeString;
        StyleAttributes sb = Styles.getDefaultSA();
        headerModel.addRow(headString, sb);
        headString = accountString + "&|" + currencyString;
        headerModel.addRow(headString, sb);
        super.preparePrintPageHeader(headerModel);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        AccountViewInfo accountBank = (AccountViewInfo)this.cboAccount.getSelectedItem();
        if (currency == null || accountBank == null) {
            return map;
        }
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        map.put("company", company.getName());
        map.put("PeriodRange", this.txtPeriod.getText());
        map.put("accountBankNumber", accountBank.getNumber());
        map.put("accountBankName", accountBank.getName());
        map.put("currency", currency.getName());
        return map;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"createDate", "bizDate", "voucherType", "voucherNumber", "oppAccountNumber", "billType", "billNumber", "description", "debit", "credit", "balance", "cash"};
        return locateNames;
    }

    @Override
    public void actionMenuItemPrintParame_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"editParame", (Object)this.editParame);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.cas.client.CashJournalPrintParameUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionTDPreview_actionPerformed(ActionEvent e) throws Exception {
        UserDefineColumnCollection udcc = this.getUserDefineColumnCollection();
        JournalDataProvider data = null;
        data = new JournalDataProvider(this.tblMain, udcc);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FI/CAS/CASHJOURNAL", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        UserDefineColumnCollection udcc = this.getUserDefineColumnCollection();
        JournalDataProvider data = null;
        data = new JournalDataProvider(this.tblMain, udcc);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FI/CAS/CASHJOURNAL", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
    }

    private UserDefineColumnCollection getUserDefineColumnCollection() throws Exception {
        UserDefineColumnCollection udcc = new UserDefineColumnCollection();
        UserDefineColumnInfo info = null;
        info = new UserDefineColumnInfo();
        info.setName("bankAccount");
        info.setDescription("");
        info.setAlias("");
        info.setColumnValue("");
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("currency");
        info.setDescription(this.kDLabelCurrency.getBoundLabelText());
        info.setAlias(this.kDLabelCurrency.getBoundLabelText());
        info.setColumnValue(this.cboCurrency.getSelectedItem().toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankAccountView");
        info.setDescription(this.kDLabelAccount.getBoundLabelText());
        info.setAlias(this.kDLabelAccount.getBoundLabelText());
        info.setColumnValue(this.cboAccount.getSelectedItem().toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("intTerm");
        info.setDescription(this.kDLabelPeriod.getBoundLabelText());
        info.setAlias(this.kDLabelPeriod.getBoundLabelText());
        info.setColumnValue(this.txtPeriod.getText());
        udcc.add((Object)info);
        Date fromDate = null;
        Timestamp toDate = null;
        CashJournalFilterParam para = (CashJournalFilterParam)this.getFilterParam();
        PeriodInfo beginPeriod = null;
        PeriodInfo endPeriod = null;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        beginPeriod = PeriodHelper.getPeriodInfo(para.getBeginYear(), para.getBeginMonth(), companyInfo);
        endPeriod = PeriodHelper.getPeriodInfo(para.getEndYear(), para.getEndMonth(), companyInfo);
        fromDate = beginPeriod.getBeginDate();
        toDate = endPeriod.getEndDate();
        info = new UserDefineColumnInfo();
        info.setName("startPeriod");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"259_BankJournalListUI"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"259_BankJournalListUI"));
        info.setColumnValue(fromDate.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("endPeriod");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"260_BankJournalListUI"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"260_BankJournalListUI"));
        info.setColumnValue(((Date)toDate).toString());
        udcc.add((Object)info);
        return udcc;
    }

    protected void applyPreference() {
        super.applyPreference();
        boolean tblMove = this.tblMain.isColumnMoveable();
        this.tblMain.setColumnMoveable(true);
        this.tblMain.moveColumn(this.tblMain.getColumnIndex("debit"), this.tblMain.getColumnIndex("localDebit"));
        this.tblMain.moveColumn(this.tblMain.getColumnIndex("credit"), this.tblMain.getColumnIndex("localCredit"));
        this.tblMain.moveColumn(this.tblMain.getColumnIndex("balance"), this.tblMain.getColumnIndex("localBalance"));
        this.tblMain.setColumnMoveable(tblMove);
        this.handler.setLocalColumnHide(this.tblMain);
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        if (this.getImportParam() != null) {
            task.invoke(this.getImportParam(), 0, true);
        }
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fi.cas.CasJournal";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"278_CashJournalListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.changeButtonStatus();
    }

    private void changeButtonStatus() throws EASBizException, BOSException, Exception {
        this.actionRemove.setEnabled(false);
        KDTSelectBlock selectBlock = null;
        IRow row = null;
        boolean flag = false;
        for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                row = this.tblMain.getRow(j);
                JournalSourceEnum source = (JournalSourceEnum)row.getCell("source").getValue();
                if (!JournalSourceEnum.BYHAND.equals((Object)source) && !JournalSourceEnum.BYIMPORT.equals((Object)source) && !JournalSourceEnum.BYK3.equals((Object)source)) continue;
                this.actionRemove.setEnabled(true);
                flag = true;
                break;
            }
            if (flag) break;
        }
    }

    protected class ActionChangeSource
    extends ItemAction {
        public ActionChangeSource(IUIObject uiObject) {
            super(uiObject);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift ctrl alt F12"));
            this.setVisible(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (CashJournalListUI.this.tblMain.getSelectManager().size() == 0 || CashJournalListUI.this.tblMain.getSelectManager() == null) {
                return;
            }
            try {
                KDTSelectBlock selectBlock = null;
                IRow row = null;
                for (int i = 0; i < CashJournalListUI.this.tblMain.getSelectManager().size(); ++i) {
                    selectBlock = CashJournalListUI.this.tblMain.getSelectManager().get(i);
                    for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                        row = CashJournalListUI.this.tblMain.getRow(j);
                        String id = (String)row.getCell("id").getValue();
                        if (id == null) continue;
                        IJournal iJournal = JournalFactory.getRemoteInstance();
                        JournalInfo info = (JournalInfo)iJournal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                        JournalSourceEnum source = info.getSource();
                        if (source == JournalSourceEnum.BYBILL) {
                            info.setSource(JournalSourceEnum.BYVOUCHER);
                        } else if (source == JournalSourceEnum.BYVOUCHER) {
                            info.setSource(JournalSourceEnum.BYHAND);
                        } else {
                            info.setSource(JournalSourceEnum.BYBILL);
                        }
                        iJournal.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), info);
                    }
                }
                CashJournalListUI.this.fillData();
            }
            catch (Exception e1) {
                SysUtil.abort((Throwable)e1);
            }
        }
    }
}

