/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractCashJournalUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.CashJournalHandler;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.KeyStroke;

public class CashJournalUI
extends AbstractCashJournalUI {
    private CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CashJournalHandler handler = new CashJournalHandler();
    private boolean isLoading = true;
    private static final String casResourcePath = "com.kingdee.eas.fi.cas.CasResource";
    PeriodInfo period = null;

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal result;
        KDFormattedTextField txt = null;
        if (this.txtDebitAmount.hasFocus()) {
            txt = this.txtDebitAmount;
        }
        if (this.txtCreditAmount.hasFocus()) {
            txt = this.txtCreditAmount;
        }
        CalculatorDialog calc = new CalculatorDialog((Container)((Object)this));
        if (txt != null) {
            calc.setInitValue(txt.getBigDecimalValue());
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int pre = 2;
        if (currency != null) {
            pre = currency.getPrecision();
        }
        if ((result = calc.showDialog(pre, true)) == null) {
            return;
        }
        if (result != null && txt != null) {
            txt.setValue((Object)result);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        this.handler.initF7Acct((IUIObject)this, this.f7OpAccountView, this.company, currency);
        this.txtDebitAmount.setPrecision(currency.getPrecision());
        this.txtCreditAmount.setPrecision(currency.getPrecision());
        super.comboCurrency_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        JournalInfo journal = new JournalInfo();
        journal.setId(BOSUuid.create((BOSObjectType)journal.getBOSType()));
        journal.setHasEffected(true);
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = sdf.format(date);
        try {
            date = sdf.parse(strDate);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        try {
            this.period = CashClientHelper.getCurrentPeriod(this.company);
            if (date.before(this.period.getBeginDate())) {
                date = this.period.getBeginDate();
            }
            if (date.after(this.period.getEndDate())) {
                date = this.period.getEndDate();
            }
            journal.setBizDate(date);
            journal.setCreateDate(date);
            journal.setPeriod(this.period);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        UserInfo user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        journal.setCashier(user);
        journal.setVerifyStatus(VerifyScopeEnum.NOVA);
        journal.setSource(JournalSourceEnum.BYHAND);
        journal.setCurrency((CurrencyInfo)this.getUIContext().get("currency"));
        journal.setAccountView((AccountViewInfo)this.getUIContext().get("account"));
        journal.setType(JournalTypeEnum.CASH);
        journal.setCompany(this.company);
        return journal;
    }

    @Override
    protected void f7Description_dataChanged(DataChangeEvent e) throws Exception {
        super.f7Description_dataChanged(e);
        if (this.f7Description.getValue() == null) {
            return;
        }
        String description = this.f7Description.getValue().toString();
        this.editData.setDescription(description);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return JournalFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("accountView.*"));
        sic.add(new SelectorItemInfo("voucherType.*"));
        sic.add(new SelectorItemInfo("billType.*"));
        sic.add(new SelectorItemInfo("period.*"));
        return sic;
    }

    private void initControl() throws EASBizException, BOSException {
        this.txtCreditAmount.setSupportedEmpty(true);
        this.txtCreditAmount.setHorizontalAlignment(4);
        this.txtDebitAmount.setSupportedEmpty(true);
        this.txtDebitAmount.setHorizontalAlignment(4);
        this.txtDebitAmount.setRemoveingZeroInDispaly(false);
        this.txtCreditAmount.setRemoveingZeroInDispaly(false);
        this.txtDebitAmount.setCommitsOnValidEdit(true);
        this.txtCreditAmount.setCommitsOnValidEdit(true);
        CashHelper.initCombCurrency(this.comboCurrency, false);
        this.handler.initComboVoucherType(this.comboVoucherType);
        this.handler.initComboBillType(this.comboBillType, true);
        this.menuView.setVisible(false);
        this.menuEdit.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionEdit.setVisible(false);
        this.f7Description.setEditable(true);
        this.f7Description.setMaxLength(255);
        ExtendParser descEP = new ExtendParser(this.f7Description);
        this.f7Description.setCommitParser((IParser)descEP);
        this.txtBillNumber.setMaxLength(50);
        this.txtPeriod.setMaxLength(50);
        this.txtVoucherNumber.setMaxLength(50);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionAddNew.setEnabled(false);
        }
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
    }

    protected void initWorkButton() {
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        super.initWorkButton();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            String acctTableId = FMClientHelper.getActualAcctTable((String)this.company.getId().toString(), (Date)this.editData.getCreateDate(), (Date)this.editData.getCreateDate());
            this.handler.initComboCashAcct(this.comboAccount, this.company, acctTableId);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.handler.setSelectObject(this.comboAccount, this.editData.getAccountView());
        this.handler.setSelectObject(this.comboCurrency, this.editData.getCurrency());
        this.handler.setSelectObject(this.comboBillType, (Object)this.editData.getBillType());
        this.handler.setSelectObject(this.comboVoucherType, this.editData.getVoucherType());
        String[] args = new String[]{String.valueOf(this.editData.getPeriod().getPeriodYear()), String.valueOf(this.editData.getPeriod().getPeriodNumber())};
        MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
        String result = mf.format(args);
        this.txtPeriod.setText(result);
        this.f7Description.setValue((Object)this.editData.getDescription());
        if (this.txtDebitAmount.getBigDecimalValue() != null && this.txtDebitAmount.getBigDecimalValue().compareTo(SysConstant.BIGZERO) == 0) {
            this.txtDebitAmount.setValue(null);
        }
        if (this.txtCreditAmount.getBigDecimalValue() != null && this.txtCreditAmount.getBigDecimalValue().compareTo(SysConstant.BIGZERO) == 0) {
            this.txtCreditAmount.setValue(null);
        }
        this.isLoading = false;
    }

    public void onLoad() throws Exception {
        if (!"FINDVIEW".equalsIgnoreCase(this.getOprtState()) && !OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            FMClientHelper.checkIsAdjustPeriod((Component)((Object)this), (CompanyOrgUnitInfo)companyInfo);
        }
        this.initControl();
        super.onLoad();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.pkCreateDate.setSupportedEmpty(false);
        this.pkBizDate.setSupportedEmpty(false);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    @Override
    protected void pkCreateDate_dataChanged(DataChangeEvent e) throws Exception {
        Date beginDate = CashClientHelper.getCurrentPeriod(this.company).getBeginDate();
        if (!this.isLoading && ((Date)e.getNewValue()).before(beginDate)) {
            this.pkCreateDate.setValue((Object)beginDate);
        } else {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Date)((Date)e.getNewValue()), (CompanyOrgUnitInfo)this.company);
            if (period == null) {
                this.pkCreateDate.setValue(e.getOldValue());
                return;
            }
            String[] args = new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
            String result = mf.format(args);
            this.txtPeriod.setText(result);
            this.editData.setPeriod(period);
        }
    }

    public static void showWindow(IUIObject ui, String id) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CashJournalUI.class.getName(), (Map)uiContext, null, "VIEW");
        uiWindow.show();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.comboBillType.getSelectedItem() != null) {
            this.editData.setBillType((BillTypeEnum)((Object)this.comboBillType.getSelectedItem()));
        } else {
            this.editData.setNull("billType");
        }
        if (this.editData.getDebitAmount() != null && this.editData.getDebitAmount().compareTo(FMConstants.ZERO) != 0) {
            this.editData.setIsDebit(true);
        } else {
            this.editData.setIsDebit(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodInfo curPeriod = CashClientHelper.getCurrentPeriod(company);
        String currentYear = String.valueOf(curPeriod.getPeriodYear());
        String currentMonth = String.valueOf(curPeriod.getNumber()).substring(4);
        boolean flagDate = this.editData.getBizDate().before(this.editData.getCreateDate());
        boolean isPeriod = CashHelper.isDatePeriod(this.editData.getBizDate(), curPeriod, company);
        if (!isPeriod) {
            String msg = EASResource.getString((String)casResourcePath, (String)"oneBizDateNotPeriod");
            Object[] objects = new Object[]{DateFormat.getDateInstance().format(this.editData.getBizDate()), currentYear, currentMonth};
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(msg, objects));
            if (result == 2) {
                SysUtil.abort();
            }
        }
        this.handler.verifyJournal((CoreUIObject)this, this.editData);
    }

    @Override
    protected void txtCreditAmount_focusLost(FocusEvent e) throws Exception {
        BigDecimal amount = this.txtCreditAmount.getBigDecimalValue();
        if (amount == null) {
            return;
        }
        if (amount.compareTo(FMConstants.MAX_VALUE) == 1) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.showMessage();
            this.txtCreditAmount.setValue(null);
        }
        if (amount.compareTo(FMConstants.ZERO) != 0) {
            this.txtDebitAmount.setValue(null);
        } else {
            this.txtCreditAmount.setValue(null);
        }
        super.txtCreditAmount_focusLost(e);
    }

    @Override
    protected void txtDebitAmount_focusLost(FocusEvent e) throws Exception {
        BigDecimal amount = this.txtDebitAmount.getBigDecimalValue();
        if (amount == null) {
            return;
        }
        if (amount.compareTo(FMConstants.MAX_VALUE) == 1) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.showMessage();
            this.txtDebitAmount.setValue(null);
        }
        if (amount.compareTo(FMConstants.ZERO) != 0) {
            this.txtCreditAmount.setValue(null);
        } else {
            this.txtDebitAmount.setValue(null);
        }
        super.txtDebitAmount_focusLost(e);
    }

    @Override
    protected void txtCreditAmount_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal amount = this.txtCreditAmount.getBigDecimalValue();
        if (amount == null) {
            return;
        }
        if (amount.compareTo(FMConstants.MAX_VALUE) == 1) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.showMessage();
            this.txtCreditAmount.setValue(null);
        }
        if (amount.compareTo(FMConstants.ZERO) != 0) {
            this.txtDebitAmount.setValue(null);
        }
        super.txtCreditAmount_dataChanged(e);
    }

    @Override
    protected void txtDebitAmount_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal amount = this.txtDebitAmount.getBigDecimalValue();
        if (amount == null) {
            return;
        }
        if (amount.compareTo(FMConstants.MAX_VALUE) == 1) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.showMessage();
            this.txtDebitAmount.setValue(null);
        }
        if (amount.compareTo(FMConstants.ZERO) != 0) {
            this.txtCreditAmount.setValue(null);
        }
        super.txtDebitAmount_dataChanged(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

