/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.cas.client.AbstractCashMgtImportGLUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CashMgtImportGLUI
extends AbstractCashMgtImportGLUI {
    private static final String RES = "com.kingdee.eas.fi.cas.crap.CRAPResources";
    private int closeWindowType = -1;
    private PeriodCollection periods = null;
    private PeriodInfo selectedPeriod = null;
    private CompanyOrgUnitInfo _companyInfo = null;

    public String getUITitle() {
        return EASResource.getString((String)RES, (String)"ImportGLUITitle");
    }

    public boolean isConfirm() throws Exception {
        return this.closeWindowType == 2;
    }

    private void initSpinner() throws Exception {
        if (this._companyInfo == null) {
            this.spYear.setModel((SpinnerModel)new SpinnerNumberModel(2000, 2000, 2038, 1));
            this.spNumber.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 12, 1));
            return;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(this._companyInfo.getId());
        if (this._companyInfo.getAccountPeriodType() == null) {
            ICompanyOrgUnit iCom = CompanyOrgUnitFactory.getRemoteInstance();
            this._companyInfo = iCom.getCompanyOrgUnitInfo((IObjectPK)companyPK);
        }
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)companyPK);
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)this._companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        if (currPeriod != null) {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)currPeriod.getEndDate(), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)currPeriod.getEndDate(), CompareType.LESS_EQUALS));
        }
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        this.periods = iPeriod.getPeriodCollection(evi);
        if (this.periods == null || this.periods.size() == 0) {
            this.spYear.setModel((SpinnerModel)new SpinnerNumberModel(2004, 2004, 2038, 1));
            this.spNumber.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 12, 1));
            return;
        }
        PeriodInfo periodInfo = null;
        int firstYear = 2004;
        int endYear = 2004;
        int firstNum = 1;
        int endNum = 12;
        int n = this.periods.size();
        for (int i = 0; i < n; ++i) {
            periodInfo = this.periods.get(i);
            if (i == 0) {
                firstYear = periodInfo.getPeriodYear();
                firstNum = periodInfo.getPeriodNumber();
                continue;
            }
            if (periodInfo.getPeriodYear() == firstYear) {
                endNum = periodInfo.getPeriodNumber();
                continue;
            }
            if (i != n - 1) continue;
            endYear = periodInfo.getPeriodYear();
        }
        if (firstYear < endYear) {
            this.spYear.setModel((SpinnerModel)new SpinnerNumberModel(firstYear, firstYear, endYear, 1));
        } else if (firstYear == endYear) {
            this.spYear.setEnabled(false);
            this.spYear.setValue((Object)new Integer(firstYear));
        }
        this.spNumber.setModel((SpinnerModel)new SpinnerNumberModel(firstNum, firstNum, endNum, 1));
        if (currPeriod != null) {
            this.spYear.setValue((Object)new Integer(currPeriod.getPeriodYear()));
            this.spNumber.setValue((Object)new Integer(currPeriod.getPeriodNumber()));
        }
        this.initSpYearEvent();
    }

    private void initSpYearEvent() throws Exception {
        this.spYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int year = Integer.parseInt(CashMgtImportGLUI.this.spYear.getValue().toString());
                if (CashMgtImportGLUI.this.periods != null) {
                    PeriodInfo periodInfo = null;
                    int firstNum = 1;
                    int endNum = 1;
                    boolean fYear = false;
                    int n = CashMgtImportGLUI.this.periods.size();
                    for (int i = 0; i < n; ++i) {
                        periodInfo = CashMgtImportGLUI.this.periods.get(i);
                        if (periodInfo.getPeriodYear() == year) {
                            if (!fYear) {
                                firstNum = periodInfo.getPeriodNumber();
                                fYear = true;
                                continue;
                            }
                            endNum = periodInfo.getPeriodNumber();
                            continue;
                        }
                        if (periodInfo.getPeriodYear() > year) break;
                    }
                    CashMgtImportGLUI.this.spNumber.setModel((SpinnerModel)new SpinnerNumberModel(firstNum, firstNum, endNum, 1));
                }
            }
        });
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.closeWindowType = 1;
        this.selectedPeriod = null;
        this.disposeUIWindow();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.closeWindowType = 2;
        int year = Integer.parseInt(this.spYear.getValue().toString());
        int num = Integer.parseInt(this.spNumber.getValue().toString());
        if (this.periods != null) {
            int n = this.periods.size();
            for (int i = 0; i < n; ++i) {
                if (this.periods.get(i).getPeriodYear() != year || this.periods.get(i).getPeriodNumber() != num) continue;
                this.selectedPeriod = this.periods.get(i);
                break;
            }
        } else {
            this.selectedPeriod = new PeriodInfo();
            this.selectedPeriod.setPeriodYear(year);
            this.selectedPeriod.setPeriodNumber(num);
        }
        this.disposeUIWindow();
    }

    public PeriodInfo getPeriod() {
        return this.selectedPeriod;
    }

    public void onLoad() throws Exception {
        this._companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("UIClassParam");
        this.initSpinner();
    }
}

