/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.UnreachedException;
import com.kingdee.eas.fi.cas.client.AbstractCashMgtInitJournalHandler;
import com.kingdee.eas.fi.cas.client.AbstractCashMgtInitJournalUI;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CashMgtInitJournalUI
extends AbstractCashMgtInitJournalUI {
    private AbstractCashMgtInitJournalHandler handler;
    private static final String RESOURCEPATH = "com.kingdee.eas.fi.cas.CasResource";
    public static final String BANKACCOUNT = "bankAccount";
    public static final String COMPANY = "company";
    public static final String CURRENCY = "currency";
    public static final String STARTPERIOD = "startPeriod";
    public static final String BANKVIEW = "bankView";
    public static final String ISBANKUNREACHED = "isBankUnreached";
    private KDFormattedTextField txtField;
    private CalculatorDialog calc;
    private List bakData;

    @Override
    protected void tblEntries_editStopped(KDTEditEvent e) throws Exception {
        BigDecimal number;
        JournalInfo journal;
        BankStatementInfo bankStatementInfo;
        super.tblEntries_editStopped(e);
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        Object value = this.tblEntries.getCell(rowIndex, colIndex).getValue();
        if (value == null) {
            return;
        }
        IRow row = this.tblEntries.getRow(rowIndex);
        Object useObject = row.getUserObject();
        if (useObject != null && useObject instanceof BankStatementInfo ? (bankStatementInfo = (BankStatementInfo)useObject).getVerifyStatus().equals((Object)VerifyScopeEnum.WHOLE) : useObject != null && useObject instanceof JournalInfo && (journal = (JournalInfo)useObject).getVerifyStatus().equals((Object)VerifyScopeEnum.WHOLE)) {
            return;
        }
        if (colIndex == this.tblEntries.getColumn("debitAmt").getColumnIndex()) {
            number = (BigDecimal)value;
            if (FMClientHelper.isExceedMaxValue((Component)((Object)this), (BigDecimal)number)) {
                this.tblEntries.getCell(rowIndex, colIndex).setValue(null);
                return;
            }
            this.tblEntries.getRow(rowIndex).getCell("creditAmt").setValue(null);
        }
        if (colIndex == this.tblEntries.getColumn("creditAmt").getColumnIndex()) {
            number = (BigDecimal)value;
            if (FMClientHelper.isExceedMaxValue((Component)((Object)this), (BigDecimal)number)) {
                this.tblEntries.getCell(rowIndex, colIndex).setValue(null);
                return;
            }
            this.tblEntries.getRow(rowIndex).getCell("debitAmt").setValue(null);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.save(e);
    }

    private void save(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.handler.storeFields();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"saveSuccess"));
        this.bakDataInTable();
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
        this.insertLine();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        this.removeLine();
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyLine_actionPerformed(e);
        this.copyLine();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        this.addLine();
    }

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
        this.setTxtField();
        int column = this.tblEntries.getSelectManager().getActiveColumnIndex();
        int row = this.tblEntries.getSelectManager().getActiveRowIndex();
        if (this.calc == null) {
            this.calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        }
        this.calc.setInitValue(null);
        BigDecimal number = this.calc.showDialog(2, true);
        int debitColumn = this.tblEntries.getColumnIndex("debitAmt");
        int creditColum = this.tblEntries.getColumnIndex("creditAmt");
        ICell selectedCell = null;
        if (column == debitColumn || column == creditColum) {
            selectedCell = this.tblEntries.getCell(row, column);
        }
        FMClientHelper.setNumberValueForCell((Component)((Object)this), (ICell)selectedCell, (BigDecimal)number);
    }

    private void setTxtField() {
        if (this.txtField == null) {
            this.txtField = new KDFormattedTextField(1);
        }
        this.txtField.setHorizontalAlignment(4);
        this.txtField.setDataVerifierType(-1);
        this.txtField.setSupportedEmpty(true);
        this.txtField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        this.txtField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
    }

    public static void initUI(IUIObject ui, CurrencyInfo currency, PeriodInfo period, AccountBankInfo accounbank, AccountViewInfo bankAccountView, boolean isBankUnreached) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)CURRENCY, (Object)currency);
        uiContext.put((Object)STARTPERIOD, (Object)period);
        uiContext.put((Object)BANKACCOUNT, (Object)accounbank);
        uiContext.put((Object)BANKVIEW, (Object)bankAccountView);
        uiContext.put((Object)ISBANKUNREACHED, (Object)isBankUnreached);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CashMgtInitJournalUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public static void initBankUnreached(IUIObject ui, CurrencyInfo currency, PeriodInfo period, AccountBankInfo accounbank, AccountViewInfo bankAccountView) throws UIException {
        CashMgtInitJournalUI.initUI(ui, currency, period, accounbank, bankAccountView, true);
    }

    public static void initEnterpriseUnreached(IUIObject ui, CurrencyInfo currency, PeriodInfo period, AccountBankInfo accounbank, AccountViewInfo bankAccountView) throws UIException {
        CashMgtInitJournalUI.initUI(ui, currency, period, accounbank, bankAccountView, false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblEntries.checkParsed();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnCopyLine.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        boolean bln = (Boolean)this.getUIContext().get(ISBANKUNREACHED);
        if (bln) {
            this.setUITitle(EASResource.getString((String)RESOURCEPATH, (String)"BankUnreachedUITitle"));
        } else {
            this.setUITitle(EASResource.getString((String)RESOURCEPATH, (String)"EnterpriseUnreachedUITitle"));
        }
        this.initData();
        this.handler = AbstractCashMgtInitJournalHandler.getInstance(bln);
        this.handler.setTable(this.tblEntries);
        this.handler.initTable(((CurrencyInfo)this.getUIContext().get(CURRENCY)).getId().toString());
        this.transferDataToHandler();
        this.handler.loadFields();
        if (this.tblEntries.getRowCount() == 0) {
            this.addLine();
        }
        this.bakDataInTable();
        this.tblEntries.setActiveCellStatus(1);
        String dformat = FMHelper.getDateFormatString();
        this.tblEntries.getColumn("createDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblEntries.getColumn("assisDate").getStyleAttributes().setNumberFormat(dformat);
    }

    private void bakDataInTable() {
        int rowCount = this.tblEntries.getRowCount();
        if (rowCount == 0) {
            this.bakData = null;
            return;
        }
        int columnCount = this.tblEntries.getColumnCount();
        ArrayList<Object> row = null;
        this.bakData = new ArrayList();
        for (int i = 0; i < rowCount; ++i) {
            row = new ArrayList<Object>();
            for (int j = 0; j < columnCount; ++j) {
                row.add(this.tblEntries.getCell(i, j).getValue());
            }
            this.bakData.add(row);
        }
    }

    private void initData() throws EASBizException, BOSException {
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.getUIContext().get(BANKACCOUNT);
        this.txtAccountBank.setText(accountBankInfo.toString());
        CurrencyInfo currencyInfo = (CurrencyInfo)this.getUIContext().get(CURRENCY);
        this.txtCurrency.setText(currencyInfo.toString());
        AccountViewInfo accountViewInfo = (AccountViewInfo)this.getUIContext().get(BANKVIEW);
        this.txtAccountView.setText(accountViewInfo.toString());
        PeriodInfo periodInfo = (PeriodInfo)this.getUIContext().get(STARTPERIOD);
        this.txtPeriod.setText(periodInfo.toString());
    }

    protected void addLine() throws EASBizException, BOSException {
        this.tblEntries.addRow();
    }

    protected void insertLine() throws EASBizException, BOSException {
        if (this.tblEntries.getSelectManager().size() > 0) {
            int top = this.tblEntries.getSelectManager().get().getTop();
            this.tblEntries.addRow(top);
        } else {
            this.addLine();
        }
    }

    protected void removeLine() {
        if (!this.checkHasSelectedAnyRow()) {
            return;
        }
        if (this.tblEntries.getSelectManager().get().size() > 0) {
            JournalInfo journalInfo;
            int top = this.tblEntries.getSelectManager().get().getTop();
            IRow row = this.tblEntries.getRow(top);
            if (row.getUserObject() instanceof BankStatementInfo) {
                BankStatementInfo bankStatementInfo = (BankStatementInfo)row.getUserObject();
                if (bankStatementInfo != null && bankStatementInfo.getVerifyStatus().equals((Object)VerifyScopeEnum.WHOLE)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"279_CashMgtInitJournalUI"));
                    SysUtil.abort();
                }
            } else if (row.getUserObject() instanceof JournalInfo && (journalInfo = (JournalInfo)row.getUserObject()) != null && journalInfo.getVerifyStatus().equals((Object)VerifyScopeEnum.WHOLE)) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"280_CashMgtInitJournalUI"));
                SysUtil.abort();
            }
            this.tblEntries.removeRow(top);
        }
    }

    public void copyLine() throws Exception {
        int rowIndex;
        IRow copiedRow;
        KDTSelectBlock selectBlock = this.tblEntries.getSelectManager().get();
        if (selectBlock != null && (copiedRow = this.tblEntries.getRow(rowIndex = selectBlock.getTop())) != null) {
            IRow newRow = this.tblEntries.addRow(this.tblEntries.getRowCount() - 1);
            int n = this.tblEntries.getColumnCount();
            for (int i = 0; i < n; ++i) {
                newRow.getCell(i).setValue(copiedRow.getCell(i).getValue());
            }
        }
    }

    protected void verifyInput(ActionEvent arg0) throws Exception {
        super.verifyInput(arg0);
        int rowCount = this.tblEntries.getRowCount();
        int colCount = this.tblEntries.getColumnCount();
        IRow row = null;
        Date createDate = null;
        Date bizDate = null;
        BigDecimal debitAmt = null;
        BigDecimal creditAmt = null;
        java.util.Date firstDayOfPeriod = ((PeriodInfo)this.getUIContext().get(STARTPERIOD)).getBeginDate();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblEntries.getRow(i);
            createDate = TypeConversionUtils.objToDate((Object)row.getCell("createDate").getValue());
            bizDate = TypeConversionUtils.objToDate((Object)row.getCell("assisDate").getValue());
            if (createDate == null) {
                throw new UnreachedException(UnreachedException.DATE_NOT_NULL);
            }
            if (!createDate.before(firstDayOfPeriod)) {
                throw new UnreachedException(UnreachedException.DATE_NOT_GREAT_FIRSTDAY);
            }
            if (bizDate != null && createDate.before(bizDate)) {
                throw new UnreachedException(UnreachedException.CREATEDATE_CANT_BEFORE_BIZDATE);
            }
            debitAmt = TypeConversionUtils.objToBigDecimal((Object)row.getCell("debitAmt").getValue());
            creditAmt = TypeConversionUtils.objToBigDecimal((Object)row.getCell("creditAmt").getValue());
            if (FMHelper.isZERO((BigDecimal)debitAmt) && FMHelper.isZERO((BigDecimal)creditAmt)) {
                throw new UnreachedException(UnreachedException.DEBIT_OR_CREDIT_NEED);
            }
            if (FMHelper.isZERO((BigDecimal)debitAmt) || FMHelper.isZERO((BigDecimal)creditAmt)) continue;
            throw new UnreachedException(UnreachedException.DEBIT_CREDIT_EXISTS);
        }
    }

    private void transferDataToHandler() {
        this.handler.setAccountBank((AccountBankInfo)this.getUIContext().get(BANKACCOUNT));
        this.handler.setAccountView((AccountViewInfo)this.getUIContext().get(BANKVIEW));
        this.handler.setCurrency((CurrencyInfo)this.getUIContext().get(CURRENCY));
        this.handler.setBeginDate(((PeriodInfo)this.getUIContext().get(STARTPERIOD)).getBeginDate());
    }

    private boolean checkHasSelectedAnyRow() {
        int selectRpw = this.tblEntries.getSelectManager().getActiveRowIndex();
        if (selectRpw == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"cm23"));
            return false;
        }
        return true;
    }

    public boolean isModify() {
        KDTEditManager em = this.tblEntries.getEditManager();
        em.stopEditing();
        int rowCount = this.tblEntries.getRowCount();
        if (rowCount == 0 && this.bakData == null) {
            return false;
        }
        if (rowCount > 0 && this.bakData == null) {
            return true;
        }
        if (rowCount != this.bakData.size()) {
            return true;
        }
        int columnCount = this.tblEntries.getColumnCount();
        List row = null;
        Object value = null;
        Object bakValue = null;
        for (int i = 0; i < rowCount; ++i) {
            row = (List)this.bakData.get(i);
            for (int j = 0; j < columnCount; ++j) {
                value = this.tblEntries.getCell(i, j).getValue();
                bakValue = row.get(j);
                if (value == null && bakValue == null) continue;
                if (value == null && bakValue != null) {
                    return true;
                }
                if (value != null && bakValue == null) {
                    return true;
                }
                if (!(value instanceof IObjectValue ? !ObjectValueUtil.objectValueEquals((AbstractObjectValue)((AbstractObjectValue)value), (AbstractObjectValue)bakValue) : (value instanceof BigDecimal ? ((BigDecimal)value).compareTo((BigDecimal)bakValue) != 0 : !value.equals(bakValue)))) continue;
                return true;
            }
        }
        return false;
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return JournalFactory.getRemoteInstance();
    }
}

