/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSelect;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgUnitTreePromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public final class ClientUtils {
    private static final Logger logger = Logger.getLogger(ClientUtils.class);
    private static final int MIN_YEAR = 1900;
    public static final String RES = "com.kingdee.eas.fi.cas.CasResources";
    public static final Color NORMAL_COLOR = new Color(0xF9F9F9);
    public static final Color PERIOD_START_COLOR = new Color(15262923);
    public static final Color DAY_SUM_COLOR = new Color(16119270);
    public static final Color DAY_TOTAL_COLOR = new Color(15789529);
    public static final Color PERIOD_TOTAL_COLOR = new Color(15262923);
    public static final Color YEAR_TOTAL_COLOR = new Color(15327928);

    private static void setComboBox(KDComboBox combo, Object[] objArr) {
        combo.removeAllItems();
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(objArr);
        combo.setModel(comboModel);
    }

    private static void setComboBox(KDComboBox combo, AbstractObjectCollection objColl) {
        if (objColl == null || objColl.size() == 0) {
            logger.error((Object)(combo.getName() + " has not any value to init"));
            SysUtil.abort();
        }
        Object[] objArr = objColl.toArray();
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(objArr);
        combo.setModel(comboModel);
    }

    public static void setCurrencyList(KDComboBox combo, boolean bAll) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        view.getSelector().add("precision");
        CurrencyCollection colCurrency = ClientUtils.getCurrencyCollection(view);
        if (colCurrency == null || colCurrency.size() == 0) {
            MsgBox.showWarning((Component)combo, (String)EASResource.getString((String)RES, (String)"NoCurrencys_Alert"));
            SysUtil.abort();
        }
        int size = colCurrency.size() + (bAll ? 1 : 0);
        Object[] objs = new Object[size];
        System.arraycopy(colCurrency.toArray(), 0, objs, 0, colCurrency.size());
        if (bAll) {
            CurrencyInfo allCurr = new CurrencyInfo();
            allCurr.put("id", (Object)"all");
            allCurr.put("number", (Object)"all");
            allCurr.put("name", (Object)EASResource.getString((String)RES, (String)"Currency_All"));
            objs[size - 1] = allCurr;
        }
        ClientUtils.setComboBox(combo, objs);
    }

    public static void setBankList(KDComboBox combo, String companyId, boolean fHasClosed) throws BOSException, EASBizException {
        AccountBankCollection banks = CashClientHelper.getAccountBankCollection(companyId, fHasClosed);
        if (banks == null || banks.size() == 0) {
            MsgBox.showWarning((Component)combo, (String)EASResource.getString((String)RES, (String)"NoBanks_Alert"));
            SysUtil.abort();
        }
        ClientUtils.setComboBox(combo, (AbstractObjectCollection)banks);
    }

    public static void setSharedAcctBankList(KDComboBox combo, String companyId, boolean fHasClosed) throws BOSException, EASBizException {
        AccountBankCollection banks = CashClientHelper.getSharedAcctAccountBankCollection(companyId, fHasClosed);
        if (banks == null || banks.size() == 0) {
            MsgBox.showWarning((Component)combo, (String)EASResource.getString((String)RES, (String)"NoBanks_Alert"));
            SysUtil.abort();
        }
        ClientUtils.setComboBox(combo, (AbstractObjectCollection)banks);
    }

    public static void setBankListIncludeShared(KDBizPromptBox prmtBankAccount, String companyId, boolean fHasClosed) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        if (!EmptyUtil.isEmpty((String)companyId)) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        if (!fHasClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)companyId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bankAccount.id");
        sic.add("bankAccount.company.id");
        sic.add("entries.accountBank.company.id");
        view.setSelector(sic);
        SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
        HashSet<String> sharedAcctSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            SharedAcctInfo sharedAcct = coll.get(i);
            AccountBankInfo bankAcct = sharedAcct.getBankAccount();
            if (bankAcct.getCompany().getId().toString().equals(companyId)) {
                sharedAcctSet.add(bankAcct.getId().toString());
                continue;
            }
            SharedAcctEntriesCollection colls = sharedAcct.getEntries();
            for (int index = 0; index < colls.size(); ++index) {
                bankAcct = colls.get(index).getAccountBank();
                if (!bankAcct.getCompany().getId().toString().equals(companyId)) continue;
                sharedAcctSet.add(bankAcct.getId().toString());
            }
        }
        if (!EmptyUtil.isEmpty(sharedAcctSet)) {
            fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
            if (!fHasClosed) {
                fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
            } else {
                fi.setMaskString("((#0 and #1 and #2) or #3)");
            }
        }
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                FilterInfo filt = new FilterInfo();
                filt.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                fi.mergeFilter(filt, "AND");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        evi.getSorter().add(new SorterItemInfo("number"));
        prmtBankAccount.setSelectorCollection(selectors);
        prmtBankAccount.setEntityViewInfo(evi);
        prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public static void setBankListIncludeShared2(KDBizPromptBox prmtBankAccount, String companyId, boolean fHasClosed) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        if (!EmptyUtil.isEmpty((String)companyId)) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        if (!fHasClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bankAccount.id");
        sic.add("bankAccount.company.id");
        sic.add("bankAccount.company.id");
        sic.add("entries.accountBank.company.id");
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)companyId, CompareType.EQUALS));
        view.setFilter(filter);
        SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
        HashSet<String> sharedAcctSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            SharedAcctInfo sharedAcct = coll.get(i);
            AccountBankInfo bankAcct = sharedAcct.getBankAccount();
            if (bankAcct.getCompany().getId().toString().equals(companyId)) {
                sharedAcctSet.add(bankAcct.getId().toString());
                continue;
            }
            SharedAcctEntriesCollection colls = sharedAcct.getEntries();
            for (int index = 0; index < colls.size(); ++index) {
                bankAcct = colls.get(index).getAccountBank();
                if (!bankAcct.getCompany().getId().toString().equals(companyId)) continue;
                sharedAcctSet.add(bankAcct.getId().toString());
            }
        }
        if (!EmptyUtil.isEmpty(sharedAcctSet)) {
            fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
            if (!fHasClosed) {
                fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
            } else {
                fi.setMaskString("((#0 and #1 and #2) or #3)");
            }
        }
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                FilterInfo filt = new FilterInfo();
                filt.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                fi.mergeFilter(filt, "AND");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        evi.getSorter().add(new SorterItemInfo("number"));
        prmtBankAccount.setSelectorCollection(selectors);
        prmtBankAccount.setEntityViewInfo(evi);
        prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public static void setBankListNoIncludeShared(KDBizPromptBox prmtBankAccount, String companyId, boolean fHasClosed) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        if (!EmptyUtil.isEmpty((String)companyId)) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        if (!fHasClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        evi.getSorter().add(new SorterItemInfo("number"));
        prmtBankAccount.setSelectorCollection(selectors);
        prmtBankAccount.setEntityViewInfo(evi);
        prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public static void setBankListIncludeShared2(KDBizPromptBox prmtBankAccount, Set companySet, boolean fHasClosed) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        if (!EmptyUtil.isEmpty((Collection)companySet)) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companySet, CompareType.INCLUDE));
        }
        if (!fHasClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bankAccount.id");
        sic.add("bankAccount.company.id");
        sic.add("bankAccount.company.id");
        sic.add("entries.accountBank.company.id");
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)companySet, CompareType.INCLUDE));
        view.setFilter(filter);
        SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
        HashSet<String> sharedAcctSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            SharedAcctInfo sharedAcct = coll.get(i);
            AccountBankInfo bankAcct = sharedAcct.getBankAccount();
            if (companySet.contains(bankAcct.getCompany().getId().toString())) {
                sharedAcctSet.add(bankAcct.getId().toString());
                continue;
            }
            SharedAcctEntriesCollection colls = sharedAcct.getEntries();
            for (int index = 0; index < colls.size(); ++index) {
                bankAcct = colls.get(index).getAccountBank();
                if (!companySet.contains(bankAcct.getCompany().getId().toString())) continue;
                sharedAcctSet.add(bankAcct.getId().toString());
            }
        }
        if (!EmptyUtil.isEmpty(sharedAcctSet)) {
            fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
            if (!fHasClosed) {
                fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
            } else {
                fi.setMaskString("((#0 and #1 and #2) or #3)");
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        evi.getSorter().add(new SorterItemInfo("number"));
        prmtBankAccount.setSelectorCollection(selectors);
        prmtBankAccount.setEntityViewInfo(evi);
        prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public static void setBankListIncludeShared(KDBizPromptBox prmtBankAccount, Set companySet, boolean fHasClosed) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        if (!EmptyUtil.isEmpty((Collection)companySet)) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companySet, CompareType.INCLUDE));
        }
        if (!fHasClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)companySet, CompareType.INCLUDE));
        view.setFilter(filter);
        SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
        HashSet<String> sharedAcctSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            SharedAcctInfo sharedAcct = coll.get(i);
            sharedAcctSet.add(sharedAcct.getBankAccount().getId().toString());
        }
        if (!EmptyUtil.isEmpty(sharedAcctSet)) {
            fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
            if (!fHasClosed) {
                fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
            } else {
                fi.setMaskString("((#0 and #1 and #2) or #3)");
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        evi.getSorter().add(new SorterItemInfo("number"));
        prmtBankAccount.setSelectorCollection(selectors);
        prmtBankAccount.setEntityViewInfo(evi);
        prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public static void setBankListNoIncludeShared(KDBizPromptBox prmtBankAccount, Set companySet, boolean fHasClosed) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        if (!EmptyUtil.isEmpty((Collection)companySet)) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companySet, CompareType.INCLUDE));
        }
        if (!fHasClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        evi.getSorter().add(new SorterItemInfo("number"));
        prmtBankAccount.setSelectorCollection(selectors);
        prmtBankAccount.setEntityViewInfo(evi);
        prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public static void setBankList(KDComboBox combo, String companyId, String acctTableId, boolean fHasClosed) throws BOSException, EASBizException {
        AccountBankCollection banks = CashClientHelper.getAccountBankCollection(companyId, fHasClosed);
        if ((banks = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)banks, null, (String)acctTableId)) == null || banks.size() == 0) {
            MsgBox.showWarning((Component)combo, (String)EASResource.getString((String)RES, (String)"NoBanks_Alert"));
            SysUtil.abort();
        }
        ClientUtils.setComboBox(combo, (AbstractObjectCollection)banks);
    }

    public static void setBankList(KDComboBox combo, String companyId, String acctTableId, boolean fHasClosed, AccountBankCollection banks) throws BOSException, EASBizException {
        for (int i = 0; i < banks.size(); ++i) {
            banks.get(i).setDisplayFormat("$number$ - $name$");
        }
        AccountBankCollection banksCol = ClientUtils.getBankColFromParamBanks(banks, fHasClosed);
        if ((banks = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)banksCol, null, (String)acctTableId)) == null || banks.size() == 0) {
            MsgBox.showWarning((Component)combo, (String)EASResource.getString((String)RES, (String)"NoBanks_Alert"));
            SysUtil.abort();
        }
        ClientUtils.setComboBox(combo, (AbstractObjectCollection)banks);
    }

    public static void setBankList(KDComboBox combo, AccountBankCollection banks) throws BOSException, EASBizException {
        for (int i = 0; i < banks.size(); ++i) {
            banks.get(i).setDisplayFormat("$number$ - $name$");
        }
        combo.addItems(banks.toArray());
    }

    private static AccountBankCollection getBankColFromParamBanks(AccountBankCollection banks, boolean hasClosed) {
        AccountBankCollection banksColReturn = null;
        if (hasClosed) {
            banksColReturn = banks;
        } else {
            banksColReturn = new AccountBankCollection();
            for (int i = 0; i < banks.size(); ++i) {
                if (banks.get(i).isIsClosed()) continue;
                banksColReturn.add(banks.get(i));
            }
        }
        return banksColReturn;
    }

    private static CurrencyCollection getCurrencyCollection() throws BOSException, EASBizException {
        ICurrency icurrency = CurrencyFactory.getRemoteInstance();
        return icurrency.getCurrencyCollection(true);
    }

    private static CurrencyCollection getCurrencyCollection(EntityViewInfo view) throws BOSException, EASBizException {
        ICurrency icurrency = CurrencyFactory.getRemoteInstance();
        return icurrency.getCurrencyCollection(view, true);
    }

    public static void setBankAccountList(KDComboBox comboAccount, CompanyOrgUnitInfo companyInfo) throws Exception {
        if (companyInfo == null || companyInfo.getId() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isBank", (Object)"1"));
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
        items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        String maskStr = "#0 and #1 and #2 and #3 ";
        filter.setMaskString(maskStr);
        AccountViewCollection accounts = AccountUtils.getAccountViewCByCompany(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (FilterInfo)filter);
        ClientUtils.setComboBox(comboAccount, (AbstractObjectCollection)accounts);
    }

    public static void setBankAccountListForFilterUI(KDComboBox comboAccount, CompanyOrgUnitInfo companyInfo, boolean fIncludeInvalid) throws Exception {
        if (companyInfo == null || companyInfo.getId() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        String maskStr = "#0 and #1 ";
        items.add(new FilterItemInfo("isBank", (Object)"1"));
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        if (!fIncludeInvalid) {
            items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
            items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
            maskStr = maskStr + " and #2 and #3 ";
        }
        filter.setMaskString(maskStr);
        AccountViewCollection colAccount = AccountUtils.getAccountViewCByCompany(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (FilterInfo)filter);
        ClientUtils.setComboBox(comboAccount, (AbstractObjectCollection)colAccount);
    }

    public static void setCashAccountList(KDComboBox combo, CompanyOrgUnitInfo companyInfo) throws Exception {
        if (companyInfo == null || companyInfo.getId() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isCash", (Object)"1"));
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
        items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        String maskStr = "#0 and #1 and #2 and #3 ";
        filter.setMaskString(maskStr);
        AccountViewCollection accounts = AccountUtils.getAccountViewCByCompany(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (FilterInfo)filter);
        if (accounts.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"340_ClientUtils"));
        }
        ClientUtils.setComboBox(combo, (AbstractObjectCollection)accounts);
    }

    public static void setSettleTypeList(KDComboBox combo) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSorter().add(new SorterItemInfo("number"));
        ISettlementType iSettleType = SettlementTypeFactory.getRemoteInstance();
        SettlementTypeCollection colSettle = iSettleType.getSettlementTypeCollection(evi);
        ClientUtils.setComboBox(combo, (AbstractObjectCollection)colSettle);
        SettlementTypeInfo nullInfo = new SettlementTypeInfo();
        nullInfo.put("id", null);
        nullInfo.put("name", (Object)"");
        combo.addItem((Object)nullInfo);
    }

    public static void setCompanyF7(KDBizPromptBox bizCompany, IUIObject ui, boolean fIncludeFrozen) {
        OrgType[] CompanyType = new OrgType[]{OrgType.Company};
        bizCompany.setDisplayFormat("$name$");
        bizCompany.setEditFormat("$number$");
        bizCompany.setCommitFormat("$number$");
        bizCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        OrgUnitTreePromptBox boxCompany = new OrgUnitTreePromptBox(ui, CompanyType, null, OrgSelect.OnlySelectCompanyEntity, false, fIncludeFrozen, false);
        bizCompany.setSelector((KDPromptSelector)boxCompany);
        bizCompany.setEditable(true);
        bizCompany.setEnabled(false);
    }

    public static void setAccountF7(KDBizPromptBox bizAcct, String companyId, boolean fIncludeInvalid) {
        bizAcct.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        bizAcct.setDisplayFormat("$number$ $name$");
        bizAcct.setEditFormat("$number$");
        bizAcct.setCommitFormat("$number$");
        bizAcct.setEditable(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isBank", (Object)"1"));
        items.add(new FilterItemInfo("isCash", (Object)"1"));
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        String maskStr = "( #0 or #1 ) and #2 ";
        if (!fIncludeInvalid) {
            items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
            items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
            maskStr = maskStr + " and #3 and #4 ";
        }
        if (!StringUtils.isEmpty((String)companyId)) {
            items.add(new FilterItemInfo("companyID.id", (Object)companyId));
            maskStr = !fIncludeInvalid ? maskStr + " and #5 " : maskStr + " and #3 ";
        }
        filter.setMaskString(maskStr);
        view.setFilter(filter);
        bizAcct.setEntityViewInfo(view);
        bizAcct.setHasCUDefaultFilter(false);
    }

    public static void setAccountList(KDComboBox combo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo != null) {
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("isCash", (Object)"1"));
            items.add(new FilterItemInfo("isBank", (Object)"1"));
            items.add(new FilterItemInfo("isLeaf", (Object)"1"));
            items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
            items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
            String maskStr = "(#0 or #1) and #2 and #3 and #4";
            filter.setMaskString(maskStr);
            AccountViewCollection accounts = AccountUtils.getAccountViewCByCompany(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (FilterInfo)filter);
            ClientUtils.setComboBox(combo, (AbstractObjectCollection)accounts);
        }
    }

    public static void setBankAccountF7(KDBizPromptBox bizAcct, String companyId, boolean fIncludeInvalid) {
        bizAcct.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        bizAcct.setDisplayFormat("$number$ $name$");
        bizAcct.setEditFormat("$number$");
        bizAcct.setCommitFormat("$number$");
        bizAcct.setEditable(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isBank", (Object)"1"));
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        if (!fIncludeInvalid) {
            items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
            items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        }
        if (!StringUtils.isEmpty((String)companyId)) {
            items.add(new FilterItemInfo("companyID.id", (Object)companyId));
        }
        view.setFilter(filter);
        bizAcct.setEntityViewInfo(view);
        bizAcct.setHasCUDefaultFilter(false);
    }

    public static void setCashAccountF7(KDBizPromptBox bizAcct, String companyId, boolean fIncludeInvalid) {
        bizAcct.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        bizAcct.setDisplayFormat("$number$ $name$");
        bizAcct.setEditFormat("$number$");
        bizAcct.setCommitFormat("$number$");
        bizAcct.setEditable(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isCash", (Object)"1"));
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        if (!fIncludeInvalid) {
            items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
            items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        }
        if (!StringUtils.isEmpty((String)companyId)) {
            items.add(new FilterItemInfo("companyID.id", (Object)companyId));
        }
        view.setFilter(filter);
        bizAcct.setEntityViewInfo(view);
        bizAcct.setHasCUDefaultFilter(false);
    }

    public static int setAccountBank(KDTextField txtBank, CompanyOrgUnitInfo companyInfo, AccountViewInfo accountInfo, CurrencyInfo currencyInfo, boolean fAlertMsg) throws BOSException, EASBizException {
        if (accountInfo != null && currencyInfo != null && companyInfo != null) {
            IAccountBank iAccountBank = AccountBankFactory.getRemoteInstance();
            AccountBankInfo accountBankInfo = iAccountBank.getAccountBankByAcc(accountInfo.getId(), companyInfo.getId());
            txtBank.setText(null);
            txtBank.setUserObject(null);
            if (accountBankInfo != null) {
                txtBank.setUserObject((Object)accountBankInfo);
                if (accountBankInfo.getBankAccountNumber() != null) {
                    txtBank.setText(accountBankInfo.getBankAccountNumber());
                }
                return 0;
            }
            if (fAlertMsg) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"cm49"));
            }
            return -1;
        }
        return -2;
    }

    public static boolean isSameDay(Date date, Date otherDate) {
        if (date == null && otherDate == null) {
            return true;
        }
        if (date == null || otherDate == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar otherCalendar = Calendar.getInstance();
        otherCalendar.setTime(otherDate);
        return calendar.get(1) == otherCalendar.get(1) && calendar.get(2) == otherCalendar.get(2) && calendar.get(5) == otherCalendar.get(5);
    }

    public static boolean isInSamePeriod(Date date, PeriodInfo periodInfo) {
        if (date == null || periodInfo == null) {
            return false;
        }
        return !date.before(periodInfo.getBeginDate()) && !date.after(periodInfo.getEndDate());
    }

    public static void setSelectedItem(KDComboBox combo, String objId) {
        if (StringUtils.isEmpty((String)objId)) {
            return;
        }
        IObjectValue obj = null;
        int n = combo.getItemCount();
        for (int i = 0; i < n; ++i) {
            obj = (IObjectValue)combo.getItemAt(i);
            if (obj == null || !obj.get("id").toString().equals(objId)) continue;
            combo.setSelectedIndex(i);
            break;
        }
    }

    public static PeriodInfo getStartPeriodInfo(Component comp, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo startPeriod = null;
        startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (startPeriod == null) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)RES, (String)"StartPeriod_NullMsg"));
            SysUtil.abort();
        }
        return startPeriod;
    }

    public static PeriodInfo getCurrentPeriod(Component comp, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo currentPeriod = null;
        currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currentPeriod == null) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"MSG_periodError"));
            SysUtil.abort();
        }
        return currentPeriod;
    }

    private static PeriodCollection getPeriodColl(CompanyOrgUnitInfo companyInfo, SystemEnum system) throws EASBizException, BOSException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)system, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)system, (CompanyOrgUnitInfo)companyInfo);
        if (startPeriod == null || currPeriod == null) {
            return new PeriodCollection();
        }
        ObjectUuidPK pkFrom = new ObjectUuidPK(startPeriod.getId());
        ObjectUuidPK pkTo = new ObjectUuidPK(currPeriod.getId());
        ObjectUuidPK companyPk = new ObjectUuidPK(companyInfo.getId());
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        PeriodCollection periodColl = iPeriod.getPeriodCollection((IObjectPK)pkFrom, (IObjectPK)pkTo, (IObjectPK)companyPk);
        return periodColl;
    }

    public static void checkCashGLPeriod(Component comp, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodCollection cashPeriodColl = ClientUtils.getPeriodColl(companyInfo, SystemEnum.CASHMANAGEMENT);
        PeriodCollection glPeriodColl = ClientUtils.getPeriodColl(companyInfo, SystemEnum.GENERALLEDGER);
        PeriodInfo cashPeriod = null;
        PeriodInfo glPeriod = null;
        for (int i = 0; i < cashPeriodColl.size(); ++i) {
            cashPeriod = cashPeriodColl.get(i);
            for (int j = 0; j < glPeriodColl.size(); ++j) {
                glPeriod = glPeriodColl.get(j);
                if (!cashPeriod.equals((Object)glPeriod)) continue;
                return;
            }
        }
        MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"CashGLPeriodNotValid"));
        SysUtil.abort();
    }

    public static PeriodCollection getCashGlPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodCollection cashPeriodColl = ClientUtils.getPeriodColl(companyInfo, SystemEnum.CASHMANAGEMENT);
        PeriodCollection glPeriodColl = ClientUtils.getPeriodColl(companyInfo, SystemEnum.GENERALLEDGER);
        PeriodInfo cashPeriod = null;
        PeriodInfo glPeriod = null;
        PeriodCollection commonColl = new PeriodCollection();
        for (int i = 0; i < cashPeriodColl.size(); ++i) {
            cashPeriod = cashPeriodColl.get(i);
            for (int j = 0; j < glPeriodColl.size(); ++j) {
                glPeriod = glPeriodColl.get(j);
                if (!cashPeriod.equals((Object)glPeriod)) continue;
                commonColl.add(cashPeriod);
            }
        }
        return commonColl;
    }

    public static CompanyOrgUnitInfo getCurrLoginCompany() {
        return ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public static void periodYearChange(KDSpinner spinner) {
        int year = Integer.parseInt(spinner.getValue().toString());
        if (year < 1900) {
            spinner.setValue((Object)new Integer(1900));
        }
    }

    public static void periodNumChange(KDSpinner spinner, CompanyOrgUnitInfo companyInfo, int year) throws Exception {
        int periodNum = Integer.parseInt(spinner.getValue().toString());
        int maxNum = PeriodUtils.getMaxPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
        int minNum = PeriodUtils.getMinPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
        if (periodNum > maxNum) {
            spinner.setValue((Object)new Integer(maxNum));
        }
        if (periodNum < minNum) {
            spinner.setValue((Object)new Integer(minNum));
        }
    }

    public static String getNumberFormat(int precision, boolean fNegativeSign) {
        StringBuffer format = new StringBuffer(8);
        format.append("%").append(fNegativeSign ? "-" : "_").append("[].").append(precision).append("n");
        return format.toString();
    }

    public static void checkCompany(Component uiComp, CompanyOrgUnitInfo companyInfo) {
        boolean expired;
        if (companyInfo == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)RES, (String)"Company_AlertMsg"));
            SysUtil.abort();
        }
        Date curDate = new Date();
        Date invalidDate = companyInfo.getInvalidDate();
        boolean bl = expired = invalidDate != null && curDate.after(invalidDate);
        if (expired) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)RES, (String)"Company_InvalidMsg"));
            SysUtil.abort();
        }
    }

    public static void checkCompany(Component uiComp, String oprtState) {
        boolean expired;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if ("FINDVIEW".equals(oprtState) || "VIEW".equals(oprtState)) {
            return;
        }
        if (companyInfo == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)RES, (String)"Company_AlertMsg"));
            SysUtil.abort();
        }
        Date curDate = new Date();
        Date invalidDate = companyInfo.getInvalidDate();
        boolean bl = expired = invalidDate != null && curDate.after(invalidDate);
        if (expired) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)RES, (String)"Company_InvalidMsg"));
            SysUtil.abort();
        }
    }

    public static void checkCompanyAndPeriod(Component ui) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        ClientUtils.checkCompany(ui, companyInfo);
        PeriodInfo periodInfo = ClientUtils.getCurrentPeriod(ui, companyInfo);
        if (periodInfo == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RES, (String)"StartPeriod_NullMsg"));
            SysUtil.abort();
        }
    }

    public static void checkCompanyAndPeriod(Component ui, Map paramMap) throws EASBizException, BOSException {
        if (paramMap.get("currentCompany") == null && paramMap.get("currentPeriod") == null) {
            ClientUtils.checkCompanyAndPeriod(ui);
        } else {
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)paramMap.get("currentCompany");
            ClientUtils.checkCompany(ui, companyInfo);
            PeriodInfo periodInfo = (PeriodInfo)paramMap.get("currentPeriod");
            if (periodInfo == null) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RES, (String)"StartPeriod_NullMsg"));
                SysUtil.abort();
            }
        }
    }

    public static void checkCompanyAndPeriod(Component ui, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) throws EASBizException, BOSException {
        if (companyInfo == null && periodInfo == null) {
            ClientUtils.checkCompanyAndPeriod(ui);
        } else {
            ClientUtils.checkCompany(ui, companyInfo);
            if (periodInfo == null) {
                MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RES, (String)"StartPeriod_NullMsg"));
                SysUtil.abort();
            }
        }
    }

    public static Date stringToDate(String str) {
        String strDateFormat = ClientUtils.getDateFormatString();
        SimpleDateFormat dateFormat = new SimpleDateFormat(strDateFormat);
        Date date = null;
        try {
            date = dateFormat.parse(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    private static String removeThousand(String text) {
        StringBuffer s = new StringBuffer();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == ',') continue;
            s.append(c);
        }
        return s.toString();
    }

    private static String toPattern(int scale) {
        StringBuffer s = new StringBuffer(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append("0");
        }
        return s.toString();
    }

    public static DateFormat getDateFormat() {
        DateFormat dateFormat = CtrlFormatUtilities.getDateFormat();
        return dateFormat;
    }

    public static DateFormat getTimeFormat() {
        DateFormat dateFormat = CtrlFormatUtilities.getTimeFormat();
        return dateFormat;
    }

    public static DateFormat getDateTimeFormat() {
        DateFormat dateFormat = CtrlFormatUtilities.getDateTimeFormat();
        return dateFormat;
    }

    public static DecimalFormat getDecimalFormat() {
        DecimalFormat decimalFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        return decimalFormat;
    }

    public static String getDateFormatString() {
        String strDateFormat = CtrlFormatUtilities.getDateFormatString();
        return strDateFormat;
    }

    public static String getTimeFormatString() {
        String strTimeFormat = CtrlFormatUtilities.getTimeFormatString();
        return strTimeFormat;
    }

    public static String getDateTimeFormatString() {
        String strDateTimeFormat = CtrlFormatUtilities.getDateTimeFormatString();
        return strDateTimeFormat;
    }

    public static String getDecimalFormatString() {
        String strDecimalFormat = CtrlFormatUtilities.getDecimalFormatString();
        return strDecimalFormat;
    }

    public static String formatDate(Date date) {
        DateFormat dateFormat = ClientUtils.getDateFormat();
        return dateFormat.format(date);
    }

    public static String formatTime(Date date) {
        DateFormat dateFormat = ClientUtils.getTimeFormat();
        return dateFormat.format(date);
    }

    public static String formatDateTime(Date date) {
        DateFormat dateFormat = ClientUtils.getDateTimeFormat();
        return dateFormat.format(date);
    }

    public static String formatDecimal(BigDecimal val) {
        DecimalFormat decimalFormat = ClientUtils.getDecimalFormat();
        decimalFormat.applyPattern(ClientUtils.toPattern(val.scale()));
        return decimalFormat.format(val);
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = ClientUtils.getDecimalFormat();
        decimalFormat.applyPattern(ClientUtils.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String formatDecimal(String text) {
        BigDecimal val = new BigDecimal(ClientUtils.removeThousand(text));
        DecimalFormat decimalFormat = ClientUtils.getDecimalFormat();
        decimalFormat.applyPattern(ClientUtils.toPattern(val.scale()));
        return decimalFormat.format(val);
    }

    public static String formatDecimal(String text, int scale) {
        BigDecimal val = new BigDecimal(ClientUtils.removeThousand(text));
        DecimalFormat decimalFormat = ClientUtils.getDecimalFormat();
        decimalFormat.applyPattern(ClientUtils.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static void setCurrencyListCopy(KDComboBox combo, boolean bAll) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        view.getSelector().add("precision");
        CurrencyCollection colCurrency = ClientUtils.getCurrencyCollection(view);
        if (colCurrency == null || colCurrency.size() == 0) {
            MsgBox.showWarning((Component)combo, (String)EASResource.getString((String)RES, (String)"NoCurrencys_Alert"));
            SysUtil.abort();
        }
        int size = colCurrency.size() + (bAll ? 2 : 0);
        Object[] objs = new Object[size];
        System.arraycopy(colCurrency.toArray(), 0, objs, 0, colCurrency.size());
        if (bAll) {
            CurrencyInfo baseCurr = new CurrencyInfo();
            baseCurr.put("id", (Object)"base");
            baseCurr.put("number", (Object)"base");
            baseCurr.put("name", (Object)EASResource.getString((String)RES, (String)"Currency_BaseCurrency"));
            objs[size - 2] = baseCurr;
            CurrencyInfo allCurr = new CurrencyInfo();
            allCurr.put("id", (Object)"all");
            allCurr.put("number", (Object)"all");
            allCurr.put("name", (Object)EASResource.getString((String)RES, (String)"Currency_All"));
            objs[size - 1] = allCurr;
        }
        ClientUtils.setComboBox(combo, objs);
    }
}

