/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fi.cas.client.AbstractDownLoadFSDataUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class DownLoadFSDataUI
extends AbstractDownLoadFSDataUI {
    private static final Logger logger = CoreUIObject.getLogger(DownLoadFSDataUI.class);
    private CompanyOrgUnitInfo company;
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResource";

    public void onLoad() throws Exception {
        this.company = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        ClientUtils.checkCompany((Component)((Object)this), this.company);
        super.onLoad();
        this.setBankAccountF7(this.company.getId().toString());
    }

    private void setBankAccountF7(String companyId) {
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("bank.ingroup", (Object)Boolean.TRUE));
        info.setFilter(filter);
        this.f7BankAccount.setEntityViewInfo(info);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void CoreUI_keyReleased(KeyEvent e) throws Exception {
        super.CoreUI_keyReleased(e);
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        AccountBankInfo acctBankInfo;
        InnerAccountInfo innerAcctInfo;
        PeriodInfo startPeriod;
        PeriodInfo currentPeriod;
        boolean isuse;
        AccountBankInfo content = (AccountBankInfo)this.f7BankAccount.getData();
        if (content == null) {
            this.f7BankAccount.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Bank_NullMsg"));
            SysUtil.abort();
        }
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("bank.*");
        content = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(content.getId()), select);
        Date endDate = DateTimeUtils.truncateDate((Date)this.dtpToDate.getSqlDate());
        Date beginDate = DateTimeUtils.truncateDate((Date)this.dptFromDate.getSqlDate());
        if (endDate.before(beginDate)) {
            this.dptFromDate.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"EndDateBeforeBeginDate"));
            SysUtil.abort();
        }
        if (!(isuse = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS046", (IObjectPK)new ObjectUuidPK(this.company.getId()))) && beginDate.before((currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company)).getBeginDate())) {
            this.dptFromDate.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"BeginDateError"));
            SysUtil.abort();
        }
        if ((startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company)).getBeginDate().after(beginDate)) {
            this.dptFromDate.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckBeginDate"));
            SysUtil.abort();
        }
        if ((innerAcctInfo = (acctBankInfo = content).getInnerAcct()) == null) {
            this.f7BankAccount.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckRelatedInnerAcct"));
            SysUtil.abort();
        }
        super.btnConfirm_actionPerformed(e);
        IBankStatement iBankStat = BankStatementFactory.getRemoteInstance();
        iBankStat.downLoadFSData(this.company.getId().toString(), acctBankInfo.getId().toString(), innerAcctInfo.getId().toString(), beginDate, endDate, this.checkAccept.isSelected());
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"DownLoadSuccess"));
        this.disposeUIWindow();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    public static void showDialogWindow(IUIObject ui, CompanyOrgUnitInfo company) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"company", (Object)company);
        IUIWindow window = null;
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        window = uiFactory.create(DownLoadFSDataUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    @Override
    protected void f7BankAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.f7BankAccount_dataChanged(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }
}

