/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.ElecBookFactory;
import com.kingdee.eas.fi.cas.client.AbstractElecBookListUI;
import com.kingdee.eas.fi.cas.client.ElecBookFilerParam;
import com.kingdee.eas.fi.cas.client.ElecBookFilerUI;
import com.kingdee.eas.fi.cas.client.ElecBookSignUI;
import com.kingdee.eas.fi.cas.client.ElecBookSyncStateUI;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElecBookListUI
extends AbstractElecBookListUI {
    private static final long serialVersionUID = 4877892876145865555L;
    private static final Logger logger = CoreUIObject.getLogger(ElecBookListUI.class);
    private ElecBookFilerUI filterUI = null;
    FillListener fillListener = new FillListener();

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuBiz.setEnabled(true);
        this.actionElecSign.setEnabled(true);
        this.actionSyncStateByBill.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"elecBook"));
        this.actionElecSign.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cycattemper"));
        this.actionSyncStateByBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_synchronization"));
    }

    @Override
    public void actionElecSign_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        int state = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("SignStatus").getValue()).getInt();
        if (state != 2) {
            throw new BEException(BEException.COMMON, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"elecBookWarn1")});
        }
        ArrayList idList = this.getSelectedIdValues();
        UIContext uiContext = new UIContext((Object)this);
        String uiName = ElecBookSignUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        ElecBookSignUI elecBookSign = (ElecBookSignUI)uiWindow.getUIObject();
        if (elecBookSign.getResult() == null) {
            return;
        }
        IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
        Map result = bankFacade.elecBook(FMHelper.list2Set((List)idList), elecBookSign.getSignStatus(), elecBookSign.getTelephoneNumber());
        this.showResult(e, idList, result, "sign");
    }

    private void showResult(ActionEvent e, List idList, Map result, String scene) throws Exception {
        String failMessage = (String)result.get("failMessage");
        int successCount = (Integer)result.get("successCount");
        int validCount = (Integer)result.get("validIds");
        if (EmptyUtil.isEmpty((String)failMessage) && validCount == idList.size()) {
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (ActionEvent)e);
        } else {
            String title = null;
            title = "sync".equals(scene) ? (successCount > 0 ? EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"syncElecBookSuccessAndFail_tip") : EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"synElecBookAllFail")) : (successCount > 0 ? EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"signElecBookSuccessAndFail_tip") : EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"signElecBookAllFail"));
            StringBuffer errMsg = new StringBuffer();
            if (validCount != idList.size()) {
                List recRefList = (List)result.get("recRefList");
                StringBuffer recRef = new StringBuffer();
                for (int i = 0; i < recRefList.size() - 1; ++i) {
                    recRef.append(recRefList.get(i)).append("\u3001");
                }
                if (recRefList.size() > 0) {
                    recRef.append(recRefList.get(recRefList.size() - 1));
                }
                if ("sync".equals(scene)) {
                    errMsg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"syncElecBookSucessAndFail_state_error"), recRef));
                } else {
                    errMsg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"signElecBookSucessAndFail_state_error"), recRef));
                }
            }
            errMsg.append(failMessage);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)errMsg.toString(), (int)1);
        }
        this.refresh(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionSyncStateByBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        int state = ((BizEnumValueInfo)this.tblMain.getRow(rowIndex).getCell("SignStatus").getValue()).getInt();
        if (state != 3) {
            throw new BEException(BEException.COMMON, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"elecBookWarn2")});
        }
        String adjustCause = (String)this.tblMain.getRow(rowIndex).getCell("adjustCause").getValue();
        String telphoneNumber = (String)this.tblMain.getRow(rowIndex).getCell("telephoneNumber").getValue();
        ArrayList idList = this.getSelectedIdValues();
        IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
        Map result = null;
        if (!"00000".equals(adjustCause)) {
            UIContext uiContext = new UIContext((Object)this);
            String uiName = ElecBookSyncStateUI.class.getName();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
            ElecBookSyncStateUI elecSync = (ElecBookSyncStateUI)uiWindow.getUIObject();
            elecSync.setTelPhoneNumber(telphoneNumber);
            elecSync.doDeal();
            uiWindow.show();
            if (elecSync.isCancel()) return;
            telphoneNumber = elecSync.getTelPhoneNumber();
            if (EmptyUtil.isEmpty((String)telphoneNumber)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"require_telephoneNumber"));
                SysUtil.abort();
            }
            result = bankFacade.syncStateByElecBook(FMHelper.list2Set((List)idList), adjustCause, telphoneNumber);
        } else {
            result = bankFacade.syncStateByElecBook(FMHelper.list2Set((List)idList), adjustCause, telphoneNumber);
        }
        this.showResult(e, idList, result, "sync");
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ElecBookFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ElecBookFilerUI();
        }
        return this.filterUI;
    }

    protected String getEditUIName() {
        return null;
    }

    public void executeQuery(FilterParam param) throws BOSException {
        ElecBookFilerParam paramInfo = (ElecBookFilerParam)param;
        if (paramInfo.isOnLine()) {
            IBankFacade bankFacade = BankFacadeFactory.getRemoteInstance();
            try {
                BankInterface bankInterface = new BankInterface();
                bankInterface.setName(paramInfo.getBankInterFace());
                bankInterface.setNumber(paramInfo.getBankInterFaceID());
                Map rst = bankFacade.getElecBookDetails(paramInfo.getCurrencyId(), paramInfo.getBankAcctIds(), paramInfo.getBeginPeriodYear(), paramInfo.getBeginPeriodMonth(), paramInfo.getEndPeriodMonth(), bankInterface, paramInfo.getOnLineType());
                String successMsg = (String)rst.get("success");
                MsgBox.showDetailAndOK((Component)((Object)this), (String)successMsg, (String)"", (int)1);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                String[] message = e.getMessage().split(";");
                MsgBox.showDetailAndOK((Component)((Object)this), (String)message[0], (String)message[1], (int)1);
                SysUtil.abort();
            }
            catch (Exception e) {
                logger.error((Object)e);
                String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"OnLineSearchError"), e.getMessage());
                MsgBox.showInfo((Component)((Object)this), (String)msgStr);
                SysUtil.abort();
            }
        }
        super.executeQuery(param);
    }

    protected void execQuery() {
        super.execQuery();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (e == null) {
                return;
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = ElecBookListUI.this.tblMain.getRow(i);
                currencyId = (String)row.getCell("Currency.id").getValue();
                if (currencyId == null) continue;
                FMClientHelper.setNumberFormat((IRow)row, (String)"Balance", (String)currencyId);
            }
        }
    }
}

