/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.fi.cas.FeeTypeCollection;
import com.kingdee.eas.fi.cas.FeeTypeFactory;
import com.kingdee.eas.fi.cas.IFeeType;
import com.kingdee.eas.fi.cas.client.AbstractFeeTypeListF7UI;
import com.kingdee.eas.fi.cas.client.FeeTypeEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class FeeTypeListF7UI
extends AbstractFeeTypeListF7UI {
    private static final Logger logger = CoreUIObject.getLogger(FeeTypeListF7UI.class);
    public static final String EV = "ev";
    public static final String IS_ENABLED_MULTI_SELECTION = "isEnabledMultiSelection";
    public static final String QueryInfo = "QueryInfo";
    public static final String ISBANK = "isBank";
    public static final String ISLEAF = "isLeaf";
    private EntityViewInfo ev = null;
    protected boolean isCanceled = true;
    private boolean isEnableMultiSelect = false;
    private Object rstData;
    boolean isLeaf = true;

    public FeeTypeListF7UI() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas", "FeeTypeQuery");
    }

    public void onLoad() throws Exception {
        Object isms = this.getUIContext().get(IS_ENABLED_MULTI_SELECTION);
        this.isEnableMultiSelect = isms != null && isms.equals(Boolean.TRUE);
        this.ev = (EntityViewInfo)this.getUIContext().get(EV);
        if (this.getUIContext().get(ISLEAF) != null) {
            this.isLeaf = (Boolean)this.getUIContext().get(ISLEAF);
        }
        super.onLoad();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionView.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionView.setEnabled(false);
        this.actionConfirm.setEnabled(true);
        this.actionClose.setEnabled(true);
        this.tblMain.checkParsed();
        this.tblMain.getColumn("longNumber").getStyleAttributes().setHided(true);
        this.pnlMain.setFocusCycleRoot(false);
        this.pnlMain.setFocusTraversalPolicy(null);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.tblMain, this.btnConfirm, this.btnColse, this.cboKey, this.txtValue, this.btnFastQuery, this.chkLike, this.treeMain}));
        this.setFocusCycleRoot(true);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.actionConfirm_actionPerformed(e);
    }

    public Object getRstData() {
        return this.rstData;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)Constants.TRUE));
        }
        if (this.ev != null) {
            FilterInfo f = (FilterInfo)this.ev.getFilter().clone();
            if (filter.getFilterItems().size() == 0) {
                filter = f;
            } else {
                try {
                    if (f.getFilterItems().size() != 0) {
                        filter.mergeFilter(f, "AND");
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return filter;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)Constants.FALSE));
        return filter;
    }

    protected String getEditUIName() {
        return FeeTypeEditUI.class.getName();
    }

    protected String getRootName() {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.app.FeeType"));
        return entity.getAlias();
    }

    protected boolean isIncludeAllChildren() {
        return true;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return FeeTypeFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.buildRstValues();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.buildRstValues();
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    private void buildRstValues() throws BOSException {
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowID.length < 1) {
            this.abort();
        }
        IFeeType iFeeType = FeeTypeFactory.getRemoteInstance();
        if (this.isEnableMultiSelect) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < rowID.length; ++i) {
                String id = this.tblMain.getRow(rowID[i]).getCell(0).getValue().toString();
                idSet.add(id);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            FeeTypeCollection feeTypeColl = iFeeType.getFeeTypeCollection(view);
            if (feeTypeColl != null && feeTypeColl.size() > 0) {
                this.rstData = feeTypeColl.toArray();
            }
        } else {
            if (this.tblMain.getRow(rowID[0]) == null) {
                this.abort();
            }
            String id = this.tblMain.getRow(rowID[0]).getCell(0).getValue().toString();
            try {
                this.rstData = iFeeType.getFeeTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
            catch (Exception ex) {
                this.handUIException(ex);
                this.abort();
            }
        }
    }

    @Override
    protected void btnFastQuery_actionPerformed(ActionEvent e) throws Exception {
        super.btnFastQuery_actionPerformed(e);
        FilterInfo filterInfo = new FilterInfo();
        if (this.cboKey.getSelectedIndex() == 0) {
            if (this.chkLike.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + this.txtValue.getText().trim() + "%"), CompareType.LIKE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)this.txtValue.getText().trim()));
            }
        } else if (this.chkLike.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + this.txtValue.getText().trim() + "%"), CompareType.LIKE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtValue.getText().trim()));
        }
        if (this.getDefaultFilterForQuery() != null && this.getDefaultFilterForQuery().getFilterItems().size() > 0) {
            filterInfo.mergeFilter(this.getDefaultFilterForQuery(), "and");
        }
        this.mainQuery = new EntityViewInfo();
        this.mainQuery.setFilter(filterInfo);
        this.tblMain.removeRows();
        this.tblMain.requestFocusInWindow();
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return PersonFactory.getRemoteInstance();
    }

    protected JButton getDefaultButton() {
        return this.btnConfirm;
    }
}

