/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemCollection;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.client.AbstractFundFlowItemF7UI;
import com.kingdee.eas.fi.cas.client.SelectTypeF7Enum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class FundFlowItemF7UI
extends AbstractFundFlowItemF7UI
implements TreeSelectionListener {
    private static final long serialVersionUID = 3702065420636150450L;
    private static final Logger logger = CoreUIObject.getLogger(FundFlowItemF7UI.class);
    public boolean isCanceled = true;
    public FundFlowItemInfo data = null;
    public FundFlowItemCollection datas = null;
    private boolean isMultiSelect = false;
    private EntityViewInfo entityViewInfo = null;
    private Set<String> treeNumber = new HashSet<String>();

    public void onLoad() throws Exception {
        if (this.getUIContext().get("entityViewInfo") != null) {
            this.entityViewInfo = (EntityViewInfo)this.getUIContext().get("entityViewInfo");
        }
        super.onLoad();
        this.initTree();
        this.btnConfirm.setEnabled(true);
        this.btnQuit.setEnabled(true);
        this.btnFastQuery.setEnabled(true);
        this.ckLike.setSelected(true);
        if (this.getUIContext().get("isMultiSelect") != null) {
            this.isMultiSelect = (Boolean)this.getUIContext().get("isMultiSelect");
        }
        if (this.isMultiSelect) {
            this.tblMain.getSelectManager().setSelectMode(10);
        } else {
            this.tblMain.getSelectManager().setSelectMode(2);
        }
        this.tblMain.setColumnMoveable(true);
        this.actionShowAll.setEnabled(true);
        this.kDTreeView1.setShowButton(false);
        if (this.getUIContext().get("direction") == null) {
            this.ckAll.setVisible(false);
        } else {
            this.ckAll.setVisible(true);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() != 0) {
            if (e.getClickCount() == 2) {
                this.actionConfirm_actionPerformed(null);
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundFlowItemFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = false;
        this.getData();
        if (this.data == null && !this.isMultiSelect) {
            return;
        }
        if (this.datas == null && this.isMultiSelect) {
            return;
        }
        this.getUIWindow().close();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.mainQuery.setFilter(this.getCurrentFilter(true));
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("longnumber"));
        this.mainQuery.setSorter(sorterColl);
        this.execQuery();
    }

    @Override
    public void actionFastQuery_actionPerformed(ActionEvent e) throws Exception {
        this.mainQuery.setFilter(this.getCurrentFilter(true));
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("longnumber"));
        this.mainQuery.setSorter(sorterColl);
        this.execQuery();
    }

    @Override
    public void actionShowAll_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
        this.mainQuery.setFilter(this.getCurrentFilter(false));
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("longnumber"));
        this.mainQuery.setSorter(sorterColl);
        this.execQuery();
    }

    protected Set<String> getWithAllChildren(Set<String> selectIdSet) {
        HashSet<String> idSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", selectIdSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        view.setFilter(filter);
        view.setSelector(selector);
        try {
            TreeBaseCollection resultColl = FundFlowItemFactory.getRemoteInstance().getTreeBaseCollection(view);
            TreeBaseInfo info = null;
            for (int i = 0; i < resultColl.size(); ++i) {
                info = resultColl.get(i);
                idSet.add(info.getId().toString());
                if (info.isIsLeaf()) continue;
                EntityViewInfo ev = new EntityViewInfo();
                ev.setFilter(new FilterInfo());
                ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE));
                TreeBaseCollection col = FundFlowItemFactory.getRemoteInstance().getTreeBaseCollection(ev);
                for (int j = 0; j < col.size(); ++j) {
                    idSet.add(col.get(j).getId().toString());
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return idSet;
    }

    private void getData() throws Exception {
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        ObjectUuidPK selectedPk = null;
        HashSet<String> selectedIds = null;
        int bottom = 0;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        if (this.isMultiSelect) {
            selectedIds = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                sb = this.tblMain.getSelectManager().get(i);
                bottom = sb.getBottom();
                for (int j = sb.getTop(); j <= bottom; ++j) {
                    selectedIds.add(this.tblMain.getRow(j).getCell("id").getValue().toString());
                }
            }
            Set<String> withAllChildren = this.getWithAllChildren(selectedIds);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", withAllChildren, CompareType.INCLUDE));
            this.datas = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(viewInfo);
            if (this.datas == null || this.datas.size() <= 0) {
                this.datas = null;
            }
        } else if (size > 0) {
            sb = this.tblMain.getSelectManager().get(0);
            if (sb.getTop() < 0) {
                this.data = null;
                return;
            }
            selectedPk = new ObjectUuidPK(this.tblMain.getRow(sb.getTop()).getCell("id").getValue().toString());
            this.data = FundFlowItemFactory.getRemoteInstance().getFundFlowItemInfo((IObjectPK)selectedPk, sic);
            if (!this.data.isIsLeaf()) {
                this.data = null;
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"mustLeaf"));
                SysUtil.abort();
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("longnumber"));
        this.mainQuery.setSorter(sorterColl);
        FilterInfo retFilterInfo = this.getCommonFilter();
        return retFilterInfo;
    }

    private FilterInfo getCurrentFilter(boolean isIncludeNumberName) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo = this.getCommonFilter();
        DefaultKingdeeTreeNode treeNode = this.getSelectedTreeNode();
        if (!treeNode.isRoot()) {
            FilterInfo tempFilter = new FilterInfo();
            FundFlowItemInfo info = (FundFlowItemInfo)treeNode.getUserObject();
            tempFilter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(info.getNumber() + "%"), CompareType.LIKE));
            try {
                filterInfo.mergeFilter(tempFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        if (isIncludeNumberName) {
            FilterInfo queryFilter = this.createFilter();
            try {
                filterInfo.mergeFilter(queryFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return filterInfo;
    }

    private FilterInfo getCommonFilter() {
        FilterInfo retFilterInfo = new FilterInfo();
        retFilterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)0));
        if (!this.ckAll.isSelected() && this.getUIContext().get("direction") != null) {
            FundFlowDirection direciton = (FundFlowDirection)((Object)this.getUIContext().get("direction"));
            retFilterInfo.getFilterItems().add(new FilterItemInfo("direction", (Object)direciton.getValue()));
            retFilterInfo.getFilterItems().add(new FilterItemInfo("direction", (Object)0));
            retFilterInfo.setMaskString("#0 and (#1 or #2)");
        }
        return retFilterInfo;
    }

    private FilterInfo createFilter() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        String value = this.txtValue.getText();
        if (!StringUtils.isEmpty((String)value)) {
            if (this.ckLike.isSelected()) {
                value = "%" + value.trim() + "%";
                if (SelectTypeF7Enum.name.equals(this.cbKey.getSelectedItem())) {
                    fic.add(new FilterItemInfo("name", (Object)value, CompareType.LIKE));
                } else if (SelectTypeF7Enum.number.equals(this.cbKey.getSelectedItem())) {
                    fic.add(new FilterItemInfo("number", (Object)value, CompareType.LIKE));
                }
            } else {
                value = value.trim();
                if (SelectTypeF7Enum.name.equals(this.cbKey.getSelectedItem())) {
                    fic.add(new FilterItemInfo("name", (Object)value, CompareType.EQUALS));
                } else if (SelectTypeF7Enum.number.equals(this.cbKey.getSelectedItem())) {
                    fic.add(new FilterItemInfo("number", (Object)value, CompareType.EQUALS));
                }
            }
        }
        return filter;
    }

    private void initTree() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = this.getCommonFilter();
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo();
        sort = new SorterItemInfo("longnumber");
        sortColl.add(sort);
        evi.setFilter(filterInfo);
        evi.setSorter(sortColl);
        FundFlowItemCollection otc = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(evi);
        this.fillTreeByFundFlowItem(this.treeMain, otc, true);
    }

    public void fillTreeByFundFlowItem(KDTree tree, FundFlowItemCollection companyCol, boolean direction) {
        DefaultKingdeeTreeNode rootNode;
        if (companyCol == null) {
            return;
        }
        DefaultKingdeeTreeNode parent = rootNode = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"allFundFlowItem"));
        HashMap<BOSUuid, DefaultKingdeeTreeNode> companyC = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
        for (int i = 0; i < companyCol.size(); ++i) {
            FundFlowItemInfo company = companyCol.get(i);
            DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
            child.setUserObject((Object)company);
            companyC.put(company.getId(), child);
            FundFlowItemInfo p = company.getParent();
            parent = p != null && companyC.get(p.getId()) != null ? (DefaultKingdeeTreeNode)companyC.get(p.getId()) : rootNode;
            parent.add((MutableTreeNode)child);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)rootNode);
        tree.setModel((TreeModel)model);
        tree.setSelectionNode(rootNode);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.buildTreeFilter();
        this.execQuery();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    private DefaultKingdeeTreeNode getSelectedTreeNode() {
        return (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    private void buildTreeFilter() {
        DefaultKingdeeTreeNode treeNode = this.getSelectedTreeNode();
        FilterInfo filterInfo = new FilterInfo();
        if (treeNode == null) {
            return;
        }
        filterInfo = this.getCommonFilter();
        if (!treeNode.isRoot()) {
            FilterInfo tempFilter = new FilterInfo();
            FundFlowItemInfo info = (FundFlowItemInfo)treeNode.getUserObject();
            if (treeNode.isLeaf()) {
                tempFilter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)info.getLongNumber(), CompareType.EQUALS));
            } else {
                tempFilter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(info.getLongNumber() + "%"), CompareType.LIKE));
            }
            try {
                filterInfo.mergeFilter(tempFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        this.mainQuery.setFilter(filterInfo);
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHandler = super.prepareInit();
        if (clientHandler != null) {
            RequestContext request = new RequestContext();
            if (this.getUIContext().get("entityViewInfo") != null) {
                this.entityViewInfo = (EntityViewInfo)this.getUIContext().get("entityViewInfo");
            }
            request.put("entityViewInfo", (Object)this.entityViewInfo);
            clientHandler.setRequestContext((Serializable)request);
        }
        return clientHandler;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public boolean isPrepareActionConfirm() {
        return true;
    }

    @Override
    public RequestContext prepareActionConfirm(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionConfirm(itemAction);
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        ObjectUuidPK selectedPk = null;
        HashSet<String> selectedIds = null;
        int bottom = 0;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isStart"));
        sic.add(new SelectorItemInfo("typeName"));
        request.put("isMultiSelect", (Object)new Boolean(this.isMultiSelect));
        if (this.isMultiSelect) {
            selectedIds = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                sb = this.tblMain.getSelectManager().get(i);
                bottom = sb.getBottom();
                for (int j = sb.getTop(); j <= bottom; ++j) {
                    selectedIds.add(this.tblMain.getRow(j).getCell("id").getValue().toString());
                }
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", selectedIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)Boolean.TRUE, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            request.put("viewInfo", (Object)viewInfo);
        } else {
            request.put("size", (Object)new Integer(size));
            if (size > 0) {
                sb = this.tblMain.getSelectManager().get(0);
                request.put("top", (Object)new Integer(sb.getTop()));
                if (sb.getTop() >= 0) {
                    selectedPk = new ObjectUuidPK(this.tblMain.getRow(sb.getTop()).getCell("id").getValue().toString());
                    request.put("selectedPk", (Object)selectedPk);
                    request.put("sic", (Object)sic);
                }
            }
        }
        return request;
    }

    private class MyCheckBoxChange
    implements ItemListener {
        private MyCheckBoxChange() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                FundFlowItemF7UI.this.actionRefresh_actionPerformed(null);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
    }
}

