/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceFactory;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.XTable;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;

public class JournalReportHelper {
    public static XTable createJournalDataTable(PeriodCollection periodCol, String[] companyIds, String[] bankIds, CurrencyInfo currency) throws BOSException {
        XTable balanceTable = JournalReportHelper.createJournalBalanceTable(periodCol, companyIds, bankIds, currency);
        XTable sumTable = JournalReportHelper.createJournalSumTable(periodCol, companyIds, bankIds, new String[]{currency.getId().toString()});
        for (int i = 0; i < periodCol.size(); ++i) {
            PeriodInfo curPeriod = periodCol.get(i);
            String[] rowKeys = balanceTable.getRowKeys();
            for (int j = 0; j < rowKeys.length; ++j) {
                String rowKey = rowKeys[j];
                Map balanceRow = balanceTable.getRow(rowKey);
                PeriodInfo period = (PeriodInfo)balanceRow.get("period");
                if (!curPeriod.getId().toString().equals(period.getId().toString())) continue;
                Map sumRow = sumTable.getRow(rowKey);
                if (sumRow != null) {
                    BigDecimal debitAmount = (BigDecimal)sumRow.get("debitamount");
                    BigDecimal creditAmount = (BigDecimal)sumRow.get("creditamount");
                    if (debitAmount == null) {
                        debitAmount = FMConstants.ZERO;
                    }
                    if (creditAmount == null) {
                        creditAmount = FMConstants.ZERO;
                    }
                    balanceRow.put("debitAmount", debitAmount);
                    balanceRow.put("creditAmount", creditAmount);
                } else {
                    balanceRow.put("debitAmount", FMConstants.ZERO);
                    balanceRow.put("creditAmount", FMConstants.ZERO);
                }
                if (i == periodCol.size() - 1) continue;
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)balanceRow.get("company");
                BankInfo bank = (BankInfo)balanceRow.get("bank");
                CurrencyInfo currencyInfo = (CurrencyInfo)balanceRow.get("currency");
                AccountBankInfo accountBank = (AccountBankInfo)balanceRow.get("accountBank");
                BigDecimal balance = (BigDecimal)balanceRow.get("balance");
                BigDecimal debitAmount = (BigDecimal)balanceRow.get("debitAmount");
                BigDecimal creditAmount = (BigDecimal)balanceRow.get("creditAmount");
                Map nextPeriodRow = balanceTable.addRow(periodCol.get(i + 1).getId().toString() + company.getId().toString() + bank.getId().toString() + currencyInfo.getId().toString() + accountBank.getId().toString());
                nextPeriodRow.put("period", periodCol.get(i + 1));
                nextPeriodRow.put("company", company);
                nextPeriodRow.put("bank", bank);
                nextPeriodRow.put("currency", currencyInfo);
                nextPeriodRow.put("accountBank", accountBank);
                nextPeriodRow.put("balance", balance.add(debitAmount).subtract(creditAmount));
                nextPeriodRow.put("debitAmount", FMConstants.ZERO);
                nextPeriodRow.put("creditAmount", FMConstants.ZERO);
            }
        }
        return balanceTable;
    }

    private static Set createSetByArray(String[] array) {
        return FMHelper.asSet((String[])array);
    }

    private static String getJournalSumSQL(PeriodCollection periodCol, String[] companyIds, String[] bankIds, String[] currencyIds) {
        int i;
        String select = "Select FPeriodID as period,t1.FCompanyID as company,FBank as bank,t1.FCurrencyID as currency,FAccountBankId as accountBank,sum(FDebitAmount) as debitAmount,sum(FCreditAmount) as creditAmount";
        String from = " From t_cas_journal t1 left join t_bd_accountBanks t2 on t1.faccountbankid=t2.fid";
        String groupBy = " Group By FPeriodID,t1.FCompanyID,FBank,t1.FCurrencyID,FAccountBankId";
        StringBuffer where = new StringBuffer();
        where.append(" where 1=1 ");
        if (periodCol != null) {
            where.append(" And t1.FPeriodID in ('").append(periodCol.get(0).getId().toString()).append("'");
            for (i = 1; i < periodCol.size(); ++i) {
                where.append(",'").append(periodCol.get(i).getId().toString()).append("'");
            }
            where.append(")");
        }
        if (companyIds != null && companyIds.length != 0) {
            where.append(" And t1.FcompanyId in ('").append(companyIds[0]).append("'");
            for (i = 1; i < companyIds.length; ++i) {
                where.append(",'").append(companyIds[i]).append("'");
            }
            where.append(")");
        }
        if (bankIds != null && bankIds.length != 0) {
            where.append(" And  FBank in ('").append(bankIds[0]).append("'");
            for (i = 1; i < bankIds.length; ++i) {
                where.append(",'").append(bankIds[i]).append("'");
            }
            where.append(")");
        }
        if (currencyIds != null && currencyIds.length != 0) {
            where.append(" And  t1.FCurrencyID in ('").append(currencyIds[0]).append("'");
            for (i = 1; i < currencyIds.length; ++i) {
                where.append(",'").append(currencyIds[i]).append("'");
            }
            where.append(")");
        }
        String sql = select + from + where + groupBy;
        return sql;
    }

    private static XTable createJournalSumTable(PeriodCollection periodCol, String[] companyIds, String[] bankIds, String[] currencyIds) throws BOSException {
        String sumSql = JournalReportHelper.getJournalSumSQL(periodCol, companyIds, bankIds, currencyIds);
        IRowSet sumRS = SQLExecutorFactory.getRemoteInstance((String)sumSql).executeSQL();
        XTable xSumTable = new XTable(sumRS, new String[]{"period", "company", "bank", "currency", "accountBank"});
        return xSumTable;
    }

    private static XTable createJournalBalanceTable(PeriodCollection periodCol, String[] companyIds, String[] bankIds, CurrencyInfo currency) throws BOSException {
        Map map;
        String rowKey;
        Object col;
        XTable journalTable = new XTable();
        journalTable = new XTable();
        journalTable.addColumn("period");
        journalTable.addColumn("company");
        journalTable.addColumn("bank");
        journalTable.addColumn("accountBank");
        journalTable.addColumn("balance");
        journalTable.addColumn("debitAmount");
        journalTable.addColumn("creditAmount");
        String[] periodIds = new String[periodCol.size()];
        for (int i = 0; i < periodCol.size(); ++i) {
            PeriodInfo period = periodCol.get(i);
            periodIds[i] = period.getId().toString();
            col = CashHelper.getAccountBankCollection(companyIds, bankIds, false);
            for (int j = 0; j < col.size(); ++j) {
                AccountBankInfo accountBank = col.get(j);
                rowKey = period.getId().toString() + accountBank.getCompany().getId().toString() + accountBank.getBank().getId().toString() + currency.getId().toString() + accountBank.getId().toString();
                map = journalTable.addRow(rowKey);
                map.put("period", period);
                map.put("company", accountBank.getCompany());
                map.put("bank", accountBank.getBank());
                map.put("currency", currency);
                map.put("accountBank", accountBank);
                map.put("balance", FMConstants.ZERO);
                map.put("debitAmount", FMConstants.ZERO);
                map.put("creditAmount", FMConstants.ZERO);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        view.getSelector().add("period.*");
        view.getSelector().add("accountBank.bank.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)JournalReportHelper.createSetByArray(periodIds), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)JournalReportHelper.createSetByArray(companyIds), CompareType.INCLUDE));
        if (!FMHelper.isEmpty((Object[])bankIds)) {
            filter.getFilterItems().add(new FilterItemInfo("accountBank.bank.id", (Object)JournalReportHelper.createSetByArray(bankIds), CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(2)));
        view.setFilter(filter);
        col = JournalBalanceFactory.getRemoteInstance().getJournalBalanceCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            JournalBalanceInfo journalBalance = ((JournalBalanceCollection)((Object)col)).get(i);
            rowKey = journalBalance.getPeriod().getId().toString() + journalBalance.getCompany().getId().toString() + journalBalance.getAccountBank().getBank().getId().toString() + journalBalance.getCurrency().getId().toString() + journalBalance.getAccountBank().getId().toString();
            map = journalTable.getRow(rowKey);
            if (map == null) continue;
            map.put("balance", journalBalance.getMonthStartAmt());
            map.put("debitAmount", journalBalance.getMonthDebitAmt());
            map.put("creditAmount", journalBalance.getMonthCreditAmt());
        }
        return journalTable;
    }
}

