/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.client.NoteReviewUI;
import com.kingdee.eas.fm.common.util.BizRelateReceivableBillUtil;
import com.kingdee.eas.fm.common.util.ReceivableBillEntryVO;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.IPayableBill;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NoteReviewUtil {
    private static final String BOSTYPE_RECEIVABLE = "16CC5356";
    private static final String BOSTYPE_PAYABLE = "FD410AF6";
    public static List<String> REC_COL_SEQ = new ArrayList<String>(Arrays.asList("draftNumber", "billAmt", "billState"));
    public static List<String> PAY_COL_SEQ = new ArrayList<String>(Arrays.asList("draftNumber", "Amount", "BillState"));

    public static IUIWindow getNoteReviewUI(HashMap uiCtx, String bosType) throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWin = uiFactory.create("com.kingdee.eas.fi.cas.client.NoteReviewUI", (Map)uiCtx);
        ((UIModelDialog)uiWin).setResizable(true);
        NoteReviewUI reviewUI = (NoteReviewUI)uiWin.getUIObject();
        NoteReviewUtil.setbosTypeAndSequence(reviewUI, bosType);
        return uiWin;
    }

    public static IUIWindow getNoteReviewByPaymentID(HashMap uiCtx, String paymentBillID) throws Exception {
        PaymentBillInfo paymentInfo = NoteReviewUtil.getPaymentBillInfo(paymentBillID);
        String NoteBosType = NoteReviewUtil.getNoteBosType(paymentInfo.getSettlementType());
        List entryList = BizRelateReceivableBillUtil.getReceivableEntryList(null, (CoreBaseInfo)paymentInfo);
        if (!EmptyUtil.isEmpty((Collection)entryList)) {
            HashSet<String> idSet = new HashSet<String>();
            String settleNumbers = "";
            for (int i = 0; i < entryList.size(); ++i) {
                ReceivableBillEntryVO entryVO = (ReceivableBillEntryVO)entryList.get(i);
                if (!EmptyUtil.isEmpty((String)((ReceivableBillEntryVO)entryList.get(i)).getReceivableBillID())) {
                    idSet.add(((ReceivableBillEntryVO)entryList.get(i)).getReceivableBillID());
                }
                if (EmptyUtil.isEmpty((String)((ReceivableBillEntryVO)entryList.get(i)).getReceivableBillNum())) continue;
                settleNumbers = settleNumbers + ((ReceivableBillEntryVO)entryList.get(i)).getReceivableBillNum() + ";";
            }
            if (idSet.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                uiCtx.put("BOTPFilter", evi);
            } else {
                AbstractObjectCollection noteColl = NoteReviewUtil.getNoteCollByDraftNumber(paymentInfo.getSettlementType(), settleNumbers, paymentInfo.getPayeeName(), paymentInfo.getCompany().getId().toString());
                NoteReviewUtil.putBOTPFilter2uiCtx(uiCtx, noteColl);
            }
        } else {
            AbstractObjectCollection noteColl = NoteReviewUtil.getNoteColl(paymentInfo);
            NoteReviewUtil.putBOTPFilter2uiCtx(uiCtx, noteColl);
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWin = uiFactory.create("com.kingdee.eas.fi.cas.client.NoteReviewUI", (Map)uiCtx);
        ((UIModelDialog)uiWin).setResizable(true);
        NoteReviewUI reviewUI = (NoteReviewUI)uiWin.getUIObject();
        NoteReviewUtil.setbosTypeAndSequence(reviewUI, NoteBosType);
        return uiWin;
    }

    public static IUIWindow getNoteReviewByDraftNumber(HashMap uiCtx, SettlementTypeInfo settType, String DraftNumbers, String payeeName, String companyID) throws Exception {
        String NoteBosType = NoteReviewUtil.getNoteBosType(settType);
        AbstractObjectCollection noteColl = NoteReviewUtil.getNoteCollByDraftNumber(settType, DraftNumbers, payeeName, companyID);
        NoteReviewUtil.putBOTPFilter2uiCtx(uiCtx, noteColl);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWin = uiFactory.create("com.kingdee.eas.fi.cas.client.NoteReviewUI", (Map)uiCtx);
        ((UIModelDialog)uiWin).setResizable(true);
        NoteReviewUI reviewUI = (NoteReviewUI)uiWin.getUIObject();
        NoteReviewUtil.setbosTypeAndSequence(reviewUI, NoteBosType);
        return uiWin;
    }

    private static boolean isSettleByNote(SettlementTypeInfo settType) {
        return settType != null && settType.getNtType() != null && (NTTypeGroupEnum.RECEIVABLE.equals((Object)settType.getNtType().getSuperGroup()) || NTTypeGroupEnum.PAYABLE.equals((Object)settType.getNtType().getSuperGroup()) || NTTypeGroupEnum.PaymentCheque.equals((Object)settType.getNtType().getSuperGroup()) && (NTTypeGroupEnum.CHEQUE.equals((Object)settType.getNtType().getGroup()) || NTTypeGroupEnum.TELE_ORDER.equals((Object)settType.getNtType().getGroup())));
    }

    private static PaymentBillInfo getPaymentBillInfo(String paymentBillID) throws BOSException, EASBizException {
        IPaymentBill paymentBill = PaymentBillFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("settlementType.ntType.*"));
        sic.add("settlementNumber");
        sic.add("payeeName");
        sic.add("company");
        PaymentBillInfo paymentBillInfo = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(paymentBillID), sic);
        return paymentBillInfo;
    }

    private static PayableBillCollection getPayableBillColl(String CompanyID, Set DraftNumbers) throws BOSException, EASBizException {
        IPayableBill payableBill = PayableBillFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(sic);
        sic.add("id");
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)CompanyID));
        filter.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)DraftNumbers, CompareType.INCLUDE));
        PayableBillCollection payableColl = payableBill.getPayableBillCollection(view);
        return payableColl;
    }

    private static ReceivableBillCollection getReceiVableBillColl(String CompanyID, Set DraftNumbers, String payeeName) throws BOSException, EASBizException {
        ReceivableBillCollection filterColl = new ReceivableBillCollection();
        if (!EmptyUtil.isEmpty((Collection)DraftNumbers)) {
            HashMap draftMap = new HashMap();
            for (Object o : DraftNumbers) {
                draftMap.put(o.toString(), new ArrayList());
            }
            IReceivableBill receivableBill = ReceivableBillFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            view.setFilter(filter);
            view.setSelector(sic);
            sic.add("id");
            sic.add("billState");
            sic.add("draftNumber");
            sic.add("endorseBill.endorsee");
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)CompanyID));
            filter.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)DraftNumbers, CompareType.INCLUDE));
            ReceivableBillCollection receiVableBillColl = receivableBill.getReceivableBillCollection(view);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)receiVableBillColl)) {
                for (int i = 0; i < receiVableBillColl.size(); ++i) {
                    ArrayList notes = (ArrayList)draftMap.get(receiVableBillColl.get(i).getDraftNumber());
                    notes.add(receiVableBillColl.get(i));
                }
                block2: for (Map.Entry entry : draftMap.entrySet()) {
                    ArrayList noteList = (ArrayList)entry.getValue();
                    if (noteList.size() == 1) {
                        filterColl.add((ReceivableBillInfo)((ArrayList)entry.getValue()).get(0));
                        continue;
                    }
                    if (noteList.size() <= 1) continue;
                    boolean matched = false;
                    for (ReceivableBillInfo noteInfo : noteList) {
                        if (EmptyUtil.isEmpty((String)payeeName) || EmptyUtil.isEmpty((CoreBaseInfo)noteInfo.getEndorseBill()) || !payeeName.equals(noteInfo.getEndorseBill().getEndorsee())) continue;
                        filterColl.add(noteInfo);
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    for (ReceivableBillInfo noteInfo : noteList) {
                        if (!BillStateEnum.Audit.equals((Object)noteInfo.getBillState()) && !BillStateEnum.SAVED.equals((Object)noteInfo.getBillState())) continue;
                        filterColl.add(noteInfo);
                        matched = true;
                        continue block2;
                    }
                }
            }
        }
        return filterColl;
    }

    private static String getNoteBosType(SettlementTypeInfo settleType) {
        if (NTTypeGroupEnum.RECEIVABLE.equals((Object)settleType.getNtType().getSuperGroup())) {
            return BOSTYPE_RECEIVABLE;
        }
        if (NTTypeGroupEnum.PAYABLE.equals((Object)settleType.getNtType().getSuperGroup())) {
            return BOSTYPE_PAYABLE;
        }
        return null;
    }

    private static AbstractObjectCollection getNoteColl(PaymentBillInfo paymentInfo) throws EASBizException, BOSException {
        SettlementTypeInfo settleType = paymentInfo.getSettlementType();
        String NoteBosType = "";
        ReceivableBillCollection coll = null;
        String payeeName = paymentInfo.getPayeeName();
        Set draftNumbers = new HashSet();
        if (!EmptyUtil.isEmpty((String)paymentInfo.getSettlementNumber())) {
            draftNumbers = NoteReviewUtil.trimDraftNumbers(paymentInfo.getSettlementNums());
        }
        if (NoteReviewUtil.isSettleByNote(settleType) && !EmptyUtil.isEmpty((String)paymentInfo.getSettlementNumber())) {
            NoteBosType = NoteReviewUtil.getNoteBosType(settleType);
            if (NoteBosType.equals(BOSTYPE_RECEIVABLE)) {
                coll = NoteReviewUtil.getReceiVableBillColl(paymentInfo.getCompany().getId().toString(), draftNumbers, payeeName);
            } else if (NoteBosType.equals(BOSTYPE_PAYABLE)) {
                coll = NoteReviewUtil.getPayableBillColl(paymentInfo.getCompany().getId().toString(), draftNumbers);
            }
        }
        return coll;
    }

    public static Set trimDraftNumbers(Set DraftNumbers) {
        HashSet<String> trimNumbers = new HashSet<String>();
        if (!EmptyUtil.isEmpty((Collection)DraftNumbers)) {
            for (Object O : DraftNumbers) {
                trimNumbers.add(((String)O).trim());
            }
        }
        return trimNumbers;
    }

    private static AbstractObjectCollection getNoteCollByDraftNumber(SettlementTypeInfo settType, String DraftNumbers, String payeeName, String companyID) throws EASBizException, BOSException {
        String NoteBosType = "";
        ReceivableBillCollection coll = null;
        if (!EmptyUtil.isEmpty((String)DraftNumbers)) {
            String[] draftNums = DraftNumbers.split(";");
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < draftNums.length; ++i) {
                set.add(draftNums[i].trim());
            }
            if (NoteReviewUtil.isSettleByNote(settType) && !EmptyUtil.isEmpty((String)DraftNumbers)) {
                NoteBosType = NoteReviewUtil.getNoteBosType(settType);
                if (NoteBosType.equals(BOSTYPE_RECEIVABLE)) {
                    coll = NoteReviewUtil.getReceiVableBillColl(companyID, set, payeeName);
                } else if (NoteBosType.equals(BOSTYPE_PAYABLE)) {
                    coll = NoteReviewUtil.getPayableBillColl(companyID, set);
                }
            }
        }
        return coll;
    }

    private static HashMap putBOTPFilter2uiCtx(HashMap uiCtx, AbstractObjectCollection noteColl) {
        uiCtx.put("BOTPFilter", NoteReviewUtil.getIDFilterEvi(noteColl));
        return uiCtx;
    }

    private static EntityViewInfo getIDFilterEvi(AbstractObjectCollection coll) {
        HashSet<String> set = new HashSet<String>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            for (int i = 0; i < coll.size(); ++i) {
                set.add(coll.getObject(i).get("id").toString());
            }
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = EmptyUtil.isEmpty(set) ? new FilterItemInfo("id", (Object)"", CompareType.EQUALS) : new FilterItemInfo("id", set, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    public static boolean isSettleByNote(String paymentID) throws EASBizException, BOSException {
        SettlementTypeInfo settType;
        PaymentBillInfo info = NoteReviewUtil.getPaymentBillInfo(paymentID);
        return info != null && (settType = info.getSettlementType()) != null && settType.getNtType() != null && (NTTypeGroupEnum.RECEIVABLE.equals((Object)settType.getNtType().getSuperGroup()) || NTTypeGroupEnum.PAYABLE.equals((Object)settType.getNtType().getSuperGroup()));
    }

    private static void setbosTypeAndSequence(NoteReviewUI reviewUI, String BosType) throws Exception {
        if (BOSTYPE_PAYABLE.equals(BosType)) {
            reviewUI.setColumnSequence(PAY_COL_SEQ);
        } else if (BOSTYPE_RECEIVABLE.equals(BosType)) {
            reviewUI.setColumnSequence(REC_COL_SEQ);
        }
        reviewUI.setSrcBosType(BosType);
    }

    public static IUIWindow getNoteReviewByNoteID(HashMap uiCtx, Set idSet, SettlementTypeInfo settleType) throws Exception {
        if (idSet != null && idSet.size() > 0) {
            String NoteBosType = NoteReviewUtil.getNoteBosType(settleType);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            uiCtx.put("BOTPFilter", evi);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWin = uiFactory.create("com.kingdee.eas.fi.cas.client.NoteReviewUI", (Map)uiCtx);
            ((UIModelDialog)uiWin).setResizable(true);
            NoteReviewUI reviewUI = (NoteReviewUI)uiWin.getUIObject();
            NoteReviewUtil.setbosTypeAndSequence(reviewUI, NoteBosType);
            return uiWin;
        }
        return null;
    }
}

