/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.client.BankOutStandUnreachUIStrategy;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.EntOutStandUnreachUIStrategy;
import com.kingdee.eas.fi.cas.client.OutStandUnreachFilterParam;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class OutStandUnreachUIStrategy {
    protected static final BigDecimal BIG_ZERO = FMConstants.ZERO;
    private static final String FIELD_CREATEDATE = "createDate";
    private static final String FIELD_ISDEBIT = "isDebit";
    private static final String FIELD_COMPANY = "company";
    protected static final String FIELD_DEBITAMOUNT = "debitAmount";
    protected static final String FIELD_CREDITAMOUNT = "creditAmount";
    protected static final String RESOURCEPATH = "com.kingdee.eas.fi.cas.client.OutStandUnreachResource";
    protected static final String RES_ITEM = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"item");
    protected static final String RES_CREATEDATE = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"createDate");
    protected static final String RES_COMPANY = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"company");
    protected static final String RES_DESCRIPTION = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"description");
    protected static final String RES_SETTLEMENTTYPE = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"settlementType");
    protected static final String RES_SETTLEMENTNUMBER = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"settlementNumber");
    protected static final String RES_DEBITAMOUNT = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"debitAmount");
    protected static final String RES_CREDITAMOUNT = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"creditAmount");
    protected static final String RES_BANKREVENTNOT = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"bankRevEntNot");
    protected static final String RES_BANKPAYENTNOT = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"bankPayEntNot");
    protected static final String RES_ENTREVBANKNOT = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"entRevBankNot");
    protected static final String RES_ENTPAYBANKNOT = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"entPayBankNot");
    protected static final String RES_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.OutStandUnreachResource", (String)"total");
    protected static final String COL_ITEM = "item";
    protected static final String COL_CREATEDATE = "createDate";
    protected static final String COL_COMPANY = "company.name";
    protected static final String COL_DESCRIPTION = "description";
    protected static final String COL_SETTLEMENTTYPE = "settlementType";
    protected static final String COL_SETTLEMENTNUMBER = "settlementNumber";
    protected static final String COL_DEBITAMOUNT = "debitAmount";
    protected static final String COL_CREDITAMOUNT = "creditAmount";

    public static OutStandUnreachUIStrategy getInstance(boolean isEntRpt) {
        if (isEntRpt) {
            return new EntOutStandUnreachUIStrategy();
        }
        return new BankOutStandUnreachUIStrategy();
    }

    public void initTable(KDTable table, String currencyId) {
        table.checkParsed();
        FMClientHelper.clearTable((KDTable)table);
        table.getSelectManager().setSelectMode(2);
        String[] columnKeys = this.getTableColumnKeys();
        String[] columnNames = this.getTableColumnNames();
        table.addColumns(columnKeys.length);
        IRow hRow = table.addHeadRow();
        for (int i = 0; i < columnKeys.length; ++i) {
            table.getColumn(i).setKey(columnKeys[i]);
            hRow.getCell(i).setValue((Object)columnNames[i]);
        }
        CashClientHelper.setNumberFormat(table, "debitAmount", currencyId);
        CashClientHelper.setNumberFormat(table, "creditAmount", currencyId);
        table.getStyleAttributes().setLocked(true);
        table.getColumn(COL_ITEM).setWidth(150);
        table.getColumn(COL_DESCRIPTION).setWidth(300);
        table.getColumn(COL_SETTLEMENTTYPE).setWidth(200);
        table.getColumn(COL_SETTLEMENTNUMBER).setWidth(200);
    }

    protected abstract String[] getTableColumnNames();

    protected abstract String[] getTableColumnKeys();

    public IRowSet getRowSet(OutStandUnreachFilterParam param) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.getQueryPk());
        EntityViewInfo ev = this.getEnitiyViewByParam(param);
        exec.setObjectView(ev);
        exec.option().isAutoTranslateEnum = true;
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    private EntityViewInfo getEnitiyViewByParam(OutStandUnreachFilterParam param) {
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(param.getFilter());
        return ev;
    }

    public void fillData(KDTable table, IRowSet rs, OutStandUnreachFilterParam param) throws SQLException {
        BigDecimal recSum = BIG_ZERO;
        BigDecimal paySum = BIG_ZERO;
        IRow recSumRow = null;
        IRow paySumRow = null;
        boolean showRecPay = param.isShowRecPay();
        boolean showTotal = param.isShowTotal();
        boolean isFirstPayRow = true;
        IRow row = null;
        int colCount = rs.getMetaData().getColumnCount();
        if (showRecPay) {
            recSumRow = table.addRow();
        }
        while (rs.next()) {
            if (showRecPay || showTotal) {
                if (this.isRec(rs.getBoolean(FIELD_ISDEBIT))) {
                    recSum = recSum.add(rs.getBigDecimal(this.getRecAmtFieldName()));
                } else {
                    BigDecimal value;
                    if (showRecPay && isFirstPayRow) {
                        paySumRow = table.addRow();
                        isFirstPayRow = false;
                    }
                    if ((value = rs.getBigDecimal(this.getPayAmtFieldName())) != null) {
                        paySum = paySum.add(value);
                    }
                }
            }
            row = table.addRow();
            for (int i = 1; i < colCount; ++i) {
                row.getCell(i).setValue(rs.getObject(i));
            }
        }
        if (showRecPay) {
            recSumRow.getCell(COL_ITEM).setValue((Object)this.getRecItemTxt());
            recSumRow.getCell(this.getRecAmtColumnKey()).setValue((Object)recSum);
            recSumRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
            if (paySumRow == null) {
                paySumRow = table.addRow();
            }
            paySumRow.getCell(COL_ITEM).setValue((Object)this.getPayItemTxt());
            paySumRow.getCell(this.getPayAmtColumnKey()).setValue((Object)paySum);
            paySumRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        } else {
            table.getColumn(COL_ITEM).getStyleAttributes().setHided(true);
        }
        if (showTotal) {
            IRow totalRow = table.addRow();
            if (showRecPay) {
                totalRow.getCell(COL_ITEM).setValue((Object)RES_TOTAL);
            } else {
                totalRow.getCell("createDate").setValue((Object)RES_TOTAL);
            }
            totalRow.getCell(this.getRecAmtColumnKey()).setValue((Object)recSum);
            totalRow.getCell(this.getPayAmtColumnKey()).setValue((Object)paySum);
            totalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        }
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            if (row.getCell("debitAmount").getValue() == null) {
                row.getCell("debitAmount").setValue((Object)CasConstants.ZERO);
            }
            if (row.getCell("creditAmount").getValue() != null) continue;
            row.getCell("creditAmount").setValue((Object)CasConstants.ZERO);
        }
    }

    protected abstract IMetaDataPK getQueryPk();

    protected abstract String getRecItemTxt();

    protected abstract String getPayItemTxt();

    protected abstract String getRecAmtColumnKey();

    protected abstract String getPayAmtColumnKey();

    protected abstract boolean isRec(boolean var1);

    protected abstract String getRecAmtFieldName();

    protected abstract String getPayAmtFieldName();
}

