/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.LogCategoryEnum;
import com.kingdee.eas.fi.cas.PayAdmitSchemeCollection;
import com.kingdee.eas.fi.cas.PayAdmitSchemeFactory;
import com.kingdee.eas.fi.cas.PayAdmitSchemeInfo;
import com.kingdee.eas.fi.cas.PayAntiRepeatCollection;
import com.kingdee.eas.fi.cas.PayAntiRepeatFactory;
import com.kingdee.eas.fi.cas.client.AbstractPayAdmitSchemeListUI;
import com.kingdee.eas.fi.cas.client.PayAdmitSchemeEditUI;
import com.kingdee.eas.fi.cas.client.PayAntiRepeatEditUI;
import com.kingdee.eas.fi.cas.utils.PayAdmitUtils;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayAdmitSchemeListUI
extends AbstractPayAdmitSchemeListUI {
    private static final Logger logger = CoreUIObject.getLogger(PayAdmitSchemeListUI.class);
    private static final String payAdmitResource = "com.kingdee.eas.fi.cas.PayAdmitResource";

    public void onLoad() throws Exception {
        super.onLoad();
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuEdit);
        this.btnAuditResult.setVisible(false);
        this.menuItemAuditResult.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.actionTraceUp.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCancel.setTextIconDisStyle((short)3);
        this.btnCancel.setText(EASResource.getString((String)payAdmitResource, (String)"2_DisEnable"));
        this.btnCancelCancel.setTextIconDisStyle((short)3);
        this.btnCancelCancel.setText(EASResource.getString((String)payAdmitResource, (String)"1_Enable"));
        this.btnToAntiRepeat.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PayAdmitSchemeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return PayAdmitSchemeEditUI.class.getName();
    }

    protected String getEditUIModal() {
        IUIWindow win = this.getUIWindow();
        if (win instanceof UINewFrame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        if (win instanceof UIDialog) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    protected void initListener() {
        super.initListener();
        FMClientHelper.addViewCompHelper((CoreUI)this, (KDMenu)this.menuHelp);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectedIdValues = this.getSelectedIdValues();
        List results = PayAdmitSchemeFactory.getRemoteInstance().cancel(FMHelper.list2Set((List)selectedIdValues));
        int fail = 0;
        StringBuffer error = new StringBuffer();
        StringBuffer errorDetail = new StringBuffer();
        String LINE_SEPARATOR = System.getProperty("line.separator");
        try {
            if (results.size() > 0) {
                for (int j = 0; j < results.size(); ++j) {
                    BankPayResult resultInfo = (BankPayResult)results.get(j);
                    if (resultInfo.getErrorDetail() == null) continue;
                    if (fail != 0) {
                        errorDetail.append(LINE_SEPARATOR);
                    }
                    errorDetail.append("\u3010" + resultInfo.getErrorDetail() + "\u3011");
                    ++fail;
                }
                if (results.size() > 0) {
                    error.append(EASResource.getString((String)payAdmitResource, (String)"3_BatchDisEnableMsg", (Object[])new Object[]{selectedIdValues.size(), selectedIdValues.size() - results.size(), results.size()}));
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)error.toString(), (String)errorDetail.toString(), (int)0);
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)payAdmitResource, (String)"37_disableSuccess"));
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectedIdValues = this.getSelectedIdValues();
        List results = PayAdmitSchemeFactory.getRemoteInstance().cancelCancel(FMHelper.list2Set((List)selectedIdValues));
        int fail = 0;
        StringBuffer error = new StringBuffer();
        StringBuffer errorDetail = new StringBuffer();
        String LINE_SEPARATOR = System.getProperty("line.separator");
        try {
            if (results.size() > 0) {
                for (int j = 0; j < results.size(); ++j) {
                    BankPayResult resultInfo = (BankPayResult)results.get(j);
                    if (resultInfo.getErrorDetail() == null) continue;
                    if (fail != 0) {
                        errorDetail.append(LINE_SEPARATOR);
                    }
                    errorDetail.append("\u3010" + resultInfo.getErrorDetail() + "\u3011");
                    ++fail;
                }
                if (results.size() > 0) {
                    error.append(EASResource.getString((String)payAdmitResource, (String)"4_BatchEnableMsg", (Object[])new Object[]{selectedIdValues.size(), selectedIdValues.size() - results.size(), results.size()}));
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)error.toString(), (String)errorDetail.toString(), (int)0);
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)payAdmitResource, (String)"36_enableSuccess"));
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.refreshList();
    }

    @Override
    public void actionToAntiRepeat_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectedIds = this.getSelectedIdValues();
        if (selectedIds.size() > 1) {
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"5_OnlyChoseOne"));
            SysUtil.abort();
        }
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PermissionFactory.getRemoteInstance().checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), "fi_cas_PayAntiRepeat_02addnew");
        if (PayAntiRepeatFactory.getRemoteInstance().exists("where payAdmitScheme.id='" + selectedIds.get(0).toString() + "'")) {
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"6_HasPayAnti"));
            SysUtil.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)selectedIds), CompareType.INCLUDE));
        view.setFilter(filter);
        PayAdmitSchemeCollection collection = PayAdmitSchemeFactory.getRemoteInstance().getPayAdmitSchemeCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)collection)) {
            PayAdmitSchemeInfo admitInfo = collection.get(0);
            if (!admitInfo.isIsEnable()) {
                MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"7_CanNotToPayAnti", (Object[])new Object[]{admitInfo.getNumber()}));
                SysUtil.abort();
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this.ui);
            uiContext.put("AdmitScheme", admitInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(PayAntiRepeatEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        ArrayList selectedIds = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)selectedIds), CompareType.INCLUDE));
        view.setFilter(filter);
        PayAdmitSchemeCollection collection = PayAdmitSchemeFactory.getRemoteInstance().getPayAdmitSchemeCollection(view);
        for (i = 0; i < collection.size(); ++i) {
            PayAdmitSchemeInfo admitInfo = collection.get(i);
            if (admitInfo.isIsEnable()) {
                MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"8_NoDelete"));
                SysUtil.abort();
            }
            if (!admitInfo.isIsPreset()) continue;
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"18_PresetNoDelete"));
            SysUtil.abort();
        }
        if (this.confirmRemove()) {
            for (i = 0; i < collection.size(); ++i) {
                PayAdmitSchemeInfo info = collection.get(i);
                PayAdmitUtils.recordAntiGravityLog(null, (CoreBaseInfo)info, LogCategoryEnum.AdmitSchemeDel, null, null, "\u51c6\u5165\u65b9\u6848\uff1a" + info.getNumber() + "\u5220\u9664");
            }
            this.Remove();
            this.saveCurrentLocation();
            this.refresh(e);
            this.restoreCurrentLocation();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        PayAdmitSchemeInfo admitInfo;
        this.checkSelected();
        ArrayList selectedIds = this.getSelectedIdValues();
        if (selectedIds.size() > 1) {
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"5_OnlyChoseOne"));
            SysUtil.abort();
        }
        if ((admitInfo = PayAdmitSchemeFactory.getRemoteInstance().getPayAdmitSchemeInfo((IObjectPK)new ObjectUuidPK(selectedIds.get(0).toString()))).isIsEnable()) {
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"9_NoEdit"));
            SysUtil.abort();
        }
        if (admitInfo.isIsPreset()) {
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"19_PresetNoEdit"));
            SysUtil.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("payAdmitScheme.id", (Object)selectedIds.get(0).toString(), CompareType.EQUALS));
        view.setFilter(filter);
        PayAntiRepeatCollection antiRepeatColl = PayAntiRepeatFactory.getRemoteInstance().getPayAntiRepeatCollection(view);
        if (antiRepeatColl != null && antiRepeatColl.size() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"38_NoEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

