/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.cas.LogCategoryEnum;
import com.kingdee.eas.fi.cas.PayAntiRepeatCollection;
import com.kingdee.eas.fi.cas.PayAntiRepeatFactory;
import com.kingdee.eas.fi.cas.PayAntiRepeatInfo;
import com.kingdee.eas.fi.cas.client.AbstractPayAntiRepeatListUI;
import com.kingdee.eas.fi.cas.client.PayAntiRepeatEditUI;
import com.kingdee.eas.fi.cas.utils.PayAdmitUtils;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PayAntiRepeatListUI
extends AbstractPayAntiRepeatListUI {
    private static final Logger logger = CoreUIObject.getLogger(PayAntiRepeatListUI.class);
    private static final String payAdmitResource = "com.kingdee.eas.fi.cas.PayAdmitResource";

    public void onLoad() throws Exception {
        super.onLoad();
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuEdit);
        this.btnAuditResult.setVisible(false);
        this.menuItemAuditResult.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.actionTraceDown.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCancel.setTextIconDisStyle((short)3);
        this.btnCancel.setText(EASResource.getString((String)payAdmitResource, (String)"2_DisEnable"));
        this.btnCancelCancel.setTextIconDisStyle((short)3);
        this.btnCancelCancel.setText(EASResource.getString((String)payAdmitResource, (String)"1_Enable"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PayAntiRepeatFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return PayAntiRepeatEditUI.class.getName();
    }

    protected String getEditUIModal() {
        IUIWindow win = this.getUIWindow();
        if (win instanceof UINewFrame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        if (win instanceof UIDialog) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    protected void initListener() {
        super.initListener();
        FMClientHelper.addViewCompHelper((CoreUI)this, (KDMenu)this.menuHelp);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectedIdValues = this.getSelectedIdValues();
        List results = PayAntiRepeatFactory.getRemoteInstance().cancel(FMHelper.list2Set((List)selectedIdValues));
        int fail = 0;
        StringBuffer error = new StringBuffer();
        StringBuffer errorDetail = new StringBuffer();
        String LINE_SEPARATOR = System.getProperty("line.separator");
        try {
            if (results.size() > 0) {
                for (int j = 0; j < results.size(); ++j) {
                    BankPayResult resultInfo = (BankPayResult)results.get(j);
                    if (resultInfo.getErrorDetail() == null) continue;
                    if (fail != 0) {
                        errorDetail.append(LINE_SEPARATOR);
                    }
                    errorDetail.append("\u3010" + resultInfo.getErrorDetail() + "\u3011");
                    ++fail;
                }
                if (results.size() > 0) {
                    error.append(EASResource.getString((String)payAdmitResource, (String)"3_BatchDisEnableMsg", (Object[])new Object[]{selectedIdValues.size(), selectedIdValues.size() - results.size(), results.size()}));
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)error.toString(), (String)errorDetail.toString(), (int)0);
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)payAdmitResource, (String)"37_disableSuccess"));
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectedIdValues = this.getSelectedIdValues();
        List results = PayAntiRepeatFactory.getRemoteInstance().cancelCancel(FMHelper.list2Set((List)selectedIdValues));
        int fail = 0;
        StringBuffer error = new StringBuffer();
        StringBuffer errorDetail = new StringBuffer();
        String LINE_SEPARATOR = System.getProperty("line.separator");
        try {
            if (results.size() > 0) {
                for (int j = 0; j < results.size(); ++j) {
                    BankPayResult resultInfo = (BankPayResult)results.get(j);
                    if (resultInfo.getErrorDetail() == null) continue;
                    if (fail != 0) {
                        errorDetail.append(LINE_SEPARATOR);
                    }
                    errorDetail.append("\u3010" + resultInfo.getErrorDetail() + "\u3011");
                    ++fail;
                }
                if (results.size() > 0) {
                    error.append(EASResource.getString((String)payAdmitResource, (String)"4_BatchEnableMsg", (Object[])new Object[]{selectedIdValues.size(), selectedIdValues.size() - results.size(), results.size()}));
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)error.toString(), (String)errorDetail.toString(), (int)0);
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)payAdmitResource, (String)"36_enableSuccess"));
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.refreshList();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        PayAntiRepeatInfo info;
        int i;
        this.checkSelected();
        ArrayList selectedIds = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)selectedIds), CompareType.INCLUDE));
        view.setFilter(filter);
        PayAntiRepeatCollection collection = PayAntiRepeatFactory.getRemoteInstance().getPayAntiRepeatCollection(view);
        for (i = 0; i < collection.size(); ++i) {
            info = collection.get(i);
            if (info.isIsEnable()) {
                MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"8_NoDelete"));
                SysUtil.abort();
            }
            if (!info.isIsPreset()) continue;
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"18_PresetNoDelete"));
            SysUtil.abort();
        }
        if (this.confirmRemove()) {
            for (i = 0; i < collection.size(); ++i) {
                info = collection.get(i);
                PayAdmitUtils.recordAntiGravityLog(null, (CoreBaseInfo)info, LogCategoryEnum.AntiSchemeDel, null, null, "\u9632\u91cd\u65b9\u6848\uff1a" + info.getNumber() + "\u5220\u9664");
            }
            this.Remove();
            this.saveCurrentLocation();
            this.refresh(e);
            this.restoreCurrentLocation();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        PayAntiRepeatInfo info;
        this.checkSelected();
        ArrayList selectedIds = this.getSelectedIdValues();
        if (selectedIds.size() > 1) {
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"5_OnlyChoseOne"));
            SysUtil.abort();
        }
        if ((info = PayAntiRepeatFactory.getRemoteInstance().getPayAntiRepeatInfo((IObjectPK)new ObjectUuidPK(selectedIds.get(0).toString()))).isIsEnable()) {
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"9_NoEdit"));
            SysUtil.abort();
        }
        if (info.isIsPreset() && !"FKZR".equals(info.getNumber()) && !"DFZR".equals(info.getNumber())) {
            MsgBox.showWarning((String)EASResource.getString((String)payAdmitResource, (String)"19_PresetNoEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

