/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitDelegationF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.RecPayBillEntryInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.NumberValueVerifyRule;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.scm.common.util.ArrayUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class RecPayHandler {
    private static Logger logger = Logger.getLogger((String)RecPayHandler.class.getName());
    public static final String srcPath = "com.kingdee.eas.fi.cas.RecPayResource";
    public static final BOSObjectType SRC_BILL_SETTLEMENT = new SettlementBillInfo().getBOSType();
    public static final String IS_INITIALIZE_BILL = "IsInitializeBill";
    public static final String OPER_COPY = "COPY";
    public static final String OPER_GENERATEBILL = "GENERATEBILL";
    public static final String OPER_OFFSET = "OFFSET";
    public static final String OPRT_STATE_FINDVIEW = "FINDVIEW";
    private static final String TOTAL = "TOTAL";
    public static final String REC_FLAG = "rec";
    public static final String PAY_FLAG = "pay";
    public static final String COL_PAY_AMT = "payAmt";
    public static final String COL_PAY_LOC_AMT = "payLocAmt";
    public static final String COL_PAY_AMT_VC = "payAmtVc";
    public static final String COL_PAY_LOC_AMT_VC = "payLocAmtVc";
    public static final String COL_REC_AMT = "recAmt";
    public static final String COL_REC_LOC_AMT = "recLocAmt";
    public static final String COL_REC_AMT_VC = "recAmtVc";
    public static final String COL_REC_LOC_AMT_VC = "recLocAmtVc";
    public static final String COL_REBATE_AMT = "rebateAmt";
    public static final String COL_REBATE_LOC_AMT = "rebateLocAmt";
    public static final String COL_ACT_PAY_AMT = "actPayAmt";
    public static final String COL_ACT_PAY_AMT_VC = "actPayAmtVc";
    public static final String COL_ACT_PAY_LOC_AMT = "actPayLocAmt";
    public static final String COL_ACT_REC_AMT = "actRecAmt";
    public static final String COL_ACT_REC_AMT_VC = "actRecAmtVc";
    public static final String COL_ACT_REC_LOC_AMT = "actRecLocAmt";
    public static final String COL_ID = "id";
    public static final String COL_SEQ = "seq";
    public static final String COL_SRC_BILL_ID = "sourceBillID";
    public static final String COL_SRC_BILL_ENTRY_ID = "sourceBillEntryID";
    public static final String COL_VC_STATUS = "vcStatus";
    public static final String COL_REMARK = "remark";
    public static final String COL_COMPANYNAME = "companyName";
    public static final String COL_NUMBER = "number";
    public static final String COL_BILLSTATUS = "billStatus";
    public static final String COL_BIZDATE = "bizDate";
    public static final String COL_SETTLEMENTSTATUS = "settlementStatus";
    public static final String COL_ADDMINORGUNIT = "adminOrgUnit";
    public static final String COL_COSTCENTER = "costCenter";
    public static final String COL_PERSON = "person";
    public static final String COL_CURRENCY_ID = "currency.id";
    public static final String COL_CURRENCY_NAME = "currency.name";
    public static final String COL_SETTLETYPENAME = "settleTypeName";
    public static final String COL_SETTLENUMBER = "settleNumber";
    public static final String COL_PAYEEACCOUNTBANK = "payeeAccountBank";
    public static final String COL_PAYEEBANK = "payeeBank";
    public static final String COL_ACTAMT = "actAmt";
    public static final String COL_ENTRIES_ID = "entries.id";
    public static final String COL_ENTRIES_REBATE = "entries.rebate";
    public static final String COL_SOURCETYPE = "sourceType";
    public static final String COL_ISCOMMITSETTLE = "isCommitSettle";
    public static final String COL_PAYERTYPE = "payerType";
    public static final String COL_PAYERNAME = "payerName";
    public static final String COL_RECTYPE = "recType";
    public static final String COL_PAYEEACCOUNTBANK_ID = "payeeAccountBank.id";
    public static final String COL_PAYEEACCOUNT = "payeeAccount";
    public static final String COL_ENTRYRECBILLTYPE = "entryRecBillType";
    public static final String COL_ENTRIES_RECAMT = "entries.recAmt";
    public static final String COL_ENTRIES_VCSTATUS = "entries.vcStatus";
    public static final String COL_PAYEETYPE = "payeeType";
    public static final String COL_PAYEENAME = "payeeName";
    public static final String COL_PAYTYPE = "payType";
    public static final String COL_PAYERACCOUNTBANK = "payerAccountBank";
    public static final String COL_PAYERBANK = "payerBank";
    public static final String COL_PAYERACCOUNT = "payerAccount";
    public static final String COL_ENTRIES_PAYAMT = "entries.payAmt";
    public static final String COL_ENTRIES_ACTPAYAMT = "entries.actPayAmt";
    public static final String COL_ENTRIES_COREBILLTYPE = "entrys.coreBillType";
    public static final String COL_ENTRIES_COREBILLNUMBER = "entrys.coreBillNumber";
    private static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999.99");

    public static void setDefaultFitlerBillDate(Component comp, boolean isInit, SourceTypeEnum sourceType, KDDatePicker dateFrom, KDDatePicker dateTo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodInfo period = null;
        if (isInit) {
            if (sourceType.equals((Object)SourceTypeEnum.AR)) {
                period = CashClientHelper.getARStartPeriodInfo(comp, companyInfo);
            } else if (sourceType.equals((Object)SourceTypeEnum.AP)) {
                period = CashClientHelper.getAPStartPeriodInfo(comp, companyInfo);
            }
            if (period != null) {
                dateFrom.setValue((Object)DateHelper.getBeforeDay((Date)period.getBeginDate()));
                dateTo.setValue((Object)DateHelper.getBeforeDay((Date)period.getBeginDate()));
            }
        } else if (sourceType.equals((Object)SourceTypeEnum.AR)) {
            period = CashClientHelper.getARCurrentPeriodInfo(comp, companyInfo);
            dateFrom.setValue((Object)period.getBeginDate());
            dateTo.setValue((Object)period.getEndDate());
        } else if (sourceType.equals((Object)SourceTypeEnum.AP)) {
            period = CashClientHelper.getAPCurrentPeriodInfo(comp, companyInfo);
            dateFrom.setValue((Object)period.getBeginDate());
            dateTo.setValue((Object)period.getEndDate());
        } else {
            dateFrom.setValue((Object)new Date());
            dateTo.setValue((Object)new Date());
        }
    }

    public static boolean verifyFitlerBillDate(CoreUIObject comp, boolean isInit, SourceTypeEnum sourceType, KDDatePicker dateFrom, KDDatePicker dateTo) {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)comp, (KDDatePicker)dateFrom);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)comp, (KDDatePicker)dateTo);
        Date billDateFrom = DateTimeUtils.truncateDate((Date)((Date)dateFrom.getValue()));
        Date billDateTo = DateTimeUtils.truncateDate((Date)((Date)dateTo.getValue()));
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)comp, (Date)billDateFrom, (Date)billDateTo);
        Date startDate = null;
        if (sourceType.equals((Object)SourceTypeEnum.AR)) {
            startDate = DateTimeUtils.truncateDate((Date)CashClientHelper.getStartDate(SystemEnum.ACCOUNTSRECEIVABLE));
        } else if (sourceType.equals((Object)SourceTypeEnum.AP)) {
            startDate = DateTimeUtils.truncateDate((Date)CashClientHelper.getStartDate(SystemEnum.ACCOUNTSPAYABLE));
        } else if (sourceType.equals((Object)SourceTypeEnum.CASH)) {
            return true;
        }
        if (isInit) {
            if (startDate != null && billDateFrom.after(startDate)) {
                dateFrom.requestFocus(true);
                MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)srcPath, (String)"DateAfterStartDate"));
                SysUtil.abort();
            }
            if (startDate != null && billDateTo.after(startDate)) {
                dateTo.requestFocus(true);
                MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)srcPath, (String)"DateAfterStartDate"));
                SysUtil.abort();
            }
        } else {
            if (startDate != null && billDateFrom.before(startDate)) {
                dateFrom.requestFocus(true);
                MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)srcPath, (String)"DateBeforeStartDate"));
                SysUtil.abort();
            }
            if (billDateTo.before(startDate)) {
                dateTo.requestFocus(true);
                MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)srcPath, (String)"DateBeforeStartDate"));
                SysUtil.abort();
            }
        }
        return true;
    }

    public static void checkStartPeriod(Component ui, CompanyOrgUnitInfo companyInfo, SourceTypeEnum sourceType) throws EASBizException, BOSException {
        if (sourceType.equals((Object)SourceTypeEnum.AR)) {
            CashClientHelper.getARStartPeriodInfo(ui, companyInfo);
        } else if (sourceType.equals((Object)SourceTypeEnum.AP)) {
            CashClientHelper.getAPStartPeriodInfo(ui, companyInfo);
        }
    }

    public static void fillTotalRow(KDTable kdtEntries) {
        if (kdtEntries == null) {
            return;
        }
        IRow totalRow = kdtEntries.addRow();
        totalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        totalRow.getStyleAttributes().setLocked(true);
        String total = EASResource.getString((String)srcPath, (String)"Total");
        totalRow.getCell(COL_SEQ).setValue((Object)total);
        totalRow.getCell(COL_SEQ).setUserObject((Object)TOTAL);
        RecPayHandler.calRowTotal(kdtEntries);
    }

    public static void calRowTotal(KDTable kdtEntries) {
        if (kdtEntries == null || kdtEntries.getRowCount() < 1) {
            return;
        }
        int beginIndex = 0;
        int endIndex = 0;
        if (kdtEntries.getColumn(COL_PAY_AMT) != null) {
            beginIndex = kdtEntries.getColumn(COL_PAY_AMT).getColumnIndex();
        } else if (kdtEntries.getColumn(COL_REC_AMT) != null) {
            beginIndex = kdtEntries.getColumn(COL_REC_AMT).getColumnIndex();
        }
        if (kdtEntries.getColumn(COL_ACT_PAY_AMT_VC) != null) {
            endIndex = kdtEntries.getColumn(COL_ACT_PAY_AMT_VC).getColumnIndex();
        } else if (kdtEntries.getColumn(COL_ACT_REC_AMT_VC) != null) {
            endIndex = kdtEntries.getColumn(COL_ACT_REC_AMT_VC).getColumnIndex();
        }
        IRow totalRow = null;
        for (int i = kdtEntries.getRowCount(); i >= 0; --i) {
            totalRow = kdtEntries.getRow(i);
            if (!RecPayHandler.checkIsTotalLine(totalRow)) continue;
            for (int j = beginIndex; j <= endIndex; ++j) {
                RecPayHandler.calColTotal(kdtEntries, totalRow, j);
            }
            break;
        }
    }

    public static void calColTotal(KDTable kdtEntries, IRow totalRow, int colIndex) {
        if (totalRow == null) {
            return;
        }
        IRow row = null;
        BigDecimal totalAmt = null;
        BigDecimal amount = null;
        int n = kdtEntries.getRowCount();
        for (int i = 0; i < n - 1; ++i) {
            row = kdtEntries.getRow(i);
            amount = (BigDecimal)row.getCell(colIndex).getValue();
            if (amount == null) continue;
            if (totalAmt == null) {
                totalAmt = FMConstants.ZERO;
            }
            totalAmt = totalAmt.add(amount);
        }
        totalRow.getCell(colIndex).setValue(totalAmt);
    }

    public static boolean checkIsTotalLine(IRow row) {
        if (row == null) {
            return false;
        }
        if (row.getCell(COL_SEQ) == null) {
            return false;
        }
        if (row.getCell(COL_SEQ).getValue() == null) {
            return false;
        }
        Object value = row.getCell(COL_SEQ).getUserObject();
        if (value == null) {
            return false;
        }
        return TOTAL.equals(value.toString());
    }

    public static void setEntrySeq(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        int seq = 1;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            if (RecPayHandler.checkIsTotalLine(row)) continue;
            row.getCell(COL_SEQ).setValue((Object)new Integer(seq++));
        }
    }

    public static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public static IRow addRow(KDTable table) {
        IRow row = null;
        row = table.getRowCount() > 0 && RecPayHandler.checkIsTotalLine(table.getRow(table.getRowCount() - 1)) ? table.addRow(table.getRowCount() - 1) : table.addRow();
        return row;
    }

    public static IRow copyLine(KDTable tblMain) {
        IRow row = null;
        IRow oldRow = null;
        if (tblMain.getSelectManager().size() > 0) {
            int top = tblMain.getSelectManager().get().getTop();
            oldRow = tblMain.getRow(top);
            if (RecPayHandler.checkIsTotalLine(oldRow)) {
                return null;
            }
            row = RecPayHandler.checkIsTotalLine(tblMain.getRow(tblMain.getRowCount() - 1)) ? tblMain.addRow(tblMain.getRowCount() - 1) : tblMain.addRow();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)srcPath, (String)"SelectValidRecord"));
            return null;
        }
        String columnFieldName = null;
        int size = tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            columnFieldName = tblMain.getColumn(i).getFieldName();
            if (COL_ID.equalsIgnoreCase(columnFieldName) || COL_SRC_BILL_ID.equalsIgnoreCase(columnFieldName) || COL_SRC_BILL_ENTRY_ID.equalsIgnoreCase(columnFieldName)) continue;
            row.getCell(i).setValue(oldRow.getCell(i).getValue());
        }
        return row;
    }

    public static void checkCanRecPay(RecPayBillInfo info) throws EASBizException {
        if (info == null) {
            return;
        }
        if (info.isIsCommitSettle()) {
            if (BillStatusEnum.AUDITED.equals((Object)info.getBillStatus()) && SettlementStatusEnum.ACCEPTED.equals((Object)info.getSettlementStatus())) {
                return;
            }
            throw new RecPayException(RecPayException.RELSBNOTACCEPT, new String[]{info.getNumber()});
        }
        if (BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            return;
        }
        throw new RecPayException(RecPayException.NOTAUDIT, new String[]{info.getNumber()});
    }

    public static void assignSelector(CoreUIObject ui, KDBizPromptBox bizPromptBox, AsstActTypeInfo asstActTypeInfo) throws Exception {
        bizPromptBox.setEditable(true);
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        String companyID = companyInfo.getId().toString();
        String rootCuID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        String relationDataObject = asstActTypeInfo.getRealtionDataObject();
        String queryInfo = asstActTypeInfo.getDefaultQueryName();
        bizPromptBox.setSelector(null);
        bizPromptBox.setEntityViewInfo(null);
        bizPromptBox.setQueryInfo(queryInfo);
        if (relationDataObject != null) {
            if (relationDataObject.equals("T_BD_AccountBanks")) {
                bizPromptBox.setSelector(null);
                bizPromptBox.setEntityViewInfo(null);
                bizPromptBox.setQueryInfo(queryInfo);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
                filter.getFilterItems().add(new FilterItemInfo("company.id", null));
                filter.setMaskString("#0 OR #1");
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                bizPromptBox.setEntityViewInfo(evi);
            } else if (relationDataObject.equals("T_BD_Customer")) {
                queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery";
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyID));
                ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
                String groupStandardId = cSSPGroupStandard.getBasicStandardId("1");
                filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)groupStandardId));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                bizPromptBox.setEntityViewInfo(evi);
                GeneralKDPromptSelectorAdaptor selectorLisenterCustomer = null;
                selectorLisenterCustomer = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7CustomerTreeDetailListUI(), (Object)ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id");
                RecPayHandler.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)selectorLisenterCustomer);
                bizPromptBox.addSelectorListener((SelectorListener)selectorLisenterCustomer);
            } else if (relationDataObject.equalsIgnoreCase("T_BD_Supplier")) {
                queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery";
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyInfo.getId()));
                ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
                String groupStandardId = cSSPGroupStandard.getBasicStandardId("2");
                filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)groupStandardId));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                bizPromptBox.setEntityViewInfo(evi);
                GeneralKDPromptSelectorAdaptor selectorLisenterSupplier = null;
                selectorLisenterSupplier = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7SupplierTreeDetailListUI(), (Object)ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id");
                RecPayHandler.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)selectorLisenterSupplier);
                bizPromptBox.addSelectorListener((SelectorListener)selectorLisenterSupplier);
            } else if (relationDataObject.equals("T_BD_Material")) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                bizPromptBox.setEntityViewInfo(evi);
                RecPayHandler.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7MaterialTreeListUI(), (Object)ui));
            } else if (relationDataObject.equalsIgnoreCase("T_BD_Person")) {
                RecPayHandler.setAdminPerson(bizPromptBox);
            } else if (relationDataObject.equalsIgnoreCase("T_ORG_Company")) {
                RecPayHandler.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)new NewCompanyF7((IUIObject)ui));
                ((NewCompanyF7)bizPromptBox.getSelector()).setNeedAddOrgRange(false);
                ((NewCompanyF7)bizPromptBox.getSelector()).setIsCUFilter(false, true);
                ((NewCompanyF7)bizPromptBox.getSelector()).setRootUnitID(rootCuID);
            } else if (relationDataObject.equalsIgnoreCase("T_ORG_CostCenter")) {
                RecPayHandler.setOrgUnitF7(bizPromptBox, OrgType.CostCenter);
            } else if (relationDataObject.equalsIgnoreCase("T_ORG_Admin")) {
                RecPayHandler.setOrgUnitF7(bizPromptBox, OrgType.Admin);
                String deptID = "00000000-0000-0000-0000-00000000000362824988";
                FilterItemInfo filterItem = new FilterItemInfo("unitLayerType.id", (Object)deptID);
                FilterInfo filter2 = new FilterInfo();
                filter2.getFilterItems().add(filterItem);
                EntityViewInfo evi = bizPromptBox.getEntityViewInfo();
                FilterInfo filter = evi.getFilter();
                filter.mergeFilter(filter2, "AND");
                evi.setFilter(filter);
                bizPromptBox.setEntityViewInfo(evi);
            } else if (relationDataObject.equalsIgnoreCase("T_ORG_Purchase")) {
                RecPayHandler.setOrgUnitF7(bizPromptBox, OrgType.Purchase);
            } else if (relationDataObject.equalsIgnoreCase("T_ORG_Storage")) {
                RecPayHandler.setOrgUnitF7(bizPromptBox, OrgType.Storage);
            } else if (relationDataObject.equalsIgnoreCase("T_ORG_Sale")) {
                RecPayHandler.setOrgUnitF7(bizPromptBox, OrgType.Sale);
            } else if (relationDataObject.equalsIgnoreCase("T_ORG_ProfitCenter")) {
                RecPayHandler.setOrgUnitF7(bizPromptBox, OrgType.ProfitCenter);
            } else if (relationDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("glAsstActTypeGrp.id"));
                ObjectUuidPK pk = new ObjectUuidPK(asstActTypeInfo.getId());
                AsstActTypeInfo info = asstActType.getAsstActTypeInfo((IObjectPK)pk, sic);
                if (info.getGlAsstActTypeGrp() == null) {
                    throw new NullPointerException(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"380_RecPayHandler"));
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)info.getGlAsstActTypeGrp().getId().toString()));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                bizPromptBox.setEntityViewInfo(evi);
                bizPromptBox.setSelector(null);
                bizPromptBox.setQueryInfo(queryInfo);
                bizPromptBox.setHasCUDefaultFilter(true);
            } else {
                bizPromptBox.setSelector(null);
                bizPromptBox.setEntityViewInfo(null);
                bizPromptBox.setQueryInfo(queryInfo);
                bizPromptBox.setHasCUDefaultFilter(true);
            }
        }
    }

    private static void assignSelector(KDPromptBox promptBox, KDPromptSelector selector) {
        promptBox.setSelector(selector);
    }

    public static void setAdminPerson(KDBizPromptBox bizPromptBox) throws BOSException, EASBizException {
        String queryInfo = "com.kingdee.eas.basedata.person.app.PersonQuery";
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        Set set = RecPayHandler.getFromUnit(companyInfo.getId().toString(), 1, 0);
        FilterInfo filter = new FilterInfo();
        if (set != null && set.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)set, CompareType.INCLUDE));
            filter.setMaskString("#0 OR #1");
        }
        filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        bizPromptBox.setQueryInfo(queryInfo);
    }

    public static void setOrgUnitF7(KDBizPromptBox bizPromptBox, OrgType fromUnitType) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        String companyID = companyInfo.getId().toString();
        OrgUnitDelegationF7 oudF7 = new OrgUnitDelegationF7(bizPromptBox, DelegationPartsEnum.THE_FROM_UNIT, fromUnitType);
        oudF7.setTheGivenOrgUnit(companyID, OrgType.Company);
        oudF7.setDoNotUseUserOrgRangeAsFilter();
        oudF7.setIncludeSelfWhenSelfIsAlsoOfTheWantedType();
    }

    public static Set getFromUnit(String toUnitID, int toUnitType, int formUnitType) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ouColl = iUnitRel.getFromUnit(toUnitID, toUnitType, formUnitType);
        HashSet<String> set = new HashSet<String>();
        int size = ouColl.size();
        for (int i = 0; i < size; ++i) {
            OrgUnitInfo info = ouColl.get(i);
            set.add(info.getId().toString());
        }
        return set;
    }

    public void fillPayeeOrPayer(KDBizPromptBox promptBox, BOSUuid id, String name, String number) {
        if (id == null && name == null) {
            return;
        }
        CurrentInfo currentInfo = new CurrentInfo();
        currentInfo.setId(id);
        currentInfo.setName(name);
        currentInfo.setNumber(number);
        promptBox.setData((Object)currentInfo);
    }

    public static void setEntryNullValue(IRow row, String[] colNames) {
        if (colNames == null) {
            return;
        }
        BigDecimal tempAmt = null;
        int len = colNames.length;
        for (int i = 0; i < len; ++i) {
            tempAmt = (BigDecimal)row.getCell(colNames[i]).getValue();
            if (tempAmt == null || tempAmt.compareTo(FMConstants.ZERO) != 0) continue;
            row.getCell(colNames[i]).setValue(null);
        }
    }

    public void setEntryTableAmt(SourceTypeEnum sourceType, KDTable kdtEntries, BigDecimal rate, BOSUuid currencyID) {
        if (sourceType == null || kdtEntries == null || rate == null || currencyID == null) {
            return;
        }
        IRow row = null;
        int size = kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = kdtEntries.getRow(i);
            if (RecPayHandler.checkIsTotalLine(row)) continue;
            this.setEntryRowAmt(sourceType, row, rate, currencyID, null);
        }
    }

    public abstract void setEntryRowAmt(SourceTypeEnum var1, IRow var2, BigDecimal var3, BOSUuid var4, KDTEditEvent var5);

    public static BigDecimal getEntryAmtSum(KDTable kdtEntries, String colName) {
        if (kdtEntries == null || kdtEntries.getRowCount() < 1 || colName == null) {
            return FMConstants.ZERO;
        }
        IRow row = null;
        BigDecimal entryAmount = FMConstants.ZERO;
        BigDecimal tempAmt = FMConstants.ZERO;
        int size = kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = kdtEntries.getRow(i);
            if (RecPayHandler.checkIsTotalLine(row) || row.getCell(colName).getValue() == null) continue;
            tempAmt = (BigDecimal)row.getCell(colName).getValue();
            entryAmount = entryAmount.add(tempAmt);
        }
        return entryAmount;
    }

    private static BigDecimal getExchangeRate(ExchangeTableInfo baseExchangeTable, CurrencyInfo sourceCur, CurrencyInfo desCur, Date date) throws Exception {
        if (baseExchangeTable == null || sourceCur == null || desCur == null || date == null) {
            return FMConstants.ONE;
        }
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(desCur.getId());
        ObjectUuidPK excTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        if (erInfo != null) {
            if (erInfo.getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                return erInfo.getConvertRate();
            }
            return FMConstants.ONE.divide(erInfo.getConvertRate(), erInfo.getPrecision());
        }
        return FMConstants.ONE;
    }

    public static ExchangeRateInfo getExRateInfo(CurrencyInfo srcCurr, CurrencyInfo destCurr, CompanyOrgUnitInfo company, Date date) throws EASBizException, BOSException {
        ExchangeTableInfo baseExchangeTable;
        if (srcCurr == null || date == null) {
            return null;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (destCurr == null) {
            destCurr = company.getBaseCurrency();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return null;
        }
        date = DateTimeUtils.truncateDate((Date)date);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurr.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurr.getId());
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iExchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo exRateInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return exRateInfo;
    }

    public static int getExRatePrec(String srcCurrId, String destCurrId, CompanyOrgUnitInfo company, Date date) {
        ExchangeTableInfo baseExchangeTable;
        if (srcCurrId == null || date == null) {
            return 0;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (destCurrId == null) {
            destCurrId = company.getBaseCurrency().getId().toString();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return 0;
        }
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        ExchangeRateInfo exRateInfo = null;
        try {
            IExchangeRate iExchangRate = ExchangeRateFactory.getRemoteInstance();
            exRateInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        if (exRateInfo != null) {
            return exRateInfo.getPrecision();
        }
        return 0;
    }

    public static boolean isIndirectExRate(ExchangeRateInfo exRateInfo) {
        if (exRateInfo == null) {
            return false;
        }
        return exRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE);
    }

    public static BigDecimal getExchangeRate(CurrencyInfo srcCurr, CompanyOrgUnitInfo company, Date date) throws Exception {
        if (srcCurr == null || date == null) {
            return null;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (RecPayHandler.isLocalCurrency(srcCurr, company)) {
            return Constants.ONE;
        }
        ExchangeRateInfo exRateInfo = RecPayHandler.getExRateInfo(srcCurr, null, company, date = DateTimeUtils.truncateDate((Date)date));
        if (exRateInfo == null) {
            return Constants.ZERO;
        }
        return exRateInfo.getConvertRate();
    }

    public static void setExchangeRate(KDComboBox comboCurrency, KDDatePicker pkBillDate, KDFormattedTextField txtExchangeRate) throws Exception {
        CurrencyInfo srcCurr = (CurrencyInfo)comboCurrency.getSelectedItem();
        if (srcCurr == null) {
            return;
        }
        Date date = DateTimeUtils.truncateDate((Date)((Date)pkBillDate.getValue()));
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        CurrencyInfo localCurrency = company.getBaseCurrency();
        if (srcCurr.getId().equals((Object)localCurrency.getId())) {
            txtExchangeRate.setValue((Object)FMConstants.ONE);
            txtExchangeRate.setEnabled(false);
        } else {
            ExchangeRateInfo exRateInfo = RecPayHandler.getExRateInfo(srcCurr, null, company, date);
            if (exRateInfo != null) {
                txtExchangeRate.setValue((Object)exRateInfo.getConvertRate());
            } else {
                txtExchangeRate.setValue(null);
            }
            txtExchangeRate.setEnabled(true);
        }
    }

    public static boolean isLocalCurrency(CurrencyInfo currency, CompanyOrgUnitInfo company) {
        boolean isLocCurrency = false;
        if (currency == null) {
            return isLocCurrency;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        CurrencyInfo localCurrency = company.getBaseCurrency();
        if (currency.getId().equals((Object)localCurrency.getId())) {
            isLocCurrency = true;
        }
        return isLocCurrency;
    }

    public void setPropBySourceType(SourceTypeEnum sourceType, KDComboBox billType, KDComboBox payeeType) throws Exception {
        if (sourceType == null) {
            return;
        }
        this.initBillType(billType, sourceType.getName());
        BookNotifyClientHelper.initCurrentType(payeeType, false, sourceType);
    }

    public abstract void initBillType(KDComboBox var1, String var2);

    public String[] getMergeColumnKeys(String sourceBillType) {
        String[] commonColumn = new String[]{COL_ID, COL_COMPANYNAME, COL_NUMBER, COL_BILLSTATUS, COL_BIZDATE, COL_CURRENCY_ID, COL_CURRENCY_NAME, COL_ADDMINORGUNIT, COL_COSTCENTER, COL_PERSON, COL_SETTLENUMBER, COL_ACTAMT, COL_SETTLEMENTSTATUS, COL_SETTLETYPENAME, COL_PAYEEACCOUNTBANK, COL_PAYEEBANK, COL_ENTRIES_ID, COL_ENTRIES_REBATE, COL_REMARK};
        if (REC_FLAG.equals(sourceBillType)) {
            String[] recColmun = new String[]{COL_PAYERTYPE, COL_PAYERNAME, COL_RECTYPE, COL_PAYEEACCOUNT, COL_SOURCETYPE, COL_ISCOMMITSETTLE, COL_PAYEEACCOUNTBANK_ID, COL_ENTRYRECBILLTYPE, COL_ENTRIES_RECAMT, COL_ENTRIES_VCSTATUS};
            int size = commonColumn.length + recColmun.length;
            String[] keys = new String[size];
            keys = ArrayUtils.mergeArray((String[])commonColumn, (String[])recColmun);
            return keys;
        }
        if (PAY_FLAG.equals(sourceBillType)) {
            String[] payColmun = new String[]{COL_PAYEETYPE, COL_PAYEENAME, COL_PAYTYPE, COL_PAYERACCOUNTBANK, COL_PAYERBANK, COL_PAYERACCOUNT, COL_ENTRIES_PAYAMT, COL_ENTRIES_ACTPAYAMT, COL_ENTRIES_COREBILLTYPE, COL_ENTRIES_COREBILLNUMBER};
            int size = commonColumn.length + payColmun.length;
            String[] keys = new String[size];
            keys = ArrayUtils.mergeArray((String[])commonColumn, (String[])payColmun);
            return keys;
        }
        return new String[0];
    }

    public void setListUITableByRec(KDTable tblMain) {
        tblMain.checkParsed();
        IRow row = null;
        String currencyId = null;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String baseCurrencyId = companyInfo.getBaseCurrency().getId().toString();
        int size = tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell(COL_CURRENCY_ID).getValue();
            if (currencyId != null) {
                FMClientHelper.setNumberFormat((IRow)row, (String)COL_ACTAMT, (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"actLocAmt", (String)baseCurrencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)COL_ENTRIES_RECAMT, (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)COL_ENTRIES_REBATE, (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"entries.actRecAmt", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"entries.actRecAmtVc", (String)currencyId);
            }
            if (tblMain.getColumn("exchangeRate") == null) continue;
            Date date = (Date)row.getCell(COL_BIZDATE).getValue();
            int prec = RecPayHandler.getExRatePrec(currencyId, null, companyInfo, date);
            row.getCell("exchangeRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)prec));
        }
    }

    public void setListUITableByPay(KDTable tblMain) {
        tblMain.checkParsed();
        IRow row = null;
        String currencyId = null;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String baseCurrencyId = companyInfo.getBaseCurrency().getId().toString();
        int size = tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell(COL_CURRENCY_ID).getValue();
            if (currencyId != null) {
                FMClientHelper.setNumberFormat((IRow)row, (String)COL_ACTAMT, (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"actLocAmt", (String)baseCurrencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)COL_ENTRIES_PAYAMT, (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)COL_ENTRIES_REBATE, (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)COL_ENTRIES_ACTPAYAMT, (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"entries.actPayAmtVc", (String)currencyId);
            }
            if (tblMain.getColumn("exchangeRate") == null) continue;
            Date date = (Date)row.getCell(COL_BIZDATE).getValue();
            int prec = RecPayHandler.getExRatePrec(currencyId, null, companyInfo, date);
            row.getCell("exchangeRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)prec));
        }
    }

    public abstract void initCellEditor(KDComboBox var1, KDTable var2) throws Exception;

    protected IIDList filterDupID(IIDList idList, String selectedId) {
        RealModeIDList noDupIdList = RealModeIDList.getEmptyIDList();
        if (idList == null) {
            return null;
        }
        int size = idList.size();
        String id = null;
        for (int i = 0; i < size; ++i) {
            id = idList.getID(i);
            if (noDupIdList.contains(id)) continue;
            noDupIdList.add(id);
        }
        noDupIdList.setCurrentID(selectedId);
        return noDupIdList;
    }

    protected IIDList getValidListByAction(ItemAction action, KDTable tblMain, String selectedId, IIDList idList, SourceTypeEnum sourceType) throws EASBizException, BOSException {
        if (action == null) {
            throw new RecPayException(RecPayException.ACTION_ISNULL);
        }
        String actionName = action.getClass().getName();
        idList = this.filterDupID(idList, selectedId);
        Set rows = FMClientHelper.getSelectedRows((KDTable)tblMain);
        if (rows.size() == 1) {
            idList = new RealModeIDList();
            idList.add(selectedId);
            return idList;
        }
        Iterator iter = rows.iterator();
        boolean isCommitSettle = false;
        boolean isVouchered = false;
        IAccountBank iAccountBank = AccountBankFactory.getRemoteInstance();
        AccountBankInfo info = null;
        InnerAccountInfo innerInfo = null;
        String accountBankId = null;
        EntityViewInfo evi = null;
        FilterInfo filter = null;
        IJournal iJournal = JournalFactory.getRemoteInstance();
        JournalCollection journals = null;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        String id = null;
        while (iter.hasNext()) {
            int rowId = (Integer)iter.next();
            int billStatus = ((BizEnumValueInfo)tblMain.getRow(rowId).getCell(COL_BILLSTATUS).getValue()).getInt();
            isVouchered = (Boolean)tblMain.getRow(rowId).getCell("isVouchered").getValue();
            isCommitSettle = (Boolean)tblMain.getRow(rowId).getCell(COL_ISCOMMITSETTLE).getValue();
            int settlementStatus = ((BizEnumValueInfo)tblMain.getRow(rowId).getCell(COL_SETTLEMENTSTATUS).getValue()).getInt();
            int selectedSourceType = ((BizEnumValueInfo)tblMain.getRow(rowId).getCell(COL_SOURCETYPE).getValue()).getInt();
            id = (String)tblMain.getRow(rowId).getCell(COL_ID).getValue();
            Object accountViewInfo = null;
            accountViewInfo = SourceTypeEnum.AR.equals((Object)sourceType) ? tblMain.getRow(rowId).getCell(COL_PAYEEACCOUNT).getValue() : tblMain.getRow(rowId).getCell(COL_PAYERACCOUNT).getValue();
            Object settlementType = tblMain.getRow(rowId).getCell("settlementType").getValue();
            if (actionName.indexOf("ActionEdit") != -1) {
                if (!isVouchered && settlementStatus == 10) continue;
                idList.remove(id, false);
                continue;
            }
            if (actionName.indexOf("ActionRemove") != -1) {
                if (sourceType == null) {
                    throw new NullPointerException("SourceType is NULL!");
                }
                if (sourceType.equals((Object)SourceTypeEnum.CASH) && (selectedSourceType == 100 || selectedSourceType == 101)) {
                    idList.remove(id, false);
                    continue;
                }
                if ((billStatus == 10 || billStatus == 11) && settlementStatus == 10) continue;
                idList.remove(id, false);
                continue;
            }
            if (actionName.indexOf("ActionAudit") != -1) {
                if (sourceType.equals((Object)SourceTypeEnum.CASH) && (selectedSourceType == 100 || selectedSourceType == 101)) {
                    idList.remove(id, false);
                    continue;
                }
                if (billStatus != 11) {
                    idList.remove(id, false);
                    continue;
                }
                if (!SourceTypeEnum.AR.equals((Object)sourceType) && !SourceTypeEnum.AP.equals((Object)sourceType)) continue;
                if (accountViewInfo == null) {
                    idList.remove(id, false);
                    continue;
                }
                if (settlementType != null) continue;
                idList.remove(id, false);
                continue;
            }
            if (actionName.indexOf("ActionAntiAudit") != -1) {
                if (sourceType.equals((Object)SourceTypeEnum.CASH) && (selectedSourceType == 100 || selectedSourceType == 101)) {
                    idList.remove(id, false);
                    continue;
                }
                if (billStatus != 12) {
                    idList.remove(id, false);
                    continue;
                }
                if (settlementStatus == 10) continue;
                idList.remove(id, false);
                continue;
            }
            if (actionName.indexOf("ActionCommitSettle") != -1) {
                if (billStatus != 12 || !isCommitSettle || settlementStatus != 10) {
                    idList.remove(id, false);
                    continue;
                }
                if (tblMain.getRow(rowId).getCell(COL_PAYEEACCOUNTBANK_ID) != null) {
                    accountBankId = (String)tblMain.getRow(rowId).getCell(COL_PAYEEACCOUNTBANK_ID).getValue();
                } else if (tblMain.getRow(rowId).getCell("payerAccountBank.id") != null) {
                    accountBankId = (String)tblMain.getRow(rowId).getCell("payerAccountBank.id").getValue();
                }
                if (accountBankId == null) {
                    idList.remove(id, false);
                    continue;
                }
                info = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankId));
                innerInfo = info.getInnerAcct();
                if (innerInfo != null) continue;
                idList.remove(id, false);
                continue;
            }
            if (actionName.indexOf("ActionRec") != -1 || actionName.indexOf("ActionPay") != -1) {
                if (isCommitSettle) {
                    if (billStatus == 12 && settlementStatus == 12) continue;
                    idList.remove(id, false);
                    continue;
                }
                if (billStatus == 12) continue;
                idList.remove(id, false);
                continue;
            }
            if (actionName.indexOf("ActionCancelRec") != -1 || actionName.indexOf("ActionCancelPay") != -1) {
                if (billStatus != 15 && billStatus != 14) {
                    idList.remove(id, false);
                    continue;
                }
                if (this.checkVcGenVoucher(id)) {
                    idList.remove(id, false);
                    continue;
                }
                evi = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billId", (Object)id));
                evi.setFilter(filter);
                journals = iJournal.getJournalCollection(evi);
                int size = journals.size();
                for (int i = 0; i < size; ++i) {
                    if (!currentPeriod.getBeginDate().after(journals.get(i).getCreateDate())) continue;
                    idList.remove(id, false);
                }
                continue;
            }
            throw new RecPayException(RecPayException.ACTION_ISNOT_VALID, new Object[]{action.getValue("Name")});
        }
        if (idList == null || idList.size() == 0) {
            throw new RecPayException(RecPayException.HASNOT_VALID_LIST, new Object[]{action.getValue("Name")});
        }
        return idList;
    }

    public CoreBillBaseCollection getValidList4GenVou(CoreBillBaseCollection sourceList, SourceTypeEnum sourceType, Component ui) throws Exception {
        RecPayBillInfo info = null;
        for (int i = sourceList.size() - 1; i >= 0; --i) {
            info = (RecPayBillInfo)sourceList.get(i);
            if (!info.getBillStatus().equals((Object)BillStatusEnum.RECED) && !info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                sourceList.removeObject(i);
                continue;
            }
            if (sourceType.equals((Object)SourceTypeEnum.AR)) {
                if (SourceTypeEnum.AR.equals((Object)info.getSourceType())) continue;
                sourceList.removeObject(i);
                continue;
            }
            if (sourceType.equals((Object)SourceTypeEnum.AP)) {
                if (SourceTypeEnum.AP.equals((Object)info.getSourceType())) continue;
                sourceList.removeObject(i);
                continue;
            }
            if (!sourceType.equals((Object)SourceTypeEnum.CASH) || SourceTypeEnum.CASH.equals((Object)info.getSourceType()) || SourceTypeEnum.CP.equals((Object)info.getSourceType()) || SourceTypeEnum.SCM.equals((Object)info.getSourceType())) continue;
            sourceList.removeObject(i);
        }
        if (sourceList == null || sourceList.size() == 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)srcPath, (String)"CanNotGenVoucher"));
            SysUtil.abort();
        }
        return sourceList;
    }

    public void getValidBillList4DelVou(KDTable tblMain, List idList, SourceTypeEnum sourceType, Component ui) {
        Set rows = FMClientHelper.getSelectedRows((KDTable)tblMain);
        Iterator iter = rows.iterator();
        int rowId = 0;
        int billStatus = 0;
        int billSourceType = 0;
        boolean isVouchered = false;
        String id = null;
        while (iter.hasNext()) {
            rowId = (Integer)iter.next();
            billStatus = ((BizEnumValueInfo)tblMain.getRow(rowId).getCell(COL_BILLSTATUS).getValue()).getInt();
            billSourceType = ((BizEnumValueInfo)tblMain.getRow(rowId).getCell(COL_SOURCETYPE).getValue()).getInt();
            isVouchered = (Boolean)tblMain.getRow(rowId).getCell("isVouchered").getValue();
            id = (String)tblMain.getRow(rowId).getCell(COL_ID).getValue();
            if (!isVouchered) {
                idList.remove(id);
                continue;
            }
            if (sourceType.equals((Object)SourceTypeEnum.AR)) {
                if (billSourceType == 100) continue;
                idList.remove(id);
                continue;
            }
            if (sourceType.equals((Object)SourceTypeEnum.AR)) {
                if (billSourceType == 100) continue;
                idList.remove(id);
                continue;
            }
            if (!sourceType.equals((Object)SourceTypeEnum.CASH) || billSourceType == 103 || billSourceType == 102 || billSourceType == 104) continue;
            idList.remove(id);
        }
        if (idList == null || idList.size() == 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)srcPath, (String)"CanNotDelVoucher"));
            SysUtil.abort();
        }
    }

    public abstract boolean checkVcGenVoucher(String var1) throws EASBizException, BOSException;

    public static EntityViewInfo getCashAccountEvi() {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.FALSE));
        evi.setFilter(filter);
        return evi;
    }

    public static void checkArapAmtIsValid(IRow row, String colName, IObjectCollection coll, Object oldValue) throws RecPayException {
        if (row.getCell(COL_SRC_BILL_ENTRY_ID).getValue() == null) {
            throw new RecPayException(RecPayException.SRC_ENTRY_ID_ISNULL);
        }
        String id = null;
        if (row.getCell(COL_SRC_BILL_ENTRY_ID).getValue() instanceof BOSUuid) {
            id = ((BOSUuid)row.getCell(COL_SRC_BILL_ENTRY_ID).getValue()).toString();
        } else if (row.getCell(COL_SRC_BILL_ENTRY_ID).getValue() instanceof String) {
            id = (String)row.getCell(COL_SRC_BILL_ENTRY_ID).getValue();
        }
        BigDecimal arapAmt = (BigDecimal)row.getCell(colName).getValue();
        RecPayBillEntryInfo entryInfo = null;
        int size = coll.size();
        for (int i = 0; i < size && !(entryInfo = (RecPayBillEntryInfo)coll.getObject(i)).getSourceBillEntryId().toString().equals(id); ++i) {
        }
        BigDecimal amount = null;
        if (entryInfo != null) {
            entryInfo.getAmount().abs();
        }
        if (amount == null) {
            amount = FMConstants.ZERO;
        }
        if (arapAmt == null) {
            arapAmt = FMConstants.ZERO;
        }
        if (arapAmt != null && arapAmt.compareTo(amount) > 0) {
            row.getCell(colName).setValue(oldValue);
            if (colName.equals(COL_REC_AMT)) {
                throw new RecPayException(RecPayException.REC_AMT_GREATER_AR, new Object[]{amount});
            }
            throw new RecPayException(RecPayException.PAY_AMT_GREATER_AP, new Object[]{amount});
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTable kdtEntries) {
        if (kdtEntries == null || kdtEntries.getRowCount() < 1 || kdtEntries.getRowCount() == 1 && RecPayHandler.checkIsTotalLine(kdtEntries.getRow(0))) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)srcPath, (String)"EntryCanNotBeNull"));
            SysUtil.abort();
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            if (RecPayHandler.checkIsTotalLine(row)) continue;
            FMClientVerifyHelper.verifyInput((CoreUIObject)ui, (KDTable)kdtEntries, (IRow)row, (String)key);
        }
    }

    public static void verifyIsZero(CoreUIObject ui, KDTable kdtEntries, String key) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            if (RecPayHandler.checkIsTotalLine(row)) continue;
            FMClientVerifyHelper.verifyInputIsZero((CoreUIObject)ui, (KDTable)kdtEntries, (IRow)row, (String)key);
        }
    }

    public static void verifyTableMaxMinValue(CoreUIObject ui, KDTable kdtEntries) {
        NumberValueVerifyRule rule = new NumberValueVerifyRule();
        rule.setMaxValue(MAX_VALUE);
        rule.setMinValue(FMConstants.ZERO);
        FMClientVerifyHelper.verifyTableMaxMinValue((CoreUIObject)ui, (KDTable)kdtEntries, (NumberValueVerifyRule)rule);
    }

    public static void verifyAccountView(CoreUIObject ui, AccountViewInfo acctViewInfo, CurrencyInfo currInfo) {
        boolean isValid;
        block12: {
            AccountCurrencyCollection acctCurrColl;
            AccountViewInfo viewInfo;
            block11: {
                if (acctViewInfo == null || currInfo == null) {
                    return;
                }
                viewInfo = null;
                acctCurrColl = null;
                if (acctViewInfo.getCurrencyID() == null) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("accountCurrency.*"));
                    try {
                        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
                        viewInfo = iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(acctViewInfo.getId()), sic);
                        acctCurrColl = viewInfo.getAccountCurrency();
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e);
                    }
                } else {
                    acctCurrColl = acctViewInfo.getAccountCurrency();
                }
                isValid = false;
                if (viewInfo == null || !viewInfo.getAccountingcurrency().equals((Object)AccountingCurrencyEnum.NOCURRENCY)) break block11;
                CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
                CurrencyInfo currency = company.getBaseCurrency();
                if (!currency.getId().toString().equals(currInfo.getId().toString())) break block12;
                isValid = true;
                break block12;
            }
            if (viewInfo != null && viewInfo.getAccountingcurrency().equals((Object)AccountingCurrencyEnum.ALLCURRENCY)) {
                isValid = true;
            } else if (acctCurrColl != null) {
                int size = acctCurrColl.size();
                for (int i = 0; i < size; ++i) {
                    if (!acctCurrColl.get(i).getCurrency().getId().equals((Object)currInfo.getId())) continue;
                    isValid = true;
                    break;
                }
            }
        }
        if (!isValid) {
            String msg = EASResource.getString((String)srcPath, (String)"AccountViewInvalid");
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public abstract RecPayBillInfo getCopyInfo(RecPayBillInfo var1);

    public static BigDecimal getScaleValue(BigDecimal value, int scale) {
        int mode = 4;
        if (value == null) {
            return FMConstants.ZERO.setScale(scale, mode);
        }
        return value.setScale(scale, mode);
    }

    public static String getResString(String resourcePath, String resName) {
        return EASResource.getString((String)resourcePath, (String)resName);
    }

    public static String getNumbers(List numbers) {
        StringBuffer strBuf = new StringBuffer("");
        int size = numbers.size();
        for (int i = 0; i < size; ++i) {
            strBuf = i == size - 1 ? strBuf.append(numbers.get(i).toString()) : strBuf.append(numbers.get(i).toString() + "\u3001");
        }
        return strBuf.toString();
    }

    public static String sumList(KDTable tblMain, boolean isDisplayEntries, int prec) {
        String colAmt = COL_ACTAMT;
        if (isDisplayEntries) {
            colAmt = "entries.actAmt";
        }
        StringBuffer msg = new StringBuffer();
        int sumCount = KDTableHelper.getSelectedCountInColumn((KDTable)tblMain, (int)tblMain.getColumn(COL_NUMBER).getColumnIndex());
        BigDecimal sumMoney = KDTableHelper.getSelectedSumInColumn((KDTable)tblMain, (int)tblMain.getColumn(colAmt).getColumnIndex());
        NumberFormat fm = NumberFormat.getInstance();
        fm.setMaximumFractionDigits(prec);
        fm.setGroupingUsed(true);
        msg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"381_RecPayHandler")).append(fm.format(sumMoney)).append("        ").append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"382_RecPayHandler")).append(sumCount).append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"383_RecPayHandler"));
        return msg.toString();
    }
}

