/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IReceiptForm;
import com.kingdee.eas.fi.cas.ReceiptException;
import com.kingdee.eas.fi.cas.ReceiptFormCollection;
import com.kingdee.eas.fi.cas.ReceiptFormFactory;
import com.kingdee.eas.fi.cas.ReceiptFormInfo;
import com.kingdee.eas.fi.cas.client.AbstractReceiptFormListUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.ReceiptFormDataProvider;
import com.kingdee.eas.fi.cas.client.ReceiptFormEditUI;
import com.kingdee.eas.fi.cas.client.ReceiptFormFilterUI;
import com.kingdee.eas.fi.cas.client.ReceiptFormHandler;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ReceiptFormListUI
extends AbstractReceiptFormListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiptFormListUI.class);
    protected CommonQueryDialog queryDlg = null;
    public static final String RECEIPTFORM_FILENAME = "/FI/CAS/RECEIPTFORM";
    protected FMFilterBaseUI filterUI = null;
    private CompanyOrgUnitInfo companyInfo = null;
    FillListener fillListener = new FillListener();

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        ReceiptFormDataProvider data = new ReceiptFormDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(RECEIPTFORM_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintView_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        ReceiptFormDataProvider data = new ReceiptFormDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(RECEIPTFORM_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionBlankOut.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_blankout"));
    }

    public void onLoad() throws Exception {
        if (this.companyInfo == null) {
            this.companyInfo = ClientUtils.getCurrLoginCompany();
        }
        ClientUtils.checkCompany((Component)((Object)this), this.companyInfo);
        super.onLoad();
        this.tblMain.getViewManager().setFreezeView(0, 1);
        this.actionEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.btnTDPrint.setIcon(EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.btnTDPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnBlankOut.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.actionWorkFlowG.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.separatorFW4.setVisible(false);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        FilterInfo filter = ev.getFilter();
        if (ev.getFilter() == null) {
            filter = new FilterInfo();
            ev.setFilter(filter);
        }
        filter.getFilterItems().add(new FilterItemInfo("hasEffected", (Object)Boolean.TRUE));
        super.beforeExcutQuery(ev);
    }

    protected void execQuery() {
        this.deleteUnHasEffectedBills();
        FilterInfo filter = this.mainQuery.getFilter();
        if (this.mainQuery.getFilter() == null) {
            filter = new FilterInfo();
            this.mainQuery.setFilter(filter);
        }
        filter.getFilterItems().add(new FilterItemInfo("hasEffected", (Object)Boolean.TRUE));
        super.execQuery();
    }

    private void deleteUnHasEffectedBills() {
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        String userId = userInfo.getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("hasEffected", (Object)FMConstants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("hasEffected", null));
        filter.setMaskString("#0 AND (#1 OR #2)");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        try {
            ReceiptFormCollection coll = ((IReceiptForm)this.getBizInterface()).getReceiptFormCollection(evi);
            ObjectUuidPK pk = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                pk = new ObjectUuidPK(coll.get(i).getId());
                ((IReceiptForm)this.getBizInterface()).delete((IObjectPK)pk);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort(e);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionBlankOut_actionPerformed(ActionEvent e) throws Exception {
        int rowNumber;
        IRow row;
        int billStatus;
        this.checkSelected();
        Set idSet = FMClientHelper.getSelectedRows((KDTable)this.tblMain);
        if (idSet.size() == 1 && (billStatus = ((BizEnumValueInfo)(row = this.tblMain.getRow(rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain))).getCell("billStatus").getValue()).getInt()) == 0) {
            throw new ReceiptException(ReceiptException.IS_BLANKOUTED);
        }
        IIDList idList = ReceiptFormHandler.getValidListByAction(this.actionBlankOut, this.tblMain, this.getSelectedKeyValue(), this.getSelectedKeyValues());
        ((IReceiptForm)this.getBizInterface()).blankOut(FMClientHelper.list2Set((IIDList)idList));
        Component component = (Component)e.getSource();
        FMClientHelper.showSuccessInfo((Component)((Object)this), (Component)component);
        this.refresh(e);
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billStatus", "asstActType.name", "asstActName", "bizDate", "currency.id", "currency.name", "amtSum"};
    }

    @Override
    protected String getEditUIName() {
        return ReceiptFormEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReceiptFormFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ReceiptFormInfo objectValue = new ReceiptFormInfo();
        return objectValue;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceiptFormFilterUI();
        }
        return this.filterUI;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        this.queryDlg = super.getQueryDlg();
        this.queryDlg.setWidth(530);
        this.queryDlg.setHeight(280);
        return this.queryDlg;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            ReceiptFormHandler.setListUITable(ReceiptFormListUI.this.tblMain);
            ReceiptFormListUI.this.tblMain.repaint();
        }
    }
}

