/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.assistant.PrintIntegrationInfo;
import com.kingdee.eas.fi.cas.AssItemsForCashRecCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashRecFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceivingBillDataProvider
implements BOSQueryDelegate {
    private static Logger logger = Logger.getLogger((String)ReceivingBillDataProvider.class.getName());
    private static IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fi.cas.ReceivingBillTDQuery");
    private Set ids = null;
    KDNoteHelper currentHelper = null;
    private String currentPK = null;
    private String templatePath = "/FI/CAS/RECEIVINGBILL";

    public static void main(String[] args) throws BOSException {
        FMClientHelper.printTDMetaDataField((String)qpk.getFullName());
    }

    public ReceivingBillDataProvider(Set id) {
        this.ids = id;
    }

    public ReceivingBillDataProvider(List id) {
        this.ids = new HashSet(id);
    }

    public ReceivingBillDataProvider(List id, KDNoteHelper currentHelper, IMetaDataPK pk) {
        this.ids = new HashSet(id);
        this.currentHelper = currentHelper;
        qpk = pk;
    }

    public ReceivingBillDataProvider(Set id, KDNoteHelper currentHelper) {
        this(id);
        this.currentHelper = currentHelper;
    }

    public ReceivingBillDataProvider(List id, KDNoteHelper currentHelper) {
        this(id);
        this.currentHelper = currentHelper;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qpk);
            exec.option().isAutoTranslateEnum = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("receivingBill.id", (Object)this.ids, CompareType.INCLUDE));
            R1PrintDataSortItem[] sortItems = ds.getSortFields();
            if (sortItems != null && sortItems.length > 0) {
                for (int i = 0; i < sortItems.length; ++i) {
                    String fieldName = sortItems[i].getSortField();
                    if (EmptyUtil.isEmpty((String)fieldName)) continue;
                    SorterItemInfo sort = null;
                    sort = fieldName.indexOf("entries") > -1 ? new SorterItemInfo(fieldName) : (fieldName.indexOf("receivingBill") > -1 ? new SorterItemInfo(fieldName) : (fieldName.indexOf(".") > -1 ? new SorterItemInfo(fieldName) : new SorterItemInfo("receivingBill." + fieldName)));
                    if (0 == sortItems[i].getSortType()) {
                        sort.setSortType(SortType.ASCEND);
                    } else {
                        sort.setSortType(SortType.DESCEND);
                    }
                    ev.getSorter().add(sort);
                }
            } else {
                SorterItemInfo sort = new SorterItemInfo("receivingBill.number");
                sort.setSortType(SortType.ASCEND);
                ev.getSorter().add(sort);
            }
            ev.setFilter(filter);
            ArrayList param = ds.getParams();
            FMClientHelper.addDataFilter((FilterInfo)filter, (ArrayList)param);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
                this.currentPK = iRowSet.getString("receivingBill.id");
                if (this.currentHelper.isPrintTimesControllable2(this.templatePath)) {
                    PrintIntegrationInfo printInfo = pinfo.getBillPrintInfo("FA44FD5B", this.currentPK);
                    int printedTimes = 0;
                    if (printInfo != null) {
                        printedTimes = printInfo.getPrintedNumber();
                    }
                    int prepareTimes = this.currentHelper.getCopies();
                    int maxPrintTimes = this.currentHelper.getMaxPrintTimes2(this.templatePath);
                    if (printedTimes < maxPrintTimes) {
                        if (printedTimes + prepareTimes <= maxPrintTimes) {
                            iRowSet.updateString("printCount", Integer.toString(printedTimes + prepareTimes));
                        } else {
                            iRowSet.updateString("printCount", Integer.toString(maxPrintTimes));
                        }
                    } else {
                        iRowSet.updateString("printCount", Integer.toString(printedTimes));
                    }
                } else {
                    iRowSet.updateString("canPrtControl", Integer.toString(3));
                }
                int precision = iRowSet.getInt("currency.precision");
                iRowSet.updateBigDecimal("actualAmt", iRowSet.getBigDecimal("actualAmt").setScale(precision, 4));
                String entryID = iRowSet.getString("receivingBillEntry.id");
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filteri = new FilterInfo();
                filteri.getFilterItems().add(new FilterItemInfo("entryParent", (Object)entryID));
                evi.setFilter(filteri);
                evi.getSelector().add(new SelectorItemInfo("*"));
                evi.getSelector().add(new SelectorItemInfo("asstActType.*"));
                AssItemsForCashRecCollection assColl = AssItemsForCashRecFactory.getRemoteInstance().getAssItemsForCashRecCollection(evi);
                AssItemsForCashRecInfo infoTmp = null;
                CoreBaseInfo entityInfo = null;
                StringBuffer sf_assName = new StringBuffer();
                StringBuffer sf_assType = new StringBuffer();
                for (int i = 0; i < assColl.size(); ++i) {
                    infoTmp = assColl.get(i);
                    if (infoTmp.getAsstActType() != null) {
                        sf_assType.append(infoTmp.getAsstActType().getName());
                    }
                    if (infoTmp.getFromID() != null && !infoTmp.getFromID().equals("") && (entityInfo = EJBAccessFactory.createRemoteInstance().getEntityInfo(infoTmp.getFromID())) != null && entityInfo.getString("name") != null) {
                        sf_assName.append(entityInfo.getString("name"));
                    }
                    if (i + 1 == assColl.size()) continue;
                    sf_assType.append("\uff1b");
                    sf_assName.append("\uff1b");
                }
                iRowSet.updateString("assName", sf_assName.toString());
                iRowSet.updateString("assType", sf_assType.toString());
                String currencyId = iRowSet.getString("currency.id");
                String companyId = iRowSet.getString("company.id");
                Date bizDate = iRowSet.getDate("receivingBill.bizDate");
                int exRatePrec = CasRecPayHandler.getExRatePrec(currencyId, null, companyId, (java.util.Date)bizDate);
                iRowSet.updateBigDecimal("receivingBill.exchangeRate", iRowSet.getBigDecimal("receivingBill.exchangeRate").setScale(exRatePrec, 4));
                iRowSet.updateString("recType.name", iRowSet.getString("recType.name"));
                iRowSet.updateString("settlementType.name", iRowSet.getString("settlementType.name"));
                iRowSet.updateString("person.name", iRowSet.getString("person.name"));
                iRowSet.updateString("adminOrgUnit.name", iRowSet.getString("adminOrgUnit.name"));
                iRowSet.updateString("coreBillNumber", iRowSet.getString("coreBillNumber"));
                iRowSet.updateString("coreBillType.name", iRowSet.getString("coreBillType.name"));
                iRowSet.updateString("contractNum", iRowSet.getString("contractNum"));
                iRowSet.updateString("contractEntrySeq", iRowSet.getString("contractEntrySeq"));
                iRowSet.updateBigDecimal("receivingBill.actRecAmt", iRowSet.getBigDecimal("receivingBill.actRecAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("receivingBill.actRecAmtVc", iRowSet.getBigDecimal("receivingBill.actRecAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("receivingBill.actRecLocAmt", iRowSet.getBigDecimal("receivingBill.actRecLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("receivingBill.actRecLocAmtVc", iRowSet.getBigDecimal("receivingBill.actRecLocAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("amount", iRowSet.getBigDecimal("amount").setScale(precision, 4));
                iRowSet.updateBigDecimal("amountVc", iRowSet.getBigDecimal("amountVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmt", iRowSet.getBigDecimal("localAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmtVc", iRowSet.getBigDecimal("localAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("unVcAmount", iRowSet.getBigDecimal("unVcAmount").setScale(precision, 4));
                iRowSet.updateBigDecimal("unVcLocAmount", iRowSet.getBigDecimal("unVcLocAmount").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebate", iRowSet.getBigDecimal("rebate").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebateAmtVc", iRowSet.getBigDecimal("rebateAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebateLocAmt", iRowSet.getBigDecimal("rebateLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebateLocAmtVc", iRowSet.getBigDecimal("rebateLocAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("actualAmtVc", iRowSet.getBigDecimal("actualAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("actualLocAmt", iRowSet.getBigDecimal("actualLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("actualLocAmtVc", iRowSet.getBigDecimal("actualLocAmtVc").setScale(precision, 4));
                String billId = iRowSet.getString("id");
                MultiApproveCollection col = FSClientHelper.getMutiApprove((String)billId);
                for (int i = 1; i <= col.size() && i <= 5; ++i) {
                    MultiApproveInfo info = col.get(i - 1);
                    iRowSet.updateString("censor" + i, info.getCreator().getName());
                }
                if (iRowSet.getString("receivingBill.auditDate") != null) {
                    iRowSet.updateString("receivingBill.auditDate", iRowSet.getString("receivingBill.auditDate").substring(0, 10));
                }
                if (iRowSet.getString("payerType.name") == null) {
                    iRowSet.updateString("payerType.name", EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"374_PaymentBillDataProvider"));
                }
                iRowSet.updateString("sourceBillId", FMClientHelper.getBillNumber((String)iRowSet.getString("sourceBillId")));
                StringBuffer voucherNumber = new StringBuffer("");
                VoucherCollection colVoucher = null;
                if (!iRowSet.getBoolean("receivingBill.fiVouchered")) continue;
                colVoucher = FMClientHelper.getVoucherCollection((String)iRowSet.getString("receivingBill.id"));
                if (colVoucher != null && colVoucher.size() > 0) {
                    for (VoucherInfo info : colVoucher) {
                        voucherNumber.append(info.getNumber());
                        voucherNumber.append("  ");
                    }
                }
                iRowSet.updateString("voucherNumber", voucherNumber.toString());
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return iRowSet;
    }
}

