/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fi.cas.RecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractReceivingFilterUI;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.cas.client.ArApRecPayLogic;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fi.cas.client.ReceivingFilterParam;
import com.kingdee.eas.fi.cas.client.ReceivingHandler;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ReceivingFilterUI
extends AbstractReceivingFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivingFilterUI.class);
    private static String resourcePath = "com.kingdee.eas.fi.cas.RecPayResource";
    private RecPayHandler handler = new ReceivingHandler();
    public CompanyOrgUnitInfo companyInfo = null;
    private boolean isInit;
    private boolean isStartAR = true;
    private SourceTypeEnum sourceType = null;
    private static final String PERMISSION = "cas_receivingbill_01view";
    private ArApRecPayHelper arapHelper = new ArApRecPayHelper();
    private ArApRecPayLogic arapLogic = new ArApRecPayLogic();
    protected ArApSysParamInfo cache = new ArApSysParamInfo();
    protected IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    protected boolean isVerifi = false;
    protected String defaultCompanyId = null;
    private boolean isDisplayEntries = false;

    public ReceivingFilterUI() throws Exception {
    }

    public ReceivingFilterUI(boolean isInit, SourceTypeEnum sourceType) throws Exception {
        this();
        this.isInit = isInit;
        this.sourceType = sourceType;
        if (isInit) {
            this.setUITitle(EASResource.getString((String)resourcePath, (String)"ARInitBillQuery"));
        }
    }

    public ReceivingFilterUI(boolean isInit, SourceTypeEnum sourceType, ArApSysParamInfo cache) throws Exception {
        this();
        this.isInit = isInit;
        this.sourceType = sourceType;
        this.cache = cache;
    }

    public ReceivingFilterUI(boolean isInit, SourceTypeEnum sourceType, ArApSysParamInfo cache, boolean isVerifi) throws Exception {
        this();
        this.isInit = isInit;
        this.sourceType = sourceType;
        this.cache = cache;
        this.isVerifi = isVerifi;
    }

    public ReceivingFilterUI(boolean isInit, SourceTypeEnum sourceType, String defaultCompanyId, boolean isVerifi) throws Exception {
        this();
        this.isInit = isInit;
        this.sourceType = sourceType;
        this.defaultCompanyId = defaultCompanyId;
        this.isVerifi = isVerifi;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (100 == this.sourceType.getValue()) {
            if (this.cache.getCompany() == null) {
                if (this.defaultCompanyId != null) {
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)this.defaultCompanyId));
                    this.cache = this.iBillFacade.getSysParams(company, this.getUIParam());
                } else {
                    this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
                }
            }
            NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, PERMISSION);
            this.prmtCompany.setRequired(true);
            this.prmtCompany.setEditFormat("$number$");
            this.prmtCompany.setDisplayFormat("$name$");
            this.prmtCompany.setCommitFormat("$number$;$name$;$code$;$simpleName$");
            this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
            this.prmtCompany.setValue((Object)this.cache.getCompany());
            if (this.isInit && this.getBeforSysStartDate() != null) {
                this.arapHelper.setDefaultFitlerBillDate((Component)((Object)this), this.cache, this.isInit, this.sourceType, this.pkBillDateFrom, this.pkBillDateTo, this.cache.getCompany());
            }
            if (!this.isInit && (this.sourceType.equals((Object)SourceTypeEnum.AR) || this.sourceType.equals((Object)SourceTypeEnum.AP))) {
                this.pkBillDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
                this.pkBillDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
            }
            this.pkBillDateFrom.setRequired(true);
            this.pkBillDateTo.setRequired(true);
            this.prmtCompany.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        ReceivingFilterUI.this.prmtCompany_dataChanged(e);
                    }
                    catch (Exception exc) {
                        ReceivingFilterUI.this.handUIException(exc);
                    }
                }
            });
            if (this.isVerifi) {
                this.prmtCompany.setEnabled(false);
                this.prmtCompany.setEditable(false);
            }
        } else {
            if (this.cache.getCompany() == null) {
                // empty if block
            }
            this.prmtCompany.setEnabled(false);
        }
        this.comboSourceType.removeItem((Object)SourceTypeEnum.AP);
        this.comboSourceType.removeItem((Object)SourceTypeEnum.CP);
        if (this.sourceType.equals((Object)SourceTypeEnum.AR)) {
            this.comboSourceType.setSelectedItem((Object)SourceTypeEnum.AR);
            this.comboSourceType.setEnabled(false);
        }
        this.comboPayerType_actionPerformed(null);
        if (100 == this.sourceType.getValue()) {
            CasForArApUtil.makeAsstActType(this.comboPayerType, this.cache, true);
        }
        if (this.isInit) {
            this.btnSubmitAll.setSelected(true);
            this.btnAuditAll.setSelected(true);
            this.btnReceiveAll.setSelected(true);
            this.btnVoucherAll.setSelected(true);
            this.panSubmit.setVisible(false);
            this.panAudit.setVisible(false);
            this.panRec.setVisible(false);
            this.panVoucher.setVisible(false);
            this.kDSeparator1.setVisible(false);
            this.setUITitle(EASResource.getString((String)resourcePath, (String)"ARInitBillQuery"));
        }
        if (this.getUIContext().get("TargetBillType") != null && ((String)this.getUIContext().get("TargetBillType")).equals("ReceiptForm")) {
            this.btnSubmitAll.setSelected(true);
            this.btnAuditAll.setSelected(true);
            this.btnReceiveAll.setSelected(true);
            this.btnVoucherAll.setSelected(true);
            this.panSubmit.setVisible(false);
            this.panAudit.setVisible(false);
            this.panRec.setVisible(false);
            this.panVoucher.setVisible(false);
            this.kDSeparator1.setVisible(false);
            this.getUIContext().remove("TargetBillType");
        }
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isSCM", Boolean.FALSE);
        map.put("sysEnum", SystemEnum.ACCOUNTSRECEIVABLE);
        map.put("permissionItem", PERMISSION);
        return map;
    }

    @Override
    public Object getParam() {
        ReceivingFilterParam param = new ReceivingFilterParam();
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        Object obj = this.prmtCompany.getValue();
        if (obj != null && 100 == this.sourceType.getValue()) {
            CompanyOrgUnitInfo company = null;
            if (obj instanceof CompanyOrgUnitInfo) {
                company = (CompanyOrgUnitInfo)obj;
                param.setCompanyId(company.getId().toString());
                param.setCompanyName(company.getName());
            } else {
                this.prmtCompany.setValue(null);
                ArApRecPayLogic.verify((CoreUIObject)this, this.prmtCompany);
            }
        }
        param.setBillDateFrom((Date)this.pkBillDateFrom.getValue());
        param.setBillDateTo((Date)this.pkBillDateTo.getValue());
        if (this.comboSourceType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setSourceType(999);
        } else {
            param.setSourceType(((SourceTypeEnum)this.comboSourceType.getSelectedItem()).getValue());
        }
        if (this.sourceType == SourceTypeEnum.AR) {
            if (this.prmtRecType.getValue() != null) {
                param.setReceivingTypeId(((ReceivingBillTypeInfo)this.prmtRecType.getValue()).getId().toString());
                param.setReceivingTypeName(((ReceivingBillTypeInfo)this.prmtRecType.getValue()).getName());
                param.setReceivingTypeNumber(((ReceivingBillTypeInfo)this.prmtRecType.getValue()).getNumber());
            }
        } else if (this.comboBillType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setBillType(999);
        } else {
            param.setBillType(((RecPayBillTypeEnum)((Object)this.comboBillType.getSelectedItem())).getValue());
        }
        if (this.prmtCurrency.getValue() == null) {
            param.setCurrencyId(null);
        } else if (this.prmtCurrency.getValue() instanceof CurrencyInfo) {
            param.setCurrencyId(((CurrencyInfo)this.prmtCurrency.getValue()).getId().toString());
        }
        if (this.comboPayerType.getSelectedItem() == null || this.comboPayerType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS) || CasForArApUtil.ITEM_ALL.equals(this.comboPayerType.getSelectedItem())) {
            param.setPayerTypeId(null);
        } else if (this.comboPayerType.getSelectedItem() instanceof DataBaseInfo) {
            param.setPayerTypeId(((DataBaseInfo)this.comboPayerType.getSelectedItem()).getId().toString());
        }
        if (this.prmtPayer.getValue() instanceof DataBaseInfo) {
            param.setPayerId(((DataBaseInfo)this.prmtPayer.getValue()).getId().toString());
            param.setPayerName(((DataBaseInfo)this.prmtPayer.getValue()).getName());
            param.setPayerNumber(((DataBaseInfo)this.prmtPayer.getValue()).getNumber());
        }
        if (this.prmtPayerTo.getValue() instanceof DataBaseInfo) {
            param.setPayerToId(((DataBaseInfo)this.prmtPayerTo.getValue()).getId().toString());
            param.setPayerToName(((DataBaseInfo)this.prmtPayerTo.getValue()).getName());
            param.setPayerNumberTo(((DataBaseInfo)this.prmtPayerTo.getValue()).getNumber());
        }
        if (this.radioHead.isSelected()) {
            param.setDisplayEntries(false);
        } else if (this.radioEntries.isSelected()) {
            param.setDisplayEntries(true);
        }
        if (!this.isInit) {
            if (this.btnSubmited.isSelected()) {
                param.setIsSubmited(1);
            } else if (this.btnSave.isSelected()) {
                param.setIsSubmited(0);
            } else if (this.btnSubmitAll.isSelected()) {
                param.setIsSubmited(999);
            }
            if (this.btnAudited.isSelected()) {
                param.setIsAudited(1);
            } else if (this.btnUnAudited.isSelected()) {
                param.setIsAudited(0);
            } else if (this.btnAuditAll.isSelected()) {
                param.setIsAudited(999);
            }
            if (this.btnReceived.isSelected()) {
                param.setIsReceived(1);
            } else if (this.btnUnReceived.isSelected()) {
                param.setIsReceived(0);
            } else if (this.btnReceiveAll.isSelected()) {
                param.setIsReceived(999);
            }
            if (this.btnVouchered.isSelected()) {
                param.setIsVouchered(1);
            } else if (this.btnUnVouchered.isSelected()) {
                param.setIsVouchered(0);
            } else if (this.btnVoucherAll.isSelected()) {
                param.setIsVouchered(999);
            }
        } else {
            param.setInit(true);
        }
        return param;
    }

    @Override
    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof ReceivingFilterParam)) {
            return;
        }
        ReceivingFilterParam filterParam = (ReceivingFilterParam)param;
        try {
            DataBaseInfo currentInfo;
            if (filterParam.getCompanyId() != null && 100 == this.sourceType.getValue()) {
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)filterParam.getCompanyId()));
                if (!CasForArApUtil.idEquals((CoreBaseInfo)this.cache.getCompany(), (CoreBaseInfo)companyInfo)) {
                    this.cache = this.iBillFacade.getSysParams(companyInfo, this.getUIParam());
                }
                if (!CasForArApUtil.idEquals((CoreBaseInfo)((CompanyOrgUnitInfo)this.prmtCompany.getValue()), (CoreBaseInfo)this.cache.getCompany())) {
                    this.prmtCompany.setData((Object)this.cache.getCompany());
                }
            }
            this.pkBillDateFrom.setValue((Object)filterParam.getBillDateFrom());
            this.pkBillDateTo.setValue((Object)filterParam.getBillDateTo());
            if (filterParam.getBillNumberFrom() != null) {
                this.prmtBillNumberFrom.setData((Object)ReceivingBillFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(filterParam.getBillNumberFrom())));
            }
            if (filterParam.getBillNumberTo() != null) {
                this.prmtBillNumberTo.setData((Object)ReceivingBillFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(filterParam.getBillNumberTo())));
            }
            if (filterParam.getCurrencyId() != null) {
                this.prmtCurrency.setValue((Object)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(filterParam.getCurrencyId())));
            } else {
                this.prmtCurrency.setValue(null);
            }
            if (filterParam.getPayerTypeId() == null) {
                this.comboPayerType.setSelectedItem((Object)CasForArApUtil.ITEM_ALL);
            } else if (!CasForArApUtil.ITEM_ALL.equals(filterParam.getPayerTypeId())) {
                int selectIndex = ReceivingFilterUI.getSelectIndex(this.comboPayerType, filterParam.getPayerTypeId());
                this.comboPayerType.setSelectedIndex(selectIndex);
            }
            if (filterParam.getPayerId() != null) {
                currentInfo = new CurrentInfo();
                currentInfo.setId(BOSUuid.read((String)filterParam.getPayerId()));
                currentInfo.setName(filterParam.getPayerName());
                currentInfo.setNumber(filterParam.getPayerNumber());
                this.prmtPayer.setData((Object)currentInfo);
            }
            if (filterParam.isDisplayEntries() || this.isDisplayEntries) {
                this.radioHead.setSelected(false);
                this.radioEntries.setSelected(true);
            } else {
                this.radioHead.setSelected(true);
                this.radioEntries.setSelected(false);
            }
            if (filterParam.getPayerToId() != null) {
                currentInfo = new CurrentInfo();
                currentInfo.setId(BOSUuid.read((String)filterParam.getPayerToId()));
                currentInfo.setName(filterParam.getPayerToName());
                currentInfo.setNumber(filterParam.getPayerNumberTo());
                this.prmtPayerTo.setData((Object)currentInfo);
            }
            if (filterParam.getReceivingTypeId() != null) {
                currentInfo = new ReceivingBillTypeInfo();
                currentInfo.setId(BOSUuid.read((String)filterParam.getReceivingTypeId()));
                currentInfo.setName(filterParam.getReceivingTypeName());
                currentInfo.setNumber(filterParam.getReceivingTypeNumber());
                this.prmtRecType.setData((Object)currentInfo);
            } else {
                this.prmtRecType.setValue(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (filterParam.getSourceType() == 999) {
            this.comboSourceType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboSourceType.setSelectedItem((Object)SourceTypeEnum.getEnum((int)filterParam.getSourceType()));
        }
        if (filterParam.getBillType() == 999) {
            this.comboBillType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboBillType.setSelectedItem((Object)RecPayBillTypeEnum.getEnum(filterParam.getBillType()));
        }
        if (filterParam.getIsSubmited() == 999) {
            this.btnSubmitAll.setSelected(true);
        } else if (filterParam.getIsSubmited() == 1) {
            this.btnSubmited.setSelected(true);
        } else {
            this.btnSave.setSelected(true);
        }
        if (filterParam.getIsAudited() == 999) {
            this.btnAuditAll.setSelected(true);
        } else if (filterParam.getIsAudited() == 1) {
            this.btnAudited.setSelected(true);
        } else {
            this.btnUnAudited.setSelected(true);
        }
        if (filterParam.getIsReceived() == 999) {
            this.btnReceiveAll.setSelected(true);
        } else if (filterParam.getIsReceived() == 1) {
            this.btnReceived.setSelected(true);
        } else {
            this.btnUnReceived.setSelected(true);
        }
        if (filterParam.getIsVouchered() == 999) {
            this.btnVoucherAll.setSelected(true);
        } else if (filterParam.getIsVouchered() == 1) {
            this.btnVouchered.setSelected(true);
        } else {
            this.btnUnVouchered.setSelected(true);
        }
    }

    public static int getSelectIndex(KDComboBox comboBox, String id) {
        for (int i = 1; i < comboBox.getItemCount(); ++i) {
            CoreBaseInfo info;
            if (!(comboBox.getItemAt(i) instanceof CoreBaseInfo) || !id.equals((info = (CoreBaseInfo)comboBox.getItemAt(i)).getId().toString())) continue;
            return i;
        }
        return 0;
    }

    public void clear() {
        super.clear();
        try {
            if (this.defaultCompanyId != null) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)this.defaultCompanyId));
                this.cache = this.iBillFacade.getSysParams(company, this.getUIParam());
            } else {
                this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
            }
            this.prmtCompany.setValue((Object)this.cache.getCompany());
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        this.comboSourceType.removeItem((Object)SourceTypeEnum.AP);
        this.comboSourceType.removeItem((Object)SourceTypeEnum.CP);
        this.comboSourceType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        if (this.sourceType.equals((Object)SourceTypeEnum.AR)) {
            this.comboSourceType.setSelectedItem((Object)SourceTypeEnum.AR);
            this.comboSourceType.setEnabled(false);
        }
        try {
            if (100 == this.sourceType.getValue()) {
                if (this.isInit) {
                    this.arapHelper.setDefaultFitlerBillDate((Component)((Object)this), this.cache, this.isInit, this.sourceType, this.pkBillDateFrom, this.pkBillDateTo, this.cache.getCompany());
                } else {
                    this.pkBillDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
                    this.pkBillDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
                }
                CasForArApUtil.makeAsstActType(this.comboPayerType, this.cache, true);
            } else {
                this.comboPayerType_actionPerformed(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            logger.error((Object)e);
        }
        this.comboPayerType.setSelectedItem((Object)CasForArApUtil.ITEM_ALL);
        this.btnSubmitAll.setSelected(true);
        this.btnAuditAll.setSelected(true);
        this.btnReceiveAll.setSelected(true);
        this.btnVoucherAll.setSelected(true);
        this.prmtRecType.setValue(null);
        this.prmtCurrency.setValue(null);
        this.prmtPayer.setValue(null);
        this.prmtPayerTo.setValue(null);
        this.radioHead.setSelected(false);
        this.radioEntries.setSelected(true);
    }

    @Override
    protected void comboSourceType_actionPerformed(ActionEvent e) throws Exception {
        Object sourceTypeEnum = this.comboSourceType.getSelectedItem();
        if (sourceTypeEnum == null) {
            return;
        }
        if (sourceTypeEnum.equals(FMSysDefinedEnum.ALL_ITEMS)) {
            this.handler.initBillType(this.comboBillType, "");
            this.comboBillType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            this.comboBillType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else if (sourceTypeEnum.equals(SourceTypeEnum.AR)) {
            this.handler.initBillType(this.comboBillType, "AR");
            this.comboBillType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            this.comboBillType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            this.arapHelper.initBillType(this.prmtRecType, SourceTypeEnum.AR, this.isInit, false);
        }
    }

    @Override
    protected void comboPayerType_actionPerformed(ActionEvent e) throws Exception {
        this.prmtPayer.setValue(null);
        this.prmtPayerTo.setValue(null);
        if (this.comboPayerType.getSelectedItem() == null || !(this.comboPayerType.getSelectedItem() instanceof AsstActTypeInfo)) {
            this.prmtPayer.setEnabled(false);
            this.prmtPayerTo.setEnabled(false);
            return;
        }
        if (this.prmtPayer.isEnabled() && this.prmtPayer.getData() != null) {
            return;
        }
        this.prmtPayer.setEnabled(true);
        this.prmtPayerTo.setEnabled(true);
        this.prmtPayer.setValue(null);
        this.prmtPayerTo.setValue(null);
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.comboPayerType.getSelectedItem();
        if (100 == this.sourceType.getValue()) {
            this.arapHelper.assignSelector((CoreUIObject)this, this.prmtPayer, asstActTypeInfo, this.cache.getCompany(), true);
            this.arapHelper.assignSelector((CoreUIObject)this, this.prmtPayerTo, asstActTypeInfo, this.cache.getCompany(), true);
        } else {
            RecPayHandler.assignSelector((CoreUIObject)this, this.prmtPayer, asstActTypeInfo);
        }
    }

    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCompany.getValue() == null) {
            return;
        }
        if (this.isInit) {
            this.arapHelper.setDefaultFitlerBillDateNoCache((Component)((Object)this), this.isInit, this.sourceType, this.pkBillDateFrom, this.pkBillDateTo, (CompanyOrgUnitInfo)this.prmtCompany.getValue());
        }
        if (!CasForArApUtil.idEquals((CoreBaseInfo)this.cache.getCompany(), (CoreBaseInfo)((CompanyOrgUnitInfo)e.getNewValue()))) {
            this.cache = this.iBillFacade.getSysParams((CompanyOrgUnitInfo)e.getNewValue(), this.getUIParam());
        }
        this.prmtPayer.setValue(null);
        this.prmtPayerTo.setValue(null);
        if (this.comboPayerType.getSelectedItem() == null || !(this.comboPayerType.getSelectedItem() instanceof AsstActTypeInfo)) {
            this.prmtPayer.setEnabled(false);
            this.prmtPayer.setData(null);
            this.prmtPayerTo.setEnabled(false);
            this.prmtPayerTo.setData(null);
            return;
        }
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.comboPayerType.getSelectedItem();
        this.arapHelper.assignSelector((CoreUIObject)this, this.prmtPayer, asstActTypeInfo, this.cache.getCompany(), true);
        this.arapHelper.assignSelector((CoreUIObject)this, this.prmtPayerTo, asstActTypeInfo, this.cache.getCompany(), true);
    }

    public boolean verify() {
        return this.arapHelper.verifyFitlerBillDate((CoreUIObject)this, this.cache, this.isInit, this.sourceType, this.pkBillDateFrom, this.pkBillDateTo, this.cache.getCompany());
    }

    public void initF7BillNumber(KDBizPromptBox prmtBillNumber) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.cache.getCompany().getId()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        prmtBillNumber.setEntityViewInfo(evi);
    }

    private Date getBeforSysStartDate() throws EASBizException, BOSException {
        PeriodInfo startPeriod = this.cache.getStartPeriod(this.getSysEnum());
        if (startPeriod == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"startPeriodIsNull"));
            SysUtil.abort();
        }
        Date beforeStartDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(startPeriod.getBeginDate());
        cal.add(5, -1);
        beforeStartDate = cal.getTime();
        return beforeStartDate;
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    public String getPermissionItem() {
        return PERMISSION;
    }

    public FilterInfo getFilterInfo() {
        ReceivingFilterParam param = new ReceivingFilterParam();
        param = (ReceivingFilterParam)this.getParam();
        return param.getFilter();
    }

    protected Class getParamClass() {
        return ReceivingFilterParam.class;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.isDisplayEntries = cp.getCustomerParam("displayEntries") == null;
        super.setCustomerParams(cp);
    }

    public CompanyOrgUnitInfo getCompanyInfo() {
        CompanyOrgUnitInfo companyInfo = this.prmtCompany.getValue() == null ? null : (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        return companyInfo;
    }
}

