/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.VcStatusEnum;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class ReceivingHandler
extends RecPayHandler {
    @Override
    public void initBillType(KDComboBox comboBillType, String sourceType) {
        if (sourceType == null) {
            return;
        }
        comboBillType.removeAllItems();
        if (sourceType.equals(SourceTypeEnum.CASH.getName())) {
            comboBillType.addItem((Object)RecPayBillTypeEnum.OTHER);
            comboBillType.addItem((Object)RecPayBillTypeEnum.PAY_CP_REFUNDMENT_BILL);
            comboBillType.setSelectedItem((Object)RecPayBillTypeEnum.OTHER);
            return;
        }
        if (sourceType.equals(SourceTypeEnum.FS.getName())) {
            comboBillType.addItem((Object)RecPayBillTypeEnum.OTHER);
            comboBillType.setSelectedItem((Object)RecPayBillTypeEnum.OTHER);
            return;
        }
        comboBillType.setEnabled(true);
        Map map = RecPayBillTypeEnum.getEnumMap();
        for (String key : map.keySet()) {
            if (key.length() < 6) continue;
            if (key.substring(0, 6).equals("REC_AR") && key.indexOf(sourceType) != -1) {
                comboBillType.addItem((Object)RecPayBillTypeEnum.getEnum(key));
                continue;
            }
            if (!sourceType.equals(SourceTypeEnum.SCM.getName())) continue;
            comboBillType.addItem((Object)RecPayBillTypeEnum.getEnum(key));
        }
        if (sourceType.equals("")) {
            comboBillType.addItem((Object)RecPayBillTypeEnum.PAY_CP_REFUNDMENT_BILL);
            comboBillType.addItem((Object)RecPayBillTypeEnum.OTHER);
        }
    }

    @Override
    public void initCellEditor(KDComboBox comboCurrency, KDTable kdtEntries) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)comboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        int precision = currencyInfo.getPrecision();
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(kdtEntries, "recAmt", precision, FMConstants.ZERO);
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(kdtEntries, "recLocAmt", precision, FMConstants.ZERO);
        if (kdtEntries.getColumn("recAmtVc") != null) {
            BookNotifyClientHelper.setTableCellEditorByFormattedTextField(kdtEntries, "recAmtVc", precision, FMConstants.ZERO);
        }
        if (kdtEntries.getColumn("recLocAmtVc") != null) {
            BookNotifyClientHelper.setTableCellEditorByFormattedTextField(kdtEntries, "recLocAmtVc", precision, FMConstants.ZERO);
        }
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(kdtEntries, "rebateAmt", precision, FMConstants.ZERO);
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(kdtEntries, "rebateLocAmt", precision, FMConstants.ZERO);
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(kdtEntries, "actRecAmt", precision, FMConstants.ZERO);
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(kdtEntries, "actRecAmtVc", precision, FMConstants.ZERO);
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(kdtEntries, "actRecLocAmt", precision, FMConstants.ZERO);
        BookNotifyClientHelper.setTableCellEditorByEnum(kdtEntries, "com.kingdee.eas.fi.cas.VcStatusEnum", "vcStatus");
    }

    @Override
    public void setEntryRowAmt(SourceTypeEnum sourceType, IRow row, BigDecimal rate, BOSUuid currencyID, KDTEditEvent e) {
        BigDecimal apLocAmt;
        if (row == null || rate == null) {
            return;
        }
        BigDecimal payAmt = (BigDecimal)row.getCell("recAmt").getValue();
        BigDecimal rebateAmt = (BigDecimal)row.getCell("rebateAmt").getValue();
        BigDecimal actPayAmt = (BigDecimal)row.getCell("actRecAmt").getValue();
        if (payAmt == null) {
            payAmt = FMConstants.ZERO;
        }
        if (rebateAmt == null) {
            rebateAmt = FMConstants.ZERO;
        }
        int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyID);
        CurrencyInfo baseCurrency = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency();
        int baseScale = FMClientHelper.getPrecOfCurrency((BOSUuid)baseCurrency.getId());
        if (SourceTypeEnum.AR.equals((Object)sourceType)) {
            if (rebateAmt.abs().compareTo(payAmt.abs()) == 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"RebateGreaterRecAmt"));
                if (e != null) {
                    BigDecimal oldValue = (BigDecimal)e.getOldValue();
                    int colIndex = e.getColIndex();
                    row.getCell(colIndex).setValue((Object)oldValue);
                }
                SysUtil.abort();
            }
            apLocAmt = payAmt.multiply(rate);
            apLocAmt = apLocAmt.setScale(baseScale, 4);
            row.getCell("recLocAmt").setValue((Object)apLocAmt);
            BigDecimal rebateLocAmt = rebateAmt.multiply(rate);
            rebateLocAmt = rebateLocAmt.setScale(baseScale, 4);
            row.getCell("rebateLocAmt").setValue((Object)rebateLocAmt);
            actPayAmt = payAmt.add(rebateAmt.negate());
            actPayAmt = actPayAmt.setScale(scale, 4);
            row.getCell("actRecAmt").setValue((Object)actPayAmt);
        } else if (SourceTypeEnum.SCM.equals((Object)sourceType)) {
            apLocAmt = payAmt.multiply(rate);
            apLocAmt = apLocAmt.setScale(baseScale, 4);
            row.getCell("recLocAmt").setValue((Object)apLocAmt);
        }
        if (actPayAmt != null) {
            BigDecimal actPayLocAmt = actPayAmt.multiply(rate);
            actPayLocAmt = actPayLocAmt.setScale(baseScale, 4);
            row.getCell("actRecLocAmt").setValue((Object)actPayLocAmt);
        } else {
            row.getCell("actRecLocAmt").setValue(null);
        }
    }

    @Override
    public boolean checkVcGenVoucher(String billId) throws EASBizException, BOSException {
        IReceivingBill iReceivingBill = ReceivingBillFactory.getRemoteInstance();
        ReceivingBillInfo info = iReceivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(billId));
        ReceivingBillEntryCollection entryColl = info.getEntries();
        if (entryColl == null || entryColl.size() <= 0) {
            return false;
        }
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            if (entryColl.get(i).getAmountVc() == null || entryColl.get(i).getAmountVc().compareTo(FMConstants.ZERO) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public RecPayBillInfo getCopyInfo(RecPayBillInfo info) {
        if (info == null) {
            return new ReceivingBillInfo();
        }
        ReceivingBillInfo oldInfo = (ReceivingBillInfo)info;
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        ReceivingBillInfo newInfo = new ReceivingBillInfo();
        newInfo.setCompany(companyInfo);
        newInfo.setBizDate(new Date());
        newInfo.setSourceType(oldInfo.getSourceType());
        newInfo.setCurrency(oldInfo.getCurrency());
        newInfo.setExchangeRate(oldInfo.getExchangeRate());
        newInfo.setActRecAmt(oldInfo.getActRecAmt());
        newInfo.setActRecLocAmt(oldInfo.getActRecLocAmt());
        newInfo.setIsCommitSettle(oldInfo.isIsCommitSettle());
        newInfo.setSettleBizType(oldInfo.getSettleBizType());
        newInfo.setFundType(oldInfo.getFundType());
        newInfo.setPayeeAccountBank(oldInfo.getPayeeAccountBank());
        newInfo.setPayeeBank(oldInfo.getPayeeBank());
        newInfo.setPayeeAccount(oldInfo.getPayeeAccount());
        newInfo.setSettlementType(oldInfo.getSettlementType());
        newInfo.setSettlementNumber(oldInfo.getSettlementNumber());
        newInfo.setOppAccount(oldInfo.getOppAccount());
        newInfo.setFpItem(oldInfo.getFpItem());
        newInfo.setDescription(oldInfo.getDescription());
        newInfo.setPayerType(oldInfo.getPayerType());
        newInfo.setPayerID(oldInfo.getPayerID());
        newInfo.setPayerName(oldInfo.getPayerName());
        newInfo.setPayerNumber(oldInfo.getPayerNumber());
        newInfo.setPayerBank(oldInfo.getPayerBank());
        newInfo.setPayerAccountBank(oldInfo.getPayerAccountBank());
        newInfo.setCreator(userInfo);
        newInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        newInfo.setBillStatus(BillStatusEnum.SAVE);
        newInfo.setSettlementStatus(SettlementStatusEnum.UNSUBMIT);
        newInfo.setAdminOrgUnit(oldInfo.getAdminOrgUnit());
        newInfo.setPerson(oldInfo.getPerson());
        ReceivingBillEntryCollection newColl = newInfo.getEntries();
        ReceivingBillEntryCollection coll = oldInfo.getEntries();
        ReceivingBillEntryInfo entryInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = coll.get(i);
            ReceivingBillEntryInfo newEntryInfo = new ReceivingBillEntryInfo();
            newEntryInfo.setSeq(entryInfo.getSeq());
            newEntryInfo.setAmount(entryInfo.getAmount());
            newEntryInfo.setLocalAmt(entryInfo.getLocalAmt());
            newEntryInfo.setRebate(entryInfo.getRebate());
            newEntryInfo.setRebateLocAmt(entryInfo.getRebateLocAmt());
            newEntryInfo.setActualAmt(entryInfo.getActualAmt());
            newEntryInfo.setActualLocAmt(entryInfo.getActualLocAmt());
            newEntryInfo.setRemark(entryInfo.getRemark());
            newEntryInfo.setVcStatus(VcStatusEnum.NOT_VERIFICATED);
            newColl.add(newEntryInfo);
        }
        return newInfo;
    }
}

