/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.ComponentUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherAbstractInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.AbstractReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.BatchFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CodingRuleMsgInfo;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fi.cas.FeeTypeDefaultMsgInfo;
import com.kingdee.eas.fi.cas.FeeTypeF7ContextUtil;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.IReceivingBillType;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.TemplateReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.TemplateReceivingBillFactory;
import com.kingdee.eas.fi.cas.TemplateReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.AbstractTemplateReceivingBillEditUI;
import com.kingdee.eas.fi.cas.client.AssItemsForCash_TmplRecClientHelper;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.MultiAssItemsForCash_TmplRecClientHelper;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fi.cas.client.RecPayRedTypeHelper;
import com.kingdee.eas.fi.cas.client.SpecialExpenseTypePromptBox;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.context.f7.F7ContextUtil;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class TemplateReceivingBillEditUI
extends AbstractTemplateReceivingBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TemplateReceivingBillEditUI.class);
    private IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
    private CasRecPayHandler handler = new CasRecPayHandler();
    private RecPayRedTypeHelper redTypeHandler = RecPayRedTypeHelper.getInstance();
    private CompanyOrgUnitInfo currentCompany = this.contextHelper.getCurrentCompany();
    private UserInfo userInfo = this.contextHelper.getCurrentUser();
    private boolean showCashAndBankAcctView = false;
    private AsstActTypeInfo innerAccountActType;
    boolean isIndirectExRate = false;
    Map paramValue = new HashMap();
    private AsstActTypeCollection asstActTypeColl;
    private KDBizPromptBox promptOpptAccountEntry = new KDBizPromptBox();
    private int deforeDel = -1;

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        this.preProcess();
        super.onLoad();
        this.showCashAndBankAcctView = (Boolean)this.paramValue.get("CS040");
        this.prmtOppAccount.getEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    TemplateReceivingBillEditUI.this.prmtOppAccount_focusGained(e);
                }
                catch (Exception exc) {
                    TemplateReceivingBillEditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtEntries.setActiveCellStatus(1);
        KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntries, (boolean)true, (Action)new ItemAction(){

            public void actionPerformed(ActionEvent e) {
                TemplateReceivingBillEditUI.this.handler.setEntrySeq(TemplateReceivingBillEditUI.this.kdtEntries);
                int size = TemplateReceivingBillEditUI.this.kdtEntries.getRowCount();
                if (size > 1) {
                    Object remark = TemplateReceivingBillEditUI.this.kdtEntries.getRow(size - 2).getCell("remark").getValue();
                    Object currency = TemplateReceivingBillEditUI.this.kdtEntries.getRow(size - 2).getCell("currency").getValue();
                    TemplateReceivingBillEditUI.this.kdtEntries.getRow(size - 1).getCell("remark").setValue(remark);
                    TemplateReceivingBillEditUI.this.kdtEntries.getRow(size - 1).getCell("currency").setValue(currency);
                }
            }
        });
        this.actionCopyLine.setVisible(false);
        this.chkMenuItemSubmitAndPrint.setVisible(false);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.menuSubmitOption.setVisible(true);
        } else {
            this.menuSubmitOption.setVisible(false);
        }
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    @Override
    public void loadFields() {
        this.prmtPayeeAccountBank.setDisplayFormat("$number$;$name$;$bankaccountnumber$");
        Map listenerMap = null;
        try {
            listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (this.editData.getSettlementType() != null && this.editData.getSettlementType().getId() != null && this.editData.getSettlementType().getNumber() == null) {
            BOSUuid pk = this.editData.getSettlementType().getId();
            try {
                ISettlementType iSettle = SettlementTypeFactory.getRemoteInstance();
                this.editData.setSettlementType(iSettle.getSettlementTypeInfo((IObjectPK)new ObjectUuidPK(pk)));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                logger.error((Object)e);
            }
        }
        if (this.editData.getCompany() == null) {
            this.editData.setCompany(this.currentCompany);
        }
        super.loadFields();
        this.txtTemplateName.setText(this.editData.getTemplateName());
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtOppBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[1]);
        int n = this.editData.getEntries().size();
        for (int i = 0; i < n; ++i) {
            TemplateReceivingBillEntryInfo entryInfo = this.editData.getEntries().get(i);
            FMClientHelper.loadFieldsBgItem((ICell)this.kdtEntries.getCell(i, "oppBgItem"), (CoreBaseInfo)entryInfo, (FMBgItemProp)entryInfo.getBgItemProps()[0]);
        }
        this.prmtPayeeAccountBank.setValue((Object)this.editData.getPayeeAccountBank());
        this.prmtPayeeAccount.setValue((Object)this.editData.getPayeeAccount());
        UIUtil.setSelectObject((KDComboBox)this.comboPayerType, (Object)this.editData.getPayerType());
        if (this.editData.getPayerType() == null) {
            this.comboPayerType.setSelectedItem((Object)FMSysDefinedEnum.OTHER);
        }
        try {
            Object selectedItemReminder = this.comboPayerType.getSelectedItem();
            ItemEvent itemEvent = new ItemEvent((ItemSelectable)this.comboPayerType, 701, selectedItemReminder, 1);
            this.comboPayerType_itemStateChanged(itemEvent);
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        if (this.editData.getPayerAccountBankO() != null) {
            this.txtPayerAccountBank.setValue((Object)this.editData.getPayerAccountBankO().getBankAccountNumber());
        } else {
            this.txtPayerAccountBank.setValue((Object)this.editData.getPayerAccountBank());
        }
        this.txtPayerBank.setText(this.editData.getPayerBank());
        UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        String payerId = this.editData.getPayerID();
        String payerNumber = this.editData.getPayerNumber();
        String payerName = this.editData.getPayerName();
        this.handler.fillPayeeOrPayer(this.prmtPayer, payerId, payerNumber, payerName);
        this.handler.setEntrySeq(this.kdtEntries);
        try {
            MultiAssItemsForCash_TmplRecClientHelper.loadFileds(this, this.kDTabbedPane1, this.tblAssItems, this.prmtOppAccount, this.editData);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtDesc.setValue((Object)this.editData.getDescription());
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
            this.comboCurrency_itemStateChanged(null);
            this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)this.prmtAdminOrgUnit);
        this.setCostCenterF7();
        AccountViewInfo acct = (AccountViewInfo)this.prmtPayeeAccount.getValue();
        if (acct != null && acct.isIsBank()) {
            this.prmtPayeeAccountBank.setRequired(true);
        } else {
            this.prmtPayeeAccountBank.setRequired(false);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        ReceivingBillTypeInfo receivingBillTypeInfo;
        DataBaseInfo info;
        this.handler.setHeadSumAmt(this.kdtEntries, this.txtActRecAmt, this.txtActRecLocAmt);
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtOppBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[1]);
        super.storeFields();
        int n = this.editData.getEntries().size();
        for (int i = 0; i < n; ++i) {
            TemplateReceivingBillEntryInfo entryInfo = this.editData.getEntries().get(i);
            FMClientHelper.storeFieldsBgItem((ICell)this.kdtEntries.getCell(i, "oppBgItem"), (CoreBaseInfo)entryInfo, (FMBgItemProp)entryInfo.getBgItemProps()[0]);
        }
        this.editData.setTemplateName(this.txtTemplateName.getText());
        boolean isRedTypeBil = false;
        if (this.f7RecBillType.getValue() != null) {
            isRedTypeBil = this.redTypeHandler.isReceivingTypeRedType((ReceivingBillTypeInfo)this.f7RecBillType.getValue());
        }
        this.editData.setIsRedBill(isRedTypeBil);
        if (this.comboPayerType.getSelectedItem() == null || this.comboPayerType.getSelectedItem() instanceof FMSysDefinedEnum) {
            this.editData.setPayerType(null);
        } else {
            this.editData.setPayerType((AsstActTypeInfo)this.comboPayerType.getSelectedItem());
        }
        if (this.editData.getPayeeAccountBank() != null) {
            this.editData.setPayeeBank(this.editData.getPayeeAccountBank().getBank());
        } else {
            this.editData.setPayeeBank((BankInfo)this.txtPayeeBank.getUserObject());
        }
        if (this.prmtPayer.getData() == null) {
            this.editData.setPayerNumber(null);
            this.editData.setPayerName(null);
            this.editData.setPayerID(null);
        } else if (this.prmtPayer.getData() instanceof String) {
            this.editData.setPayerNumber((String)this.prmtPayer.getData());
            this.editData.setPayerName((String)this.prmtPayer.getData());
        } else if (this.prmtPayer.getData() instanceof DataBaseInfo && (info = (DataBaseInfo)this.prmtPayer.getData()) != null) {
            if (info.getId() != null) {
                this.editData.setPayerID(info.getId().toString());
            }
            this.editData.setPayerNumber(info.getNumber());
            this.editData.setPayerName(info.getName());
        }
        this.editData.setPayAccountBank(null);
        String bankAccountNumber = this.getAccountNumber();
        this.editData.setPayerAccountBank(bankAccountNumber);
        this.editData.setPayerAccountBankO(this.getAccountBankByAccountNumber(bankAccountNumber));
        if (this.editData.getPayerAccountBankO() != null) {
            this.editData.setOppInnerAcct(this.editData.getPayerAccountBankO().getInnerAcct());
        } else {
            this.editData.setOppInnerAcct(null);
        }
        if (this.editData.getPayeeAccount() != null) {
            if (this.editData.getPayeeAccount().isIsBank()) {
                this.editData.setFundType(BizTypeEnum.BANK);
            } else if (this.editData.getPayeeAccount().isIsCash()) {
                this.editData.setFundType(BizTypeEnum.CASH);
            } else {
                this.editData.setFundType(BizTypeEnum.OTHER);
            }
        }
        if (this.f7RecBillType.getData() != null && (receivingBillTypeInfo = (ReceivingBillTypeInfo)this.f7RecBillType.getData()) != null) {
            this.editData.setSourceType(receivingBillTypeInfo.getSourceSysType());
        }
        if (this.prmtDesc.getValue() instanceof VoucherAbstractInfo) {
            this.editData.setDescription(((VoucherAbstractInfo)this.prmtDesc.getValue()).getName());
        } else if (this.prmtDesc.getValue() instanceof String) {
            this.editData.setDescription(this.prmtDesc.getText().toString());
        } else if (this.prmtDesc.getValue() == null) {
            this.editData.setDescription(null);
        }
        MultiAssItemsForCash_TmplRecClientHelper.storeTable2VO(this.tblAssItems, this.editData);
        this.editData.setIsInitializeBill(false);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        TemplateReceivingBillInfo info = this.handler.getDefaultTplRecInfo(this.currentCompany, (TemplateReceivingBillInfo)dataObject);
        if (this.getOprtState().equals(OprtState.ADDNEW) && EmptyUtil.isEmpty((String)info.getNumber())) {
            try {
                CodingRuleMsgInfo msg = BatchFetchParamFacadeFactory.getRemoteInstance().getCodingMsg(info.getCompany().getId().toString(), (IObjectValue)info);
                FmRpcCacheInfo cacheInfo = new FmRpcCacheInfo();
                cacheInfo.setHasCodeRule(msg.isExistCodingRule());
                cacheInfo.setNumber(msg.getNumber());
                cacheInfo.setAddViewCode(msg.isAddView());
                cacheInfo.setModifiable(msg.isModifiable());
                FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)info.getCompany().getId().toString(), (FmRpcCacheInfo)cacheInfo);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        super.setDataObject((IObjectValue)info);
    }

    private String getAccountNumber() {
        AccountBankInfo info;
        String bankAccountNumber = null;
        if (this.txtPayerAccountBank.getData() instanceof String || this.txtPayerAccountBank.getText() instanceof String) {
            bankAccountNumber = this.txtPayerAccountBank.getText();
        } else if (this.txtPayerAccountBank.getData() instanceof AccountBankInfo && (info = (AccountBankInfo)this.txtPayerAccountBank.getData()) != null) {
            bankAccountNumber = info.getBankAccountNumber();
        }
        return bankAccountNumber;
    }

    private AccountBankInfo getAccountBankByAccountNumber(String acctNumber) {
        if (EmptyUtil.isEmpty((String)acctNumber)) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)acctNumber.trim()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("ctrlStrategy.*");
        ev.getSelector().addObjectCollection((IObjectCollection)sic);
        try {
            AccountBankCollection banks = AccountBankFactory.getRemoteInstance().getAccountBankCollection(ev);
            if (banks != null && banks.size() > 0) {
                return banks.get(0);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            logger.error((Object)e);
        }
        return null;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionWorkFlowG.setEnabled(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionCreateFrom.setEnabled(false);
        this.actionCreateFrom.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionViewDoProccess.setEnabled(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setEnabled(false);
        this.actionDelVoucher.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.actionNextPerson.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        TemplateReceivingBillInfo info = (TemplateReceivingBillInfo)this.getDataObject();
        boolean isLocalCurrency = RecPayHandler.isLocalCurrency(info.getCurrency(), null);
        this.txtExchangeRate.setEnabled(!isLocalCurrency);
        this.initTxtNumberStatus();
        AssItemsForCash_TmplRecClientHelper.initDataStutas(this.getOprtState(), this.tblAssItems);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.remove((Component)this.btnAuditResult);
    }

    private void preProcess() throws BOSException, EASBizException {
        this.paramValue.put("ui_name", "TemplateReceivingBillEditUI");
        this.paramValue.put("isFirtTime", Boolean.FALSE);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("CS021", null);
        param.put("CS032", null);
        param.put("CS033", null);
        param.put("CS037", null);
        param.put("CS039", null);
        param.put("CS040", null);
        param.put("CS044", null);
        param.put("CS052", null);
        param.put("CS063", null);
        param.put("CS073", null);
        param.put("CS082", null);
        param.put("CS083", null);
        this.paramValue.put("param", param);
        this.paramValue = BatchFetchParamFacadeFactory.getRemoteInstance().fetchParam(this.paramValue);
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber});
        int height = this.kdtEntries.getHeight();
        int width = this.kdtEntries.getWidth();
        this.kDPanel1.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, width, height));
        this.kDPanel2.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, width, height));
    }

    protected void initUIProp() throws Exception {
        this.txtActRecAmt.setHorizontalAlignment(4);
        this.txtActRecLocAmt.setHorizontalAlignment(4);
        this.txtExchangeRate.setHorizontalAlignment(4);
        CurrencyCollection currencyColl = (CurrencyCollection)this.paramValue.get("currencyCollection");
        Map listenerMap = ComponentUtil.removeComponentListeners((JComponent)this.comboCurrency);
        if (currencyColl == null) {
            CashHelper.initCombCurrency(this.comboCurrency, false);
        } else {
            CashHelper.initCombCurrency(this.comboCurrency, currencyColl, false);
        }
        ComponentUtil.addComponentListeners((JComponent)this.comboCurrency, (Map)listenerMap);
        FeeTypeF7ContextUtil.initFeeTypeTree((IUIObject)this, this.f7FeeType, true);
        this.initPayerType();
        ExtendParser prmtDescParser = new ExtendParser(this.prmtDesc);
        this.prmtDesc.setCommitParser((IParser)prmtDescParser);
        this.prmtDesc.setCommitFormat("$number$;$name$");
        this.prmtDesc.setDisplayFormat("$name$");
        this.prmtDesc.setMaxLength(255);
        KDBizPromptBox f7Account = new KDBizPromptBox();
        SpecialExpenseTypePromptBox selector = new SpecialExpenseTypePromptBox((IUIObject)this);
        selector.setMultiSelect(false);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)true));
        ev.setFilter(filter);
        f7Account.setQueryInfo("com.kingdee.eas.cp.bc.app.ExpenseTypeQuery");
        f7Account.setEntityViewInfo(ev);
        f7Account.setSelector((KDPromptSelector)selector);
        f7Account.setEnabledMultiSelection(false);
        f7Account.setEditFormat("$number$");
        f7Account.setDisplayFormat("$typeName$-$number$");
        f7Account.setCommitFormat("$number$;$name$");
        this.kdtEntries.getColumn("expenseType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7Account));
        this.preProcessOpAcctF7();
        this.kdtEntries.getColumn("oppAccount").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.promptOpptAccountEntry));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$ $name$"));
        this.kdtEntries.getColumn("oppAccount").setRenderer((IBasicRender)avr);
        boolean isShowOppAccount = (Boolean)this.paramValue.get("CS021");
        this.kdtEntries.getColumn("oppAccount").getStyleAttributes().setHided(isShowOppAccount);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtOppBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.prmtOppBgItem.setHistoryRecordEnabled(false);
        KDBizPromptBox prmtEntryOutBgItem = new KDBizPromptBox();
        this.add((Component)prmtEntryOutBgItem);
        prmtEntryOutBgItem.setVisible(true);
        prmtEntryOutBgItem.setEditable(true);
        prmtEntryOutBgItem.setDisplayFormat("$number$");
        prmtEntryOutBgItem.setEditFormat("$number$");
        prmtEntryOutBgItem.setCommitFormat("$number$");
        FMClientHelper.initBgItemF7((KDBizPromptBox)prmtEntryOutBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        prmtEntryOutBgItem.setHistoryRecordEnabled(false);
        this.kdtEntries.getColumn("oppBgItem").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtEntryOutBgItem));
        KDBizPromptBox f7FundFlowItem = RecPayHelper.getF7FundFlowItemUi((IUIObject)this, FundFlowDirection.IN);
        this.kdtEntries.getColumn("fundFlowItem").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7FundFlowItem));
        ExtendParser parser = new ExtendParser(this.txtPayerAccountBank);
        this.txtPayerAccountBank.setCommitParser((IParser)parser);
        this.txtPayerAccountBank.setCommitFormat("$number$;$name$;$bankaccountnumber$");
        this.txtPayerAccountBank.setDisplayFormat("$bankaccountnumber$");
        this.txtPayerAccountBank.setMaxLength(80);
        this.kDPanel1.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 869, 322));
        this.kDPanel2.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 869, 322));
        this.tblAssItems.getColumn("fromName").getStyleAttributes().setHided(true);
        this.tblAssItems.getColumn("fieldName").getStyleAttributes().setHided(true);
        KDBizPromptBox prmtBoxAssActType = new KDBizPromptBox();
        prmtBoxAssActType.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.AsstActTypeQuery");
        prmtBoxAssActType.setDisplayFormat("$name$ $number$");
        this.tblAssItems.getColumn("asstActType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBoxAssActType));
        this.tblAssItems.getColumn("asstActType").getStyleAttributes().setLocked(true);
        this.tblAssItems.getColumn("asstActType").setWidth(150);
        this.tblAssItems.getColumn("fromNumber").setWidth(400);
        this.tblAssItems.checkParsed();
    }

    protected void initPropEvi() throws Exception {
        super.initPropEvi();
        boolean CS032 = (Boolean)this.paramValue.get("CS032");
        boolean CS033 = (Boolean)this.paramValue.get("CS033");
        this.f7FeeType.setRequired(CS032);
        this.prmtProject.setRequired(CS033);
        boolean isShowOppAccount = (Boolean)this.paramValue.get("CS021");
        this.kdtEntries.getColumn("oppAccount").getStyleAttributes().setHided(isShowOppAccount);
    }

    private void initPayerType() throws Exception {
        Map listenerMap = ComponentUtil.removeComponentListeners((JComponent)this.comboPayerType);
        this.comboPayerType.removeAllItems();
        this.asstActTypeColl = (AsstActTypeCollection)this.paramValue.get("asstActTypeCollection");
        if (this.asstActTypeColl == null) {
            this.asstActTypeColl = CasRecPayHandler.getAsstActTypeColl(null, false, false);
        }
        this.comboPayerType.addItem((Object)FMSysDefinedEnum.OTHER);
        this.comboPayerType.addItems(this.asstActTypeColl.toArray());
        for (int i = 0; i < this.asstActTypeColl.size(); ++i) {
            if (!"innerAccount".equalsIgnoreCase(this.asstActTypeColl.get(i).getAsstHGAttribute())) continue;
            this.innerAccountActType = this.asstActTypeColl.get(i);
        }
        Object asstActType = this.paramValue.get("defaultAsstActType");
        if (asstActType != null && asstActType instanceof AsstActTypeInfo) {
            UIUtil.setSelectObject((KDComboBox)this.comboPayerType, (Object)((AsstActTypeInfo)asstActType));
        } else {
            UIUtil.setSelectObject((KDComboBox)this.comboPayerType, (Object)FMSysDefinedEnum.OTHER);
        }
        ComponentUtil.addComponentListeners((JComponent)this.comboPayerType, (Map)listenerMap);
    }

    private void preProcessOpAcctF7() {
        this.promptOpptAccountEntry.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.promptOpptAccountEntry.setVisible(true);
        this.promptOpptAccountEntry.setEditable(true);
        this.promptOpptAccountEntry.setDisplayFormat("$number$ $name$");
        this.promptOpptAccountEntry.setEditFormat("$number$");
        this.promptOpptAccountEntry.setCommitFormat("$number$;$name$");
        this.promptOpptAccountEntry.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                try {
                    TemplateReceivingBillEditUI.this.promptOpptAccountEntry_willCommit(e);
                }
                catch (Exception exc) {
                    TemplateReceivingBillEditUI.this.handUIException(exc);
                }
            }
        });
        this.promptOpptAccountEntry.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    TemplateReceivingBillEditUI.this.promptOpptAccountEntry_willShow(e);
                }
                catch (Exception exc) {
                    TemplateReceivingBillEditUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void promptOpptAccountEntry_willCommit(CommitEvent e) {
        try {
            this.setEntryOppAcctEvi(this.promptOpptAccountEntry, this.showCashAndBankAcctView);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    protected void promptOpptAccountEntry_willShow(SelectorEvent e) {
        try {
            this.setEntryOppAcctEvi(this.promptOpptAccountEntry, this.showCashAndBankAcctView);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("assItems.*");
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("payeeAccount.id"));
        sic.add(new SelectorItemInfo("payeeAccount.name"));
        sic.add(new SelectorItemInfo("payeeAccount.number"));
        sic.add(new SelectorItemInfo("payeeAccount.isBank"));
        sic.add(new SelectorItemInfo("payeeAccount.isCash"));
        sic.add(new SelectorItemInfo("payeeBank.name"));
        sic.add(new SelectorItemInfo("payeeAccountBank.*"));
        sic.add(new SelectorItemInfo("settlementType.*"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("feeType.id"));
        sic.add(new SelectorItemInfo("feeType.name"));
        sic.add(new SelectorItemInfo("feeType.number"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("oppAccount.CAA"));
        sic.add(new SelectorItemInfo("recBillType.*"));
        sic.add(new SelectorItemInfo("entries.recBillType.number"));
        sic.add(new SelectorItemInfo("entries.recBillType.isPreSet"));
        sic.add(new SelectorItemInfo("entries.recBillType.preSetBillType"));
        sic.add(new SelectorItemInfo("entries.recBillType.preSetBillType.id"));
        sic.add(new SelectorItemInfo("entries.currency.id"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.currency.precision"));
        sic.add(new SelectorItemInfo("entries.oppAccount.*"));
        sic.add(new SelectorItemInfo("entries.expenseType.*"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.id"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.number"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.name"));
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.precision");
        sic.add("payerType.*");
        sic.add("payerAccountBankO.bankAccountNumber");
        sic.add("payerAccountBankO.company.id");
        sic.add("payerAccountBankO.id");
        sic.add("payerAccountBankO.name");
        sic.add("payerAccountBankO.number");
        sic.add("payerAccountBankO.bank.id");
        sic.add("payerAccountBankO.bank.name");
        sic.add("payerAccountBankO.ctrlStrategy.*");
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("company.CU"));
        sic.add("company.baseCurrency.number");
        sic.add("company.baseCurrency.id");
        sic.add(new SelectorItemInfo("payeeAccountBank.bank.id"));
        sic.add(new SelectorItemInfo("payeeAccountBank.bank.name"));
        sic.add(new SelectorItemInfo("payeeAccountBank.bank.number"));
        sic.add(new SelectorItemInfo("payeeAccountBank.bank.inGroup"));
        sic.add("assItems.asstActType.id");
        sic.add("assItems.asstActType.number");
        sic.add("entries.assItemsEntries.*");
        sic.add("adminOrgUnit.id");
        sic.add("adminOrgUnit.number");
        sic.add("adminOrgUnit.name");
        sic.add("outBgItemID");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        sic.add("oppBgItemID");
        sic.add("oppBgItemNumber");
        sic.add("oppBgItemName");
        sic.add("entries.oppBgItemNumber");
        sic.add("costCenter.id");
        sic.add("costCenter.name");
        sic.add("costCenter.number");
        return sic;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        AccountViewInfo acct;
        AccountBankInfo payeeAcctBank;
        String msg;
        ReceivingBillTypeInfo receiveType;
        super.verifyInput(e);
        ClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        if (!this.f7BizType.isEnabled()) {
            this.f7BizType.setRequired(false);
        }
        if ((receiveType = (ReceivingBillTypeInfo)this.f7RecBillType.getData()) != null && (receiveType.getSourceSysType().equals((Object)SourceTypeEnum.AP) || receiveType.getSourceSysType().equals((Object)SourceTypeEnum.AR))) {
            Object payeeType = this.comboPayerType.getSelectedItem();
            if (payeeType != null && payeeType.equals(FMSysDefinedEnum.OTHER)) {
                msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"ArApPayerTypeNotOther");
                MsgBox.showWarning((Component)((Object)this), (String)msg);
                this.comboPayerType.requestFocus();
                SysUtil.abort();
            } else {
                ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayer);
            }
        }
        if ((payeeAcctBank = (AccountBankInfo)this.prmtPayeeAccountBank.getValue()) != null) {
            ReceivingBillTypeInfo billType;
            AccountViewInfo account;
            CurrencyInfo Crinfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            CurrencyInfo acctBankCrinfo = payeeAcctBank.getCurrency();
            if (payeeAcctBank.isIsByCurrency() && !acctBankCrinfo.getId().equals((Object)Crinfo.getId())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"CurrencyNotEqual"));
                SysUtil.abort();
            }
            if (payeeAcctBank != null && payeeAcctBank.getAccount() != null && (account = (AccountViewInfo)this.prmtPayeeAccount.getValue()) != null && !payeeAcctBank.getAccount().getId().equals((Object)account.getId())) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"AccountViewNotEqual"));
                SysUtil.abort();
            }
            if (!((billType = (ReceivingBillTypeInfo)this.f7RecBillType.getData()) != null && billType.getId().toString().equals("fjJCrQESEADgABolwKgSQyqo2zU=") || payeeAcctBank.getAccountType() != AccountType.PAYOUT)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayeeAccountNotOut"));
                SysUtil.abort();
            }
        }
        if (this.prmtSettlementType.getValue() != null && this.prmtPayeeAccount.getValue() == null && this.prmtPayeeAccountBank.getValue() == null) {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"must_have_payee_AccountView_or_Accountbank");
            MsgBox.showError((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        if ((acct = (AccountViewInfo)this.prmtOppAccount.getData()) != null && acct.isIsBank()) {
            String accountId;
            String companyId;
            String bankAccountNumber;
            String companyNumber;
            if (EmptyUtil.isEmpty((String)this.txtPayerAccountBank.getText())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayerAccountBankCanNotBeNull"));
                SysUtil.abort();
            }
            if (!this.handler.getBankAccountNumberBelong(companyNumber = this.currentCompany.getId().toString(), bankAccountNumber = this.txtPayerAccountBank.getText().toString())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayerAccountBankCanNotExist"));
                SysUtil.abort();
            }
            if (!this.handler.getAccountBelong(companyId = this.currentCompany.getId().toString(), accountId = ((AccountViewInfo)this.prmtOppAccount.getData()).getId().toString(), bankAccountNumber)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"RelAcctViewNotEqualOppAcctView"));
                SysUtil.abort();
            }
        }
        boolean isOutBank = true;
        if (payeeAcctBank != null && payeeAcctBank.getBank().isInGroup()) {
            isOutBank = false;
        }
        if (!(EmptyUtil.isEmpty((String)this.txtPayerBank.getText()) || EmptyUtil.isEmpty((String)this.txtPayeeBank.getText()) || isOutBank)) {
            SettBizTypeInfo bizTypeInfo;
            if (this.txtPayerBank.getText().equals(this.txtPayeeBank.getText())) {
                bizTypeInfo = (SettBizTypeInfo)this.f7BizType.getData();
                if (bizTypeInfo != null && !SettBizTypeEnum.RECINSIDE.equals((Object)bizTypeInfo.getType())) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"mustRecinSide"));
                    this.f7BizType.requestFocus();
                    SysUtil.abort();
                }
            } else {
                bizTypeInfo = (SettBizTypeInfo)this.f7BizType.getData();
                if (bizTypeInfo != null && !SettBizTypeEnum.RECOUTSIDE.equals((Object)bizTypeInfo.getType()) && !SettBizTypeEnum.RECINSIDEDIF.equals((Object)bizTypeInfo.getType())) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"mustRecinSideDif"));
                    this.f7BizType.requestFocus();
                    SysUtil.abort();
                }
            }
        }
        if (this.txtPayerAccountBank.getText() != null) {
            boolean sameAccountAllowable = (Boolean)this.paramValue.get("CS073");
            AccountBankInfo acctBankInfo = (AccountBankInfo)this.prmtPayeeAccountBank.getValue();
            if (acctBankInfo != null && !sameAccountAllowable && this.txtPayerAccountBank.getText().equals(acctBankInfo.getBankAccountNumber())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"CantBeSameAccount"));
                SysUtil.abort();
            }
        }
        AssItemsForCash_TmplRecClientHelper.verifyInput((CoreUIObject)this, this.editData);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TemplateReceivingBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        TemplateReceivingBillInfo info = null;
        info = new TemplateReceivingBillInfo();
        info.setBizDate(new Date());
        info.setSourceType(SourceTypeEnum.CASH);
        info.setCompany(this.currentCompany);
        info.setExchangeRate(Constants.ONE);
        info.setCurrency(this.currentCompany.getBaseCurrency());
        info.setCreator(this.userInfo);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setPayerName(null);
        info.setPayerNumber(null);
        info.getEntries().add((TemplateReceivingBillEntryInfo)this.createNewDetailData(null));
        try {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            ev.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"999", CompareType.EQUALS));
            IReceivingBillType iReceivingBillType = ReceivingBillTypeFactory.getRemoteInstance();
            ReceivingBillTypeCollection coll = iReceivingBillType.getReceivingBillTypeCollection(ev);
            AbstractReceivingBillTypeInfo defaultBillTypeInfo = null;
            if (coll != null && !coll.isEmpty()) {
                defaultBillTypeInfo = coll.get(0);
            }
            if (null != defaultBillTypeInfo && DeletedStatusEnum.DELETED.equals((Object)defaultBillTypeInfo.getDeletedStatus())) {
                defaultBillTypeInfo = null;
            }
            if (defaultBillTypeInfo != null) {
                info.setRecBillType((ReceivingBillTypeInfo)defaultBillTypeInfo);
                info.setSourceSysType(defaultBillTypeInfo.getSourceSysType());
            }
            AsstActTypeInfo defalutAssitType = null;
            AsstActTypeCollection asstActDefalutTypeColl = CasRecPayHandler.getAsstActTypeColl(null, false, true);
            if (asstActDefalutTypeColl != null && asstActDefalutTypeColl.size() > 0) {
                defalutAssitType = asstActDefalutTypeColl.get(0);
            }
            if (defalutAssitType != null) {
                info.setPayerType(defalutAssitType);
            }
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort(e);
        }
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        TemplateReceivingBillEntryInfo entryInfo = new TemplateReceivingBillEntryInfo();
        entryInfo.setSeq(1);
        entryInfo.setCurrency(currencyInfo);
        return entryInfo;
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal rate = this.txtExchangeRate.getBigDecimalValue();
        CurrencyInfo srcCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (srcCurrency == null) {
            return;
        }
        if (!srcCurrency.getId().equals((Object)this.currentCompany.getBaseCurrency().getId())) {
            ExchangeRateInfo exRateInfo = CasRecPayHandler.getExRateInfo(srcCurrency.getId().toString(), null, null, new Date());
            this.isIndirectExRate = CasRecPayHandler.isIndirectExRate(exRateInfo);
            if (this.isIndirectExRate && rate.compareTo(Constants.ZERO) != 0) {
                rate = Constants.ONE.divide(rate, 20, 4);
            }
        } else {
            rate = Constants.ONE;
            this.isIndirectExRate = true;
        }
        BOSUuid currencyId = this.currentCompany.getBaseCurrency().getId();
        this.handler.setEntryTableAmt(this.kdtEntries, rate, currencyId);
        this.handler.setHeadSumAmt(this.kdtEntries, this.txtActRecAmt, this.txtActRecLocAmt);
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntries.getColumn("amount").getColumnIndex()) {
            ICell cell;
            if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
                return;
            }
            BigDecimal exchangeRate = this.txtExchangeRate.getBigDecimalValue();
            if (exchangeRate == null) {
                return;
            }
            if (this.isIndirectExRate && exchangeRate.compareTo(Constants.ZERO) != 0) {
                exchangeRate = Constants.ONE.divide(exchangeRate, 20, 4);
            }
            if ((cell = this.kdtEntries.getCell(rowIndex, colIndex)).getValue() instanceof BigDecimal) {
                BigDecimal amount = (BigDecimal)cell.getValue();
                BigDecimal localAmt = exchangeRate.multiply(amount);
                this.kdtEntries.getRow(rowIndex).getCell("localAmt").setValue((Object)localAmt);
            }
            this.handler.setHeadSumAmt(this.kdtEntries, this.txtActRecAmt, this.txtActRecLocAmt);
        } else if (colIndex == this.kdtEntries.getColumn("oppAccount").getColumnIndex()) {
            int i = KDTableUtil.getSelectedRow((KDTable)this.kdtEntries);
            Integer seq = (Integer)this.kdtEntries.getRow(i).getCell("seq").getValue();
            AccountViewInfo viewInfo = (AccountViewInfo)this.kdtEntries.getRow(i).getCell("oppAccount").getValue();
            if (viewInfo == null) {
                MultiAssItemsForCash_TmplRecClientHelper.removeSomeRow(this.tblAssItems, seq);
            } else {
                String oldValueStr = AccessHelper.getId((Object)e.getOldValue());
                String newValueStr = AccessHelper.getId((Object)e.getValue());
                if (!newValueStr.equals(oldValueStr)) {
                    MultiAssItemsForCash_TmplRecClientHelper.append2AssItemsEntries((CoreUIObject)this, this.kDTabbedPane1, this.tblAssItems, viewInfo, this.editData, seq);
                }
            }
        }
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo srcCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (srcCurrency == null) {
            return;
        }
        if (!srcCurrency.getId().equals((Object)this.currentCompany.getBaseCurrency().getId())) {
            ExchangeRateInfo exRateInfo = CasRecPayHandler.getExRateInfo(srcCurrency.getId().toString(), null, null, new Date());
            this.isIndirectExRate = CasRecPayHandler.isIndirectExRate(exRateInfo);
        } else {
            this.isIndirectExRate = true;
        }
        CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        String baseCurrencyId = this.contextHelper.getCompanyBaseCurrency(this.currentCompany).getId().toString();
        int baseCurrPre = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)baseCurrencyId));
        this.handler.initCellEditor(this.kdtEntries, info, baseCurrencyId);
        this.txtActRecAmt.setPrecision(info.getPrecision());
        this.txtActRecLocAmt.setPrecision(baseCurrPre);
        this.txtActRecAmt.setRemoveingZeroInDispaly(false);
        this.txtActRecLocAmt.setRemoveingZeroInDispaly(false);
        int prec = CasRecPayHandler.getExRatePrec(info.getId().toString(), null, this.currentCompany, new Date());
        this.txtExchangeRate.setPrecision(prec);
        this.txtExchangeRate.setValue((Object)RecPayHandler.getExchangeRate(info, null, new Date()));
        this.txtExchangeRate.setRemoveingZeroInDispaly(false);
        this.txtExchangeRate.setRemoveingZeroInEdit(true);
        boolean isLocalCurrency = RecPayHandler.isLocalCurrency(info, null);
        boolean canModifyAmt = this.editData == null || this.editData.getBillStatus() == null || this.editData.getBillStatus().equals((Object)BillStatusEnum.SAVE) || this.editData.getBillStatus().equals((Object)BillStatusEnum.SUBMIT);
        this.txtExchangeRate.setEnabled(canModifyAmt && !isLocalCurrency);
    }

    @Override
    protected void prmtPayeeAccount_willShow(SelectorEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.setPayeeAcctEvi(currencyInfo);
    }

    private void setPayeeAcctEvi(CurrencyInfo currencyInfo) throws EASBizException, BOSException, ParserException {
        String currencyId = currencyInfo.getId().toString();
        String companyId = this.currentCompany.getId().toString();
        String cuId = this.currentCompany.getCU().getId().toString();
        this.prmtPayeeAccount.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi(cuId, companyId, currencyId, false);
        EntityViewInfo evi = new EntityViewInfo(treeevi.toString());
        FilterInfo filterIsLeaf = new FilterInfo();
        filterIsLeaf.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        evi.getFilter().mergeFilter(filterIsLeaf, "and");
        this.prmtPayeeAccount.setEntityViewInfo(evi);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        this.prmtPayeeAccount.setSelector((KDPromptSelector)opseelect);
    }

    @Override
    protected void prmtPayeeAccount_willCommit(CommitEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.setPayeeAcctEvi(currencyInfo);
    }

    @Override
    protected void prmtPayeeAccount_dataChanged(DataChangeEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        AccountViewInfo acct = (AccountViewInfo)this.prmtPayeeAccount.getValue();
        if (acct != null && acct.isIsBank()) {
            this.prmtPayeeAccountBank.setRequired(true);
        } else {
            this.prmtPayeeAccountBank.setRequired(false);
        }
    }

    @Override
    protected void prmtPayeeAccountBank_willShow(SelectorEvent e) throws Exception {
        AccountViewInfo account = (AccountViewInfo)this.prmtPayeeAccount.getValue();
        ReceivingBillTypeInfo btype = (ReceivingBillTypeInfo)this.f7RecBillType.getData();
        boolean istransDown = false;
        if (btype != null && btype.getId().toString().equals("fjJCrQESEADgABolwKgSQyqo2zU=")) {
            istransDown = true;
        }
        if (account != null) {
            String accountId = account.getId().toString();
            this.setPayeeAcctBankEvi(accountId, istransDown);
        } else {
            this.setPayeeAcctBankEvi(null, istransDown);
        }
    }

    private void setPayeeAcctBankEvi(String accountId, boolean isTransDown) throws Exception {
        String companyId = this.currentCompany.getId().toString();
        this.prmtPayeeAccountBank.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo evi = new EntityViewInfo();
        evi = this.editData.getReceivingBillType() == null || !CasRecPayBillTypeEnum.RealType.equals((Object)this.editData.getReceivingBillType()) ? CasRecPayHandler.getAccountBankContainTurstEvi(companyId, accountId) : CasRecPayHandler.getAccountBankEvi(companyId, accountId);
        if (!isTransDown) {
            FilterInfo payOutValueFilter = new FilterInfo();
            payOutValueFilter.getFilterItems().add(new FilterItemInfo("accountType", (Object)new Integer(1), CompareType.NOTEQUALS));
            evi.getFilter().mergeFilter(payOutValueFilter, "and");
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isReckoning", (Object)Boolean.FALSE));
        this.prmtPayeeAccountBank.setEntityViewInfo(evi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.prmtPayeeAccountBank.setSelectorCollection(selectors);
    }

    @Override
    protected void prmtPayeeAccountBank_willCommit(CommitEvent e) throws Exception {
        AccountViewInfo account = (AccountViewInfo)this.prmtPayeeAccount.getValue();
        ReceivingBillTypeInfo btype = (ReceivingBillTypeInfo)this.f7RecBillType.getData();
        boolean istransDown = false;
        if (btype != null && btype.getId().toString().equals("fjJCrQESEADgABolwKgSQyqo2zU=")) {
            istransDown = true;
        }
        if (account != null && account.isIsBank()) {
            String accountId = account.getId().toString();
            this.setPayeeAcctBankEvi(accountId, istransDown);
        } else {
            this.setPayeeAcctBankEvi(null, istransDown);
        }
    }

    @Override
    protected void f7RecBillType_willCommit(CommitEvent e) throws Exception {
        super.f7RecBillType_willCommit(e);
        this.setF7RecBillTypeEvi();
    }

    @Override
    protected void f7RecBillType_willShow(SelectorEvent e) throws Exception {
        super.f7RecBillType_willShow(e);
        this.setF7RecBillTypeEvi();
    }

    private void setF7RecBillTypeEvi() throws RecPayException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        this.f7RecBillType.setEntityViewInfo(ev);
        this.f7RecBillType.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtPayeeAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        boolean isNotNull;
        boolean bl = isNotNull = e.getNewValue() != null;
        if (!isNotNull) {
            this.txtPayeeBank.setUserObject(null);
            this.txtPayeeBank.setText(null);
            return;
        }
        this.f7BizType.setValue(null);
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtPayeeAccountBank.getValue();
        CurrencyInfo currency = null;
        if (accountBankInfo.isIsByCurrency()) {
            currency = accountBankInfo.getCurrency();
            this.comboCurrency.setEnabled(false);
        } else {
            currency = this.currentCompany.getBaseCurrency();
            this.comboCurrency.setEnabled(true);
        }
        UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        boolean isOwnAccountBank = accountBankInfo.getCompany().getId().equals((Object)this.currentCompany.getId());
        IBank iBank = BankFactory.getRemoteInstance();
        BankInfo bankInfo = iBank.getBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getBank().getId()));
        this.txtPayeeBank.setUserObject((Object)bankInfo);
        this.txtPayeeBank.setText(bankInfo.getName());
        if (this.prmtPayeeAccount.getData() == null && isOwnAccountBank) {
            this.prmtPayeeAccount.setValue((Object)accountBankInfo.getAccount());
        }
    }

    @Override
    protected void f7BizType_dataChanged(DataChangeEvent e) throws Exception {
        super.f7BizType_dataChanged(e);
        SettBizTypeInfo bizTypeInfo = (SettBizTypeInfo)this.f7BizType.getData();
        if (bizTypeInfo == null) {
            return;
        }
        if (SettBizTypeEnum.RECINSIDE.equals((Object)bizTypeInfo.getType()) && EmptyUtil.isEmpty((Object)this.prmtPayer.getData()) && this.innerAccountActType != null) {
            UIUtil.setSelectObject((KDComboBox)this.comboPayerType, (Object)this.innerAccountActType);
        }
    }

    @Override
    protected void f7BizType_willCommit(CommitEvent e) throws Exception {
        super.f7BizType_willCommit(e);
        AccountBankInfo accBank = (AccountBankInfo)this.prmtPayeeAccountBank.getData();
        this.f7BizType.setEntityViewInfo(this.getBizTypeEV(accBank));
        this.f7BizType.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void f7BizType_willShow(SelectorEvent e) throws Exception {
        super.f7BizType_willShow(e);
        AccountBankInfo accBank = (AccountBankInfo)this.prmtPayeeAccountBank.getData();
        this.f7BizType.setEntityViewInfo(this.getBizTypeEV(accBank));
        this.f7BizType.getQueryAgent().resetRuntimeEntityView();
    }

    private EntityViewInfo getBizTypeEV(AccountBankInfo accBank) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        HashSet<Integer> set = new HashSet<Integer>();
        if (accBank != null && !accBank.getBank().isInGroup() && accBank.getInnerAcct() != null) {
            set.add(new Integer(2));
            filter.getFilterItems().add(new FilterItemInfo("type", set, CompareType.INCLUDE));
        } else {
            set.add(new Integer(3));
            set.add(new Integer(1));
            set.add(new Integer(51));
            filter.getFilterItems().add(new FilterItemInfo("type", set, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isOnlyClHouse", (Object)new Integer(0)));
        if (accBank == null || accBank.getInnerAcct() == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
        }
        return ev;
    }

    @Override
    protected void prmtOppAccount_willShow(SelectorEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.setOppAcctEvi(info, this.showCashAndBankAcctView);
    }

    private void setOppAcctEvi(CurrencyInfo currencyInfo, boolean showCashAndBank) throws EASBizException, BOSException, ParserException {
        String currencyId = null;
        if (((Boolean)this.paramValue.get("CS063")).booleanValue()) {
            currencyId = currencyInfo.getId().toString();
        }
        String companyId = this.currentCompany.getId().toString();
        String cuId = this.currentCompany.getCU().getId().toString();
        this.prmtOppAccount.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi(cuId, companyId, currencyId, false, showCashAndBank);
        EntityViewInfo evi = new EntityViewInfo(treeevi.toString());
        FilterInfo filterIsLeaf = new FilterInfo();
        filterIsLeaf.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        evi.getFilter().mergeFilter(filterIsLeaf, "and");
        if (this.editData.getBillStatus() != null && this.editData.getBillStatus().equals((Object)BillStatusEnum.RECED)) {
            treeevi.getFilter().getFilterItems().add(new FilterItemInfo("isCash", (Object)Constants.FALSE));
            treeevi.getFilter().getFilterItems().add(new FilterItemInfo("isBank", (Object)Constants.FALSE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("isCash", (Object)Constants.FALSE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("isBank", (Object)Constants.FALSE));
        }
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        this.prmtOppAccount.setSelector((KDPromptSelector)opseelect);
        this.prmtOppAccount.setEntityViewInfo(evi);
    }

    private void setEntryOppAcctEvi(KDBizPromptBox prmtOppAccountEntry, boolean showCashAndBank) throws EASBizException, BOSException, ParserException {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        String currencyId = null;
        if (((Boolean)this.paramValue.get("CS063")).booleanValue()) {
            currencyId = currencyInfo.getId().toString();
        }
        String companyId = this.currentCompany.getId().toString();
        String cuId = this.currentCompany.getCU().getId().toString();
        prmtOppAccountEntry.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi(cuId, companyId, currencyId, false, showCashAndBank);
        EntityViewInfo evi = new EntityViewInfo(treeevi.toString());
        FilterInfo filterIsLeaf = new FilterInfo();
        filterIsLeaf.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        evi.getFilter().mergeFilter(filterIsLeaf, "and");
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        prmtOppAccountEntry.setSelector((KDPromptSelector)opseelect);
        prmtOppAccountEntry.setEntityViewInfo(evi);
    }

    @Override
    protected void prmtOppAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOppAccount_dataChanged(e);
        AccountViewInfo AccountView = (AccountViewInfo)this.prmtOppAccount.getData();
        if (AccountView == null) {
            this.prmtPayer.setData(null);
            IRow row = null;
            Integer valueSeq = new Integer(0);
            int count = this.tblAssItems.getRowCount();
            for (int i = count - 1; i >= 0; --i) {
                row = this.tblAssItems.getRow(i);
                valueSeq = (Integer)row.getCell("parentID").getValue();
                if (valueSeq == null) continue;
                this.tblAssItems.removeRow(i);
            }
            this.kDTabbedPane1.setEnabledAt(1, false);
            this.kDTabbedPane1.setSelectedIndex(0);
            return;
        }
        AsstActTypeInfo atinfo = null;
        if (this.comboPayerType.getSelectedItem() instanceof AsstActTypeInfo) {
            atinfo = (AsstActTypeInfo)this.comboPayerType.getSelectedItem();
        }
        if (AccountView.isIsBank() && this.prmtPayer.getData() == null || AccountView.isIsCash() || AccountView.isIsBank() && this.comboPayerType.getSelectedItem() != FMSysDefinedEnum.OTHER && (atinfo == null || !"companyOrg".equalsIgnoreCase(atinfo.getAsstHGAttribute()))) {
            this.comboPayerType.setSelectedItem((Object)FMSysDefinedEnum.OTHER);
            this.prmtPayer.setData((Object)this.currentCompany.getName());
        }
        if (AccountView.isIsCash()) {
            this.txtPayerAccountBank.setData(null);
            this.txtPayerBank.setText(null);
        }
        if (this.prmtOppAccount.getValue() == null) {
            MultiAssItemsForCash_TmplRecClientHelper.removeSomeRow(this.tblAssItems, -99);
        } else {
            MultiAssItemsForCash_TmplRecClientHelper.removeSomeRow(this.tblAssItems, -99);
            MultiAssItemsForCash_TmplRecClientHelper.append2AssItemsEntries((CoreUIObject)this, this.kDTabbedPane1, this.tblAssItems, (AccountViewInfo)this.prmtOppAccount.getValue(), this.editData, -99);
        }
    }

    @Override
    protected void prmtOppAccount_willCommit(CommitEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.setOppAcctEvi(info, this.showCashAndBankAcctView);
    }

    @Override
    protected void txtPayerAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        super.txtPayerAccountBank_dataChanged(e);
        if (e.getNewValue() != null && !e.getNewValue().equals(e.getOldValue()) && e.getNewValue() instanceof AccountBankInfo) {
            AccountBankInfo acctbank = (AccountBankInfo)e.getNewValue();
            this.editData.setPayerAccountBankO(acctbank);
            if (acctbank.getBank() != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("company.*");
                selector.add("bank.*");
                selector.add("bank.*");
                AccountBankInfo accountBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctbank.getId()), selector);
                this.txtPayerBank.setText(accountBank.getBank().toString());
                if (this.comboPayerType.getSelectedItem() == FMSysDefinedEnum.OTHER) {
                    if (EmptyUtil.isEmpty((String)accountBank.getAcctName())) {
                        this.prmtPayer.setData((Object)accountBank.getCompany().getName());
                    } else {
                        this.prmtPayer.setData((Object)accountBank.getAcctName());
                    }
                }
            }
        } else if (e.getNewValue() != null && (e.getNewValue() instanceof SupplierCompanyBankInfo || e.getNewValue() instanceof CustomerCompanyBankInfo)) {
            CoreBaseInfo obj = (CoreBaseInfo)e.getNewValue();
            String bank = (String)obj.get("bank");
            this.txtPayerBank.setText(bank);
        } else if (e.getNewValue() == null) {
            this.editData.setPayerAccountBankO(null);
            this.txtPayerBank.setText(null);
        }
    }

    @Override
    protected void txtPayerAccountBank_willCommit(CommitEvent e) throws Exception {
        super.txtPayerAccountBank_willCommit(e);
        this.setPayerAccountBank();
    }

    @Override
    protected void txtPayerAccountBank_willShow(SelectorEvent e) throws Exception {
        super.txtPayerAccountBank_willShow(e);
        this.setPayerAccountBank();
    }

    private void setPayerAccountBank() throws BOSException, EASBizException {
        Object payer = this.prmtPayer.getValue();
        boolean isSupplier = false;
        boolean isCustomer = false;
        boolean isInnerSupplierOrCustomer = false;
        SupplierInfo supplier = null;
        CustomerInfo customer = null;
        if (payer instanceof CurrentInfo) {
            if (payer != null && ((CurrentInfo)((Object)payer)).getId() != null) {
                String id = ((CurrentInfo)((Object)payer)).getId().toString();
                if (BOSUuid.read((String)id).getType().equals((Object)new SupplierInfo().getBOSType())) {
                    isSupplier = true;
                    supplier = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(id));
                    isInnerSupplierOrCustomer = supplier.isIsInternalCompany();
                } else if (BOSUuid.read((String)id).getType().equals((Object)new CustomerInfo().getBOSType())) {
                    isCustomer = true;
                    customer = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(id));
                    isInnerSupplierOrCustomer = customer.isIsInternalCompany();
                }
            }
        } else if (payer instanceof SupplierInfo) {
            isSupplier = true;
            supplier = (SupplierInfo)payer;
            if (supplier != null) {
                supplier = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(supplier.getId()));
                isInnerSupplierOrCustomer = supplier.isIsInternalCompany();
            }
        } else if (payer instanceof CustomerInfo) {
            isCustomer = true;
            customer = (CustomerInfo)payer;
            if (customer != null) {
                customer = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(customer.getId()));
                isInnerSupplierOrCustomer = customer.isIsInternalCompany();
            }
        }
        if (isSupplier && !isInnerSupplierOrCustomer) {
            this.initSupplierCompanyInfoBank((DataBaseInfo)supplier, this.txtPayerAccountBank);
        } else if (isCustomer && !isInnerSupplierOrCustomer) {
            this.initCustomerCompanyInfoBank((DataBaseInfo)customer, this.txtPayerAccountBank);
        } else {
            this.initPayerAcctBankASAcctBank();
        }
    }

    private void initTxtNumberStatus() {
        boolean isNumberEdtableStatus;
        TemplateReceivingBillInfo info = (TemplateReceivingBillInfo)this.getDataObject();
        if (info == null) {
            return;
        }
        String oprtS = this.getOprtState();
        String listOprtState = (String)this.getUIContext().get("listOprtState");
        if (listOprtState != null && listOprtState.equals("FINDVIEW")) {
            oprtS = "FINDVIEW";
        }
        boolean hasCodingRule = this.paramValue.get("hasCodingRule") != null && this.paramValue.get("hasCodingRule").equals(Boolean.TRUE);
        boolean isNumberModifyable = this.paramValue.get("isModifiable") != null && this.paramValue.get("isModifiable").equals(Boolean.TRUE);
        boolean isAddView = this.paramValue.get("isAddView") != null && this.paramValue.get("isAddView").equals(Boolean.TRUE);
        boolean bl = isNumberEdtableStatus = info.getBillStatus() == null || info.getBillStatus().equals((Object)BillStatusEnum.SAVE) || info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT);
        if (!oprtS.equals(OprtState.ADDNEW) && !oprtS.equals(OprtState.EDIT) || !isNumberEdtableStatus || oprtS.equals(OprtState.ADDNEW) && hasCodingRule && (!isAddView || isAddView && !isNumberModifyable) || oprtS.equals(OprtState.EDIT) && hasCodingRule && !isNumberModifyable) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
        if (oprtS.equals(OprtState.ADDNEW) && hasCodingRule && !isAddView) {
            this.txtNumber.setRequired(false);
        } else {
            this.txtNumber.setRequired(true);
        }
    }

    private void initCustomerCompanyInfoBank(DataBaseInfo customer, KDBizPromptBox txtPayerAccountBank) {
        txtPayerAccountBank.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyInfoBankQuery");
        txtPayerAccountBank.setHasCUDefaultFilter(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (customer != null) {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customer.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        view.setFilter(filter);
        txtPayerAccountBank.setEntityViewInfo(view);
        txtPayerAccountBank.setEditFormat("$bankAccount$");
        txtPayerAccountBank.setDisplayFormat("$bankAccount$");
        txtPayerAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    private CustomerInfo getCustomer(Object objCust) {
        if (objCust instanceof CustomerInfo) {
            return (CustomerInfo)objCust;
        }
        return null;
    }

    private SupplierInfo getSupplier(Object objCust) {
        if (objCust instanceof SupplierInfo) {
            return (SupplierInfo)objCust;
        }
        return null;
    }

    @Override
    protected void prmtPayer_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo info;
        super.prmtPayer_dataChanged(e);
        Object payer = this.prmtPayer.getValue();
        if (payer instanceof SupplierInfo) {
            SupplierInfo supplier = this.getSupplier(this.prmtPayer.getData());
            if (supplier != null) {
                SupplierCompanyInfoInfo supplierCompany = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supplier.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
                if (supplierCompany != null) {
                    CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)supplier, (String)this.currentCompany.getId().toString());
                    this.txtPayerAccountBank.setText(bankInfo.getBankAccount());
                    this.txtPayerBank.setText(bankInfo.getBank());
                } else {
                    this.txtPayerAccountBank.setText(null);
                    this.txtPayerBank.setText(null);
                }
            }
        } else if (payer instanceof CustomerInfo) {
            CustomerInfo cust = this.getCustomer(this.prmtPayer.getData());
            if (cust != null) {
                CustomerCompanyInfoInfo custCompany = CustomerFactory.getRemoteInstance().getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(cust.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
                if (custCompany != null) {
                    CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)cust, (String)this.currentCompany.getId().toString());
                    this.txtPayerAccountBank.setText(bankInfo.getBankAccount());
                    this.txtPayerBank.setText(bankInfo.getBank());
                } else {
                    this.txtPayerAccountBank.setText(null);
                    this.txtPayerBank.setText(null);
                }
            }
        } else if (payer instanceof AccountBankInfo && (info = (AccountBankInfo)payer) != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("bank.*");
            selector.add("company.name");
            info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getId()), selector);
            if (EmptyUtil.isEmpty((String)info.getAcctName())) {
                ((AccountBankInfo)payer).setName(info.getCompany().getName());
            } else {
                ((AccountBankInfo)payer).setName(info.getAcctName());
            }
            this.txtPayerBank.setText(info.getBank().getName());
            this.txtPayerAccountBank.setText(info.getBankAccountNumber());
        }
    }

    private void initSupplierCompanyInfoBank(DataBaseInfo supply, KDBizPromptBox txtPayerAccountBank) {
        txtPayerAccountBank.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
        txtPayerAccountBank.setHasCUDefaultFilter(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (supply != null) {
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supply.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        view.setFilter(filter);
        txtPayerAccountBank.setEntityViewInfo(view);
        txtPayerAccountBank.setEditFormat("$bankAccount$");
        txtPayerAccountBank.setDisplayFormat("$bankAccount$");
        txtPayerAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void initPayerAcctBankASAcctBank() {
        AccountBankInfo payerAcctBank = (AccountBankInfo)this.prmtPayeeAccountBank.getData();
        AccountViewInfo oppAccount = (AccountViewInfo)this.prmtOppAccount.getValue();
        Object payerType = this.comboPayerType.getSelectedItem();
        Object payerName = this.prmtPayer.getData();
        if (oppAccount == null) {
            this.initPayerAccountBankEV(payerAcctBank, oppAccount, false, payerType, payerName);
        } else if (oppAccount.isIsBank()) {
            this.initPayerAccountBankEV(payerAcctBank, oppAccount, true, payerType, payerName);
        } else {
            this.initPayerAccountBankEV(payerAcctBank, oppAccount, false, payerType, payerName);
        }
        this.txtPayerAccountBank.setEditFormat("$bankAccountNumber$");
        this.txtPayerAccountBank.setDisplayFormat("$bankAccountNumber$");
        this.txtPayerAccountBank.setCommitFormat("$simpleCode$;$number$;$name$;$bankAccountNumber$");
        this.txtPayerAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void initPayerAccountBankEV(AccountBankInfo payeeAcctBank, AccountViewInfo oppAccount, boolean isBank, Object payerType, Object payerName) {
        this.txtPayerAccountBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        if (isBank) {
            filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)oppAccount.getId().toString()));
        }
        if (payerType instanceof AsstActTypeInfo) {
            FilterInfo filterName;
            CurrentInfo current;
            AsstActTypeInfo info = (AsstActTypeInfo)payerType;
            String realPayerName = "";
            if (info.getAsstHGAttribute().equalsIgnoreCase("provider") && !EmptyUtil.isEmpty((Object)payerName)) {
                if (payerName instanceof SupplierInfo) {
                    DataBaseInfo supplierInfo = (DataBaseInfo)payerName;
                    realPayerName = supplierInfo.getName();
                } else if (payerName instanceof CurrentInfo) {
                    current = (CurrentInfo)((Object)payerName);
                    realPayerName = current.getName();
                }
                if (realPayerName != null) {
                    filterName = new FilterInfo();
                    filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)realPayerName));
                    filterName.getFilterItems().add(new FilterItemInfo("name", (Object)realPayerName));
                    filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)realPayerName));
                    filterName.setMaskString("#0 or #1 or #2");
                    try {
                        filter.mergeFilter(filterName, "and");
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                }
            }
            if (info.getAsstHGAttribute().equalsIgnoreCase("customer") && !EmptyUtil.isEmpty((Object)payerName)) {
                if (payerName instanceof CustomerInfo) {
                    DataBaseInfo customerInfo = (DataBaseInfo)payerName;
                    realPayerName = customerInfo.getName();
                } else if (payerName instanceof CurrentInfo) {
                    current = (CurrentInfo)((Object)payerName);
                    realPayerName = current.getName();
                }
                if (realPayerName != null) {
                    filterName = new FilterInfo();
                    filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)realPayerName));
                    filterName.getFilterItems().add(new FilterItemInfo("name", (Object)realPayerName));
                    filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)realPayerName));
                    filterName.setMaskString("#0 or #1 or #2");
                    try {
                        filter.mergeFilter(filterName, "and");
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
        if (payeeAcctBank != null && payeeAcctBank.getInnerAcct() != null) {
            SettBizTypeInfo bizType = (SettBizTypeInfo)this.f7BizType.getData();
            if (bizType != null && bizType.getType() == SettBizTypeEnum.RECINSIDE) {
                filter.getFilterItems().add(new FilterItemInfo("InnerAcct.id", null, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)payeeAcctBank.getBank().getId()));
            }
            if (bizType != null && bizType.getType() == SettBizTypeEnum.RECINSIDEDIF) {
                filter.getFilterItems().add(new FilterItemInfo("InnerAcct.id", null, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)payeeAcctBank.getBank().getId(), CompareType.NOTEQUALS));
            }
        }
        String strValue = (String)this.paramValue.get("CS039");
        FilterInfo filterCurcompany = new FilterInfo();
        filterCurcompany.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        FilterInfo filterOtherClearhouse = new FilterInfo();
        filterOtherClearhouse.getFilterItems().add(new FilterItemInfo("bank.inGroup", (Object)"1"));
        if ("0".equals(strValue)) {
            try {
                filter.mergeFilter(filterCurcompany, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        } else if ("1".equals(strValue)) {
            try {
                filterCurcompany.mergeFilter(filterOtherClearhouse, "or");
                filter.mergeFilter(filterCurcompany, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("ctrlStrategy.*");
        this.txtPayerAccountBank.setSelectorCollection(selectors);
        this.txtPayerAccountBank.setEntityViewInfo(evi);
        this.txtPayerAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void comboPayerType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2 || this.comboPayerType.getSelectedItem() == null) {
            return;
        }
        boolean canEditpayerAcctBank = true;
        if (this.editData != null) {
            canEditpayerAcctBank = BillStatusEnum.SAVE.equals((Object)this.editData.getBillStatus()) || BillStatusEnum.SUBMIT.equals((Object)this.editData.getBillStatus());
        }
        this.prmtPayer.setValue(null);
        this.txtPayerBank.setText(null);
        this.txtPayerAccountBank.setValue(null);
        if (this.comboPayerType.getSelectedItem() instanceof AsstActTypeInfo) {
            AsstActTypeInfo info = (AsstActTypeInfo)this.comboPayerType.getSelectedItem();
            this.prmtPayer.setFilterInfoProducer(null);
            this.prmtPayer.setSelector(null);
            this.handler.setAsstActSelectorByCU((CoreUIObject)this, this.prmtPayer, info, this.currentCompany, false);
            if (info.getAsstHGAttribute().equalsIgnoreCase("innerAccount")) {
                info.setIsForCompany(false);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
                filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                this.prmtPayer.setEntityViewInfo(evi);
                this.prmtPayer.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$simpleCode$;$number$;$name$", this.prmtPayer));
                this.txtPayerAccountBank.setEnabled(false);
            } else if (info.getAsstHGAttribute().equalsIgnoreCase("bankAccount")) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                this.prmtPayer.setEntityViewInfo(evi);
                this.prmtPayer.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$simpleCode$;$number$;$name$", this.prmtPayer));
                this.txtPayerAccountBank.setEnabled(false);
            } else {
                this.prmtPayer.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$", this.prmtPayer));
                if (canEditpayerAcctBank) {
                    this.txtPayerAccountBank.setEnabled(true);
                }
            }
            this.prmtPayer.setDisplayFormat("$number$ $name$");
        } else if (this.comboPayerType.getSelectedItem() instanceof FMSysDefinedEnum) {
            ExtendParser parser = new ExtendParser(this.prmtPayer);
            this.prmtPayer.setCommitParser((IParser)parser);
            this.prmtPayer.setMaxLength(80);
            this.prmtPayer.setDisplayFormat("$name$");
            if (canEditpayerAcctBank) {
                this.txtPayerAccountBank.setEnabled(true);
            }
        }
    }

    @Override
    protected void prmtPayer_willShow(SelectorEvent e) throws Exception {
        if (this.comboPayerType.getSelectedItem() == null || this.comboPayerType.getSelectedItem() instanceof FMSysDefinedEnum) {
            e.setCanceled(true);
            return;
        }
    }

    @Override
    protected void prmtPayer_willCommit(CommitEvent e) throws Exception {
        AsstActTypeInfo info;
        super.prmtPayer_willCommit(e);
        if (this.comboPayerType.getSelectedItem() instanceof AsstActTypeInfo && (info = (AsstActTypeInfo)this.comboPayerType.getSelectedItem()).getAsstHGAttribute().equalsIgnoreCase("provider")) {
            EntityViewInfo view = this.prmtPayer.getEntityViewInfo();
            FilterInfo filter = view.getFilter();
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            this.prmtPayer.setEntityViewInfo(view);
            this.prmtPayer.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void prmtProject_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtProject_dataChanged(e);
        try {
            ProjectInfo project = (ProjectInfo)this.prmtProject.getValue();
            PersonInfo bill = null;
            if (project != null && project.getPrjManager() != null) {
                ObjectUuidPK objPk = new ObjectUuidPK(project.getPrjManager().getId().toString());
                bill = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)objPk);
                this.editData.setProjectManager(bill);
            } else {
                this.editData.setProjectManager(null);
            }
        }
        catch (ClassCastException ex) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"SelectEffectProject");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            this.prmtProject.requestFocus();
        }
    }

    @Override
    protected void prmtProject_willCommit(CommitEvent e) throws Exception {
        super.prmtProject_willCommit(e);
        this.setProjectEvi();
    }

    @Override
    protected void prmtProject_willShow(SelectorEvent e) throws Exception {
        boolean val_company = (Boolean)this.paramValue.get("CS037");
        super.prmtProject_willShow(e);
        if (!val_company) {
            F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        }
        this.setProjectEvi();
    }

    private void setProjectEvi() {
        boolean val = (Boolean)this.paramValue.get("CS037");
        EntityViewInfo view = new EntityViewInfo();
        if (val) {
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        } else {
            F7ContextUtil.resetFilterItemCompareValue((EntityViewInfo)view, (String)"company.id", null, (CompareType)CompareType.NOTEQUALS);
            if (EmptyUtil.isEmpty((Object)view.getFilter())) {
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
            }
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.NOTEQUALS));
        this.prmtProject.setEntityViewInfo(view);
        this.prmtProject.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        this.handler.setEntrySeq(table);
        this.handler.setHeadSumAmt(table, this.txtActRecAmt, this.txtActRecLocAmt);
        this.refreshAssItems((TemplateReceivingBillEntryInfo)lineData, "D");
    }

    protected void afterInsertLine(KDTable table, IObjectValue lineData) {
        this.handler.setEntrySeq(table);
        this.refreshAssItems((TemplateReceivingBillEntryInfo)lineData, "I");
        this.kDTabbedPane1.setEnabledAt(1, false);
        this.kDTabbedPane1.setSelectedIndex(0);
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
        this.handler.setEntrySeq(table);
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        int seq = row.getRowIndex();
        TemplateReceivingBillEntryInfo entryInfo = (TemplateReceivingBillEntryInfo)obj;
        entryInfo.setSeq(seq + 1);
        super.loadLineFields(table, row, obj);
    }

    private void refreshAssItems(TemplateReceivingBillEntryInfo info, String type) {
        block4: {
            block3: {
                if (!"D".equals(type)) break block3;
                int deleteSeq = info.getSeq();
                MultiAssItemsForCash_TmplRecClientHelper.removeSomeRow(this.tblAssItems, deleteSeq);
                int deleteIndex = this.getIndexBeDeleted(deleteSeq);
                if (deleteIndex == this.deforeDel - 1) {
                    return;
                }
                int size = this.tblAssItems.getRowCount();
                Integer tmp = null;
                for (int i = 0; i < size; ++i) {
                    tmp = (Integer)this.tblAssItems.getRow(i).getCell("entryID").getValue();
                    if (tmp == null || deleteSeq >= tmp) continue;
                    this.tblAssItems.getRow(i).getCell("entryID").setValue((Object)new Integer(tmp - 1));
                }
                break block4;
            }
            if (!"I".equals(type)) break block4;
            int insertSeq = info.getSeq();
            int size = this.tblAssItems.getRowCount();
            Integer tmp = null;
            for (int i = 0; i < size; ++i) {
                tmp = (Integer)this.tblAssItems.getRow(i).getCell("entryID").getValue();
                if (tmp == null || tmp < insertSeq) continue;
                this.tblAssItems.getRow(i).getCell("entryID").setValue((Object)new Integer(tmp + 1));
            }
        }
    }

    private int getIndexBeDeleted(int seq) {
        return seq - 1;
    }

    @Override
    protected void kdtEntries_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int i = KDTableUtil.getSelectedRow((KDTable)this.kdtEntries);
        Integer seq = (Integer)this.kdtEntries.getRow(i).getCell("seq").getValue();
        MultiAssItemsForCash_TmplRecClientHelper.entries_tableSelectChanged(this.tblAssItems, seq, this.kDTabbedPane1, this.editData.isFiVouchered());
    }

    protected void prmtOppAccount_focusGained(FocusEvent e) throws Exception {
        MultiAssItemsForCash_TmplRecClientHelper.entries_tableSelectChanged(this.tblAssItems, -99, this.kDTabbedPane1, this.editData.isFiVouchered());
    }

    protected void setCostCenterF7() {
        Object param = this.paramValue.get("CS082");
        if (param != null && param.toString().equals("0")) {
            NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
            costCenterF7.setNeedAddOrgRange(false);
            costCenterF7.setIsCUFilter(false);
            if (null == this.currentCompany.getCU()) {
                this.currentCompany.setCU(this.contextHelper.getCurrentCtrlUnit());
            }
            if (null == this.currentCompany.getBaseCurrency()) {
                this.currentCompany.setBaseCurrency(this.baseCurrency);
            }
            costCenterF7.setCurrentCUID(this.currentCompany.getCU().getId().toString());
            costCenterF7.setNeedConsiderFaultTree(false);
            this.prmtCostCenter.setDisplayFormat("$number$ $name$");
            this.prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
            this.prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
            this.prmtCostCenter.getQueryAgent().resetRuntimeEntityView();
        } else {
            CasRecPayHandler.initCostCenterOrgFilter(this.prmtCostCenter, this.currentCompany);
        }
    }

    @Override
    protected void f7FeeType_dataChanged(DataChangeEvent e) throws Exception {
        FeeTypeDefaultMsgInfo fdmc = AssItemsForCash_TmplRecClientHelper.getFeeTypeDefaultMsgInfo((FeeTypeInfo)this.f7FeeType.getValue());
        this.fillMsg2UI(fdmc);
    }

    private void fillMsg2UI(FeeTypeDefaultMsgInfo fdmc) {
        if (fdmc.getId() == null) {
            return;
        }
        if (fdmc.getOppAccountView() != null) {
            this.prmtOppAccount.setValue((Object)fdmc.getOppAccountView());
        }
        if (fdmc.getRecPayerType() != null) {
            UIUtil.setSelectObject((KDComboBox)this.comboPayerType, (Object)fdmc.getRecPayerType());
        } else {
            this.comboPayerType.setSelectedItem((Object)FMSysDefinedEnum.OTHER);
        }
        if (EmptyUtil.isEmpty((String)this.prmtDesc.getText()) && !EmptyUtil.isEmpty((String)fdmc.getDescription())) {
            this.prmtDesc.setValue((Object)fdmc.getDescription());
        }
    }

    @Override
    protected void tblAssItems_editStopped(KDTEditEvent e) throws Exception {
        KDTable table = (KDTable)e.getSource();
        int r = e.getRowIndex();
        int c = e.getColIndex();
        String key = table.getColumnKey(c);
        if (key.equals("selected")) {
            Object selected = table.getRow(r).getCell("selected").getValue();
            if (((Boolean)selected).booleanValue()) {
                table.getRow(r).getCell("fromNumber").getStyleAttributes().setLocked(false);
            } else {
                table.getRow(r).getCell("fromNumber").getStyleAttributes().setLocked(true);
                table.getRow(r).getCell("fromNumber").setValue(null);
            }
        }
    }
}

