/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.AbstractTransToPaymentFilterUI;
import com.kingdee.eas.fi.cas.client.TransToPaymentListUI;
import com.kingdee.eas.fm.be.BizTypeEnum;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransToPaymentFilterUI
extends AbstractTransToPaymentFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TransToPaymentFilterUI.class);
    private static HashMap selectCondition;
    private static String resourcePath;
    public static final int REC_TRANS_TYPE = 0;
    public static final int PAY_TRANS_TYPE = 1;
    private boolean isShowBank = false;
    int transType = 0;

    public TransToPaymentFilterUI() throws Exception {
        if (selectCondition == null) {
            selectCondition = new HashMap();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.transType = (Integer)this.getUIContext().get("transType");
        FMClientHelper.initComboCurrency((KDComboBox)this.cboCurrency, (boolean)true);
        this.initBillStatus(this.comboBizType);
        this.initCompanyF7();
        super.onLoad();
        if (0 == this.transType) {
            this.comKDRetFlag.setSelectedIndex(2);
        } else if (1 == this.transType) {
            this.comKDRetFlag.setSelectedIndex(1);
        }
        if (selectCondition != null) {
            this.setParam();
        }
        this.kDNumamount.setHorizontalAlignment(4);
    }

    protected void initCompanyF7() {
        KDBizPromptBox bizOrgUnitBox = this.kDProCompany;
        this.kDProCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        if (bizOrgUnitBox != null) {
            NewOrgUnitFilterInfoProducer iProducer = null;
            String permissionItem = this.getPermissionItem();
            iProducer = new NewOrgUnitFilterInfoProducer(this.getMainOrgType());
            if (iProducer != null) {
                if (permissionItem != null) {
                    iProducer.getModel().setPermissionItem(permissionItem);
                }
                bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                if (iProducer.getModel() != null) {
                    bizOrgUnitBox.setSelector((KDPromptSelector)iProducer.getModel());
                    iProducer.getModel().setMultiSelect(this.isSupportMultiOrgs());
                }
            }
            bizOrgUnitBox.setCommitFormat("$number$");
            bizOrgUnitBox.setEditFormat("$number$");
            bizOrgUnitBox.setDisplayFormat("$name$");
            bizOrgUnitBox.setEnabledMultiSelection(this.isSupportMultiOrgs());
        }
        if (selectCondition != null && selectCondition.containsKey("company")) {
            CompanyOrgUnitCollection coll = (CompanyOrgUnitCollection)selectCondition.get("company");
            OrgUnitInfo[] orgcoll = new OrgUnitInfo[coll.size()];
            for (int i = 0; i < coll.size(); ++i) {
                orgcoll[i] = coll.get(i);
            }
            this.kDProCompany.setValue((Object)orgcoll);
        }
        if (EmptyUtil.isEmpty((Object)this.kDProCompany.getValue()) || ((Object[])this.kDProCompany.getValue()).length == 0 || EmptyUtil.isEmpty((Object)((Object[])this.kDProCompany.getValue())[0])) {
            this.kDProCompany.setValue((Object)new OrgUnitInfo[]{ContextHelperFactory.getRemoteInstance().getCurrentCompany()});
        }
    }

    public boolean isSupportMultiOrgs() {
        return true;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    public OrgType getMainOrgType() {
        return OrgType.Company;
    }

    public String getPermissionItem() {
        if (0 == this.transType) {
            return "cas_receivingbill_02addNew";
        }
        return "cas_paymentbill_02addNew";
    }

    @Override
    protected void f7BankAccount_willShow(SelectorEvent e) throws Exception {
        CurrencyInfo selectedCurrency;
        F7SelectorFactory.initAccountBank((IUIObject)this, (KDBizPromptBox)this.f7BankAccount);
        this.f7BankAccount.setDisplayFormat("$bankAccountNumber$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        this.isShowBank = this.isShowSetBank.isSelected();
        if (!this.isShowBank) {
            filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)Boolean.TRUE));
        }
        if (!EmptyUtil.isEmpty((Object)this.kDProCompany.getValue())) {
            OrgUnitInfo[] companyInfos = (OrgUnitInfo[])this.kDProCompany.getValue();
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < companyInfos.length; ++i) {
                ids.add(companyInfos[i].getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("company.id", ids, CompareType.INCLUDE));
        } else {
            String currencyCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currencyCompany, CompareType.EQUALS));
        }
        FilterInfo currencyFilter = new FilterInfo();
        if (this.cboCurrency.getSelectedItem() != null && !this.cboCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS) && (selectedCurrency = (CurrencyInfo)this.cboCurrency.getSelectedItem()) != null) {
            currencyFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)new Boolean(true)));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)selectedCurrency.getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)new Boolean(false)));
            currencyFilter.setMaskString("( #0 and #1 ) or #2 ");
        }
        filter.mergeFilter(currencyFilter, "and");
        view.setFilter(filter);
        this.f7BankAccount.setEntityViewInfo(view);
        this.f7BankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    public static HashMap showTransToPaymentFilterUI(CoreUIObject ui) {
        int transType = ((TransToPaymentListUI)ui).getTransType();
        HashMap returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            selectCondition = (HashMap)ui.getUIContext().get("selectMap");
            uiContext.put((Object)"transType", (Object)transType);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TransToPaymentFilterUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((TransToPaymentFilterUI)uiWindow.getUIObject()).getReturnValue();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }

    public boolean verify() throws AccountBankException {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dtpBegin);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dtpEndTo);
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (KDDatePicker)this.dtpBegin, (KDDatePicker)this.dtpEndTo);
        AccountBankCollection coll = new AccountBankCollection();
        AccessHelper.getF7Datas((KDBizPromptBox)this.f7BankAccount, (IObjectCollection)coll);
        HashMap<String, AccountBankInfo> map = new HashMap<String, AccountBankInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            AccountBankInfo tmp = coll.get(i);
            if (map.containsKey(tmp.getBankAccountNumber())) {
                String msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"sharedSelectAcctError"), tmp.getBankAccountNumber());
                throw new AccountBankException(AccountBankException.COMMON, new Object[]{msg});
            }
            map.put(tmp.getBankAccountNumber(), tmp);
        }
        return true;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.disposeUIWindow();
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        selectCondition.put("beginDate", this.dtpBegin.getValue());
        selectCondition.put("endDate", this.dtpEndTo.getValue());
        selectCondition.put("Currency", this.cboCurrency.getSelectedItem());
        AccountBankCollection coll = new AccountBankCollection();
        AccessHelper.getF7Datas((KDBizPromptBox)this.f7BankAccount, (IObjectCollection)coll);
        selectCondition.put("BankAccount", coll);
        CompanyOrgUnitCollection company = new CompanyOrgUnitCollection();
        AccessHelper.getF7Datas((KDBizPromptBox)this.kDProCompany, (IObjectCollection)company);
        selectCondition.put("company", company);
        selectCondition.put("BizType", this.comboBizType.getSelectedItem());
        selectCondition.put("BizName", this.txtBizName.getText());
        selectCondition.put("Description", this.txtdescription.getText());
        selectCondition.put("amount", this.kDNumamount.getNumberValue());
        selectCondition.put("isKDRetFlag", this.comKDRetFlag.getSelectedItem());
        this.disposeUIWindow();
    }

    private void setParam() {
        if (selectCondition.get("beginDate") != null) {
            this.dtpBegin.setValue(selectCondition.get("beginDate"));
        }
        if (selectCondition.get("endDate") != null) {
            this.dtpEndTo.setValue(selectCondition.get("endDate"));
        }
        if (selectCondition.get("Currency") != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, selectCondition.get("Currency"));
            if (selectCondition.get("BankAccount") != null) {
                AccountBankCollection coll = (AccountBankCollection)selectCondition.get("BankAccount");
                Object[] objArr = new Object[coll.size()];
                for (int i = 0; i < objArr.length; ++i) {
                    objArr[i] = coll.get(i);
                }
                this.f7BankAccount.setData((Object)objArr);
            }
            if (selectCondition.get("BizType") != null) {
                FMClientHelper.setSelectObject((KDComboBox)this.comboBizType, selectCondition.get("BizType"));
            }
            if (selectCondition.get("BizName") != null) {
                this.txtBizName.setText((String)selectCondition.get("BizName"));
            }
            if (selectCondition.get("Description") != null) {
                this.txtdescription.setText((String)selectCondition.get("Description"));
            }
            if (selectCondition.get("amount") != null) {
                this.kDNumamount.setValue(selectCondition.get("amount"));
            }
            if (selectCondition.get("isKDRetFlag") != null) {
                FMClientHelper.setSelectObject((KDComboBox)this.comKDRetFlag, selectCondition.get("isKDRetFlag"));
            }
        }
    }

    private HashMap getReturnValue() {
        return selectCondition;
    }

    private void initBillStatus(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        combo.addItem((Object)BizTypeEnum.normal);
        combo.addItem((Object)BizTypeEnum.transUp);
        combo.addItem((Object)BizTypeEnum.transDown);
        combo.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    static {
        resourcePath = "com.kingdee.eas.fi.cas.RecPayResource";
    }
}

