/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.AbstractTransToPaymentListUI;
import com.kingdee.eas.fi.cas.client.TransToPaymentFilterUI;
import com.kingdee.eas.fm.be.BizTypeEnum;
import com.kingdee.eas.fm.be.SharedAcctFacadeFactory;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.DynamicUtils;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.KDRetFlagEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransToPaymentListUI
extends AbstractTransToPaymentListUI {
    private static final Logger logger = CoreUIObject.getLogger(TransToPaymentListUI.class);
    private Set selectCondition;
    private AccountBankCollection selectBankAccount;
    private Map resultMap = new HashMap();
    private Map selectMap;
    public static final int REC_TRANS_TYPE = 0;
    public static final int PAY_TRANS_TYPE = 1;
    private int transType;

    public Map getSelectMap() {
        return this.selectMap;
    }

    public int getTransType() {
        return this.transType;
    }

    public void setTransType(int transType) {
        this.transType = transType;
    }

    public TransToPaymentListUI() throws Exception {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.selectCondition = new HashSet();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.actionRefresh.setVisible(false);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void filltblMain(Set companyId, Date beginDate, Date endDate, String Currency2, Set idSet, String BizType, String BizName, String Description, BigDecimal amount, Integer isKDRetFlag) throws BOSException, SQLException {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.removeRows();
        IRowSet rs = this.getRowSet(companyId, beginDate, endDate, Currency2, idSet, BizType, BizName, Description, amount, isKDRetFlag);
        if (rs == null || rs.toCollection().size() == 0) {
            return;
        }
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)Currency2));
        while (rs.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell("TransDate").setValue((Object)CtrlFormatUtilities.getDateFormat().format(rs.getDate("FBizTime")));
            row.getCell("TransTime").setValue((Object)CtrlFormatUtilities.getTimeFormat().format(rs.getTime("FBizTime")));
            row.getCell("Currency").setValue(rs.getObject("FCurrencyName"));
            row.getCell("AccountCode").setValue(rs.getObject("FBankAccountnumber"));
            row.getCell("BankAccount").setValue(rs.getObject("FAccountNumber"));
            row.getCell("BankName").setValue(rs.getObject("FBankAccountName"));
            row.getCell("Amount").getStyleAttributes().setNumberFormat(numberFtm);
            if (this.transType == 1) {
                row.getCell("Amount").setValue(rs.getObject("FDebitAmount"));
            } else if (this.transType == 0) {
                row.getCell("Amount").setValue(rs.getObject("FCreditAmount"));
            }
            row.getCell("BizName").setValue(rs.getObject("FBizName"));
            row.getCell("OppUnit").setValue(rs.getObject("FOppUnit"));
            row.getCell("OppBank").setValue(rs.getObject("FOppBank"));
            row.getCell("OppAccount").setValue(rs.getObject("FOppBankNumber"));
            row.getCell("BizNumber").setValue(rs.getObject("FBizNumber"));
            row.getCell("Description").setValue(rs.getObject("FDescription"));
            row.getCell("ID").setValue(rs.getObject("id"));
            row.getCell("FBankAccountID").setValue(rs.getObject("FBankAccountID"));
            row.getCell("isKDRetFlag").setValue(rs.getObject("ISKDRETFLAG"));
        }
        this.tblMain.getColumn("ID").getStyleAttributes().setHided(true);
    }

    public Date getNextDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, 1);
        return c.getTime();
    }

    private IRowSet getRowSet(Set companyId, Date beginDate, Date endDate, String Currency2, Set idSet, String BizType, String BizName, String Description, BigDecimal amount, Integer isKDRetFlag) throws BOSException {
        MetaDataPK PK = new MetaDataPK("com.kingdee.eas.fi.cas.app", "TransToSettlementQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)PK);
        endDate = this.getNextDay(endDate);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("FIsDebit", (Object)new Integer(this.transType)));
        filter.getFilterItems().add(new FilterItemInfo("FIsReced", (Object)new Integer(0)));
        if (!EmptyUtil.isEmpty((Collection)companyId)) {
            filter.getFilterItems().add(new FilterItemInfo("FCompanyID", (Object)companyId, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("FBizTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("FBizTime", (Object)endDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("FCurrencyID", (Object)Currency2, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isCreatedtransDown", (Object)new Integer(0)));
        if (!EmptyUtil.isEmpty((Object)amount)) {
            if (this.transType == 1) {
                filter.getFilterItems().add(new FilterItemInfo("FDebitAmount", (Object)amount, CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("FCreditAmount", (Object)amount, CompareType.EQUALS));
            }
        }
        if (idSet != null && idSet.size() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("FBankAccountID", (Object)idSet, CompareType.INCLUDE));
        }
        if (!BizType.equals("1000")) {
            filter.getFilterItems().add(new FilterItemInfo("FBizType", (Object)BizType));
        }
        if (!BizName.equals("") && BizName.length() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("FBizName", (Object)("%" + BizName + "%"), CompareType.LIKE));
        }
        if (!Description.equals("") && Description.length() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("FDescription", (Object)("%" + Description + "%"), CompareType.LIKE));
        }
        if (isKDRetFlag != 2) {
            if (isKDRetFlag == 1) {
                filter.getFilterItems().add(new FilterItemInfo("isKDRetFlag", (Object)0));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("isKDRetFlag", (Object)1));
            }
        }
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sortCompany = new SorterItemInfo("company.id");
        sorterColl.add(sortCompany);
        SorterItemInfo sortBizTime = new SorterItemInfo("bizTime");
        sortBizTime.setSortType(SortType.DESCEND);
        sorterColl.add(sortBizTime);
        ev.setSorter(sorterColl);
        ev.setFilter(filter);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        Integer isKDRetFlag = 0;
        this.getUIContext().put("selectMap", this.selectMap);
        this.selectMap = TransToPaymentFilterUI.showTransToPaymentFilterUI(this);
        if (this.selectMap != null && this.selectMap.isEmpty()) {
            return;
        }
        CompanyOrgUnitCollection company = (CompanyOrgUnitCollection)this.selectMap.get("company");
        Date beginDate = (Date)this.selectMap.get("beginDate");
        Date endDate = (Date)this.selectMap.get("endDate");
        String Currency2 = ((CurrencyInfo)this.selectMap.get("Currency")).getId().toString();
        HashSet<String> companySet = new HashSet<String>();
        if (this.selectMap.get("BankAccount") != null && ((AccountBankCollection)this.selectMap.get("BankAccount")).size() > 0) {
            int i;
            AccountBankCollection coll = (AccountBankCollection)this.selectMap.get("BankAccount");
            HashSet<String> numberSet = new HashSet<String>();
            for (int i2 = 0; i2 < coll.size(); ++i2) {
                AccountBankInfo info = coll.get(i2);
                numberSet.add(info.getBankAccountNumber());
            }
            Map result = SharedAcctFacadeFactory.getRemoteInstance().getSharedAcctAndCompany(numberSet);
            AccountBankInfo[] acctBank = (AccountBankInfo[])result.get("acctBank");
            String[] companyIds = (String[])result.get("companys");
            for (i = 0; i < acctBank.length; ++i) {
                idSet.add(acctBank[i].getId().toString());
            }
            for (i = 0; i < companyIds.length; ++i) {
                companySet.add(companyIds[i]);
            }
        } else if (company.size() > 0) {
            for (int i = 0; i < company.size(); ++i) {
                companySet.add(company.get(i).getId().toString());
            }
        } else {
            companySet.add(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        }
        Integer BizTypeInt = !this.selectMap.get("BizType").equals(FMSysDefinedEnum.ALL_ITEMS) ? new Integer(((BizTypeEnum)this.selectMap.get("BizType")).getValue()) : new Integer(1000);
        if (this.selectMap.get("isKDRetFlag") != null) {
            isKDRetFlag = new Integer(((KDRetFlagEnum)this.selectMap.get("isKDRetFlag")).getValue());
        } else if (0 == this.transType) {
            isKDRetFlag = new Integer(2);
        } else if (1 == this.transType) {
            isKDRetFlag = new Integer(1);
        }
        String BizName = this.selectMap.get("BizName").toString();
        String Description = this.selectMap.get("Description").toString();
        BigDecimal amount = null;
        if (!EmptyUtil.isEmpty(this.selectMap.get("amount"))) {
            amount = new BigDecimal(this.selectMap.get("amount").toString());
        }
        this.filltblMain(companySet, beginDate, endDate, Currency2, idSet, BizTypeInt.toString(), BizName, Description, amount, isKDRetFlag);
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        List selectedIds = this.getSelectedRowIds();
        Iterator iterator = selectedIds.iterator();
        HashSet<String> idSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            idSet.add(id);
        }
        ArrayList bankacctIds = FMClientHelper.getSelectedFieldValues((KDTable)this.tblMain, (String)"FBankAccountID");
        Set bankacctSet = ConvertUtils.SET((Object[])new Object[]{bankacctIds});
        this.selectBankAccount = (AccountBankCollection)DynamicUtils.getInfos(AccountBankCollection.class, (Object[])new Object[]{bankacctSet});
        this.selectCondition.addAll(idSet);
        this.disposeUIWindow();
    }

    private List getSelectedRowIds() {
        ArrayList<String> ids = new ArrayList<String>();
        IBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = this.tblMain.getRow(j);
                ids.add(row.getCell("ID").getValue().toString());
            }
        }
        return ids;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    public static Map showTransToPaymentListUI(CoreUIObject ui, int transType) {
        Map returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TransToPaymentListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            ((TransToPaymentListUI)uiWindow.getUIObject()).setTransType(transType);
            uiWindow.show();
            returnValue = ((TransToPaymentListUI)uiWindow.getUIObject()).getReturnValue();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }

    private Map getReturnValue() {
        if (EmptyUtil.isEmpty((Object)this.selectMap)) {
            this.resultMap.put("BankAccount", null);
        } else {
            this.resultMap.put("BankAccount", this.selectMap.get("BankAccount"));
            this.resultMap.put("companyColls", this.selectMap.get("company"));
        }
        this.resultMap.put("selectCondition", this.selectCondition);
        this.resultMap.put("selectBankAccount", this.selectBankAccount);
        return this.resultMap;
    }
}

