/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.NoticeTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractTransferBookNotifyUI;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.util.Date;

public class TransferBookNotifyUI
extends AbstractTransferBookNotifyUI {
    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtNoticeType.setText(NoticeTypeEnum.ALLOC.toString());
        this.txtNoticeType.setUserObject((Object)NoticeTypeEnum.ALLOC);
        this.txtNoticeType.setEditable(false);
    }

    @Override
    protected IObjectValue createNewData() {
        JournalInfo journal = new JournalInfo();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        journal.setId(BOSUuid.create((BOSObjectType)journal.getBOSType()));
        journal.setHasEffected(false);
        Date date = new Date();
        journal.setBizDate(date);
        PeriodInfo period = null;
        try {
            period = PeriodUtils.getPeriodInfo((Date)date, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        journal.setPeriod(period);
        journal.setVerifyStatus(VerifyScopeEnum.NOVA);
        journal.setSource(JournalSourceEnum.BYHAND);
        journal.setCurrency(company.getBaseCurrency());
        journal.setCreditAmount(FMConstants.ZERO);
        journal.setDebitAmount(FMConstants.ZERO);
        journal.setCompany(company);
        return journal;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void storeData() {
        this.tableHandler.bindTableToData(this.tblMain, (IObjectCollection)this.journalCollection, JournalInfo.class.getName());
        for (int i = 0; i < this.journalCollection.size(); ++i) {
            this.journalCollection.get(i).setCreateDate((Date)this.dpkBillDate.getValue());
            this.journalCollection.get(i).setBillNumber(this.txtBillNumber.getText());
        }
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)this.resourcePath, (KDTextField)this.txtBillNumber, (String)"NoBillNumber");
        super.verifyInput(e);
    }
}

