/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.formula.CashCaculaterHelper;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.fm.common.FmBatchCalculator;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CashBatchCaculator
extends FmBatchCalculator
implements ICalculator,
IMethodBatchQuery {
    private Map currencyMap = new HashMap();
    private Map companyMap_forGroupCompany = new HashMap();
    private Map companyMap_fordoCash = new HashMap();
    private Map mapIdNumberCompany = new HashMap();
    private Map mapIdNumberCurrency = new HashMap();
    private List listIdNumberBankAcct = new ArrayList();
    private Map mapIdNumberBankAcct = new HashMap();
    private List listIdNumberAcctView = new ArrayList();

    public BigDecimal cash(String companyNum, String sDataSource, String cashAccountView, String oppAccountNumber, String bankAcctNum, String currencyNum, String sBeginDate, String sEndDate, String sDataType) throws BOSException, EASBizException {
        return null;
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.serverCtx = this.context.getServerContext();
    }

    public boolean batchQuery(Map methods) {
        super.batchQuery(methods);
        for (Map.Entry e : methods.entrySet()) {
            String method = (String)e.getKey();
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.execute(param);
        }
        return true;
    }

    public void execute(SortedParameterArray params) {
        try {
            Map mapGroup = this.GroupByCompanyAndDate(params);
            Map batchMap = (Map)mapGroup.get("batch");
            Iterator it = batchMap.entrySet().iterator();
            int index = 0;
            while (it.hasNext()) {
                Map.Entry o = it.next();
                this.doCash((List)o.getValue(), params, o.getKey().toString());
                ++index;
            }
            List nonBatchList = (List)mapGroup.get("nonbatch");
            for (int i = 0; i < nonBatchList.size(); ++i) {
                Parameter param = (Parameter)nonBatchList.get(i);
                Object[] args = this.getParams(param);
                try {
                    if (param.getValue() != null && "error".equals(param.getValue())) {
                        param.setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"397_CashBatchCaculator"));
                        continue;
                    }
                    BigDecimal valueReturn = CashCaculaterHelper.getInstance().cash(this.serverCtx, args);
                    param.setValue((Object)valueReturn);
                    continue;
                }
                catch (Exception e) {
                    param.setValue((Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            for (int i = 0; i < params.size(); ++i) {
                FormulaValueBackfill backFill = new FormulaValueBackfill(params.getParameter(i));
                backFill.setException((Throwable)e);
            }
        }
    }

    private void doCash(List paramVOs, SortedParameterArray params, String key) throws EASBizException, BOSException {
        Map numbersMap = this.getNumbers(paramVOs);
        Set companyIdSet = null;
        if (this.companyMap_fordoCash.containsKey((String)numbersMap.get("companyNumber"))) {
            companyIdSet = (Set)this.companyMap_fordoCash.get((String)numbersMap.get("companyNumber"));
        } else {
            companyIdSet = this.getCompanyIds((String)numbersMap.get("companyNumber"));
            this.companyMap_fordoCash.put((String)numbersMap.get("companyNumber"), companyIdSet);
        }
        if (companyIdSet == null) {
            throw new CasDataException(CasDataException.NULL_COMPANY);
        }
        Set oppAccountIdSet = this.getOppAccountIds(numbersMap.get("oppAccountNumber").toString());
        String currencyId = null;
        if (this.currencyMap.containsKey(numbersMap.get("currencyNumber").toString())) {
            currencyId = (String)this.currencyMap.get(numbersMap.get("currencyNumber").toString());
        } else {
            currencyId = this.getCurrencyId(numbersMap.get("currencyNumber").toString());
            this.currencyMap.put(numbersMap.get("currencyNumber").toString(), currencyId);
        }
        Set accountViewIdSet = this.getAccountViewIds(numbersMap.get("accountViewNumber").toString());
        Date fromDate = ((ParamsVO)paramVOs.get(0)).getBeginDate();
        Date toDate = ((ParamsVO)paramVOs.get(0)).getEndDate();
        Map resultMap = this.queryByDay(fromDate, toDate, null, 1, null, companyIdSet, currencyId, true, 4, 0, accountViewIdSet, oppAccountIdSet);
        this.processResult(resultMap, params, key);
    }

    private Object[] getParams(Parameter param) {
        String endDate;
        String beginDate;
        String currencyNumber;
        Object[] args = param.getArgs();
        String companyNumber = args[0].toString();
        if (FMHelper.isEmpty((String)companyNumber)) {
            companyNumber = this.reportCompanyNumber;
            args[0] = companyNumber;
        }
        if (FMHelper.isEmpty((String)(currencyNumber = args[5].toString()))) {
            currencyNumber = this.reportCurrencyNumber;
            args[5] = currencyNumber;
        }
        if (FMHelper.isEmpty((String)(beginDate = args[6].toString()))) {
            beginDate = FMConstants.FORMAT_DAY.format(this.reportBeginDate);
            args[6] = beginDate;
        }
        if (FMHelper.isEmpty((String)(endDate = args[7].toString()))) {
            endDate = FMConstants.FORMAT_DAY.format(this.reportEndDate);
            args[7] = endDate;
        }
        return args;
    }

    private void processResult(Map resultMap, SortedParameterArray paramsCol, String key) {
        Object[] params = null;
        String companyNumber = null;
        String bankAcctNum = null;
        String currencyNum = null;
        CashDataTypeEnum dataType = null;
        String FCOMPANYID = "";
        String FACCOUNTVIEWID = "";
        String FCURRENCYID = "";
        String FACCOUNTBANKID = "";
        Parameter param = this.getParam(paramsCol, key);
        params = this.getParams(param);
        companyNumber = params[0].toString();
        FCOMPANYID = this.getIDByNumber_Company(companyNumber);
        bankAcctNum = params[3].toString();
        FACCOUNTBANKID = this.getIDByNumber_BankAcct(bankAcctNum);
        currencyNum = params[5].toString();
        FCURRENCYID = this.getIDByNumber_Currency(currencyNum);
        dataType = CashDataTypeEnum.getEnum(params[8].toString());
        BigDecimal result = FMConstants.ZERO;
        if (dataType == CashDataTypeEnum.Y) {
            String key1 = this.genKey(FCOMPANYID, FACCOUNTVIEWID, FCURRENCYID, FACCOUNTBANKID);
            String key2 = this.genKey(FCOMPANYID, "null", FCURRENCYID, FACCOUNTBANKID);
            result = (BigDecimal)resultMap.get(key1);
            if (result == null && (result = (BigDecimal)resultMap.get(key2)) == null) {
                result = FMConstants.ZERO;
            }
        } else if (dataType == CashDataTypeEnum.C) {
            String key1 = this.genKey(FCOMPANYID, FACCOUNTVIEWID, FCURRENCYID, FACCOUNTBANKID) + "fdaystartamt";
            String key2 = this.genKey(FCOMPANYID, "null", FCURRENCYID, FACCOUNTBANKID) + "fdaystartamt";
            result = (BigDecimal)resultMap.get(key1);
            if (result == null && (result = (BigDecimal)resultMap.get(key2)) == null) {
                result = FMConstants.ZERO;
            }
        } else if (dataType == CashDataTypeEnum.JF) {
            String key1 = this.genKey(FCOMPANYID, FACCOUNTVIEWID, FCURRENCYID, FACCOUNTBANKID) + "fdebitamt";
            String key2 = this.genKey(FCOMPANYID, "null", FCURRENCYID, FACCOUNTBANKID) + "fdebitamt";
            result = (BigDecimal)resultMap.get(key1);
            if (result == null && (result = (BigDecimal)resultMap.get(key2)) == null) {
                result = FMConstants.ZERO;
            }
        } else if (dataType == CashDataTypeEnum.DF) {
            String key1 = this.genKey(FCOMPANYID, FACCOUNTVIEWID, FCURRENCYID, FACCOUNTBANKID) + "fcreditamt";
            String key2 = this.genKey(FCOMPANYID, "null", FCURRENCYID, FACCOUNTBANKID) + "fcreditamt";
            result = (BigDecimal)resultMap.get(key1);
            if (result == null && (result = (BigDecimal)resultMap.get(key2)) == null) {
                result = FMConstants.ZERO;
            }
        }
        param.setValue((Object)result);
    }

    private Parameter getParam(SortedParameterArray params, String key) {
        Parameter param = null;
        for (int i = 0; i < params.size(); ++i) {
            String dataType;
            String keyDyn;
            String endDate;
            param = params.getParameter(i);
            Object[] args = this.getParams(param);
            String companyNumber = args[0].toString();
            if (FMHelper.isEmpty((String)companyNumber)) {
                companyNumber = this.reportCompanyNumber;
            }
            String dataSource = args[1].toString();
            String cashAccountView = args[2].toString();
            String bankAcctNum = args[3].toString();
            String currencyNum = args[5].toString();
            if (FMHelper.isEmpty((String)currencyNum)) {
                currencyNum = this.reportCurrencyNumber;
            }
            String oppAccoutNumber = args[4].toString();
            String beginDate = args[6].toString();
            if (FMHelper.isEmpty((String)beginDate)) {
                beginDate = FMHelper.formateDate((Date)this.reportBeginDate);
            }
            if (FMHelper.isEmpty((String)(endDate = args[7].toString()))) {
                endDate = FMHelper.formateDate((Date)this.reportEndDate);
            }
            if (!key.equals(keyDyn = this.genKey(companyNumber, dataSource, cashAccountView, oppAccoutNumber, bankAcctNum, currencyNum, beginDate, endDate, dataType = args[8].toString()))) continue;
            return param;
        }
        return param;
    }

    private String getIDByNumber_AcctView(String number) {
        for (int i = 0; i < this.listIdNumberAcctView.size(); ++i) {
            IdToNumber_AcctView info = (IdToNumber_AcctView)this.listIdNumberAcctView.get(i);
            if (!info.getNumber().equals(number)) continue;
            return info.getId();
        }
        return "";
    }

    public Map queryByDay(Date fromDate, Date toDate, Set accountPropertyIdSet, int amountUnit, Set bankIdSet, Set companyAllIdSet, String currencyId, boolean includeCash, int groupType, int level, Set accountViewIdSet, Set oppAccountIdSet) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)this.serverCtx).getCurrentCompany();
        PeriodInfo beginPeriodInfo = PeriodUtils.getPeriodInfo((Context)this.serverCtx, (Date)fromDate, (IObjectPK)new ObjectUuidPK(curCompany.getId()));
        StringBuffer sbState = new StringBuffer();
        sbState.append("SELECT ss.fcompanyid , sp.fid spfid,sp.FPERIODYEAR*100 + sp.FPERIODNUMBER startperiod,cp.fid cpfid, cp.FPERIODYEAR*100 + cp.FPERIODNUMBER curPeriod ");
        sbState.append(" FROM t_bd_systemstatusctrol ss, t_bd_period sp, t_bd_period cp");
        sbState.append(" WHERE ss.fstartperiodid = sp.fid AND ss.fcurrentperiodid = cp.fid");
        sbState.append(" and ss.FSYSTEMSTATUSID in (select fid from t_bd_systemstatus  where fname =7)");
        sbState.append(" and ss.fisstart=1");
        sbState.append(" and ");
        sbState.append(FMHelper.buildIn((String)"ss.fcompanyid", (Object[])companyAllIdSet.toArray()));
        IRowSet rs = DbUtil.executeQuery((Context)this.serverCtx, (String)sbState.toString());
        HashMap<String, HashSet<String>> otherCompany = new HashMap<String, HashSet<String>>();
        HashSet<String> okCompany = new HashSet<String>();
        HashSet<String> allCompany = new HashSet<String>();
        try {
            while (rs.next()) {
                if (beginPeriodInfo == null) {
                    String pkey = rs.getString("spfid");
                    HashSet<String> csSet = (HashSet<String>)otherCompany.get(pkey);
                    if (csSet == null) {
                        csSet = new HashSet<String>();
                        otherCompany.put(pkey, csSet);
                    }
                    csSet.add(rs.getString("fcompanyid"));
                    allCompany.add(rs.getString("fcompanyid"));
                    continue;
                }
                int beginKey = beginPeriodInfo.getPeriodYear() * 100 + beginPeriodInfo.getPeriodNumber();
                if (beginKey >= rs.getInt("startperiod") && beginKey <= rs.getInt("curPeriod")) {
                    okCompany.add(rs.getString("fcompanyid"));
                    allCompany.add(rs.getString("fcompanyid"));
                }
                if (beginKey <= rs.getInt("curPeriod")) continue;
                String pkey = rs.getString("cpfid");
                HashSet<String> csSet = (HashSet<String>)otherCompany.get(pkey);
                if (csSet == null) {
                    csSet = new HashSet<String>();
                    otherCompany.put(pkey, csSet);
                }
                csSet.add(rs.getString("fcompanyid"));
                allCompany.add(rs.getString("fcompanyid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        BigDecimal limit = FMConstants.ZERO;
        String tbl = this.getTableTableNameByDate(this.serverCtx);
        this.genBalanceByDate(this.serverCtx, tbl, okCompany, bankIdSet, beginPeriodInfo, currencyId, fromDate, toDate, accountViewIdSet, oppAccountIdSet);
        for (Map.Entry element : otherCompany.entrySet()) {
            String period = (String)element.getKey();
            Set otherCompanySet = (Set)element.getValue();
            PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)this.serverCtx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period));
            if (periodInfo == null) continue;
            this.genBalanceByDate(this.serverCtx, tbl, otherCompanySet, bankIdSet, periodInfo, currencyId, fromDate, toDate, accountViewIdSet, oppAccountIdSet);
        }
        FMQuerySqlBuilder sb = this.genResultByDate(amountUnit, groupType, includeCash, level, curCompany, limit, tbl);
        ResultSet rs1 = sb.exeQuery(this.serverCtx);
        try {
            String FCOMPANYID = "";
            String FACCOUNTVIEWID = "";
            String FCURRENCYID = "";
            String FACCOUNTBANKID = "";
            BigDecimal endBalance = FMConstants.ZERO;
            BigDecimal startBalance = FMConstants.ZERO;
            BigDecimal debitBalance = FMConstants.ZERO;
            BigDecimal creditBalance = FMConstants.ZERO;
            while (rs1.next()) {
                FCOMPANYID = rs1.getString("FCOMPANYID");
                FACCOUNTVIEWID = rs1.getString("FACCOUNTVIEWID");
                FCURRENCYID = rs1.getString("FCURRENCYID");
                FACCOUNTBANKID = rs1.getString("FACCOUNTBANKID");
                endBalance = rs1.getBigDecimal("FDAYENDAMT");
                startBalance = rs1.getBigDecimal("fdaystartamt");
                debitBalance = rs1.getBigDecimal("fdebitamt");
                creditBalance = rs1.getBigDecimal("fcreditamt");
                String key1 = this.genKey(FCOMPANYID, FACCOUNTVIEWID, FCURRENCYID, FACCOUNTBANKID);
                String key2 = this.genKey(FCOMPANYID, "null", FCURRENCYID, FACCOUNTBANKID);
                returnMap.put(key1, endBalance);
                returnMap.put(key2, endBalance);
                returnMap.put(key1 + "fdaystartamt", startBalance);
                returnMap.put(key2 + "fdaystartamt", startBalance);
                returnMap.put(key1 + "fdebitamt", debitBalance);
                returnMap.put(key2 + "fdebitamt", debitBalance);
                returnMap.put(key1 + "fcreditamt", creditBalance);
                returnMap.put(key2 + "fcreditamt", creditBalance);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }

    private FMQuerySqlBuilder genResultByDate(int amountUnit, int groupType, boolean includeCash, int level, CompanyOrgUnitInfo curCompany, BigDecimal limit, String tbl) throws BOSException {
        this.prepareDate(this.serverCtx, groupType, level, tbl);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" SELECT isnull(jb.fcompanyid,'0') fcompanyid , jb.faccountviewid, jb.fcurrencyid, isnull(jb.faccountbankid,'0') faccountbankid,");
        sb.appendSql(CashBatchCaculator.appUnit(" jb.fdaystartamt", " fdaystartamt", amountUnit));
        sb.appendSql(CashBatchCaculator.appUnit(" jb.fdebitamt", " fdebitamt", amountUnit));
        sb.appendSql(CashBatchCaculator.appUnit(" jb.fcreditamt", " fcreditamt", amountUnit));
        sb.appendSql(CashBatchCaculator.appUnit(" jb.fdayendamt", "fdayendamt", amountUnit));
        sb.appendSql(" isnull(jb.FAccountPropertyID,'00') FAccountPropertyID,");
        sb.appendSql(" isnull(jb.fbankid,'00') fbankId");
        sb.appendSql(" FROM " + tbl + " jb ");
        sb.appendSql(" where 1=1");
        if (!includeCash) {
            sb.appendSql(" and jb.faccountbankid is not null");
        }
        return sb;
    }

    public static String appUnit(String colName, String alia, int unit) {
        return colName + "/" + unit + " " + alia + ", ";
    }

    private void prepareDate(Context ctx, int groupType, int level, String tbl) throws BOSException {
        String sql = "update " + tbl + " set (fbankid, FAccountPropertyID) = (select t_bd_accountbanks.fbank ,t_bd_accountbanks.FPropertyID from t_bd_accountbanks where t_bd_accountbanks.fid = " + tbl + ".faccountbankid)";
        DbUtil.execute((Context)ctx, (String)sql);
        String sqluplevel = null;
        if (level > 0) {
            switch (groupType) {
                case 1: {
                    sqluplevel = "update " + tbl + " set (fbankid,FKey) =(select p.fid,null from  t_bd_bank p, t_bd_bank c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fbankid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    break;
                }
                case 2: {
                    sqluplevel = "update " + tbl + " set (fcompanyid,FKey) =(select p.fid, null from  t_org_company p, t_org_company c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fCompanyid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    break;
                }
                case 3: {
                    sqluplevel = "update " + tbl + " set (fcompanyid,FKey) =(select p.fid, null from  t_org_company p, t_org_company c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fCompanyid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    break;
                }
                default: {
                    sqluplevel = "update " + tbl + " set (fbankid,FKey) =(select p.fid,null from  t_bd_bank p, t_bd_bank c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fbankid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                }
            }
        }
    }

    private String getTableTableNameByDate(Context ctx) throws BOSException {
        String tbl = this.getTempTableName("casbalance", ctx);
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("FCOMPANYID        varchar(44),");
        createTableSql.append("FKey        varchar(44),");
        createTableSql.append("FBANKID           varchar(44),");
        createTableSql.append("FACCOUNTVIEWID    varchar(44),");
        createTableSql.append("FAccountPropertyID    varchar(44),");
        createTableSql.append("FCURRENCYID       varchar(44),");
        createTableSql.append("FACCOUNTBANKID    varchar(44),");
        createTableSql.append("FPERIODID         varchar(44),");
        createTableSql.append("FDAYSTARTAMT       NUMERIC(19,4) ,");
        createTableSql.append("FDEBITAMT          NUMERIC(19,4),");
        createTableSql.append("FCREDITAMT         NUMERIC(19,4),");
        createTableSql.append("FDAYENDAMT         NUMERIC(19,4) ");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        return tbl;
    }

    public String getTempTableName(String desc, Context ctx) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(desc);
    }

    private void genBalanceByDate(Context ctx, String tbl, Set companyIdSet, Set bankids, PeriodInfo periodId, String currencyId, Date fromDate, Date toDate, Set accountViewIdSet, Set oppAccountidSet) throws BOSException {
        if (companyIdSet.size() == 0) {
            return;
        }
        if (periodId == null) {
            return;
        }
        FMQuerySqlBuilder sbfirst = this.getFirstPeriodByDate(companyIdSet, bankids, periodId, currencyId, tbl, fromDate, toDate, accountViewIdSet, oppAccountidSet);
        sbfirst.execute(ctx);
    }

    private FMQuerySqlBuilder getFirstPeriodByDate(Set companyIdSet, Set bankids, PeriodInfo beginPeriodId, String currencyId, String tbl, Date fromDate, Date toDate, Set accountViewIdSet, Set oppAccountIdSet) {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("insert into ");
        sb.appendSql(tbl);
        sb.appendSql(" (");
        sb.appendSql(" fcompanyid, faccountviewid, fcurrencyid, faccountbankid,");
        sb.appendSql(" fdaystartamt,fdebitamt,");
        sb.appendSql(" fcreditamt, fdayendamt ");
        sb.appendSql(" )");
        sb.appendSql(" SELECT   s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid, ");
        sb.appendSql(" SUM (s.fmonthstartamt),");
        sb.appendSql("  SUM (s.fmonthdebitamt), SUM (s.fmonthcreditamt), ");
        sb.appendSql("  SUM (s.fmonthstartamt) + SUM (s.fmonthdebitamt) - SUM (s.fmonthcreditamt) fmonthbalance ");
        sb.appendSql("  FROM (");
        sb.appendSql(" SELECT  jb.fcompanyid, jb.faccountviewid, jb.fcurrencyid, jb.faccountbankid,");
        sb.appendSql(" jb.fmonthstartamt,");
        sb.appendSql(" 0 fmonthdebitamt, 0 fmonthcreditamt,jb.fmonthstartamt fmonthbalance ");
        sb.appendSql("  FROM t_cas_journalbalance jb");
        sb.appendSql("  WHERE ftype in(1,2) and fisinit=0");
        sb.appendFilter("jb.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("jb.fperiodid", FMHelper.asSet((String)beginPeriodId.getId().toString()), CompareType.INCLUDE);
        sb.appendFilter("jb.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (accountViewIdSet != null && accountViewIdSet.size() > 0) {
            sb.appendFilter("jb.faccountviewid", accountViewIdSet, CompareType.INCLUDE);
        }
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        if (oppAccountIdSet != null && oppAccountIdSet.size() > 0) {
            sb.appendFilter("jb.faccountviewid", oppAccountIdSet, CompareType.INCLUDE);
        }
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  0 fmonthstartamt,");
        sb.appendSql("    SUM (fdebitamount) fmonthdebitamt, SUM (fcreditamount) fmonthcreditamt, 0 fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)fromDate).toString());
        sb.appendSql("} and j.FCreateDate <= {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (accountViewIdSet != null && accountViewIdSet.size() > 0) {
            sb.appendFilter("j.faccountviewid", accountViewIdSet, CompareType.INCLUDE);
        }
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR j.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        if (oppAccountIdSet != null && oppAccountIdSet.size() > 0) {
            sb.appendFilter("j.faccountviewid", oppAccountIdSet, CompareType.INCLUDE);
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  SUM (fdebitamount-fcreditamount) fmonthstartamt,");
        sb.appendSql("    0 fmonthdebitamt, 0 fmonthcreditamt, 0 fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)beginPeriodId.getBeginDate()).toString());
        sb.appendSql("} and j.FCreateDate < {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)fromDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (accountViewIdSet != null && accountViewIdSet.size() > 0) {
            sb.appendFilter("j.faccountviewid", accountViewIdSet, CompareType.INCLUDE);
        }
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR j.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        if (oppAccountIdSet != null && oppAccountIdSet.size() > 0) {
            sb.appendFilter("j.faccountviewid", oppAccountIdSet, CompareType.INCLUDE);
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  0 fmonthstartamt,");
        sb.appendSql("    0 fmonthdebitamt, 0 fmonthcreditamt, SUM (fdebitamount-fcreditamount) fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)beginPeriodId.getBeginDate()).toString());
        sb.appendSql("} and j.FCreateDate <= {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (accountViewIdSet != null && accountViewIdSet.size() > 0) {
            sb.appendFilter("j.faccountviewid", accountViewIdSet, CompareType.INCLUDE);
        }
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR j.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        if (oppAccountIdSet != null && oppAccountIdSet.size() > 0) {
            sb.appendFilter("j.faccountviewid", oppAccountIdSet, CompareType.INCLUDE);
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql(" \t\t  ) s");
        sb.appendSql(" GROUP BY s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid ");
        return sb;
    }

    private String genKey(String fcompanyid, String faccountviewid, String fcurrencyid, String faccountbankid) {
        StringBuffer sb = new StringBuffer();
        sb.append("fcompanyid--");
        if (fcompanyid == null) {
            sb.append("null");
        } else {
            sb.append(fcompanyid);
        }
        sb.append("faccountviewid--");
        if (faccountviewid == null) {
            sb.append("null");
        } else {
            sb.append(faccountviewid);
        }
        sb.append("fcurrencyid--");
        if (fcurrencyid == null) {
            sb.append("null");
        } else {
            sb.append(fcurrencyid);
        }
        sb.append("faccountbankid--");
        if (faccountbankid == null) {
            sb.append("null");
        } else {
            sb.append(faccountbankid);
        }
        return sb.toString();
    }

    private String getIDByNumber_Company(String companyNumber) {
        if (this.mapIdNumberCompany.get(companyNumber) != null) {
            return (String)this.mapIdNumberCompany.get(companyNumber);
        }
        return "";
    }

    private String getIDByNumber_Currency(String currencyNumber) {
        if (this.mapIdNumberCurrency.get(currencyNumber) != null) {
            return (String)this.mapIdNumberCompany.get(currencyNumber);
        }
        return "";
    }

    private String getIDByNumber_BankAcct(String bankAcctNumber) {
        if (this.mapIdNumberBankAcct.get(bankAcctNumber) != null) {
            return (String)this.mapIdNumberBankAcct.get(bankAcctNumber);
        }
        return "0";
    }

    private Set getAccountViewIds(String accountViewNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)accountViewNum) || accountViewNum.equals("")) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid,Fnumber from t_bd_accountview where 1=1");
        if (!StringUtils.isEmpty((String)accountViewNum)) {
            if (accountViewNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = accountViewNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(accountViewNum.trim()).append("'");
            }
        }
        HashSet<String> acctViewIdSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.serverCtx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                acctViewIdSet.add(rs.getString("FID"));
                this.listIdNumberAcctView.add(new IdToNumber_AcctView(rs.getString("FID"), rs.getString("Fnumber")));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (acctViewIdSet.size() > 0) {
            return acctViewIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private Set getOppAccountIds(String oppAccountNumber) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)oppAccountNumber) || oppAccountNumber.equals("")) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid,Fnumber from t_bd_accountview where 1=1");
        if (!StringUtils.isEmpty((String)oppAccountNumber)) {
            if (oppAccountNumber.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = oppAccountNumber.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(oppAccountNumber.trim()).append("'");
            }
        }
        HashSet<String> acctViewIdSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.serverCtx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                acctViewIdSet.add(rs.getString("FID"));
                this.listIdNumberAcctView.add(new IdToNumber_AcctView(rs.getString("FID"), rs.getString("Fnumber")));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (acctViewIdSet.size() > 0) {
            return acctViewIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private Set getBankAcctIds(String bankAcctNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)bankAcctNum) || bankAcctNum.equals("")) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid,Fnumber from t_bd_accountbanks where 1=1");
        if (!StringUtils.isEmpty((String)bankAcctNum)) {
            if (bankAcctNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = bankAcctNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(bankAcctNum.trim()).append("'");
            }
        }
        HashSet<String> bankAcctIdSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.serverCtx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                bankAcctIdSet.add(rs.getString("FID"));
                this.listIdNumberBankAcct.add(new IdToNumber_AcctBank(rs.getString("FID"), rs.getString("Fnumber")));
                this.mapIdNumberBankAcct.put(rs.getString("Fnumber"), rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (bankAcctIdSet.size() > 0) {
            return bankAcctIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private Set getCompanyIds(String companyNum) throws BOSException {
        if (FMHelper.isEmpty((String)companyNum)) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid,FNumber from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(nums[i].trim()).append("!%' )");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        IRowSet rs = DbUtil.executeQuery((Context)this.serverCtx, (String)sql.toString());
        try {
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
                this.mapIdNumberCompany.put(rs.getString("fnumber"), rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (idSet.size() > 0) {
            return idSet;
        }
        return null;
    }

    private String getCurrencyId(String currencyNum) throws BOSException, CasDataException {
        if (FMHelper.isEmpty((String)currencyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select fid,fnumber from t_bd_currency where 1=1 ");
        if (!StringUtils.isEmpty((String)currencyNum)) {
            if (currencyNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = currencyNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(currencyNum.trim()).append("'");
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.serverCtx, (String)sql.toString());
        try {
            if (rs.next()) {
                this.mapIdNumberCurrency.put(rs.getString("fnumber"), rs.getString("fid"));
                return rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        throw new CasDataException(CasDataException.NULL_CURRENCY);
    }

    private Map getNumbers(List paramVOs) {
        ParamsVO vo = null;
        StringBuffer sbCompanyNumber = new StringBuffer();
        StringBuffer sbCashAccountView = new StringBuffer();
        StringBuffer sbOppAccountNumber = new StringBuffer();
        StringBuffer sbBankAcctNum = new StringBuffer();
        StringBuffer sbCurrency = new StringBuffer();
        String companyNumber = "";
        String accountViewNumber = "";
        String oppAccountNumber = "";
        String bankAcctNumber = "";
        String currencyNumber = "";
        for (int i = 0; i < paramVOs.size(); ++i) {
            vo = (ParamsVO)paramVOs.get(i);
            companyNumber = vo.getCompanyNumber();
            if (companyNumber != null && !"".equals(companyNumber.trim())) {
                sbCompanyNumber.append(companyNumber).append(";");
            }
            if ((accountViewNumber = vo.getCashAccountView()) != null && !"".equals(accountViewNumber.trim())) {
                sbCashAccountView.append(accountViewNumber).append(";");
            }
            if ((bankAcctNumber = vo.getBankAcctNum()) != null && !"".equals(bankAcctNumber.trim())) {
                sbBankAcctNum.append(bankAcctNumber).append(";");
            }
            if ((oppAccountNumber = vo.getOppAccountNumber()) != null && !"".equals(oppAccountNumber.trim())) {
                sbOppAccountNumber.append(oppAccountNumber).append(";");
            }
            if ((currencyNumber = vo.getCurrencyNum()) == null || "".equals(currencyNumber.trim())) continue;
            sbCurrency.append(currencyNumber).append(";");
        }
        HashMap<String, String> hmTest = new HashMap<String, String>();
        hmTest.put("companyNumber", sbCompanyNumber.toString());
        hmTest.put("accountViewNumber", sbCashAccountView.toString());
        hmTest.put("bankAcctNumber", sbBankAcctNum.toString());
        hmTest.put("oppAccountNumber", sbOppAccountNumber.toString());
        hmTest.put("currencyNumber", sbCurrency.toString());
        return hmTest;
    }

    private Map GroupByCompanyAndDate(SortedParameterArray params) throws BOSException, EASBizException {
        HashMap<String, Cloneable> hmReturn = new HashMap<String, Cloneable>();
        HashMap hmReturn_batch = new HashMap();
        ArrayList<Parameter> nonBatchList = new ArrayList<Parameter>();
        Object paramList = null;
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.getParameter(i);
            Object[] args = this.getParams(param);
            String companyNumber = args[0].toString();
            if (FMHelper.isEmpty((String)companyNumber)) {
                companyNumber = this.reportCompanyNumber;
            }
            String dataSource = args[1].toString();
            String cashAccountView = args[2].toString();
            String bankAcctNum = args[3].toString();
            String currencyNum = args[5].toString();
            if (FMHelper.isEmpty((String)currencyNum)) {
                currencyNum = this.reportCurrencyNumber;
            }
            String oppAccountNumber = args[4].toString();
            String beginDate = args[6].toString();
            String endDate = args[7].toString();
            String dataType = args[8].toString();
            CompanyOrgUnitCollection col = null;
            if (this.companyMap_forGroupCompany.containsKey(companyNumber)) {
                col = (CompanyOrgUnitCollection)this.companyMap_forGroupCompany.get(companyNumber);
            } else {
                col = CompanyOrgUnitFactory.getLocalInstance((Context)this.serverCtx).getCompanyOrgUnitCollection("select * where number = '" + companyNumber + "'");
                this.companyMap_forGroupCompany.put(companyNumber, col);
            }
            if (col.isEmpty()) {
                param.setValue((Object)"error");
                nonBatchList.add(param);
                continue;
            }
            if (this.belongsNonBatch(CashDataTypeEnum.getEnum(dataType)) || col.get(0).isIsBizUnit()) {
                // empty if block
            }
            nonBatchList.add(param);
        }
        hmReturn.put("batch", hmReturn_batch);
        hmReturn.put("nonbatch", nonBatchList);
        return hmReturn;
    }

    private boolean belongsNonBatch(CashDataTypeEnum dataType) {
        return dataType != CashDataTypeEnum.JF && dataType != CashDataTypeEnum.DF && dataType != CashDataTypeEnum.Y && dataType != CashDataTypeEnum.C;
    }

    private String genKey(String companyNumber, String dataSource, String cashAccountView, String oppAccountNumber, String bankAcctNum, String currencyNum, String beginDate, String endDate, String dataType) {
        return "company-" + companyNumber + "begindate-" + beginDate + "enddate-" + endDate;
    }

    static class ParamsVO {
        String companyNumber;
        CashDataSourceEnum dataSource;
        String cashAccountView;
        String oppAccountNumber;
        String bankAcctNum;
        String currencyNum;
        Date beginDate;
        Date endDate;
        CashDataTypeEnum dataType;
        DateFormat FORMAT_DAY = new SimpleDateFormat("yyyy-MM-dd");

        public ParamsVO(String companyNumber, String dataSource, String cashAccountView, String oppAccountNumber, String bankAcctNum, String currencyNum, String beginDate, String endDate, String dataType) {
            this.companyNumber = companyNumber;
            if (dataSource != null && !dataSource.equals("")) {
                this.dataSource = CashDataSourceEnum.getEnum(dataSource);
            }
            this.cashAccountView = cashAccountView;
            this.bankAcctNum = bankAcctNum;
            this.oppAccountNumber = oppAccountNumber;
            this.currencyNum = currencyNum;
            if (beginDate != null && !beginDate.equals("")) {
                try {
                    this.beginDate = this.FORMAT_DAY.parse(beginDate);
                }
                catch (ParseException e) {
                    this.beginDate = this.getDayBegin();
                }
            }
            if (dataType != null && !dataType.equals("")) {
                try {
                    this.endDate = this.FORMAT_DAY.parse(endDate);
                }
                catch (ParseException e) {
                    this.endDate = this.getDayBegin();
                }
            }
            if (dataType != null && !dataType.equals("")) {
                this.dataType = CashDataTypeEnum.getEnum(dataType);
            }
        }

        public String getOppAccountNumber() {
            return this.oppAccountNumber;
        }

        public String getBankAcctNum() {
            return this.bankAcctNum;
        }

        public Date getBeginDate() {
            return this.beginDate;
        }

        public String getCompanyNumber() {
            return this.companyNumber;
        }

        public String getCurrencyNum() {
            return this.currencyNum;
        }

        public CashDataSourceEnum getDataSource() {
            return this.dataSource;
        }

        public CashDataTypeEnum getDataType() {
            return this.dataType;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public Date getDayBegin() {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }

        public String getCashAccountView() {
            return this.cashAccountView;
        }
    }

    static class IdToNumber_Company {
        private String id;
        private String number;

        public IdToNumber_Company(String id, String number) {
            this.id = id;
            this.number = number;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    static class IdToNumber_AcctView {
        private String id;
        private String number;

        public IdToNumber_AcctView(String id, String number) {
            this.id = id;
            this.number = number;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    static class IdToNumber_AcctBank {
        private String id;
        private String number;

        public IdToNumber_AcctBank(String id, String number) {
            this.id = id;
            this.number = number;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    static class IdToNumber_Currency {
        private String id;
        private String number;

        public IdToNumber_Currency(String id, String number) {
            this.id = id;
            this.number = number;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }
}

