/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.subacct.client.AbstractRptSubAcctSumFilterUI;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptSubAcctSumFilterUI
extends AbstractRptSubAcctSumFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptSubAcctSumFilterUI.class);
    public CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo localCcurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);

    public void onLoad() throws Exception {
        super.onLoad();
        FMClientHelper.initComboCurrency((KDComboBox)this.cboCurrency, (boolean)true);
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.localCcurrency);
        this.cboUnit.setSelectedItem((Object)AmountUnitEnum.yuan);
        this.initAccountBank((IUIObject)this, this.prmtBankAcct);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public void clear() {
        super.clear();
        this.cboUnit.setSelectedItem((Object)AmountUnitEnum.yuan);
        this.prmtBankAcct.setValue(null);
        this.prmtSubBankAcct.setValue(null);
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.localCcurrency);
    }

    public void setCustomerParams(RptParams params) {
        RptConditionManager rm = new RptConditionManager(params);
        rm.restoreAllStatus((Container)((Object)this));
        try {
            Set bankAcctIdSet = (Set)params.getObject("bankAcctIdSet");
            CoreBaseInfo[] c = RptFmClientUtil.getBaseInfoFromIdSet((Set)bankAcctIdSet);
            this.prmtBankAcct.setData((Object)c);
            Set subBankAcctIdSet = (Set)params.getObject("subBankAcctIdSet");
            CoreBaseInfo[] c2 = RptFmClientUtil.getBaseInfoFromIdSet((Set)subBankAcctIdSet);
            this.prmtSubBankAcct.setData((Object)c2);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this));
        Set bankAcctIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtBankAcct));
        Set subbankAcctIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtSubBankAcct));
        rm.setProperty("bankAcctIdSet", (Object)bankAcctIdSet);
        rm.setProperty("subBankAcctIdSet", (Object)subbankAcctIdSet);
        return rm.toRptParams();
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpStartDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpEndDate);
        Date startDate = this.dpStartDate.getSqlDate();
        Date endDate = this.dpEndDate.getSqlDate();
        PeriodInfo startPeriod = null;
        try {
            startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (FMHelper.isEmpty((CoreBaseInfo)startPeriod)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"429_RptSubAcctSumFilterUI"));
            SysUtil.abort();
        }
        if (startPeriod.getBeginDate().after(startDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"430_RptSubAcctSumFilterUI"));
            SysUtil.abort();
        }
        if (startDate.after(endDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_RptSubAcctSumFilterUI"));
            SysUtil.abort();
        }
        return true;
    }

    @Override
    protected void prmtBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBankAcct_dataChanged(e);
        this.prmtSubBankAcct.setValue(null);
    }

    @Override
    protected void prmtSubBankAcct_willCommit(CommitEvent e) throws Exception {
        this.resetSubBankAcctEntityView();
    }

    private void resetSubBankAcctEntityView() {
        Set bankAcctIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtBankAcct));
        this.prmtSubBankAcct.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        if (bankAcctIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)bankAcctIdSet, CompareType.INCLUDE));
        }
        evi.setFilter(filter);
        this.prmtSubBankAcct.setEntityViewInfo(evi);
    }

    @Override
    protected void prmtSubBankAcct_willShow(SelectorEvent e) throws Exception {
        this.resetSubBankAcctEntityView();
    }

    public void initAccountBank(IUIObject coreui, KDBizPromptBox prmtAccountBank) {
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isMotherAccount", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        entryViewInfo.setFilter(filter);
        prmtAccountBank.setEntityViewInfo(entryViewInfo);
        prmtAccountBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        prmtAccountBank.setDisplayFormat("$number$ $name$");
        prmtAccountBank.setEditFormat("$number$");
        prmtAccountBank.setCommitFormat("$number$;$name$");
    }
}

