/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.subacct.ISubAcctFinalCheckoutFacade;
import com.kingdee.eas.fi.cas.subacct.ISubAcctMgtInitFacade;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceFactory;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceInfo;
import com.kingdee.eas.fi.cas.subacct.SubAcctFinalCheckoutFacadeFactory;
import com.kingdee.eas.fi.cas.subacct.SubAcctMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.subacct.client.AbstractSubAccountMgtInitUI;
import com.kingdee.eas.fi.cas.subacct.client.AbstractSubAcctMgtInitHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;

public class SubAccountMgtInitUI
extends AbstractSubAccountMgtInitUI {
    private static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    private AbstractSubAcctMgtInitHandler handler;
    private PeriodInfo startPeriodInfo;
    private CompanyOrgUnitInfo company;
    private CurrencyInfo currency;
    private KDFormattedTextField txtField;
    private CalculatorDialog calc;
    private boolean isEdit = false;
    private boolean isSave = false;
    private boolean isCurrencyFirst = false;
    private boolean isLoaded = false;
    private boolean isFirstPeriod;
    private boolean shouldReloadPrintVar = true;

    protected KDTDefaultCellEditor getNumberEditor() {
        this.setTxtField();
        KDTDefaultCellEditor tmpNumberEditor = new KDTDefaultCellEditor((JTextField)this.txtField);
        tmpNumberEditor.setClickCountToStart(1);
        return tmpNumberEditor;
    }

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        this.setTxtField();
        int column = this.tblMain.getSelectManager().getActiveColumnIndex();
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        if (this.calc == null) {
            this.calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        }
        this.calc.setInitValue(null);
        BigDecimal number = this.calc.showDialog(2, true);
        ICell selectedCell = this.tblMain.getCell(row, column);
        if (selectedCell != null && !selectedCell.getStyleAttributes().isLocked() && number != null) {
            FMClientHelper.setNumberValueForCell((Component)((Object)this), (ICell)selectedCell, (BigDecimal)number);
            this.tblMain_editStopped(null);
        }
    }

    protected void btnCalculator_actionPerformed(ActionEvent e) throws Exception {
        this.setTxtField();
        int column = this.tblMain.getSelectManager().getActiveColumnIndex();
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        if (this.calc == null) {
            this.calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        }
        this.calc.setInitValue(null);
        BigDecimal number = this.calc.showDialog(2, true);
        ICell selectedCell = this.tblMain.getCell(row, column);
        if (selectedCell != null && !selectedCell.getStyleAttributes().isLocked() && number != null) {
            selectedCell.setValue((Object)number);
            this.tblMain_editStopped(null);
        }
    }

    private void setTxtField() {
        if (this.txtField == null) {
            this.txtField = new KDFormattedTextField(1);
        }
        this.txtField.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.currency.getId()));
        this.txtField.setHorizontalAlignment(4);
        this.txtField.setDataVerifierType(-1);
        this.txtField.setSupportedEmpty(true);
        this.txtField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        this.txtField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.btnRefresh_actionPerformed(e);
        this.initUI();
        this.loadFields();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getIsInit(this.company)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckSubmit"));
            SysUtil.abort();
        }
        this.handler.storeField(this.tblMain);
        this.isSave = true;
        this.isEdit = false;
        this.showStatusMessage(AbstractSubAcctMgtInitHandler.SAVESUCCESS);
        this.btnRefresh_actionPerformed(null);
    }

    private boolean getIsInit(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
    }

    private void showStatusMessage(String msg) {
        this.setMessageText(msg);
        this.showMessage();
    }

    @Override
    public void actionFinishInit_actionPerformed(ActionEvent e) throws Exception {
        super.actionFinishInit_actionPerformed(e);
        this.finishInit();
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.getIsInit(this.company)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckSubmit"));
            this.setWorkButtonForInit(true);
            SysUtil.abort();
        }
        super.actionImport_actionPerformed(e);
        this.startPeriodInfo = CashClientHelper.getStartPeriod(this.company);
        this.handler.importFromJournalToInit(this.tblMain, this.startPeriodInfo.getId().toString());
        this.showStatusMessage(EASResource.getString((String)resourcePath, (String)"cm76"));
        if (this.handler.isImportChanged()) {
            this.isEdit = true;
            this.isSave = false;
        }
    }

    @Override
    public void actionInitAgain_actionPerformed(ActionEvent e) throws Exception {
        super.actionInitAgain_actionPerformed(e);
        this.antiInit();
    }

    private void antiInit() throws EASBizException, BOSException {
        ISubAcctMgtInitFacade iSubAcctMgtInitFacade = SubAcctMgtInitFacadeFactory.getRemoteInstance();
        String strCompanyId = this.company.getId().toString();
        String strPeriodId = this.startPeriodInfo.getId().toString();
        iSubAcctMgtInitFacade.antiInit(strCompanyId, strPeriodId);
        this.setWorkButtonForInit(false);
        this.handler.initKDTableFormatter(this.tblMain);
        this.showStatusMessage(EASResource.getString((String)resourcePath, (String)"cm41"));
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (!this.getIsInit(this.company)) {
            this.changeButtonStatus();
        }
    }

    private void changeButtonStatus() {
    }

    public static boolean isZERO(BigDecimal o) {
        return o == null || o.compareTo(FMConstants.ZERO) == 0;
    }

    public boolean isRowNotValid(IRow row) {
        Object debitObj = row.getCell("yearDebitAmount").getValue();
        Object creditObj = row.getCell("yearCreditAmount").getValue();
        Object balanceObj = row.getCell("beginBalance").getValue();
        boolean isDebitNotValid = AbstractSubAcctMgtInitHandler.isNull(debitObj);
        boolean isCreditNotValid = AbstractSubAcctMgtInitHandler.isNull(creditObj);
        boolean isBalanceNotValid = AbstractSubAcctMgtInitHandler.isNull(balanceObj);
        boolean isRowNotValid = isDebitNotValid || isCreditNotValid || isBalanceNotValid;
        return isRowNotValid;
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        if (this.isLoaded) {
            return;
        }
        if (!this.isCurrencyFirst && this.handler.getCurrency().equals(this.cboCurrency.getSelectedItem())) {
            return;
        }
        this.isCurrencyFirst = false;
        super.cboCurrency_actionPerformed(e);
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckSaveAndSwitch"));
        } else {
            this.initUI();
            this.loadFields();
        }
        switch (flag) {
            case 0: {
                this.actionSubmit_actionPerformed(null);
            }
            case 1: {
                this.initUI();
                this.cboCurrency.setSelectedItem((Object)this.handler.getCurrency());
                this.loadFields();
            }
            case 2: {
                this.cboCurrency.setSelectedItem((Object)this.handler.getCurrency());
                return;
            }
        }
    }

    @Override
    public void loadFields() {
        try {
            this.handler.loadField(this.tblMain);
            if (!this.handler.isDisplayImport()) {
                this.ActionImport.setEnabled(false);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void initUI() throws Exception {
        this.isEdit = false;
        this.isSave = false;
        FMClientHelper.clearTable((KDTable)this.tblMain);
        if (!this.getIsInit(this.company)) {
            this.ActionImport.setVisible(true);
            this.ActionImport.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.tblMain.getStyleAttributes().setLocked(false);
        } else {
            this.ActionImport.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.tblMain.getStyleAttributes().setLocked(true);
        }
        this.handler = AbstractSubAcctMgtInitHandler.getInstance(null);
        this.currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        this.handler.setCurrency(this.currency);
        this.handler.setCompanyInfo(this.company);
        this.startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
        this.handler.setPeriodInfo(this.startPeriodInfo);
        this.handler.setNumberEditor((ICellEditor)this.getNumberEditor());
        this.handler.initTable(this.tblMain, this.isFirstPeriod);
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
    }

    @Override
    protected void tblMain_editStarted(KDTEditEvent e) throws Exception {
        super.tblMain_editStarted(e);
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        super.tblMain_editStarting(e);
    }

    protected IObjectValue createNewData() {
        return new SubAccountBalanceInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SubAccountBalanceFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        this.isCurrencyFirst = true;
        this.isLoaded = true;
        this.tblMain.checkParsed();
        this.init();
        this.initUI();
        super.onLoad();
        ItemAction restoreAction = this.tHelper.getActionRestoreDefault(this.tblMain);
        restoreAction.setVisible(false);
        ItemAction showRefAction = this.tHelper.getActionShowPreference(this.tblMain);
        showRefAction.setVisible(false);
        ItemAction saveAction = this.tHelper.getActionSave(this.tblMain);
        saveAction.setVisible(false);
        this.actionSave.setEnabled(false);
        this.isLoaded = false;
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.handler.initKDTableFormatter(this.tblMain);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_importfromzz"));
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.btnFinishInit.setIcon(EASResource.getIcon((String)"imgTbtn_closeinitialize"));
        this.btnInitAgain.setIcon(EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.ActionImport.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_input"));
        this.actionFinishInit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.actionInitAgain.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.actionCalculator.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_counter"));
        this.actionSubmitOption.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_new"));
    }

    public void finishInit() throws Exception {
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckSaveMsg"));
        }
        switch (flag) {
            case 2: {
                this.btnRefresh_actionPerformed(null);
                return;
            }
            case 1: {
                this.btnRefresh_actionPerformed(null);
            }
            case 0: {
                this.actionSubmit_actionPerformed(null);
            }
        }
        if (this.getIsInit(this.company)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckSubmit"));
            this.setWorkButtonForInit(true);
            SysUtil.abort();
        }
        ISubAcctMgtInitFacade iSubAcctMgtInitFacade = SubAcctMgtInitFacadeFactory.getRemoteInstance();
        String strCompanyId = this.company.getId().toString();
        String strPeriodId = this.startPeriodInfo.getId().toString();
        iSubAcctMgtInitFacade.finishInit(strCompanyId, strPeriodId);
        this.setWorkButtonForInit(true);
        this.handler.initKDTableFormatter(this.tblMain);
        this.showStatusMessage(EASResource.getString((String)resourcePath, (String)"cm21"));
    }

    private void setWorkButtonForInit(boolean isUsed) {
        this.kDMenuItemInit.setVisible(false);
        this.kDMenuItemAntiInit.setVisible(false);
        this.ActionImport.setEnabled(!isUsed);
        this.actionSave.setEnabled(!isUsed);
        this.actionSubmit.setEnabled(!isUsed);
        this.tblMain.getStyleAttributes().setLocked(isUsed);
    }

    public void init() throws Exception {
        this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        ClientUtils.checkCompany((Component)((Object)this), this.company);
        this.startPeriodInfo = CashClientHelper.getStartPeriod(this.company);
        if (this.startPeriodInfo.isIsAdjustPeriod()) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"startPeriodIsAdjust"));
            SysUtil.abort();
        }
        this.txtStartPeriod.setText(this.startPeriodInfo.toString());
        this.isFirstPeriod = this.startPeriodInfo.getPeriodNumber() == 1;
        FMClientHelper.initComboCurrency((KDComboBox)this.cboCurrency, (boolean)true);
        if (this.getIsInit(this.company)) {
            this.setWorkButtonForInit(true);
        } else {
            this.setWorkButtonForInit(false);
        }
    }

    public IRow getSelectedRow(KDTable tblMain) {
        this.checkSelected();
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            SysUtil.abort();
        }
        IRow row = tblMain.getRow(selectBlock.getTop());
        return row;
    }

    public void checkSelected() {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public boolean checkBeforeWindowClosing() {
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckSaveAndExit"));
        }
        this.savePrintSetting(this.getTableForPrintSetting());
        switch (flag) {
            case 0: {
                this.saveData();
                return super.checkBeforeWindowClosing();
            }
            case 1: {
                return super.checkBeforeWindowClosing();
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    private void saveData() {
        try {
            if (this.getIsInit(this.company)) {
                MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckSubmit"));
                SysUtil.abort();
            }
            this.handler.storeField(this.tblMain);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String sCurrency = this.lblCurrency.getBoundLabelText() + ": &[currency]";
        String sAccount = this.lblStartPeriod.getBoundLabelText() + " &[startPeriod]";
        headerModel.addRow(sCurrency + "&|" + sAccount);
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionAntiFinal_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiFinal_actionPerformed(e);
        String companyId = this.company.getId().toString();
        ISubAcctFinalCheckoutFacade iSubAcctFinalCheckoutFacade = SubAcctFinalCheckoutFacadeFactory.getRemoteInstance();
        iSubAcctFinalCheckoutFacade.deleteCheckAccount(companyId);
    }

    @Override
    public void actionFinal_actionPerformed(ActionEvent e) throws Exception {
        super.actionFinal_actionPerformed(e);
        String companyId = this.company.getId().toString();
        ISubAcctFinalCheckoutFacade iSubAcctFinalCheckoutFacade = SubAcctFinalCheckoutFacadeFactory.getRemoteInstance();
        iSubAcctFinalCheckoutFacade.finalCheckAccount(companyId);
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            Map varMap = null;

            MyExtVarProvider() {
                this.initVarMap();
            }

            private void initVarMap() {
                this.varMap = SubAccountMgtInitUI.this.preparePrintVariantMap();
            }

            public Variant requestVarData(String varName) {
                if (SubAccountMgtInitUI.this.shouldReloadPrintVar) {
                    this.initVarMap();
                }
                if (this.varMap == null) {
                    return null;
                }
                Object obj = this.varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }

    private Map preparePrintVariantMap() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("currency", this.cboCurrency.getSelectedItem());
        hm.put("startPeriod", this.txtStartPeriod.getText());
        return hm;
    }
}

