/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BSSourceEnum;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fi.cas.web.param.BankStatementWebFilterParam;
import com.kingdee.eas.fi.cas.web.param.FetchAccTableParam;
import com.kingdee.eas.fi.cas.web.param.QueryTable;
import com.kingdee.eas.fi.cas.web.param.QueryTableRow;
import com.kingdee.eas.fm.be.TransdetailSourceEnum;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BankStatementWebUtil {
    private static final Logger logger = Logger.getLogger(BankStatementWebUtil.class);
    public static final String BANK = "BANK";
    public static final String CURRENCY = "currency";
    public static final String COL_DATE = "createDate";
    public static final String COL_DESC = "description";
    public static final String COL_SETTLETYPE_NAME = "settleType.name";
    public static final String COL_SETTLENUMBER = "settleNumber";
    public static final String COL_SEQUENCENUMBER = "sequenceNumber";
    public static final String COL_TRADENUMBER = "tradeNumber";
    public static final String COL_CASHIER = "cashier";
    public static final String COL_OPPUNIT = "oppUnit";
    public static final String COL_OPPACCOUNTNUMBER = "oppAccountNumber";
    public static final String COL_VOUCHERNUMBER = "voucherNumber";
    public static final String COL_DEBIT = "debitAmount";
    public static final String COL_CREDIT = "creditAmount";
    public static final String COL_BALANCE = "balance";
    public static final String COL_VERIFY = "verifyStatus";
    public static final String COL_SOURCE = "source";
    public static final String COL_ID = "id";
    public static final String BALANCE = "balance";
    public static final String YEAR_DEBIT = "yeardebit";
    public static final String YEAR_CREADIT = "yearcreadit";
    public static final String COL_COMPANY = "company_name";
    public static final String COL_COMPANY_ID = "company_id";
    public static final String COL_BUSINESSTYPE = "businessType";
    private static final String COL_TRANSDETAIL_SOURCE = "transdetailSource";

    public static IRowSet getRowset(Context ctx, IMetaDataPK mainQueryPK, BankStatementWebFilterParam param) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        if (param.isByDay()) {
            if (param.getToDate() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo(COL_DATE, (Object)DateTimeUtils.truncateDate((java.util.Date)param.getToDate()), CompareType.LESS_EQUALS));
            }
            if (param.getFromDate() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo(COL_DATE, (Object)DateTimeUtils.truncateDate((java.util.Date)param.getFromDate()), CompareType.GREATER_EQUALS));
            }
        } else {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
            String periodTypeId = companyInfo.getAccountPeriodType().getId().toString();
            String sql = BankStatementWebUtil.getPeriodCollSQL(periodTypeId, param.getBeginYear(), param.getBeginMonth(), param.getEndYear(), param.getEndMonth());
            filterInfo.getFilterItems().add(new FilterItemInfo("period.id", (Object)sql, CompareType.INNER));
        }
        AccountBankInfo accountBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(param.getAccountBankId()));
        EntityViewInfo mainQuery = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)param.getCompanyId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)param.getCurrencyId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)param.getAccountBankId()));
        if (param.getAccountBankId() != null) {
            long beginDateLong = param.getFromDate() == null ? -1L : param.getFromDate().getTime();
            long endDateLong = param.getToDate() == null ? -1L : param.getToDate().getTime();
            FetchAccTableParam accTableParam = new FetchAccTableParam(param.getCompanyId(), param.getBeginYear(), param.getBeginMonth(), param.getEndYear(), param.getEndMonth(), beginDateLong, endDateLong, param.isByDay());
            String acctTableId = JournalWebUtil.getDisplayAcctTable(ctx, accTableParam);
            accountBankInfo = JournalWebUtil.getJouranlBalanceAcctBank(ctx, accountBankInfo, null, acctTableId);
            AccountViewInfo account = new AccountViewInfo();
            if (accountBankInfo.getAccount() != null) {
                account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getAccount().getId().toString()));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("accountView.id", (Object)account.getId().toString()));
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        mainQuery.getSorter().add(new SorterItemInfo(COL_DATE));
        mainQuery.getSorter().add(new SorterItemInfo("createTime"));
        mainQuery.getSorter().add(new SorterItemInfo("lineNo"));
        mainQuery.setFilter(filterInfo);
        exec.setObjectView(mainQuery);
        String sql = exec.getSQL();
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    public static QueryTable getBankStatementlList(Context ctx, BankStatementWebFilterParam filterParam, QueryTable queryTable) throws EASBizException, BOSException, SQLException {
        if (filterParam != null && ctx != null && filterParam.getCompanyId() != null && filterParam.getAccountBankId() != null && filterParam.getCurrencyId() != null) {
            String companyId = filterParam.getCompanyId();
            String accountBankId = filterParam.getAccountBankId();
            String currencyId = filterParam.getCurrencyId();
            AccountBankInfo accountBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(filterParam.getAccountBankId()));
            int periodSize = 0;
            int periodIndex = 0;
            BigDecimal periodDebit = SysConstant.BIGZERO;
            BigDecimal periodCredit = SysConstant.BIGZERO;
            BigDecimal curBal = SysConstant.BIGZERO;
            String LBL_DAYSTART = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart", (Locale)ctx.getLocale());
            String LBL_PERIOD = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_Period", (Locale)ctx.getLocale());
            String LBL_YEAR = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_Year", (Locale)ctx.getLocale());
            MetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.fi.cas", "BankStatementWebQuery");
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPk);
            EntityViewInfo ev = new EntityViewInfo();
            exec.setObjectView(ev);
            IRowSet rs = BankStatementWebUtil.getRowset(ctx, (IMetaDataPK)mainQueryPk, filterParam);
            PeriodCollection qryPeriods = BankStatementWebUtil.getQryPeriods(ctx, filterParam);
            if (!filterParam.isByDay()) {
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterParam.getCompanyId()));
                PeriodInfo periodInfoFrom = PeriodUtils.getPeriodInfo((Context)ctx, (int)filterParam.getBeginYear(), (int)filterParam.getBeginMonth(), (CompanyOrgUnitInfo)companyInfo);
                PeriodInfo periodInfoTo = PeriodUtils.getPeriodInfo((Context)ctx, (int)filterParam.getEndYear(), (int)filterParam.getEndMonth(), (CompanyOrgUnitInfo)companyInfo);
                java.util.Date startDate = new java.util.Date(periodInfoFrom.getBeginDate().getTime());
                java.util.Date endDate = new java.util.Date(periodInfoTo.getEndDate().getTime());
                filterParam.setAdjustPeriod(periodInfoFrom.isIsAdjustPeriod());
                filterParam.setFromDate(startDate);
                filterParam.setToDate(endDate);
            }
            if (qryPeriods != null && qryPeriods.size() > 0) {
                if (filterParam.isByDay()) {
                    java.util.Date firstDate = DateHelper.getFirstDayOfMonth((java.util.Date)filterParam.getFromDate());
                    if (filterParam.getFromDate().compareTo(firstDate) > 0) {
                        java.util.Date startDate = firstDate;
                        java.util.Date periodEndDate = DateHelper.getBeforeDay((java.util.Date)filterParam.getFromDate());
                        ICashManagement cashInacct = CashManagementFactory.getLocalInstance(ctx);
                        BigDecimal debit = cashInacct.getBStateData(companyId, accountBankId, currencyId, startDate, periodEndDate, CashDataTypeEnum.JF, true);
                        BigDecimal credit = cashInacct.getBStateData(companyId, accountBankId, currencyId, startDate, periodEndDate, CashDataTypeEnum.DF, true);
                        periodDebit = periodDebit.add(debit);
                        periodCredit = periodCredit.add(credit);
                    }
                }
                periodSize = qryPeriods.size();
                BankStatementInfo startInfo = BankStatementWebUtil.getStartAmts(ctx, filterParam, accountBankId, currencyId, accountBankInfo.getAccount().getId().toString(), companyId);
                QueryTableRow row = null;
                if (rs == null || rs.size() == 0) {
                    boolean fHasDayStart;
                    boolean bl = fHasDayStart = filterParam.isByDay() && filterParam.isShowBeginBalance();
                    if (fHasDayStart) {
                        row = queryTable.addRow();
                        BankStatementWebUtil.appendStatisticRow(row, filterParam.getFromDate(), LBL_DAYSTART, null, null, startInfo.getBigDecimal("balance"));
                        PeriodInfo curPeriod = qryPeriods.get(0);
                        qryPeriods.remove(curPeriod);
                        Date periodEndDate = new Date(curPeriod.getEndDate().getTime());
                        curBal = startInfo.getBigDecimal("balance");
                        BigDecimal yearDebit = startInfo.getBigDecimal(YEAR_DEBIT);
                        BigDecimal yearCredit = startInfo.getBigDecimal(YEAR_CREADIT);
                        if (filterParam.isShowMonthTotal()) {
                            row = queryTable.addRow();
                            BankStatementWebUtil.appendStatisticRow(row, periodEndDate, LBL_PERIOD, periodDebit, periodCredit, curBal);
                        }
                        if (filterParam.isShowYearTotal()) {
                            row = queryTable.addRow();
                            BankStatementWebUtil.appendStatisticRow(row, periodEndDate, LBL_YEAR, yearDebit, yearCredit, curBal);
                        }
                    }
                    row = queryTable.addRow();
                    BankStatementWebUtil.appendStatisticForNullData(ctx, queryTable, qryPeriods, startInfo, filterParam);
                } else {
                    BankStatementWebUtil.appendDataAndStatistics(ctx, queryTable, rs, curBal, startInfo, periodIndex, periodSize, qryPeriods, filterParam);
                }
            }
        }
        return queryTable;
    }

    public static void appendStatisticForNullData(Context ctx, QueryTable queryTable, PeriodCollection periods, BankStatementInfo startInfo, BankStatementWebFilterParam filterParam) {
        if (!BankStatementWebUtil.hasStatisticRows(filterParam)) {
            return;
        }
        if (periods.size() == 0) {
            return;
        }
        BigDecimal balance = startInfo.getBigDecimal("balance");
        BigDecimal yearDebit = startInfo.getBigDecimal(YEAR_DEBIT);
        BigDecimal yearCredit = startInfo.getBigDecimal(YEAR_CREADIT);
        if (periods.get(0).getPeriodNumber() == 1) {
            yearDebit = FMConstants.ZERO;
            yearCredit = FMConstants.ZERO;
        }
        PeriodInfo prePeriod = null;
        String LBL_PERIOD = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_Period", (Locale)ctx.getLocale());
        String LBL_START = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_PeriodStart", (Locale)ctx.getLocale());
        String LBL_YEAR = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_Year", (Locale)ctx.getLocale());
        QueryTableRow row = null;
        int n = periods.size();
        for (int i = 0; i < n; ++i) {
            PeriodInfo curPeriod = periods.get(i);
            if (prePeriod != null && curPeriod.getPeriodYear() != prePeriod.getPeriodYear()) {
                yearDebit = SysConstant.BIGZERO;
                yearCredit = SysConstant.BIGZERO;
            }
            Date startDate = new Date(curPeriod.getBeginDate().getTime());
            Date periodEndDate = new Date(curPeriod.getEndDate().getTime());
            boolean fHasPeriodSum = BankStatementWebUtil.hasPeriodSumRow(filterParam);
            if (filterParam.isShowBeginBalance() && BankStatementWebUtil.hasPeriodStartRow(curPeriod, filterParam)) {
                row = queryTable.addRow();
                BankStatementWebUtil.appendStatisticRow(row, startDate, LBL_START, null, null, balance);
            }
            if (filterParam.isShowMonthTotal() && fHasPeriodSum) {
                row = queryTable.addRow();
                BankStatementWebUtil.appendStatisticRow(row, periodEndDate, LBL_PERIOD, null, null, balance);
            }
            if (filterParam.isShowYearTotal() && fHasPeriodSum) {
                row = queryTable.addRow();
                BankStatementWebUtil.appendStatisticRow(row, periodEndDate, LBL_YEAR, yearDebit, yearCredit, balance);
            }
            prePeriod = curPeriod;
        }
    }

    public static PeriodCollection getQryPeriods(Context ctx, BankStatementWebFilterParam param) throws BOSException, EASBizException {
        java.util.Date beginDate = param.getFromDate();
        java.util.Date endDate = param.getToDate();
        ObjectUuidPK companyPK = new ObjectUuidPK(param.getCompanyId());
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        PeriodCollection periods = null;
        if (param.isByDay()) {
            periods = PeriodUtils.getPeriodCollection((Context)ctx, (java.util.Date)beginDate, (java.util.Date)endDate, (IObjectPK)companyPK);
        } else {
            String periodtypeId = companyInfo.getAccountPeriodType().getId().toString();
            int beginYear = param.getBeginYear();
            int beginMonth = param.getBeginMonth();
            int endYear = param.getEndYear();
            int endMonth = param.getEndMonth();
            periods = BankStatementWebUtil.getPeriodColl(ctx, periodtypeId, beginYear, beginMonth, endYear, endMonth);
        }
        BankStatementWebUtil.sortPeriodColl(periods);
        if (!(periods != null && periods.size() != 0 || param.isByDay() || param.getBeginYear() != param.getEndYear() || param.getBeginMonth() != param.getEndMonth())) {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)param.getBeginYear(), (int)param.getBeginMonth(), (IObjectPK)companyPK);
            periods.add(periodInfo);
        }
        return periods;
    }

    public static PeriodCollection getPeriodColl(Context ctx, String periodtypeId, int beginYear, int beginMonth, int endYear, int endMonth) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_bd_period A ");
        sb.append(" where A.FPERIODYEAR*100 + A.FPERIODNUMBER >=");
        sb.append(beginYear * 100 + beginMonth);
        sb.append(" and A.FPERIODYEAR*100 + A.FPERIODNUMBER  <=");
        sb.append(endYear * 100 + endMonth);
        sb.append(" and A.FTypeID='");
        sb.append(periodtypeId);
        sb.append("'");
        filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)sb.toString(), CompareType.INNER));
        ev.setFilter(filter);
        ev.getSorter().add(new SorterItemInfo("periodyear"));
        ev.getSorter().add(new SorterItemInfo("periodnumber"));
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection periocColl = iPeriod.getPeriodCollection(ev);
        return periocColl;
    }

    public static void sortPeriodColl(PeriodCollection coll) {
        if (coll != null) {
            Object[] collAry = coll.toArray();
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    PeriodInfo new01 = (PeriodInfo)o1;
                    PeriodInfo new02 = (PeriodInfo)o2;
                    return new01.getBeginDate().compareTo(new02.getBeginDate());
                }
            };
            Arrays.sort(collAry, c);
            coll.clear();
            for (int i = 0; i < collAry.length; ++i) {
                coll.add((PeriodInfo)collAry[i]);
            }
        }
    }

    public static BankStatementInfo getStartAmts(Context ctx, BankStatementWebFilterParam param, String bankId, String currencyId, String accountId, String companyId) throws BOSException, EASBizException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        ObjectUuidPK bankPK = new ObjectUuidPK(bankId);
        ObjectUuidPK currencyPK = new ObjectUuidPK(currencyId);
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
        PeriodInfo beginPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)param.getBeginYear(), (int)param.getBeginMonth(), (CompanyOrgUnitInfo)companyInfo);
        IBankStatement iStmt = BankStatementFactory.getLocalInstance(ctx);
        return iStmt.getDateStartData((IObjectPK)companyPK, (IObjectPK)bankPK, (IObjectPK)currencyPK, param.getFromDate(), (IObjectPK)new ObjectUuidPK(beginPeriodInfo.getId()), (IObjectPK)new ObjectUuidPK(accountId));
    }

    public static void appendStatisticRow(QueryTableRow row, java.util.Date dispDate, String lblDesc, BigDecimal debitAmount, BigDecimal creditAmount, BigDecimal balance) {
        if (row != null) {
            row.addCell(COL_DATE).setValue(dispDate);
            row.addCell(COL_DESC).setValue(lblDesc);
            if (debitAmount != null && debitAmount.signum() != 0) {
                row.addCell(COL_DEBIT).setValue(debitAmount);
            }
            if (creditAmount != null && creditAmount.signum() != 0) {
                row.addCell(COL_CREDIT).setValue(creditAmount);
            }
            if (balance != null) {
                row.addCell("balance").setValue(balance);
            }
        }
    }

    public static boolean hasStatisticRows(BankStatementWebFilterParam filterParam) {
        return filterParam.isShowBeginBalance() || filterParam.isShowDayTotal() || filterParam.isShowMonthTotal() || filterParam.isShowYearTotal();
    }

    public static void loadDataToRow(QueryTableRow row, IRowSet rs, BigDecimal balance) throws SQLException {
        if (rs != null && row != null) {
            row.addCell(COL_DATE, rs.getObject(COL_DATE));
            row.addCell(COL_DESC, rs.getObject(COL_DESC));
            row.addCell(COL_SETTLETYPE_NAME, rs.getObject(COL_SETTLETYPE_NAME));
            row.addCell(COL_SETTLENUMBER, rs.getObject(COL_SETTLENUMBER));
            row.addCell(COL_SEQUENCENUMBER, rs.getObject(COL_SEQUENCENUMBER));
            row.addCell(COL_TRADENUMBER, rs.getObject(COL_TRADENUMBER));
            row.addCell(COL_CASHIER, rs.getObject(COL_CASHIER));
            row.addCell(COL_OPPUNIT, rs.getObject(COL_OPPUNIT));
            row.addCell(COL_OPPACCOUNTNUMBER, rs.getObject(COL_OPPACCOUNTNUMBER));
            row.addCell(COL_VOUCHERNUMBER, rs.getObject(COL_VOUCHERNUMBER));
            row.addCell(COL_DEBIT, rs.getBigDecimal(COL_DEBIT));
            row.addCell(COL_CREDIT, rs.getBigDecimal(COL_CREDIT));
            row.addCell("balance", balance);
            row.addCell(COL_VERIFY, rs.getBoolean(COL_VERIFY));
            row.addCell(COL_SOURCE, (Object)BSSourceEnum.getEnum(rs.getInt(COL_SOURCE)));
            row.addCell(COL_ID, rs.getObject(COL_ID));
            row.addCell(COL_BUSINESSTYPE, rs.getObject(COL_BUSINESSTYPE));
            row.addCell(COL_COMPANY, rs.getObject("company.name"));
            row.addCell(COL_COMPANY_ID, rs.getObject("company.id"));
            row.addCell("bankVouvherNo", rs.getObject("bankVouvherNo"));
            if (rs.getObject(COL_TRANSDETAIL_SOURCE) != null) {
                row.addCell(COL_TRANSDETAIL_SOURCE, TransdetailSourceEnum.getEnum((int)rs.getInt(COL_TRANSDETAIL_SOURCE)));
            }
        }
    }

    public static boolean isSameDay(java.util.Date date, java.util.Date otherDate) {
        if (date == null && otherDate == null) {
            return true;
        }
        if (date == null || otherDate == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar otherCalendar = Calendar.getInstance();
        otherCalendar.setTime(otherDate);
        return calendar.get(1) == otherCalendar.get(1) && calendar.get(2) == otherCalendar.get(2) && calendar.get(5) == otherCalendar.get(5);
    }

    public static int periodCompare(PeriodInfo periodA, PeriodInfo periodB) {
        boolean fChange = false;
        if (periodA == null || periodB == null) {
            return -1;
        }
        fChange = periodA.getPeriodYear() != periodB.getPeriodYear();
        fChange = fChange || periodA.getPeriodYear() == periodB.getPeriodYear() && periodA.getPeriodNumber() != periodB.getPeriodNumber();
        return fChange ? 1 : 0;
    }

    public static void appendDataAndStatistics(Context ctx, QueryTable queryTable, IRowSet rs, BigDecimal curBal, BankStatementInfo startInfo, int periodIndex, int periodSize, PeriodCollection qryPeriods, BankStatementWebFilterParam filterParam) throws SQLException {
        PeriodInfo curPeriod = new PeriodInfo();
        PeriodInfo prePeriod = new PeriodInfo();
        Date preDate = null;
        BigDecimal dayCredit = SysConstant.BIGZERO;
        BigDecimal dayDebit = SysConstant.BIGZERO;
        BigDecimal yearDebit = startInfo.getBigDecimal(YEAR_DEBIT);
        BigDecimal yearCredit = startInfo.getBigDecimal(YEAR_CREADIT);
        BigDecimal periodCredit = SysConstant.BIGZERO;
        BigDecimal periodDebit = SysConstant.BIGZERO;
        String LBL_DAY = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_Day", (Locale)ctx.getLocale());
        String LBL_DAYSTART = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart", (Locale)ctx.getLocale());
        String LBL_PERIOD = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_Period", (Locale)ctx.getLocale());
        String LBL_START = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_PeriodStart", (Locale)ctx.getLocale());
        String LBL_YEAR = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_Year", (Locale)ctx.getLocale());
        curBal = startInfo.getBigDecimal("balance");
        boolean fHasDayStart = filterParam.isByDay() && filterParam.isShowBeginBalance();
        QueryTableRow row = null;
        if (fHasDayStart) {
            row = queryTable.addRow();
            BankStatementWebUtil.appendStatisticRow(row, filterParam.getFromDate(), LBL_DAYSTART, null, null, curBal);
        }
        rs.beforeFirst();
        while (rs.next()) {
            int periodChange;
            Date curDate = rs.getDate(COL_DATE);
            String bankVourcherCode = rs.getString("bankVouvherNo");
            String periodId = rs.getString("period.id");
            if (preDate != null && prePeriod != null && prePeriod != null && !periodId.equals(prePeriod.getId().toString()) && periodIndex + 1 < periodSize) {
                ++periodIndex;
            }
            curPeriod = qryPeriods.get(periodIndex);
            if (filterParam.isShowDayTotal() && preDate != null && !BankStatementWebUtil.isSameDay(curDate, preDate)) {
                row = queryTable.addRow();
                BankStatementWebUtil.appendStatisticRow(row, preDate, LBL_DAY, dayDebit, dayCredit, curBal);
                dayDebit = SysConstant.BIGZERO;
                dayCredit = SysConstant.BIGZERO;
            }
            if ((periodChange = BankStatementWebUtil.periodCompare(prePeriod, curPeriod)) == -1 || periodChange == 1) {
                if (preDate != null && prePeriod != null) {
                    Date prePeriodEnd = new Date(prePeriod.getEndDate().getTime());
                    if (filterParam.isShowMonthTotal()) {
                        row = queryTable.addRow();
                        BankStatementWebUtil.appendStatisticRow(row, prePeriodEnd, LBL_PERIOD, periodDebit, periodCredit, curBal);
                    }
                    if (filterParam.isShowYearTotal()) {
                        row = queryTable.addRow();
                        BankStatementWebUtil.appendStatisticRow(row, prePeriodEnd, LBL_YEAR, yearDebit, yearCredit, curBal);
                    }
                    periodDebit = SysConstant.BIGZERO;
                    periodCredit = SysConstant.BIGZERO;
                }
                if (!periodId.equals(curPeriod.getId().toString())) {
                    PeriodCollection noDataPeriods = new PeriodCollection();
                    do {
                        noDataPeriods.add(curPeriod);
                    } while (periodIndex + 1 < periodSize && !periodId.equals((curPeriod = qryPeriods.get(++periodIndex)).getId().toString()));
                    BankStatementInfo statInfo = new BankStatementInfo();
                    statInfo.setBigDecimal(YEAR_DEBIT, yearDebit);
                    statInfo.setBigDecimal(YEAR_CREADIT, yearCredit);
                    statInfo.put("balance", curBal);
                    BankStatementWebUtil.appendStatisticForNullData(ctx, queryTable, noDataPeriods, statInfo, filterParam);
                }
                if (filterParam.isShowBeginBalance()) {
                    boolean fHasRow;
                    boolean bl = fHasRow = !filterParam.isByDay() || filterParam.isByDay() && !BankStatementWebUtil.isInSamePeriod(filterParam.getFromDate(), curPeriod);
                    if (fHasRow) {
                        Date periodStartDay = new Date(curPeriod.getBeginDate().getTime());
                        row = queryTable.addRow();
                        BankStatementWebUtil.appendStatisticRow(row, periodStartDay, LBL_START, null, null, curBal);
                    }
                }
            }
            if (prePeriod != null && curPeriod.getPeriodYear() != prePeriod.getPeriodYear()) {
                yearDebit = SysConstant.BIGZERO;
                yearCredit = SysConstant.BIGZERO;
            }
            BigDecimal debit = rs.getBigDecimal(COL_DEBIT);
            BigDecimal credit = rs.getBigDecimal(COL_CREDIT);
            if (debit == null) {
                debit = SysConstant.BIGZERO;
            }
            if (credit == null) {
                credit = SysConstant.BIGZERO;
            }
            dayDebit = dayDebit.add(debit);
            dayCredit = dayCredit.add(credit);
            periodDebit = periodDebit.add(debit);
            periodCredit = periodCredit.add(credit);
            yearDebit = yearDebit.add(debit);
            yearCredit = yearCredit.add(credit);
            curBal = curBal.add(credit).subtract(debit);
            row = queryTable.addRow();
            BankStatementWebUtil.loadDataToRow(row, rs, curBal);
            preDate = curDate;
            prePeriod = curPeriod;
        }
        if (filterParam.isShowDayTotal()) {
            row = queryTable.addRow();
            BankStatementWebUtil.appendStatisticRow(row, preDate, LBL_DAY, dayDebit, dayCredit, curBal);
        }
        if (BankStatementWebUtil.hasPeriodSumRow(filterParam)) {
            java.util.Date endDate = new Date(curPeriod.getEndDate().getTime());
            if (filterParam.isByDay() && endDate.after(filterParam.getToDate())) {
                endDate = filterParam.getToDate();
            }
            if (filterParam.isShowMonthTotal()) {
                row = queryTable.addRow();
                BankStatementWebUtil.appendStatisticRow(row, endDate, LBL_PERIOD, periodDebit, periodCredit, curBal);
            }
            if (filterParam.isShowYearTotal()) {
                row = queryTable.addRow();
                BankStatementWebUtil.appendStatisticRow(row, endDate, LBL_YEAR, yearDebit, yearCredit, curBal);
            }
        }
        if (periodIndex + 1 < periodSize) {
            PeriodCollection noDataPeriods = new PeriodCollection();
            while (periodIndex + 1 < periodSize) {
                curPeriod = qryPeriods.get(++periodIndex);
                noDataPeriods.add(curPeriod);
            }
            startInfo.setBigDecimal(YEAR_DEBIT, yearDebit);
            startInfo.setBigDecimal(YEAR_CREADIT, yearCredit);
            startInfo.put("balance", curBal);
            row = queryTable.addRow();
            BankStatementWebUtil.appendStatisticForNullData(ctx, queryTable, noDataPeriods, startInfo, filterParam);
        }
    }

    public static boolean isInSamePeriod(java.util.Date date, PeriodInfo periodInfo) {
        if (date == null || periodInfo == null) {
            return false;
        }
        return !date.before(periodInfo.getBeginDate()) && !date.after(periodInfo.getEndDate());
    }

    public static boolean hasPeriodSumRow(BankStatementWebFilterParam filterParam) {
        boolean fHasRow = !filterParam.isByDay();
        fHasRow = fHasRow || filterParam.isByDay();
        return fHasRow;
    }

    public static boolean hasPeriodStartRow(PeriodInfo period, BankStatementWebFilterParam filterParam) {
        boolean fHasRow = !filterParam.isByDay();
        fHasRow = fHasRow || filterParam.isByDay() && !BankStatementWebUtil.isInSamePeriod(filterParam.getFromDate(), period);
        return fHasRow;
    }

    public static String getPeriodCollSQL(String periodTypeId, int beginYear, int beginMonth, int endYear, int endMonth) {
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_bd_period A ");
        sb.append(" where A.FPERIODYEAR*100 + A.FPERIODNUMBER >=");
        sb.append(beginYear * 100 + beginMonth);
        sb.append(" and A.FPERIODYEAR*100 + A.FPERIODNUMBER  <=");
        sb.append(endYear * 100 + endMonth);
        sb.append(" and A.FTypeID='");
        sb.append(periodTypeId);
        sb.append("'");
        return sb.toString();
    }
}

