/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.IVcScheme;
import com.kingdee.eas.base.vc.VcSchemeCollection;
import com.kingdee.eas.base.vc.VcSchemeFactory;
import com.kingdee.eas.base.vc.VcSchemeInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CASWebHelper {
    public static final Integer TRUE = new Integer(1);
    public static final Integer FALSE = new Integer(0);
    private static Map<String, PeriodInfo> periodMap;
    private static Map startPeriodMap;

    public static AccountBankCollection getAccountBankCollection(Context ctx, String companyID, boolean isIncludeClosed) throws BOSException {
        return CASWebHelper.getAccountBankCollection(ctx, companyID, null, isIncludeClosed);
    }

    public static AccountBankCollection getAccountBankCollection(Context ctx, String companyID, String idStr, boolean isIncludeClosed) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("currency.*");
        selector.add("number");
        selector.add("name");
        selector.add("bankAccountNumber");
        selector.add("account.id");
        selector.add("bank.name");
        selector.add("account.number");
        selector.add("account.name");
        FilterInfo fi = new FilterInfo();
        if (companyID != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        }
        if (!EmptyUtil.isEmpty((String)idStr)) {
            idStr = idStr.replaceAll("'", "");
            String[] ids = idStr.split(",");
            HashSet<String> idSet = new HashSet<String>();
            for (int index = 0; index < ids.length; ++index) {
                idSet.add(ids[index]);
            }
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        }
        if (!isIncludeClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)TRUE));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        for (int i = 0; i < acctBankCol.size(); ++i) {
            acctBankCol.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankCol;
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
    }

    public static PeriodInfo getPeriodInfo(Context ctx, String companyId) throws EASBizException, BOSException {
        if (periodMap == null) {
            periodMap = new HashMap<String, PeriodInfo>();
        }
        if (periodMap.containsKey(companyId)) {
            return periodMap.get(companyId);
        }
        PeriodInfo info = CASWebHelper.getCurrentPeriod(ctx, companyId);
        periodMap.put(companyId, info);
        return info;
    }

    public static PeriodInfo getCashStartPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        if (startPeriodMap == null) {
            startPeriodMap = new HashMap();
        }
        if (startPeriodMap.containsKey(companyId)) {
            return (PeriodInfo)startPeriodMap.get(companyId);
        }
        PeriodInfo info = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyId));
        startPeriodMap.put(companyId, info);
        return info;
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyId));
    }

    public static PeriodCollection getPeriodColls(Context ctx, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc == null || periodc.size() == 0) {
            return null;
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            return periodc;
        }
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        PeriodCollection rsltCols = new PeriodCollection();
        int n = periodc.size();
        for (int i = 0; i < n; ++i) {
            PeriodInfo periodInfo = periodc.get(i);
            if (!CASWebHelper.isAfterStartPeriod(startPeriod, periodInfo)) continue;
            rsltCols.add(periodInfo);
        }
        return rsltCols;
    }

    public static boolean isAfterStartPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod == null || periodInfo == null) {
            return false;
        }
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() <= periodInfo.getPeriodNumber();
    }

    public static CurrencyInfo getBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(company);
        return currency;
    }

    public static CurrencyCollection getCurrencyColl(Context ctx) throws BOSException {
        String currencyOql = "select * where  (id <> '11111111-1111-1111-1111-111111111111DEB58FDC' and id <> '22222222-2222-2222-2222-222222222222DEB58FDC') ";
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(currencyOql);
    }

    public static CurrencyCollection getCurrencyValidColl(Context ctx, CompanyOrgUnitInfo company) throws BOSException {
        CurrencyCollection currencyAllColl = CASWebHelper.getCurrencyColl(ctx);
        CurrencyCollection currencyColl = new CurrencyCollection();
        CurrencyInfo currencyInfo = null;
        for (int idx = currencyAllColl.size() - 1; idx >= 0; --idx) {
            currencyInfo = currencyAllColl.get(idx);
            if (currencyInfo == null) continue;
            try {
                JournalWebUtil.getExchange(ctx, company, currencyInfo, null, null);
                currencyColl.add(currencyInfo);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return currencyColl;
    }

    public static boolean isAdjustPeriod(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        return periodInfo != null && periodInfo.isIsAdjustPeriod();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VcSchemeInfo getVcSchemeInfoByBiz(Context ctx, String cuId) throws EASBizException, BOSException {
        VcSchemeCollection schemeColl;
        VcSchemeInfo info = null;
        IVcScheme iVcScheme = VcSchemeFactory.getLocalInstance((Context)ctx);
        String subSysName = "com.kingdee.eas.fi.cas";
        String oql = "CU.id in ('" + cuId + "', '" + "00000000-0000-0000-0000-000000000000CCE7AED4" + "', '" + "11111111-1111-1111-1111-111111111111CCE7AED4" + "') and isUsing=1";
        if (subSysName != null) {
            oql = "where subSysName='" + subSysName + "'  and " + oql;
        }
        if ((schemeColl = iVcScheme.getVcSchemeCollection(oql)).size() > 1) {
            VcSchemeCollection validScheme = new VcSchemeCollection();
            for (int i = 0; i < schemeColl.size(); ++i) {
                VcSchemeInfo info1 = schemeColl.get(i);
                if (info1.isIsUsing()) continue;
                validScheme.add(info1);
            }
            if (validScheme.size() > 1) {
                throw new EASBizException(new NumericExceptionSubItem("EASWebCas_BankVC_2013001", CASWebUtil.getResource(ctx, "HaveMultiAbleVCScheme")));
            }
            if (validScheme.size() != 1) throw new EASBizException(new NumericExceptionSubItem("EASWebCas_BankVC_2013002", CASWebUtil.getResource(ctx, "HaveMultiUnAbleVCScheme")));
            info = validScheme.get(0);
        } else if (schemeColl.size() == 1) {
            info = schemeColl.get(0);
        } else if (schemeColl.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("EASWebCas_BankVC_2013002", EASCommonResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"NoValidVcScheme", (Locale)ctx.getLocale())));
        }
        if (info != null) return info;
        throw new EASBizException(new NumericExceptionSubItem("EASWebCas_BankVC_2013002", EASCommonResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"NoValidVcScheme", (Locale)ctx.getLocale())));
    }

    public static String getCASMsg(Context ctx, String keyStr) {
        return EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)keyStr, (Locale)ctx.getLocale());
    }

    public static String getCASMsg(Context ctx, String resourcePath, String keyStr) {
        return EASCommonResource.getString((String)resourcePath, (String)keyStr, (Locale)ctx.getLocale());
    }

    public static CompanyOrgUnitCollection getAuthorizedOrgCollection(Context ctx, String prmitItems, boolean includeVirtual) throws BOSException, EASBizException {
        UserInfo curUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Set idSet = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(curUser.getId()), OrgType.Company, null, prmitItems);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        if (!includeVirtual) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE));
        }
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longNumber"));
        view.setSorter(sorter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        view.setSelector(sic);
        CompanyOrgUnitCollection fiOrgColls = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        return fiOrgColls;
    }

    public static Set<String> getAuthorizedOrg(Context ctx, String prmitItems, boolean includeVirtual) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        CompanyOrgUnitCollection fiOrgColls = CASWebHelper.getAuthorizedOrgCollection(ctx, prmitItems, includeVirtual);
        idSet = new HashSet();
        for (int idx = 0; idx < fiOrgColls.size(); ++idx) {
            CompanyOrgUnitInfo fiOrgUnit = fiOrgColls.get(idx);
            if (fiOrgUnit == null || fiOrgUnit.getId() == null) continue;
            idSet.add(fiOrgUnit.getId().toString());
        }
        return idSet;
    }

    public static String getAuthorizedOrgFilter(Context ctx, String prmitItems, boolean includeVirtual, String filed) throws EASBizException, BOSException {
        StringBuffer filter = new StringBuffer();
        if (StringUtil.isEmptyString((String)filed)) {
            filed = "id";
        }
        UserInfo curUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Set idSet = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(curUser.getId()), OrgType.Company, null, prmitItems);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo(filed, (Object)idSet, CompareType.INCLUDE));
        return fi.toSql();
    }

    public static String getAuthorizedOrgFilter_F7Special(Context ctx, String prmitItems, boolean includeVirtual, String unitFiled, String treeFiled) throws EASBizException, BOSException {
        if (StringUtil.isEmptyString((String)unitFiled)) {
            unitFiled = "unit.id";
        }
        UserInfo curUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Set idSet = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(curUser.getId()), OrgType.Company, null, prmitItems);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo(unitFiled, (Object)idSet, CompareType.INCLUDE));
        return fi.toSql();
    }

    private static void getOrgStructureIdSet(IOrgStructure iOrgStrcture, List<String> orgTreeIds, Set<String> idSet) throws BOSException {
        if (idSet == null || idSet.size() <= 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectColl = new SelectorItemCollection();
        selectColl.add(new SelectorItemInfo("id"));
        selectColl.add(new SelectorItemInfo("tree.id"));
        selectColl.add(new SelectorItemInfo("parent.id"));
        view.setSelector(selectColl);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        OrgStructureCollection orgStructureColl = iOrgStrcture.getOrgStructureCollection(view);
        HashSet<String> orgStructIdSet = new HashSet<String>();
        String tmpStr = null;
        for (int idx = 0; idx < orgStructureColl.size(); ++idx) {
            OrgStructureInfo orgInfo = orgStructureColl.get(idx);
            if (orgInfo != null && orgInfo.getTree() != null && orgInfo.getTree().getId() != null && !orgTreeIds.contains(tmpStr = orgInfo.getTree().getId().toString())) {
                orgTreeIds.add(tmpStr);
            }
            if (orgInfo == null || orgInfo.getParent() == null || orgInfo.getParent().getId() == null) continue;
            orgStructIdSet.add(orgInfo.getParent().getId().toString());
        }
        if (orgStructIdSet.size() > 0) {
            CASWebHelper.getOrgStructureIdSet(iOrgStrcture, orgTreeIds, orgStructIdSet);
        }
    }

    public static int getCurYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return cal.get(1);
    }

    public static int getCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return cal.get(2) + 1;
    }

    public static Map getParamMap(Context ctx, String orgId, String ... parameterKeys) throws EASBizException, BOSException {
        HashMap<String, ObjectUuidPK> paramNumberAndOrgId = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK orgPK = new ObjectUuidPK(orgId);
        for (int i = 0; i < parameterKeys.length; ++i) {
            paramNumberAndOrgId.put(parameterKeys[i], orgPK);
        }
        IParamControl pc = null;
        pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap paramMap = pc.getParamHashMap(paramNumberAndOrgId);
        for (String key : paramMap.keySet()) {
            Object value = paramMap.get(key);
            if (value == null || !value.equals("true") && !value.equals("false")) continue;
            paramMap.put(key, Boolean.valueOf(value.toString()));
        }
        return paramMap;
    }

    public static boolean hasFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName) throws EASBizException, BOSException {
        return PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(userPK, orgPK, permItemName);
    }

    public static BOTRelationCollection getBOTRelationColFromExtendProperty(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        BOTRelationCollection botCol = new BOTRelationCollection();
        if (model.getExtendedProperty("botrelation") != null) {
            Object o;
            String botrelationStr = model.getExtendedProperty("botrelation");
            ArrayList list = (ArrayList)JSONUtils.convertJsonToObject((Context)ctx, (String)botrelationStr, ArrayList.class);
            for (int i = 0; i < list.size(); ++i) {
                LinkedTreeMap map = (LinkedTreeMap)list.get(i);
                Iterator iterator = map.keySet().iterator();
                BOTRelationInfo info = new BOTRelationInfo();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    if (map.get((Object)key) == null || "date".equals(key)) continue;
                    if ("isEffected".equals(key)) {
                        info.setIsEffected(false);
                        continue;
                    }
                    if ("relationEntries".equals(key)) {
                        info.put(key, (Object)CASWebHelper.getBOTEntryRelation((ArrayList)map.get((Object)key), info));
                        continue;
                    }
                    info.put(key, map.get((Object)key));
                }
                botCol.add(info);
            }
            if (model.containsKey("relationColl") && !EmptyUtil.isEmpty((Object)(o = model.get("relationColl"))) && o instanceof String) {
                model.put("relationColl", (Object)botCol);
            }
            return botCol;
        }
        return null;
    }

    private static BOTRelationEntryCollection getBOTEntryRelation(ArrayList list, BOTRelationInfo relationinfo) {
        if (list == null || list.size() == 0) {
            return null;
        }
        BOTRelationEntryCollection botCol = new BOTRelationEntryCollection();
        for (int i = 0; i < list.size(); ++i) {
            LinkedTreeMap map = (LinkedTreeMap)list.get(i);
            Iterator iterator = map.keySet().iterator();
            BOTRelationEntryInfo info = new BOTRelationEntryInfo();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                if (map.get((Object)key) == null) continue;
                info.put(key, map.get((Object)key));
            }
            info.put("relation", (Object)relationinfo);
            botCol.add(info);
        }
        return botCol;
    }
}

