/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CompanyReconcileHelper {
    public static final Map<String, List<Map<String, Object>>> contrastResultCache = new ConcurrentHashMap<String, List<Map<String, Object>>>();
    public static final Map<String, List<Map<String, Object>>> unContrastCashResultCache = new ConcurrentHashMap<String, List<Map<String, Object>>>();
    public static final Map<String, List<Map<String, Object>>> unContrastGLResultCache = new ConcurrentHashMap<String, List<Map<String, Object>>>();
    public static final Map<String, BigInteger> groupMaxNumber = new ConcurrentHashMap<String, BigInteger>();

    public static void saveCacheOfContrastRst(String companyID, List<Map<String, Object>> vcRstMap) {
        contrastResultCache.put(companyID, vcRstMap);
    }

    public static void saveCacheOfUncontrastCashRst(String companyID, List<Map<String, Object>> vcRstMap) {
        unContrastCashResultCache.put(companyID, vcRstMap);
    }

    public static void saveCacheOfUncontrastGLRst(String companyID, List<Map<String, Object>> vcRstMap) {
        unContrastGLResultCache.put(companyID, vcRstMap);
    }

    public static void saveCacheOfGroupMaxNumber(String companyID, BigInteger maxNumber) {
        groupMaxNumber.put(companyID, maxNumber);
    }

    public static List<Map<String, Object>> getCacheOfContrastRst(String companyID) {
        List<Map<String, Object>> rstMap = contrastResultCache.get(companyID);
        if (rstMap == null) {
            rstMap = new ArrayList<Map<String, Object>>();
            contrastResultCache.put(companyID, rstMap);
        }
        return rstMap;
    }

    public static List<Map<String, Object>> getCacheOfUnContrastCashRst(String companyID) {
        List<Map<String, Object>> rstMap = unContrastCashResultCache.get(companyID);
        if (rstMap == null) {
            rstMap = new ArrayList<Map<String, Object>>();
            unContrastCashResultCache.put(companyID, rstMap);
        }
        return rstMap;
    }

    public static List<Map<String, Object>> getCacheOfUnContrastGLRst(String companyID) {
        List<Map<String, Object>> rstMap = unContrastGLResultCache.get(companyID);
        if (rstMap == null) {
            rstMap = new ArrayList<Map<String, Object>>();
            unContrastGLResultCache.put(companyID, rstMap);
        }
        return rstMap;
    }

    public static BigInteger getCacheOfGroupMaxNumber(String companyID) {
        BigInteger maxNumber = groupMaxNumber.get(companyID);
        if (maxNumber == null) {
            maxNumber = new BigInteger("0");
            groupMaxNumber.put(companyID, maxNumber);
        }
        return maxNumber;
    }
}

