/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.OperateBillEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillLogFactory;
import com.kingdee.eas.fi.cas.PaymentBillLogInfo;
import com.kingdee.eas.fi.cas.PaymentOperateType;
import com.kingdee.eas.fi.cas.client.RepeatPaymentBillListUI;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.client.RepeatSettlementBillListUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FMClientHelper {
    public static AccountRefContrastCollection getEnabledAcctRefContrastColl(Context ctx, String companyId, Date beginDate, Date endDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS_EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
        return coll;
    }

    public static void saveOperateLog(Set idSet, PaymentOperateType operateType, UserInfo userInfo, OperateBillEnum billType) {
        try {
            if (EmptyUtil.isEmpty((Collection)idSet)) {
                return;
            }
            EntityViewInfo likeView = new EntityViewInfo();
            FilterInfo likeFilter = new FilterInfo();
            likeFilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            likeView.getSelector().add("id");
            likeView.getSelector().add("number");
            likeView.getSelector().add("name");
            likeView.getSelector().add("company.*");
            likeView.setFilter(likeFilter);
            PaymentBillCollection paymentBillCollection = PaymentBillFactory.getRemoteInstance().getPaymentBillCollection(likeView);
            CoreBaseCollection logCollection = new CoreBaseCollection();
            for (int i = 0; i < paymentBillCollection.size(); ++i) {
                PaymentBillInfo info = paymentBillCollection.get(i);
                PaymentBillLogInfo logInfo = new PaymentBillLogInfo();
                logInfo.setIP(SysContext.getSysContext().getClientIP());
                logInfo.setOperateBill(billType.getAlias());
                logInfo.setOperateBillEnum(billType);
                logInfo.setOperateTime(new Timestamp(System.currentTimeMillis()));
                logInfo.setUserName(userInfo.getName());
                logInfo.setUserNumber(userInfo.getNumber());
                logInfo.setCompany(info.getCompany());
                logInfo.setBillNumber(info.getNumber());
                logInfo.setOperateType(operateType);
                logCollection.add((CoreBaseInfo)logInfo);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.set(5, calendar.get(5) - 30);
            Date time = calendar.getTime();
            Date DestDate = DateTimeUtils.truncateDate((Date)time);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("operateTime", (Object)DestDate, CompareType.LESS_EQUALS));
            PaymentBillLogFactory.getRemoteInstance().delete(filter);
            PaymentBillLogFactory.getRemoteInstance().addnewBatchData(logCollection);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void showUI(Map allCompanyIdMap, Set chongFuSet, CoreUI thisUI, int actionType) throws UIException {
        String originalId;
        UIContext uiContext = new UIContext((Object)thisUI);
        RealModeIDList iidlist = new RealModeIDList();
        ArrayList<String> idList = new ArrayList<String>();
        BOSObjectType type = null;
        Iterator iterator = allCompanyIdMap.keySet().iterator();
        if (iterator.hasNext()) {
            Object id = iterator.next();
            originalId = (String)id;
            type = BOSUuid.read((String)originalId).getType();
        }
        for (Object id : allCompanyIdMap.keySet()) {
            String[] likedIdAndNumArr;
            String likedIdAndNum;
            int i;
            originalId = (String)id;
            if (!iidlist.contains(originalId)) {
                iidlist.add(originalId);
                if (actionType != 2) {
                    idList.add(originalId);
                }
            }
            if (!chongFuSet.contains(originalId)) continue;
            List likedIdAndNumList = (List)allCompanyIdMap.get(originalId);
            for (i = 0; i < likedIdAndNumList.size(); ++i) {
                likedIdAndNum = (String)likedIdAndNumList.get(i);
                likedIdAndNumArr = likedIdAndNum.split(";");
                if (!chongFuSet.contains(likedIdAndNumArr[0]) || iidlist.contains(likedIdAndNumArr[0])) continue;
                iidlist.add(likedIdAndNumArr[0]);
                if (actionType == 2) continue;
                idList.add(likedIdAndNumArr[0]);
            }
            for (i = 0; i < likedIdAndNumList.size(); ++i) {
                likedIdAndNum = (String)likedIdAndNumList.get(i);
                likedIdAndNumArr = likedIdAndNum.split(";");
                if (!iidlist.contains(likedIdAndNumArr[0])) {
                    iidlist.add(likedIdAndNumArr[0]);
                    if (actionType == 2) continue;
                    idList.add(likedIdAndNumArr[0]);
                    continue;
                }
                if (actionType == 2) continue;
                int indexOf = idList.indexOf(likedIdAndNumArr[0]);
                if (new PaymentBillInfo().getBOSType().equals((Object)type)) {
                    idList.remove(originalId);
                    idList.add(indexOf, originalId);
                    continue;
                }
                if (!new SettlementBillInfo().getBOSType().equals((Object)type) || idList.contains(originalId)) continue;
                idList.add(indexOf, originalId);
            }
        }
        uiContext.put((Object)"ID", (Object)(System.currentTimeMillis() + ""));
        uiContext.put((Object)"IDList", (Object)iidlist);
        uiContext.put((Object)"realIDList", idList);
        uiContext.put((Object)"chongFuSet", (Object)chongFuSet);
        uiContext.put((Object)"actionType", (Object)actionType);
        IUIWindow uiWindow = null;
        if (new PaymentBillInfo().getBOSType().equals((Object)type)) {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RepeatPaymentBillListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        } else if (new SettlementBillInfo().getBOSType().equals((Object)type)) {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RepeatSettlementBillListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        }
        if (uiWindow != null) {
            uiWindow.show();
        }
    }

    public static void saveOperateLog(PaymentBillInfo info, PaymentOperateType operateType, UserInfo userInfo, OperateBillEnum billType) {
        try {
            if (info == null) {
                return;
            }
            CoreBaseCollection logCollection = new CoreBaseCollection();
            PaymentBillLogInfo logInfo = new PaymentBillLogInfo();
            logInfo.setIP(SysContext.getSysContext().getClientIP());
            logInfo.setOperateBill(billType.getAlias());
            logInfo.setOperateBillEnum(billType);
            logInfo.setOperateTime(new Timestamp(System.currentTimeMillis()));
            logInfo.setUserName(userInfo.getName());
            logInfo.setUserNumber(userInfo.getNumber());
            logInfo.setCompany(info.getCompany());
            logInfo.setBillNumber(info.getNumber());
            logInfo.setOperateType(operateType);
            logCollection.add((CoreBaseInfo)logInfo);
            PaymentBillLogFactory.getRemoteInstance().addnewBatchData(logCollection);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void saveSettleBillOperateLog(SettlementBillInfo info, PaymentOperateType operateType, UserInfo userInfo, OperateBillEnum billType) {
        try {
            if (EmptyUtil.isEmpty((CoreBaseInfo)info)) {
                return;
            }
            CoreBaseCollection logCollection = new CoreBaseCollection();
            PaymentBillLogInfo logInfo = new PaymentBillLogInfo();
            logInfo.setIP(SysContext.getSysContext().getClientIP());
            logInfo.setOperateTime(new Timestamp(System.currentTimeMillis()));
            logInfo.setUserName(userInfo.getName());
            logInfo.setUserNumber(userInfo.getNumber());
            logInfo.setCompany(info.getCompany());
            logInfo.setBillNumber(info.getNumber());
            if (info.getType() != null && info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE)) {
                logInfo.setOperateBillEnum(OperateBillEnum.SettlementBill_PayOut);
                logInfo.setOperateBill(OperateBillEnum.SettlementBill_PayOut.getAlias());
            } else {
                logInfo.setOperateBillEnum(OperateBillEnum.SettlementBill_LinkPay);
                logInfo.setOperateBill(OperateBillEnum.SettlementBill_LinkPay.getAlias());
            }
            logInfo.setOperateType(operateType);
            logCollection.add((CoreBaseInfo)logInfo);
            PaymentBillLogFactory.getRemoteInstance().addnewBatchData(logCollection);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void showSettlebillUI(Map allCompanyIdMap, Set chongFuSet, UIContext uiContext, int actionType) throws UIException {
        RealModeIDList iidlist = new RealModeIDList();
        ArrayList<String> idList = new ArrayList<String>();
        for (Object id : allCompanyIdMap.keySet()) {
            String[] likedIdAndNumArr;
            String likedIdAndNum;
            int i;
            String originalId = (String)id;
            if (!iidlist.contains(originalId)) {
                iidlist.add(originalId);
                if (actionType != 2) {
                    idList.add(originalId);
                }
            }
            if (!chongFuSet.contains(originalId)) continue;
            List likedIdAndNumList = (List)allCompanyIdMap.get(originalId);
            for (i = 0; i < likedIdAndNumList.size(); ++i) {
                likedIdAndNum = (String)likedIdAndNumList.get(i);
                likedIdAndNumArr = likedIdAndNum.split(";");
                if (!chongFuSet.contains(likedIdAndNumArr[0]) || iidlist.contains(likedIdAndNumArr[0])) continue;
                iidlist.add(likedIdAndNumArr[0]);
                if (actionType == 2) continue;
                idList.add(likedIdAndNumArr[0]);
            }
            for (i = 0; i < likedIdAndNumList.size(); ++i) {
                likedIdAndNum = (String)likedIdAndNumList.get(i);
                likedIdAndNumArr = likedIdAndNum.split(";");
                if (!iidlist.contains(likedIdAndNumArr[0])) {
                    iidlist.add(likedIdAndNumArr[0]);
                    if (actionType == 2) continue;
                    idList.add(likedIdAndNumArr[0]);
                    continue;
                }
                if (actionType == 2) continue;
                int indexOf = idList.indexOf(likedIdAndNumArr[0]);
                idList.remove(originalId);
                idList.add(indexOf, originalId);
            }
        }
        uiContext.put((Object)"ID", (Object)(System.currentTimeMillis() + ""));
        uiContext.put((Object)"IDList", (Object)iidlist);
        uiContext.put((Object)"realIDList", idList);
        uiContext.put((Object)"chongFuSet", (Object)chongFuSet);
        uiContext.put((Object)"actionType", (Object)actionType);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RepeatSettlementBillListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public static void saveSettleBillOperateLog(Set idSet, PaymentOperateType operateType, UserInfo userInfo, OperateBillEnum billType) {
        try {
            if (EmptyUtil.isEmpty((Collection)idSet)) {
                return;
            }
            EntityViewInfo likeView = new EntityViewInfo();
            FilterInfo likeFilter = new FilterInfo();
            likeFilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            likeView.getSelector().add("id");
            likeView.getSelector().add("number");
            likeView.getSelector().add("name");
            likeView.getSelector().add("type");
            likeView.getSelector().add("company.*");
            likeView.setFilter(likeFilter);
            SettlementBillCollection settlementBillCollection = SettlementBillFactory.getRemoteInstance().getSettlementBillCollection(likeView);
            CoreBaseCollection logCollection = new CoreBaseCollection();
            for (int i = 0; i < settlementBillCollection.size(); ++i) {
                SettlementBillInfo info = settlementBillCollection.get(i);
                PaymentBillLogInfo logInfo = new PaymentBillLogInfo();
                logInfo.setIP(SysContext.getSysContext().getClientIP());
                if (info.getType() != null && info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE)) {
                    logInfo.setOperateBillEnum(OperateBillEnum.SettlementBill_PayOut);
                    logInfo.setOperateBill(OperateBillEnum.SettlementBill_PayOut.getAlias());
                } else {
                    logInfo.setOperateBillEnum(OperateBillEnum.SettlementBill_LinkPay);
                    logInfo.setOperateBill(OperateBillEnum.SettlementBill_LinkPay.getAlias());
                }
                logInfo.setOperateTime(new Timestamp(System.currentTimeMillis()));
                logInfo.setUserName(userInfo.getName());
                logInfo.setUserNumber(userInfo.getNumber());
                logInfo.setCompany(info.getCompany());
                logInfo.setBillNumber(info.getNumber());
                logInfo.setOperateType(operateType);
                logCollection.add((CoreBaseInfo)logInfo);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.set(5, calendar.get(5) - 30);
            Date time = calendar.getTime();
            Date DestDate = DateTimeUtils.truncateDate((Date)time);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("operateTime", (Object)DestDate, CompareType.LESS_EQUALS));
            PaymentBillLogFactory.getRemoteInstance().delete(filter);
            PaymentBillLogFactory.getRemoteInstance().addnewBatchData(logCollection);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

