/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Set;

public class PayProcessUtil {
    protected static final String ARAP_RESOURCE = "com.kingdee.eas.fi.ar.ArApBillResource";

    public static boolean isRedRec(ReceivingBillTypeInfo recInfo) {
        ReceivingBillTypeInfo recSourceInfo;
        if (recInfo.getId().toString().equals("DAWSqQEREADgAAIswKgSfCqo2zU=") || recInfo.getId().toString().equals("DAWSqQEREADgAAInwKgSfCqo2zU=") || recInfo.getId().toString().equals("DAWSqQEREADgAAIvwKgSfCqo2zU=")) {
            return true;
        }
        return recInfo.getPreSetBillType() != null && ((recSourceInfo = recInfo.getPreSetBillType()).getId().toString().equals("DAWSqQEREADgAAIswKgSfCqo2zU=") || recSourceInfo.getId().toString().equals("DAWSqQEREADgAAInwKgSfCqo2zU=") || recSourceInfo.getId().toString().equals("DAWSqQEREADgAAIvwKgSfCqo2zU="));
    }

    public static void checkIfCanRefundPay(ReceivingBillInfo info) throws BOSException, EASBizException {
        boolean isCanRefundmentPay = false;
        if (info.isIsRefundmentPay()) {
            ReceivingBillTypeInfo recInfo = info.getRecBillType();
            if (PayProcessUtil.isRedRec(recInfo)) {
                AccountViewInfo accountInfo = info.getPayeeAccount();
                boolean bl = isCanRefundmentPay = !accountInfo.isIsCash();
                if (accountInfo.isIsBank()) {
                    isCanRefundmentPay = false;
                }
                if (info.getPayeeAccountBank() != null) {
                    isCanRefundmentPay = false;
                }
            }
            if (!isCanRefundmentPay) {
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)ARAP_RESOURCE, (String)"BillCantPayProcess")));
            }
        }
    }

    public static void checkIfHadRefundPaymentBill(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)idSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        IPaymentBill iPaymentBill = null;
        iPaymentBill = ctx == null ? PaymentBillFactory.getRemoteInstance() : PaymentBillFactory.getLocalInstance(ctx);
        PaymentBillCollection paymentBillCollection = iPaymentBill.getPaymentBillCollection(view);
        if (paymentBillCollection.size() != 0) {
            throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)ARAP_RESOURCE, (String)"BillHasNext")));
        }
    }
}

