/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.monitor.client.WfUtils;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AssItemsForCashPayCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashPayFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashPayInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PaymentBillDataProviderNew
implements BOSQueryDelegate {
    private static Logger logger = Logger.getLogger((String)PaymentBillDataProviderNew.class.getName());
    private static IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fi.cas.PaymentBillTDQuery");
    private Set ids = null;
    private String templatePath = "/FI/CAS/PAYMENTBILL";
    private String currentPK = null;
    private boolean isPrintUnPassAuditResult = true;
    KDNoteHelper currentHelper = null;

    public PaymentBillDataProviderNew(Set id) {
        this.ids = id;
    }

    public PaymentBillDataProviderNew(List id) {
        this(new HashSet(id));
    }

    public PaymentBillDataProviderNew(List id, boolean isPrintUnPassAuditResult) {
        this(new HashSet(id));
        this.isPrintUnPassAuditResult = isPrintUnPassAuditResult;
    }

    public PaymentBillDataProviderNew(List id, KDNoteHelper currentHelper, IMetaDataPK pk) {
        this(new HashSet(id));
        this.currentHelper = currentHelper;
        qpk = pk;
    }

    public PaymentBillDataProviderNew(Set id, KDNoteHelper currentHelper) {
        this.ids = id;
        this.currentHelper = currentHelper;
    }

    public PaymentBillDataProviderNew(List id, KDNoteHelper currentHelper) {
        this(new HashSet(id));
        this.currentHelper = currentHelper;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qpk);
            exec.option().isAutoTranslateEnum = true;
            exec.option().isAutoTranslateBoolean = true;
            exec.option().isMultiLanguage = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("paymentBill.id", (Object)this.ids, CompareType.INCLUDE));
            ArrayList param = ds.getParams();
            R1PrintDataSortItem[] sortItems = ds.getSortFields();
            if (sortItems != null && sortItems.length > 0) {
                for (int i = 0; i < sortItems.length; ++i) {
                    String fieldName = sortItems[i].getSortField();
                    if (EmptyUtil.isEmpty((String)fieldName)) continue;
                    SorterItemInfo sort = null;
                    sort = fieldName.indexOf("entries") > -1 ? new SorterItemInfo(fieldName) : (fieldName.indexOf("paymentBill") > -1 ? new SorterItemInfo(fieldName) : (fieldName.indexOf(".") > -1 ? new SorterItemInfo(fieldName) : new SorterItemInfo("paymentBill." + fieldName)));
                    if (0 == sortItems[i].getSortType()) {
                        sort.setSortType(SortType.ASCEND);
                    } else {
                        sort.setSortType(SortType.DESCEND);
                    }
                    ev.getSorter().add(sort);
                }
            } else {
                SorterItemInfo sort = new SorterItemInfo("paymentBill.number");
                sort.setSortType(SortType.ASCEND);
                ev.getSorter().add(sort);
            }
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
                this.currentPK = iRowSet.getString("paymentBill.id");
                int precision = iRowSet.getInt("currency.precision");
                iRowSet.updateBigDecimal("actualAmt", iRowSet.getBigDecimal("actualAmt").setScale(precision, 4));
                String entryID = iRowSet.getString("PaymentBillEntry.id");
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filteri = new FilterInfo();
                filteri.getFilterItems().add(new FilterItemInfo("entryParent", (Object)entryID));
                evi.setFilter(filteri);
                evi.getSelector().add(new SelectorItemInfo("*"));
                evi.getSelector().add(new SelectorItemInfo("asstActType.*"));
                AssItemsForCashPayCollection assColl = AssItemsForCashPayFactory.getRemoteInstance().getAssItemsForCashPayCollection(evi);
                AssItemsForCashPayInfo infoTmp = null;
                CoreBaseInfo entityInfo = null;
                StringBuffer sf_assName = new StringBuffer();
                StringBuffer sf_assType = new StringBuffer();
                for (int i = 0; i < assColl.size(); ++i) {
                    infoTmp = assColl.get(i);
                    if (infoTmp.getAsstActType() != null) {
                        sf_assType.append(infoTmp.getAsstActType().getName());
                    }
                    if (infoTmp.getFromID() != null && !infoTmp.getFromID().equals("") && (entityInfo = EJBAccessFactory.createRemoteInstance().getEntityInfo(infoTmp.getFromID())) != null && entityInfo.getString("name") != null) {
                        sf_assName.append(entityInfo.getString("name"));
                    }
                    if (i + 1 == assColl.size()) continue;
                    sf_assType.append("\uff1b");
                    sf_assName.append("\uff1b");
                }
                iRowSet.updateString("assName", sf_assName.toString());
                iRowSet.updateString("assType", sf_assType.toString());
                String currencyId = iRowSet.getString("currency.id");
                String companyId = iRowSet.getString("company.id");
                Date bizDate = iRowSet.getDate("paymentBill.bizDate");
                int exRatePrec = this.getExRatePrec(currencyId, null, companyId, bizDate);
                iRowSet.updateBigDecimal("paymentBill.exchangeRate", iRowSet.getBigDecimal("paymentBill.exchangeRate").setScale(exRatePrec, 4));
                iRowSet.updateString("paymentBillType.name", iRowSet.getString("paymentBillType.name"));
                iRowSet.updateString("settlementType.name", iRowSet.getString("settlementType.name"));
                iRowSet.updateString("person.name", iRowSet.getString("person.name"));
                iRowSet.updateString("adminOrgUnit.name", iRowSet.getString("adminOrgUnit.name"));
                iRowSet.updateString("coreBillNumber", iRowSet.getString("coreBillNumber"));
                iRowSet.updateString("coreBillType.name", iRowSet.getString("coreBillType.name"));
                iRowSet.updateString("contractNum", iRowSet.getString("contractNum"));
                iRowSet.updateString("contractEntrySeq", iRowSet.getString("contractEntrySeq"));
                iRowSet.updateString("oppAccount1.name", iRowSet.getString("oppAccount1.name"));
                iRowSet.updateString("costCenter.name", iRowSet.getString("costCenter.name"));
                iRowSet.updateString("paymentBill.recProvince", iRowSet.getString("paymentBill.recProvince"));
                iRowSet.updateString("paymentBill.recCity", iRowSet.getString("paymentBill.recCity"));
                iRowSet.updateBigDecimal("paymentBill.actPayAmt", iRowSet.getBigDecimal("paymentBill.actPayAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("paymentBill.actPayAmtVc", iRowSet.getBigDecimal("paymentBill.actPayAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("paymentBill.actPayLocAmt", iRowSet.getBigDecimal("paymentBill.actPayLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("paymentBill.actPayLocAmtVc", iRowSet.getBigDecimal("paymentBill.actPayLocAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("amount", iRowSet.getBigDecimal("amount").setScale(precision, 4));
                iRowSet.updateBigDecimal("amountVc", iRowSet.getBigDecimal("amountVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmt", iRowSet.getBigDecimal("localAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmtVc", iRowSet.getBigDecimal("localAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("unVcAmount", iRowSet.getBigDecimal("unVcAmount").setScale(precision, 4));
                iRowSet.updateBigDecimal("unVcLocAmount", iRowSet.getBigDecimal("unVcLocAmount").setScale(precision, 4));
                if (iRowSet.getBigDecimal("rebate") != null) {
                    iRowSet.updateBigDecimal("rebate", iRowSet.getBigDecimal("rebate").setScale(precision, 4));
                }
                iRowSet.updateBigDecimal("rebateAmtVc", iRowSet.getBigDecimal("rebateAmtVc").setScale(precision, 4));
                if (iRowSet.getBigDecimal("rebateLocAmt") != null) {
                    iRowSet.updateBigDecimal("rebateLocAmt", iRowSet.getBigDecimal("rebateLocAmt").setScale(precision, 4));
                }
                if (iRowSet.getBigDecimal("rebateLocAmtVc") != null) {
                    iRowSet.updateBigDecimal("rebateLocAmtVc", iRowSet.getBigDecimal("rebateLocAmtVc").setScale(precision, 4));
                }
                if (iRowSet.getBigDecimal("actualAmtVc") != null) {
                    iRowSet.updateBigDecimal("actualAmtVc", iRowSet.getBigDecimal("actualAmtVc").setScale(precision, 4));
                }
                if (iRowSet.getBigDecimal("actualLocAmt") != null) {
                    iRowSet.updateBigDecimal("actualLocAmt", iRowSet.getBigDecimal("actualLocAmt").setScale(precision, 4));
                }
                if (iRowSet.getBigDecimal("actualLocAmtVc") != null) {
                    iRowSet.updateBigDecimal("actualLocAmtVc", iRowSet.getBigDecimal("actualLocAmtVc").setScale(precision, 4));
                }
                String billId = iRowSet.getString("id");
                MultiApproveCollection col = CashHelper.getMutiApprove(billId);
                if (this.isPrintUnPassAuditResult) {
                    for (int i = 1; i <= col.size() && i <= 5; ++i) {
                        MultiApproveInfo info = col.get(i - 1);
                        iRowSet.updateString("censor" + i, info.getCreator().getName());
                        iRowSet.updateString("auditResult" + i, info.getIsPass().toString());
                        iRowSet.updateString("auditOpinion" + i, info.getOpinion());
                    }
                } else {
                    IQueryExecutor multiExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.PaymentBillMultiApproveQuery"));
                    EntityViewInfo multiEv = new EntityViewInfo();
                    FilterInfo multiFilter = new FilterInfo();
                    multiFilter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
                    multiFilter.getFilterItems().add(new FilterItemInfo("ProcInst.state", (Object)"closed.completed,open.running,open.not_running.suspended", CompareType.INCLUDE));
                    multiFilter.mergeFilter(WfUtils.getApproveFilter((String)billId), "and");
                    multiEv.getSelector().add(new SelectorItemInfo("creator.name"));
                    multiEv.getSelector().add(new SelectorItemInfo("isPass"));
                    multiEv.getSelector().add(new SelectorItemInfo("opinion"));
                    SorterItemInfo multiSic = new SorterItemInfo("CreateTime");
                    multiSic.setSortType(SortType.ASCEND);
                    multiEv.getSorter().add(multiSic);
                    multiEv.setFilter(multiFilter);
                    multiExec.setObjectView(multiEv);
                    IRowSet iMultiRowSet = multiExec.executeQuery();
                    int i = 1;
                    while (iMultiRowSet.next()) {
                        if ("true".equals(iMultiRowSet.getString("isPass"))) {
                            iRowSet.updateString("censor" + i, iMultiRowSet.getString("creator.name"));
                            iRowSet.updateString("auditResult" + i, iMultiRowSet.getString("isPass"));
                            iRowSet.updateString("auditOpinion" + i, iMultiRowSet.getString("opinion"));
                            ++i;
                        } else {
                            for (int j = 1; j <= i; ++j) {
                                iRowSet.updateString("censor" + j, null);
                                iRowSet.updateString("auditResult" + j, null);
                                iRowSet.updateString("auditOpinion" + j, null);
                            }
                            i = 1;
                        }
                        if (i != 6) continue;
                    }
                }
                if (iRowSet.getString("paymentBill.auditDate") != null) {
                    iRowSet.updateString("paymentBill.auditDate", iRowSet.getString("paymentBill.auditDate").substring(0, 10));
                }
                if (iRowSet.getString("payeeType.name") == null) {
                    iRowSet.updateString("payeeType.name", EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"374_PaymentBillDataProvider"));
                }
                iRowSet.updateString("sourceBillId", this.getBillNumber(iRowSet.getString("sourceBillId")));
                StringBuffer voucherNumber = new StringBuffer("");
                VoucherCollection colVoucher = null;
                if (!iRowSet.getBoolean("paymentBill.fiVouchered")) continue;
                colVoucher = this.getVoucherCollection(iRowSet.getString("paymentBill.id"));
                if (colVoucher != null && colVoucher.size() > 0) {
                    for (VoucherInfo info : colVoucher) {
                        voucherNumber.append(info.getNumber());
                        voucherNumber.append("  ");
                    }
                }
                iRowSet.updateString("voucherNumber", voucherNumber.toString());
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return iRowSet;
    }

    private void addDataFilter(FilterInfo filter, ArrayList param) throws BOSException {
        DSParam dp;
        String s;
        if (filter == null || filter.getFilterItems().size() == 0) {
            return;
        }
        if (param == null || param.size() == 0) {
            return;
        }
        FilterInfo datafilter = null;
        if (param != null && param.size() > 0 && (s = (dp = (DSParam)param.get(0)).getColName()) != null && s.equalsIgnoreCase("datafilter")) {
            String f = dp.getAssociateField();
            try {
                datafilter = new FilterInfo(f);
            }
            catch (Exception e) {
                logger.info((Object)f);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (datafilter != null && datafilter.getFilterItems().size() > 0) {
            filter.mergeFilter(datafilter, "AND");
        }
    }

    private int getExRatePrec(String srcCurrId, String destCurrId, String companyId, java.util.Date date) {
        if (srcCurrId == null || date == null) {
            return 0;
        }
        try {
            CompanyOrgUnitInfo company = null;
            if (destCurrId == null) {
                company = companyId == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                destCurrId = company.getBaseCurrency().getId().toString();
            }
            return this.getExchangeRatePrec(srcCurrId, destCurrId, company);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return 0;
    }

    private int getExchangeRatePrec(String sourceCurID, String desCurID, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ObjectUuidPK sourceCurrpk;
        String key = sourceCurID + "+" + desCurID;
        int prec = 3;
        ExchangeRateInfo erInfo = null;
        ExchangeTableInfo baseExchangeTable = company.getBaseExchangeTable();
        if (baseExchangeTable == null) {
            logger.error((Object)"baseExchangeTable is null");
        }
        ObjectUuidPK destCurrpk = new ObjectUuidPK(desCurID);
        ObjectUuidPK excTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
        erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurID)), (IObjectPK)destCurrpk, new java.util.Date(System.currentTimeMillis()));
        if (erInfo != null && erInfo.getExchangeAux() != null) {
            prec = erInfo.getExchangeAux().getPrecision();
        }
        return prec;
    }

    private String getBillNumber(String id) throws Exception {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BOSUuid bosId = BOSUuid.read((String)id);
        IObjectValue info = DynamicObjectFactory.getRemoteInstance().getValue(bosId.getType(), (IObjectPK)pk);
        return info.getString("number");
    }

    private VoucherCollection getVoucherCollection(String billId) throws BOSException, EASBizException {
        String[] srcEntriesID = new String[]{billId};
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        BOSObjectType voucherBosType = new VoucherInfo().getBOSType();
        BOTRelationCollection relationColl = iBTPManager.getDestRelation(billId);
        VoucherCollection colVoucher = null;
        if (relationColl != null && !relationColl.isEmpty()) {
            HashSet<String> voucherIds = new HashSet<String>();
            BOTRelationInfo relationInfo = null;
            int size = relationColl.size();
            for (int i = 0; i < size; ++i) {
                relationInfo = relationColl.get(i);
                if (!relationInfo.getDestEntityID().equals(voucherBosType.toString())) continue;
                voucherIds.add(relationInfo.getDestObjectID());
            }
            if (voucherIds != null && voucherIds.size() != 0) {
                IVoucher iVoucher = VoucherFactory.getRemoteInstance();
                SelectorItemCollection cel = new SelectorItemCollection();
                cel.add("*");
                cel.add("creator.*");
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().addObjectCollection((IObjectCollection)cel);
                FilterInfo filter = new FilterInfo();
                FilterItemInfo filterItem = new FilterItemInfo("id", voucherIds, CompareType.INCLUDE);
                filter.getFilterItems().add(filterItem);
                view.setFilter(filter);
                colVoucher = iVoucher.getVoucherCollection(view);
            }
        }
        if (colVoucher == null) {
            colVoucher = new VoucherCollection();
        }
        return colVoucher;
    }
}

