/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils.common.tdprint;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.assistant.PrintIntegrationInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class AgentPayBillTDProvider
implements BOSQueryDelegate {
    private static Logger logger = Logger.getLogger(AgentPayBillTDProvider.class);
    private Set ids = null;
    private IMetaDataPK qpk = null;
    private static final String SHREntryAmount = "XXXXXX";

    public AgentPayBillTDProvider() {
    }

    public AgentPayBillTDProvider(List id) {
        this.ids = new HashSet(id);
    }

    public AgentPayBillTDProvider(List id, IMetaDataPK qpk) {
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.qpk);
            exec.option().isAutoTranslateEnum = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            R1PrintDataSortItem[] sortItems = ds.getSortFields();
            if (sortItems != null && sortItems.length > 0) {
                for (int i = 0; i < sortItems.length; ++i) {
                    String fieldName = sortItems[i].getSortField();
                    if (EmptyUtil.isEmpty((String)fieldName)) continue;
                    SorterItemInfo sort = null;
                    sort = fieldName.indexOf("ENTRYS") > -1 ? new SorterItemInfo(fieldName) : (fieldName.indexOf("AGENTPAYBILL") > -1 ? new SorterItemInfo(fieldName) : (fieldName.indexOf(".") > -1 ? new SorterItemInfo(fieldName) : new SorterItemInfo("AGENTPAYBILL." + fieldName)));
                    if (0 == sortItems[i].getSortType()) {
                        sort.setSortType(SortType.ASCEND);
                    } else {
                        sort.setSortType(SortType.DESCEND);
                    }
                    ev.getSorter().add(sort);
                }
            } else {
                SorterItemInfo sort = new SorterItemInfo("AGENTPAYBILL.number");
                sort.setSortType(SortType.ASCEND);
                ev.getSorter().add(sort);
            }
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
            int printedTimes = 0;
            while (iRowSet.next()) {
                String fid;
                ObjectUuidPK pk;
                String bosType;
                PrintIntegrationInfo printInfo;
                if (iRowSet.getString("SourceType").equals("SHR")) {
                    String companyID = iRowSet.getString("company.id");
                    boolean encryption = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS112", (IObjectPK)new ObjectUuidPK(companyID));
                    if (encryption) {
                        IRowSetMetaData rsmd = iRowSet.getRowSetMetaData();
                        rsmd.setColumnType(rsmd.getColumnIndex("entrys.amount"), 1);
                        iRowSet.updateString("entrys.amount", SHREntryAmount);
                    }
                }
                if ((printInfo = pinfo.getBillPrintInfo(bosType = (pk = new ObjectUuidPK(fid = this.ids.iterator().next().toString())).getObjectType().toString(), fid)) != null) {
                    printedTimes = printInfo.getPrintedNumber();
                }
                try {
                    iRowSet.updateString("printCount", String.valueOf(printedTimes + 1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                logger.info((Object)("------------printCount = " + (printedTimes + 1)));
                logger.error((Object)("------------printCount = " + (printedTimes + 1)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iRowSet;
    }
}

