/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils.common.tdprint;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BankBalanceAdjustFactory;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStmtBookReportInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.utils.common.tdprint.WebInfoSnapShot;
import com.kingdee.eas.fi.cas.utils.common.tdprint.WebMultiInfoCollSnapShot;
import com.kingdee.eas.fi.cas.utils.common.tdprint.WebTDUtils;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankBalanceAdjustWebDataProvider
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(BankBalanceAdjustWebDataProvider.class);
    public static final String RES_PATH = "com.kingdee.eas.fi.cas.web.CasWebResource";
    private String idStr = null;

    public BankBalanceAdjustWebDataProvider(Set ids) {
        for (String id : ids) {
            if (EmptyUtil.isEmpty((String)this.idStr)) {
                this.idStr = id;
                continue;
            }
            this.idStr = this.idStr + "," + id;
        }
    }

    public BankBalanceAdjustWebDataProvider(List ids) {
        for (String id : ids) {
            if (EmptyUtil.isEmpty((String)this.idStr)) {
                this.idStr = id;
                continue;
            }
            this.idStr = this.idStr + "," + id;
        }
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        DynamicRowSet rowSet = null;
        try {
            Set exportData = BankBalanceAdjustFactory.getRemoteInstance().getBalanceAdjustPageInitData(this.idStr);
            WebMultiInfoCollSnapShot tkdtss = this.generateRowSet(exportData, (IRowSet)rowSet);
            rowSet = new DynamicRowSet(tkdtss.getTitleKeys().length);
            this.generateMetaData(tkdtss, rowSet);
            Iterator it = exportData.iterator();
            int index = 0;
            WebTDUtils tdUtil = new WebTDUtils();
            while (it.hasNext()) {
                HashMap mapResultOnlyDetail = new HashMap();
                Map mapResult = (Map)it.next();
                mapResultOnlyDetail.put("entprUnreachedDetails", mapResult.get("entprUnreachedColl"));
                mapResultOnlyDetail.put("bankUnreachedDetails", mapResult.get("bankUnreachedColl"));
                UserDefineColumnCollection udcc = this.getUserDefineColumnCollection(mapResult);
                WebMultiInfoCollSnapShot kdtss = this.generateSnapShot(mapResultOnlyDetail, udcc);
                int Sacle = EmptyUtil.isEmpty(mapResult.get("precision")) ? 4 : (Integer)mapResult.get("precision");
                tdUtil.fillRowSetForAdjust(kdtss, rowSet, udcc, Sacle);
                ++index;
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return rowSet;
    }

    private void printRowSet(WebInfoSnapShot kdtss, IRowSet rs) throws SQLException {
        String[] keys = kdtss.getTitleKeys();
        while (rs.next()) {
            for (int i = 0; i < keys.length; ++i) {
                System.out.println(keys[i] + " = " + rs.getString(keys[i]));
            }
            System.out.println("******************************************************");
        }
        rs.beforeFirst();
    }

    private WebMultiInfoCollSnapShot generateRowSet(Set exportData, IRowSet rowSet) throws SQLException, EASBizException, BOSException {
        Iterator it = exportData.iterator();
        boolean index = false;
        HashMap<String, BankStatementCollection> mapResultOnlyDetail = new HashMap<String, BankStatementCollection>();
        UserDefineColumnCollection udcc = null;
        BankStatementCollection entprUnreachedColl = new BankStatementCollection();
        JournalCollection bankUnreachedColl = new JournalCollection();
        while (it.hasNext()) {
            Map mapResult = (Map)it.next();
            entprUnreachedColl.addObjectCollection((IObjectCollection)mapResult.get("entprUnreachedColl"));
            bankUnreachedColl.addObjectCollection((IObjectCollection)mapResult.get("bankUnreachedColl"));
            udcc = this.getUserDefineColumnCollection(mapResult);
        }
        mapResultOnlyDetail.put("entprUnreachedDetails", entprUnreachedColl);
        mapResultOnlyDetail.put("bankUnreachedDetails", (BankStatementCollection)bankUnreachedColl);
        WebMultiInfoCollSnapShot kdtss = this.generateSnapShot(mapResultOnlyDetail, udcc);
        return kdtss;
    }

    private void generateMetaData(WebInfoSnapShot kdtss, DynamicRowSet drs) throws SQLException {
        String[] keys = kdtss.getTitleKeys();
        for (int i = 0; i < keys.length; ++i) {
            ColInfo ciId = new ColInfo();
            ciId.colType = 12;
            ciId.columnName = keys[i];
            drs.setColInfo(i + 1, ciId);
        }
    }

    protected WebMultiInfoCollSnapShot generateSnapShot(Map infoColls, UserDefineColumnCollection udcc) throws SQLException {
        WebMultiInfoCollSnapShot kdtss = new WebMultiInfoCollSnapShot(infoColls, udcc);
        kdtss.init();
        return kdtss;
    }

    protected UserDefineColumnCollection getUserDefineColumnCollection(Map bankBal) throws EASBizException, BOSException {
        UserDefineColumnCollection udcc = new UserDefineColumnCollection();
        this.getInfoCommon(udcc, bankBal);
        this.getInfoEntBankJounral(udcc, bankBal);
        this.getInfoBankStatmnt(udcc, bankBal);
        return udcc;
    }

    private void getInfoBankStatmnt(UserDefineColumnCollection udcc, Map bankBal) {
        BankStmtBookReportInfo rptInfo = (BankStmtBookReportInfo)bankBal.get("rptInfo");
        Integer precision = (Integer)bankBal.get("precision");
        UserDefineColumnInfo info = null;
        String title = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"409_BankBalanceAdjustWebDataProvider");
        info = new UserDefineColumnInfo();
        info.setName("statmntAmount");
        info.setDescription(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"269_QingCapitalSumFacadeControllerBean"));
        info.setAlias(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"269_QingCapitalSumFacadeControllerBean"));
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal bankStmtAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getBankStmtAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(bankStmtAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("entprGot");
        info.setDescription(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"410_BankBalanceAdjustWebDataProvider"));
        info.setAlias(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"410_BankBalanceAdjustWebDataProvider"));
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal entprGotAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getEntprGotAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(entprGotAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("entprPayed");
        info.setDescription(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"411_BankBalanceAdjustWebDataProvider"));
        info.setAlias(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"411_BankBalanceAdjustWebDataProvider"));
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal entprPayedAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getEntprPayedAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(entprPayedAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("adjustedStatmntAmount");
        info.setDescription(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"412_BankBalanceAdjustWebDataProvider"));
        info.setAlias(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"412_BankBalanceAdjustWebDataProvider"));
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal bankBalance = PrecisionUtil.formatCurrencyPrecision((BigDecimal)((BigDecimal)bankBal.get("bankBalance")), (CurrencyInfo)currencyInfo);
        info.setColumnValue(bankBalance.toString());
        udcc.add((Object)info);
    }

    private void getInfoEntBankJounral(UserDefineColumnCollection udcc, Map bankBal) {
        BankStmtBookReportInfo rptInfo = (BankStmtBookReportInfo)bankBal.get("rptInfo");
        Integer precision = (Integer)bankBal.get("precision");
        UserDefineColumnInfo info = null;
        String title = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"413_BankBalanceAdjustWebDataProvider");
        info = new UserDefineColumnInfo();
        info.setName("jornalAmount");
        info.setDescription(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"269_QingCapitalSumFacadeControllerBean"));
        info.setAlias(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"269_QingCapitalSumFacadeControllerBean"));
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal bankBookAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getBankBookAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(bankBookAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankGot");
        info.setDescription(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"414_BankBalanceAdjustWebDataProvider"));
        info.setAlias(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"414_BankBalanceAdjustWebDataProvider"));
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal bankGotAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getBankGotAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(bankGotAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankPayed");
        info.setDescription(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"415_BankBalanceAdjustWebDataProvider"));
        info.setAlias(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"415_BankBalanceAdjustWebDataProvider"));
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal bankPayedAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)rptInfo.getBankPayedAmt(), (CurrencyInfo)currencyInfo);
        info.setColumnValue(bankPayedAmt.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("adjustedJournalAmount");
        info.setDescription(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"412_BankBalanceAdjustWebDataProvider"));
        info.setAlias(title + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"412_BankBalanceAdjustWebDataProvider"));
        currencyInfo = new CurrencyInfo();
        currencyInfo.setPrecision(precision.intValue());
        BigDecimal entBalance = PrecisionUtil.formatCurrencyPrecision((BigDecimal)((BigDecimal)bankBal.get("entBalance")), (CurrencyInfo)currencyInfo);
        info.setColumnValue(entBalance.toString());
        udcc.add((Object)info);
    }

    private void getInfoCommon(UserDefineColumnCollection udcc, Map bankBal) {
        UserDefineColumnInfo info = null;
        AccountBankInfo bankInfo = (AccountBankInfo)bankBal.get("accountBank");
        PeriodInfo periodInfo = (PeriodInfo)bankBal.get("periodInfo");
        CurrencyInfo currencyInfo = (CurrencyInfo)bankBal.get("currencyInfo");
        Date date = (Date)bankBal.get("bizDate");
        info = new UserDefineColumnInfo();
        info.setName("bankAccount");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"416_BankBalanceAdjustWebDataProvider"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"416_BankBalanceAdjustWebDataProvider"));
        info.setColumnValue(bankInfo.getNumber() + " " + bankInfo.getName() + " " + bankInfo.getBankAccountNumber());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankAccountNumber");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"11_AgentPayBillControllerBean"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"11_AgentPayBillControllerBean"));
        info.setColumnValue(bankInfo.getNumber() + " " + bankInfo.getName() + " " + bankInfo.getBankAccountNumber());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("currency");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"4_AgentPayBillControllerBean"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"4_AgentPayBillControllerBean"));
        info.setColumnValue(currencyInfo.getName());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankAccountView");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"417_BankBalanceAdjustWebDataProvider"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"417_BankBalanceAdjustWebDataProvider"));
        info.setColumnValue(bankInfo.getAccount().getNumber() + " " + bankInfo.getAccount().getName());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankInfoAccountNumber");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"418_BankBalanceAdjustWebDataProvider"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"418_BankBalanceAdjustWebDataProvider"));
        info.setColumnValue(bankInfo.getBankAccountNumber());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankInfoName");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"260_QingCapitalSumFacadeControllerBean"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"260_QingCapitalSumFacadeControllerBean"));
        info.setColumnValue(bankInfo.getName());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankInfoNumber");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"259_QingCapitalSumFacadeControllerBean"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"259_QingCapitalSumFacadeControllerBean"));
        info.setColumnValue(bankInfo.getNumber());
        udcc.add((Object)info);
        if (periodInfo != null) {
            info = new UserDefineColumnInfo();
            info.setName("intTerm");
            info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"265_QingCapitalSumFacadeControllerBean"));
            info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"265_QingCapitalSumFacadeControllerBean"));
            info.setColumnValue(periodInfo.getPeriodYear() + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"419_BankBalanceAdjustWebDataProvider") + periodInfo.getPeriodNumber() + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"380_JournalDataProvider"));
            udcc.add((Object)info);
        }
        if (date != null) {
            info = new UserDefineColumnInfo();
            info.setName("bizDate");
            info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"320_BankBalanceAdjustEditUI"));
            info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"320_BankBalanceAdjustEditUI"));
            info.setColumnValue(date.toString());
            udcc.add((Object)info);
        }
        info = new UserDefineColumnInfo();
        info.setName("Company");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"420_BankBalanceAdjustWebDataProvider"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"420_BankBalanceAdjustWebDataProvider"));
        info.setColumnValue(bankInfo.getCompany().toString());
        udcc.add((Object)info);
        String auditName = bankBal.get("audit") == null ? "" : (String)bankBal.get("audit");
        info = new UserDefineColumnInfo();
        info.setName("audit");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"421_BankBalanceAdjustWebDataProvider"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"421_BankBalanceAdjustWebDataProvider"));
        info.setColumnValue(auditName);
        udcc.add((Object)info);
        String auditTime = bankBal.get("auditTime") == null ? "" : (String)bankBal.get("auditTime");
        info = new UserDefineColumnInfo();
        info.setName("auditTime");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"422_BankBalanceAdjustWebDataProvider"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"422_BankBalanceAdjustWebDataProvider"));
        info.setColumnValue(auditTime);
        udcc.add((Object)info);
        String transDetailAmtStr = "";
        if (bankBal.get("transDetailAmt") != null) {
            BigDecimal transDetailAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)((BigDecimal)bankBal.get("transDetailAmt")), (CurrencyInfo)currencyInfo);
            transDetailAmtStr = transDetailAmt.toString();
        }
        info = new UserDefineColumnInfo();
        info.setName("transDetailAmt");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"423_BankBalanceAdjustWebDataProvider"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"423_BankBalanceAdjustWebDataProvider"));
        info.setColumnValue(transDetailAmtStr);
        udcc.add((Object)info);
        String journalDifferenceAmtStr = "";
        if (bankBal.get("journalDifferenceAmt") != null) {
            BigDecimal journalDifferenceAmt = PrecisionUtil.formatCurrencyPrecision((BigDecimal)((BigDecimal)bankBal.get("journalDifferenceAmt")), (CurrencyInfo)currencyInfo);
            journalDifferenceAmtStr = journalDifferenceAmt.toString();
        }
        info = new UserDefineColumnInfo();
        info.setName("journalDifferenceAmt");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"424_BankBalanceAdjustWebDataProvider"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"424_BankBalanceAdjustWebDataProvider"));
        info.setColumnValue(journalDifferenceAmtStr);
        udcc.add((Object)info);
    }
}

