/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.validate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.validate.AbstractValidator;
import com.kingdee.eas.fi.cas.validate.ValidateResult;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public abstract class AbstractPaymentBillValidator
extends AbstractValidator {
    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("payerAccount.*");
        selector.add("payerAccount.InnerAcct.*");
        selector.add("payerAccountBank.*");
        selector.add("payeeAccountBankO.*");
        selector.add("payeeAccountBankO.InnerAcct.*");
        selector.add("payerAccountBank.InnerAcct.*");
        selector.add("payerAccountBank.InnerAcct.clearingHouse.*");
        selector.add("settlementType.*");
        selector.add("settlementType.ntType.*");
        selector.add("cheque.*");
        selector.add("payerBank.*");
        selector.add("bizType.*");
        selector.add("oppInnerAcct.*");
        selector.add("oppAccount.*");
        selector.add("company.*");
        selector.add("payBillType.*");
        selector.add("actRecAccountBank.*");
        selector.add("payerInAcctID.*");
        selector.add(new SelectorItemInfo("entries.*"));
        selector.add(new SelectorItemInfo("cheque.*"));
        selector.add(new SelectorItemInfo("cheque.applyRec.applyCompany.id"));
        selector.add(new SelectorItemInfo("cbPayInfo.paymentCurrency.isoCode"));
        selector.add(new SelectorItemInfo("cbPayInfo.payeeCurrency.isoCode"));
        return selector;
    }

    protected IPaymentBill getBizInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return PaymentBillFactory.getRemoteInstance();
        }
        return PaymentBillFactory.getLocalInstance(ctx);
    }

    @Override
    protected IObjectCollection getBizCollection(Context ctx, EntityViewInfo evi) throws BOSException {
        return this.getBizInterface(ctx).getPaymentBillCollection(evi);
    }

    protected void checkAcctViewIsValid(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        if (info.getPayerAccount() != null) {
            RecPayHelper.checkAcctViewIsValid(ctx, info.getNumber(), info.getCompany(), info.getPayerAccount());
        }
        if (info.getOppAccount() != null) {
            RecPayHelper.checkAcctViewIsValid(ctx, info.getNumber(), info.getCompany(), info.getOppAccount());
        }
    }

    protected void checkPSClose(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        RecPayHelper.checkPSIsClose(ctx, info);
    }

    protected boolean checkIsActionFromSettle(Context ctx, String billId) {
        boolean isRecBySettle = false;
        if (ctx.get((Object)("isAutoRecPayByCH" + billId)) != null) {
            isRecBySettle = true;
            ctx.remove((Object)("isAutoRecPayByCH" + billId));
        }
        return isRecBySettle;
    }

    protected void isCanManualRecPay(Context ctx, RecPayBillInfo info) throws RecPayException {
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean isOutSettleAutoRecPay = ctxHelper.getBooleanParam("CS062", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (isOutSettleAutoRecPay && info.getBizType() != null && (info.getBizType().getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) || info.getBizType().getType().equals((Object)SettBizTypeEnum.LINKPAY) || info.getBizType().getType().equals((Object)SettBizTypeEnum.RECOUTSIDE)) && (info.getSettlementStatus().equals((Object)SettlementStatusEnum.SUBMITED) || info.getSettlementStatus().equals((Object)SettlementStatusEnum.ACCEPTED))) {
            throw new RecPayException(RecPayException.CANNOT_PAY_CS062);
        }
        boolean isInSettleAutoRecPay = ctxHelper.getBooleanParam("CS110", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (isInSettleAutoRecPay && info.getBizType() != null && (info.getBizType().getType().equals((Object)SettBizTypeEnum.PAYINSIDE) || info.getBizType().getType().equals((Object)SettBizTypeEnum.PAYINSIDEDIF) || info.getBizType().getType().equals((Object)SettBizTypeEnum.RECINSIDE) || info.getBizType().getType().equals((Object)SettBizTypeEnum.RECINSIDEDIF)) && (info.getSettlementStatus().equals((Object)SettlementStatusEnum.SUBMITED) || info.getSettlementStatus().equals((Object)SettlementStatusEnum.ACCEPTED))) {
            throw new RecPayException(RecPayException.CANNOT_PAY_CS110);
        }
    }

    @Override
    public ValidateResult validate(Context ctx, IObjectCollection abstractObjectCollection, boolean throwException) throws BOSException, EASBizException {
        if (!(abstractObjectCollection instanceof PaymentBillCollection)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"correct_valid", (Locale)ctx.getLocale()));
        }
        return super.validate(ctx, abstractObjectCollection, throwException);
    }
}

