/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.validate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.validate.IValidator;
import com.kingdee.eas.fi.cas.validate.ValidateResult;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public abstract class AbstractValidator
implements IValidator {
    @Override
    public void validate(Context ctx, Set idSet) throws BOSException, EASBizException {
        this.validate(ctx, idSet, true);
    }

    @Override
    public ValidateResult validate(Context ctx, Set idSet, boolean throwException) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)this.getSelector(), null);
        IObjectCollection oColl = this.getBizCollection(ctx, evi);
        if (oColl instanceof AbstractObjectCollection) {
            IObjectCollection rangedOColl = (IObjectCollection)((AbstractObjectCollection)oColl).clone();
            rangedOColl.clear();
            Iterator setIt = idSet.iterator();
            while (setIt.hasNext()) {
                rangedOColl.addObject(oColl.getObject((Object)BOSUuid.read((String)setIt.next().toString())));
            }
            oColl = rangedOColl;
        }
        return this.validate(ctx, oColl, throwException);
    }

    @Override
    public ValidateResult validate(Context ctx, Set idSet, boolean throwException, boolean isForBE) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)this.getSelector(), null);
        IObjectCollection oColl = this.getBizCollection(ctx, evi);
        if (oColl instanceof AbstractObjectCollection) {
            IObjectCollection rangedOColl = (IObjectCollection)((AbstractObjectCollection)oColl).clone();
            rangedOColl.clear();
            Iterator setIt = idSet.iterator();
            while (setIt.hasNext()) {
                rangedOColl.addObject(oColl.getObject((Object)BOSUuid.read((String)setIt.next().toString())));
            }
            oColl = rangedOColl;
        }
        return this.validate(ctx, oColl, throwException, isForBE);
    }

    @Override
    public void validate(Context ctx, IObjectCollection objectCollection) throws BOSException, EASBizException {
        this.validate(ctx, objectCollection, true);
    }

    @Override
    public ValidateResult validate(Context ctx, IObjectCollection objectCollection, boolean throwException) throws BOSException, EASBizException {
        this.init(ctx);
        if (objectCollection == null || objectCollection.size() == 1) {
            throwException = true;
        }
        ValidateResult result = new ValidateResult();
        HashSet<String> validIdSet = new HashSet<String>();
        LinkedHashMap<String, String> errorMsg = new LinkedHashMap<String, String>();
        IObjectCollection validColl = (IObjectCollection)((AbstractObjectCollection)objectCollection).clone();
        validColl.clear();
        int j = objectCollection.size();
        for (int i = 0; i < j; ++i) {
            IObjectValue oValue = objectCollection.getObject(i);
            try {
                this.internValidate(ctx, oValue);
                validIdSet.add(oValue.get(oValue.getPKField()).toString());
                validColl.addObject(oValue);
                continue;
            }
            catch (BOSException e) {
                if (throwException) {
                    throw e;
                }
                e.printStackTrace();
                errorMsg.put(oValue.getString("number"), e.getMessage());
                continue;
            }
            catch (EASBizException e) {
                if (throwException) {
                    throw e;
                }
                e.printStackTrace();
                errorMsg.put(oValue.getString("number"), e.getMessage());
            }
        }
        result.setValidObjColl(validColl);
        result.setValidIdSet(validIdSet);
        result.setErrorMsg(errorMsg);
        return result;
    }

    public ValidateResult validate(Context ctx, IObjectCollection objectCollection, boolean throwException, boolean isForBE) throws BOSException, EASBizException {
        this.init(ctx);
        if (objectCollection == null || objectCollection.size() == 1) {
            throwException = true;
        }
        ValidateResult result = new ValidateResult();
        HashSet<String> validIdSet = new HashSet<String>();
        LinkedHashMap<String, String> errorMsg = new LinkedHashMap<String, String>();
        IObjectCollection validColl = (IObjectCollection)((AbstractObjectCollection)objectCollection).clone();
        validColl.clear();
        int j = objectCollection.size();
        for (int i = 0; i < j; ++i) {
            IObjectValue oValue = objectCollection.getObject(i);
            try {
                this.internValidate(ctx, oValue, isForBE);
                validIdSet.add(oValue.get(oValue.getPKField()).toString());
                validColl.addObject(oValue);
                continue;
            }
            catch (BOSException e) {
                if (throwException) {
                    throw e;
                }
                e.printStackTrace();
                errorMsg.put(oValue.getString("number"), e.getMessage());
                continue;
            }
            catch (EASBizException e) {
                if (throwException) {
                    throw e;
                }
                e.printStackTrace();
                errorMsg.put(oValue.getString("number"), e.getMessage());
            }
        }
        result.setValidObjColl(validColl);
        result.setValidIdSet(validIdSet);
        result.setErrorMsg(errorMsg);
        return result;
    }

    public abstract void internValidate(Context var1, IObjectValue var2) throws BOSException, EASBizException;

    public abstract void internValidate(Context var1, IObjectValue var2, boolean var3) throws BOSException, EASBizException;

    protected abstract IObjectCollection getBizCollection(Context var1, EntityViewInfo var2) throws BOSException;

    protected abstract SelectorItemCollection getSelector();

    protected void init(Context ctx) {
    }
}

