/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.validate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.validate.AbstractPaymentBillValidator;
import com.kingdee.eas.fi.cas.validate.ValidateResult;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IContextHelper;
import java.util.HashSet;

public class PaymentBillPayValidator
extends AbstractPaymentBillValidator {
    private PaymentBillCollection agentBillColl = null;
    private boolean needComit = false;
    private PaymentBillCollection billColl = null;
    private ArApRecPayServerHelper arapHelper = new ArApRecPayServerHelper();

    @Override
    protected void init(Context ctx) {
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = this.billColl != null && this.billColl.size() > 0 ? this.billColl.get(0).getCompany() : ctxHelper.getCurrentCompany();
        this.needComit = ctxHelper.getBooleanParam("CS011", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
    }

    @Override
    public ValidateResult validate(Context ctx, IObjectCollection abstractObjectCollection, boolean throwException) throws BOSException, EASBizException {
        PaymentBillCollection coll = (PaymentBillCollection)abstractObjectCollection;
        this.getAgentBillCollection(ctx, coll);
        this.apValidate(ctx, coll);
        this.billColl = coll;
        return super.validate(ctx, abstractObjectCollection, throwException);
    }

    private void apValidate(Context ctx, PaymentBillCollection coll) throws BOSException, CasForArApException {
        HashSet<String> apSet = new HashSet<String>();
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            PaymentBillInfo info = coll.get(i);
            if (info.getSourceType() != SourceTypeEnum.AP || !info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
            apSet.add(info.getId().toString());
        }
    }

    private void getAgentBillCollection(Context ctx, PaymentBillCollection coll) throws BOSException {
        HashSet<String> agentBillIDSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PaymentBillInfo paymentbill = coll.get(i);
            if (FMHelper.isEmpty((String)paymentbill.getAgentPaymentBillID())) continue;
            agentBillIDSet.add(paymentbill.getAgentPaymentBillID());
        }
        if (agentBillIDSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", agentBillIDSet, CompareType.INCLUDE));
            this.agentBillColl = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
        }
    }

    @Override
    public void internValidate(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        boolean isRecBySettle;
        PaymentBillInfo agentBillInfo;
        String agentBillID;
        PaymentBillInfo info = (PaymentBillInfo)objectValue;
        this.checkAcctViewIsValid(ctx, info);
        if (info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
            throw new RecPayException(RecPayException.CANNOT_PAY_AFTER_PAYED);
        }
        if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
            throw new RecPayException(RecPayException.CANNOT_PAY_BEFORE_AUDITED);
        }
        this.checkPSClose(ctx, info);
        if (info.getSourceType() == SourceTypeEnum.AP) {
            this.arapHelper.checkPayeeForPayment(ctx, info);
        }
        if (this.agentBillColl != null && !FMHelper.isEmpty((String)(agentBillID = info.getAgentPaymentBillID())) && this.agentBillColl.contains(BOSUuid.read((String)agentBillID)) && !BillStatusEnum.PAYED.equals((Object)(agentBillInfo = this.agentBillColl.get(BOSUuid.read((String)agentBillID))).getBillStatus())) {
            throw new CasException(CasException.AGENTBILLNOTPAYCANTPAY);
        }
        if (info.needCommitCH() && this.needComit) {
            throw new RecPayException(RecPayException.CANNOTPAY);
        }
        boolean isRealBill = info.getPaymentBillType().equals((Object)CasRecPayBillTypeEnum.RealType);
        if (!isRealBill && info.getPayerAccount() == null) {
            throw new RecPayException(RecPayException.PAYERACCOUNT_CANNOT_BE_NULL);
        }
        if (info.getSourceType() != SourceTypeEnum.AP && info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && !(isRecBySettle = this.checkIsActionFromSettle(ctx, info.getId().toString()))) {
            this.isCanManualRecPay(ctx, info);
        }
    }

    @Override
    public void internValidate(Context ctx, IObjectValue objectValue, boolean isForBE) throws BOSException, EASBizException {
        boolean isRecBySettle;
        PaymentBillInfo agentBillInfo;
        String agentBillID;
        PaymentBillInfo info = (PaymentBillInfo)objectValue;
        this.checkAcctViewIsValid(ctx, info);
        if (info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
            throw new RecPayException(RecPayException.CANNOT_PAY_AFTER_PAYED);
        }
        if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
            throw new RecPayException(RecPayException.CANNOT_PAY_BEFORE_AUDITED);
        }
        this.checkPSClose(ctx, info);
        if (info.getSourceType() == SourceTypeEnum.AP) {
            this.arapHelper.checkPayeeForPayment(ctx, info);
        }
        if (this.agentBillColl != null && !FMHelper.isEmpty((String)(agentBillID = info.getAgentPaymentBillID())) && this.agentBillColl.contains(BOSUuid.read((String)agentBillID)) && !BillStatusEnum.PAYED.equals((Object)(agentBillInfo = this.agentBillColl.get(BOSUuid.read((String)agentBillID))).getBillStatus())) {
            throw new CasException(CasException.AGENTBILLNOTPAYCANTPAY);
        }
        if (info.needCommitCH() && this.needComit) {
            throw new RecPayException(RecPayException.CANNOTPAY);
        }
        boolean isRealBill = info.getPaymentBillType().equals((Object)CasRecPayBillTypeEnum.RealType);
        if (!isRealBill && info.getPayerAccount() == null) {
            throw new RecPayException(RecPayException.PAYERACCOUNT_CANNOT_BE_NULL);
        }
        if (info.getSourceType() != SourceTypeEnum.AP && info.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && !(isRecBySettle = this.checkIsActionFromSettle(ctx, info.getId().toString()))) {
            this.isCanManualRecPay(ctx, info);
        }
    }
}

