/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaEvaSchemeFactory;
import com.kingdee.eas.fi.fa.basedata.FaEvaSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.IFaEvaScheme;
import com.kingdee.eas.fi.fa.basedata.client.AbstractFaEvaSchemeListUI;
import com.kingdee.eas.fi.fa.basedata.client.FaBaseClientUtils;
import com.kingdee.eas.fi.fa.basedata.client.FaEvaSchemeEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class FaEvaSchemeListUI
extends AbstractFaEvaSchemeListUI {
    private static final long serialVersionUID = -263415253357887831L;

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.EvaScheme");
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.checkComp((Component)this.getUIContext().get("Owner"), aCompanyOrgUnitInfo);
        super.onLoad();
        this.menuItemImportData.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.menuItemExportData.setAccelerator(KeyStroke.getKeyStroke("ctrl shift E"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemLocate.setVisible(true);
        this.menuItemLocate.setEnabled(true);
        Icon iconStaruse = EASResource.getIcon((String)"imgTbtn_staruse");
        Icon iconForbid = EASResource.getIcon((String)"imgTbtn_forbid");
        this.btnCancelCancel.setIcon(iconStaruse);
        this.btnCancel.setIcon(iconForbid);
        this.btnCancelCancel.setVisible(true);
        this.btnCancel.setVisible(true);
        this.menuItemCancelCancel.setIcon(iconStaruse);
        this.menuItemCancel.setIcon(iconForbid);
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    public void initListener() {
        super.initListener();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int selectedRow = FaEvaSchemeListUI.this.tblMain.getSelectManager().get().getTop();
                if (selectedRow < 0) {
                    return;
                }
                String enable = FaEvaSchemeListUI.this.tblMain.getRow(selectedRow).getCell("isEnabled").getValue().toString();
                if (enable.equals("true")) {
                    FaEvaSchemeListUI.this.setBtnStatus(true);
                } else {
                    FaEvaSchemeListUI.this.setBtnStatus(false);
                }
            }
        });
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            this.dealWithRowSet(rowSet);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void dealWithRowSet(IRowSet rs) throws Exception {
        while (rs.next()) {
            String strEvaItems = FaBaseClientUtils.getItemInfo(rs.getString("faEvaItem")).toString();
            strEvaItems = strEvaItems.substring(1, strEvaItems.length() - 1);
            rs.updateObject("faEvaItem", (Object)strEvaItems);
        }
        rs.beforeFirst();
    }

    protected String getEditUIName() {
        return FaEvaSchemeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaEvaSchemeFactory.getRemoteInstance();
    }

    private boolean isEvaSchemeBeCall() throws BOSException {
        String strKey = this.getSelectedKeyValue();
        if (strKey != null) {
            try {
                this.getBizInterface().isReferenced((IObjectPK)new ObjectUuidPK(strKey));
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        return filter;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isEvaSchemeBeCall()) {
            String strResource = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.CanNotEditEvaScheme");
            MsgBox.showInfo((Component)((Object)this), (String)strResource);
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isEvaSchemeBeCall()) {
            String strResource = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.CanNotDelEvaScheme");
            MsgBox.showInfo((Component)((Object)this), (String)strResource);
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setEvaSchemeEnabled(true);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setEvaSchemeEnabled(false);
    }

    private void setEvaSchemeEnabled(boolean enabled) throws Exception {
        String strResource;
        String strKey = this.getSelectedKeyValue();
        if (strKey == null) {
            strResource = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.SelectOneEvaScheme");
            MsgBox.showInfo((Component)((Object)this), (String)strResource);
            SysUtil.abort();
        }
        String strBeginUse = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.BeginUse");
        String strEndUse = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.EndUse");
        String strUse = enabled ? strBeginUse : strEndUse;
        strResource = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.TheEvaScheme");
        int confirm = MsgBox.showConfirm2((Component)((Object)this), (String)(strUse + strResource));
        if (confirm == 0) {
            IFaEvaScheme iEvaScheme = FaEvaSchemeFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(strKey);
            FaEvaSchemeInfo evaSchemeInfo = iEvaScheme.getFaEvaSchemeInfo((IObjectPK)pk);
            evaSchemeInfo.setIsEnabled(enabled);
            iEvaScheme.update((IObjectPK)pk, (CoreBaseInfo)evaSchemeInfo);
            this.actionRefresh_actionPerformed(null);
        }
    }

    private void setBtnStatus(boolean enable) {
        this.btnCancelCancel.setEnabled(!enable);
        this.menuItemCancelCancel.setEnabled(!enable);
        this.btnCancel.setEnabled(enable);
        this.menuItemCancel.setEnabled(enable);
        this.btnEdit.setEnabled(!enable);
        this.menuItemEdit.setEnabled(!enable);
        this.btnRemove.setEnabled(!enable);
        this.menuItemRemove.setEnabled(!enable);
    }

    private void checkComp(Component comp, CompanyOrgUnitInfo aCompanyOrgUnitInfo) {
        if (aCompanyOrgUnitInfo != null) {
            String strMsg;
            if (aCompanyOrgUnitInfo.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)aCompanyOrgUnitInfo.getInvalidDate(), (Date)new Date())) {
                strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Disabled");
                MsgBox.showInfo((Component)comp, (String)strMsg);
                SysUtil.abort();
            }
            if (!aCompanyOrgUnitInfo.isIsBizUnit()) {
                strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun");
                MsgBox.showInfo((Component)comp, (String)strMsg);
                SysUtil.abort();
            }
        } else {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Null");
            MsgBox.showInfo((Component)comp, (String)strMsg);
            SysUtil.abort();
        }
    }
}

