/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.DepreciationMethodEnum;
import com.kingdee.eas.fi.fa.basedata.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.fa.basedata.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.fa.basedata.IFaNewLeasePolicy;
import com.kingdee.eas.fi.fa.basedata.InterestCalculationEnum;
import com.kingdee.eas.fi.fa.basedata.client.AbstractFaNewLeasePolicyEditUI;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.fa.manage.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class FaNewLeasePolicyEditUI
extends AbstractFaNewLeasePolicyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FaNewLeasePolicyEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPreferredSize(new Dimension(600, 450));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setLoadField();
        this.initButtonStatus4Enabled();
        this.firstTwoRadioButton.setVisible(false);
        this.thirdThreeRadioButton.setVisible(false);
        this.thirdFourRadioButton.setVisible(false);
        this.thirdOneRadioButton.setBounds(33, 30, 600, 19);
        this.threePanel.add((Component)this.thirdOneRadioButton, (Object)new KDLayout.Constraints(33, 30, 600, 19, 260));
        this.thirdTwoRadioButton.setBounds(33, 60, 140, 19);
        this.threePanel.add((Component)this.thirdTwoRadioButton, (Object)new KDLayout.Constraints(33, 60, 140, 19, 260));
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.setEditData();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.initButtonStatus();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        IFaNewLeasePolicy iFactory = FaNewLeasePolicyFactory.getRemoteInstance();
        StringBuffer message = new StringBuffer();
        KDTextField focusComp = this.txtNumber;
        String strTemp = null;
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            message.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.strNumberIsNull"));
        } else {
            this.editData.setNumber(this.txtNumber.getText().trim());
            try {
                iFactory.checkNumberDup(this.editData);
            }
            catch (EASBizException e1) {
                this.txtNumber.requestFocus();
                throw e1;
            }
        }
        if (this.editData.getName() == null || this.editData.getName().trim().length() == 0) {
            strTemp = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.strNameIsNull");
            if (message.length() == 0) {
                message.append(strTemp);
                focusComp = this.txtName;
            } else {
                message.append(";");
                message.append(strTemp);
            }
        } else {
            boolean isFileName = StringUtils.isFileName((String)this.editData.getName());
            if (!isFileName) {
                String msg1 = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource.strIllegalName");
                if (message.length() == 0) {
                    message.append(msg1);
                    focusComp = this.txtName;
                } else {
                    message.append(";");
                    message.append(msg1);
                }
            }
            try {
                iFactory.checkNameDup(this.editData);
            }
            catch (EASBizException e1) {
                this.txtName.requestFocus();
                throw e1;
            }
        }
        if (this.editData.getId() != null) {
            // empty if block
        }
        if (message.length() > 0) {
            focusComp.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message.toString());
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        FaNewLeasePolicyInfo faNewLeasePolicyInfo = new FaNewLeasePolicyInfo();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        faNewLeasePolicyInfo.setCompany(aCompanyOrgUnitInfo);
        faNewLeasePolicyInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        if (aCompanyOrgUnitInfo == null || aCompanyOrgUnitInfo.getId() == null) {
            faNewLeasePolicyInfo.setIsGroup(true);
        } else {
            faNewLeasePolicyInfo.setIsGroup(false);
        }
        return faNewLeasePolicyInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaNewLeasePolicyFactory.getRemoteInstance();
    }

    protected void initListener() {
        this.firstOneRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FaNewLeasePolicyEditUI.this.grayDisplayRadioButton();
            }
        });
    }

    private void initButtonStatus() {
        this.btnAddNew.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.txtNumber.setRequired(true);
        this.txtName.setRequired(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.firstTwoRadioButton.setEnabled(false);
        this.initButtonStatus4Enabled();
    }

    private void initButtonStatus4Enabled() {
        if (this.editData == null) {
            return;
        }
        this.btnEdit.setEnabled("VIEW".equals(this.getOprtState()) && this.editData.getDeletedStatus() != 1);
        this.btnSave.setEnabled(this.editData.getDeletedStatus() != 1);
        this.btnCancel.setEnabled(this.editData.getDeletedStatus() == 1);
        this.btnCancelCancel.setEnabled(this.editData.getDeletedStatus() != 1);
        OrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentOrgUnit();
        if (!currentCompany.getId().toString().equals(this.editData.getCompany().getId().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
        }
    }

    private void setEditData() {
        this.setEditDataFromButton();
        this.editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
    }

    private void setEditDataFromButton() {
        if (this.firstOneRadioButton.isSelected()) {
            this.editData.setTranslationMethod(FaLiabilitiesCvMethodEnum.DAY);
        } else {
            this.editData.setTranslationMethod(FaLiabilitiesCvMethodEnum.PERIOD);
        }
        if (this.secondOneRadioButton.isSelected()) {
            this.editData.setDepreciationMethod(DepreciationMethodEnum.First);
        } else {
            this.editData.setDepreciationMethod(DepreciationMethodEnum.Second);
        }
        if (this.thirdOneRadioButton.isSelected()) {
            this.editData.setInterestCalculationMethod(InterestCalculationEnum.FIRST);
        } else if (this.thirdTwoRadioButton.isSelected()) {
            this.editData.setInterestCalculationMethod(InterestCalculationEnum.SECOND);
        } else if (this.thirdThreeRadioButton.isSelected()) {
            this.editData.setInterestCalculationMethod(InterestCalculationEnum.THIRD);
        } else {
            this.editData.setInterestCalculationMethod(InterestCalculationEnum.FORTH);
        }
    }

    private void setLoadField() {
        this.setOprtState(this.oprtState);
        if ("EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            this.setLoadFieldButton();
        }
        this.grayDisplayRadioButton();
    }

    private void setLoadFieldButton() {
        if (this.editData.getTranslationMethod().getValue() == 1) {
            this.firstOneRadioButton.setSelected(true);
        } else {
            this.firstTwoRadioButton.setSelected(true);
        }
        if ("1".equals(this.editData.getDepreciationMethod().getValue())) {
            this.secondOneRadioButton.setSelected(true);
        } else {
            this.secondTwoRadioButton.setSelected(true);
        }
        if (this.editData.getInterestCalculationMethod().getValue() == 1) {
            this.thirdOneRadioButton.setSelected(true);
        } else if (this.editData.getInterestCalculationMethod().getValue() == 2) {
            this.thirdTwoRadioButton.setSelected(true);
        } else if (this.editData.getInterestCalculationMethod().getValue() == 3) {
            this.thirdThreeRadioButton.setSelected(true);
        } else {
            this.thirdFourRadioButton.setSelected(true);
        }
    }

    private void grayDisplayRadioButton() {
        if (this.firstOneRadioButton.isSelected()) {
            this.secondOneRadioButton.setEnabled(true);
            this.secondTwoRadioButton.setEnabled(true);
            this.thirdOneRadioButton.setEnabled(true);
            this.thirdTwoRadioButton.setEnabled(true);
            this.thirdThreeRadioButton.setEnabled(false);
            this.thirdFourRadioButton.setEnabled(false);
            if (this.thirdThreeRadioButton.isSelected() || this.thirdFourRadioButton.isSelected()) {
                this.thirdOneRadioButton.setSelected(true);
                this.thirdThreeRadioButton.setSelected(false);
                this.thirdFourRadioButton.setSelected(false);
            }
        } else {
            this.secondOneRadioButton.setEnabled(false);
            this.secondTwoRadioButton.setEnabled(true);
            if (this.secondOneRadioButton.isSelected()) {
                this.secondOneRadioButton.setSelected(false);
                this.secondTwoRadioButton.setSelected(true);
            }
            this.thirdOneRadioButton.setEnabled(false);
            this.thirdTwoRadioButton.setEnabled(false);
            this.thirdThreeRadioButton.setEnabled(true);
            this.thirdFourRadioButton.setEnabled(true);
            if (this.thirdOneRadioButton.isSelected() || this.thirdTwoRadioButton.isSelected()) {
                this.thirdOneRadioButton.setSelected(false);
                this.thirdTwoRadioButton.setSelected(false);
                this.thirdThreeRadioButton.setSelected(true);
            }
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
        this.lockUIForViewStatus();
        this.setOprtState("VIEW");
        this.initButtonStatus4Enabled();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyIfRefToNewLeaseBill();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.verifyIfRefToNewLeaseBill();
        super.actionRemove_actionPerformed(e);
    }

    private void verifyIfRefToNewLeaseBill() throws BOSException, EASBizException {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        if (FaLeaseInBillNewFactory.getRemoteInstance().exists("where newLeasePolicyRef = '" + this.editData.getId().toString() + "'")) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"72_FaNewLeasePolicyEditUI"));
            SysUtil.abort();
        }
    }
}

