/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.def.client;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.agent.AgentException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.UILifeCycleEvent;
import com.kingdee.eas.framework.client.UILifeCycleImp;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DetailPanelNoCon
extends JPanel {
    private static final long serialVersionUID = -5058182349722236713L;
    private static final Logger logger = Logger.getLogger(DetailPanelNoCon.class);
    protected KDWorkButton btnAddnewLine;
    protected KDWorkButton btnInsertLine;
    protected KDWorkButton btnRemoveLines;
    protected KDPanel controlPanel;
    protected KDTable entryTable;
    protected KDPanel entryPanel;
    protected HashMap resourceMap = null;
    protected DataBinder dataBinder = null;
    private AbstractObjectValue newDetailInfo = null;
    private Rectangle rect = null;
    private boolean isAgent = false;
    private CoreUI ui = null;
    private Set addListeners = new HashSet();
    private Set removeListeners = new HashSet();
    private Set insertListeners = new HashSet();

    public DetailPanelNoCon(CoreUI ui, DataBinder binder, KDTable kdt, AbstractObjectValue newVO, HashMap resourceMap, boolean isAgent) throws Exception {
        this(binder, kdt, newVO, resourceMap, isAgent);
        this.ui = ui;
        this.ui.getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)new UILifeListener());
    }

    public DetailPanelNoCon(DataBinder binder, KDTable kdt, AbstractObjectValue newVO, HashMap resourceMap, boolean isAgent) throws Exception {
        CtrlUIEnv.setKingdeeLAF();
        this.jbInit();
        this.dataBinder = binder;
        this.entryTable = kdt;
        this.rect = this.entryTable.getBounds();
        this.newDetailInfo = newVO;
        this.resourceMap = resourceMap;
        this.isAgent = isAgent;
        this.initKDWorkButtion();
        this.initUIContentLayout();
    }

    private void initStatus(String oprtStatus) {
        if (this.ui != null) {
            boolean enabled = false;
            if (!OprtState.VIEW.equals(oprtStatus)) {
                enabled = true;
            }
            this.btnAddnewLine.setEnabled(enabled);
            this.btnInsertLine.setEnabled(enabled);
            this.btnRemoveLines.setEnabled(enabled);
        }
    }

    private void jbInit() throws Exception {
        this.btnAddnewLine = new KDWorkButton();
        this.btnInsertLine = new KDWorkButton();
        this.btnRemoveLines = new KDWorkButton();
        this.controlPanel = new KDPanel();
        this.entryTable = new KDTable();
        this.entryPanel = new KDPanel();
        this.btnAddnewLine.setName("btnAddnewLine");
        this.btnInsertLine.setName("btnInsertLine");
        this.btnRemoveLines.setName("btnRemoveLines");
        this.controlPanel.setName("controlPanel");
        this.entryTable.setName("entryTable");
        this.entryPanel.setName("entryPanel");
        this.btnAddnewLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DetailPanelNoCon.this.actionAddnewLine_actionPerformed(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                    logger.debug((Object)("addLine error:" + e));
                }
            }
        });
        this.btnInsertLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DetailPanelNoCon.this.actionInsertLine_actionPerformed(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                    logger.debug((Object)("InsertLine error:" + e));
                }
            }
        });
        this.btnRemoveLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DetailPanelNoCon.this.actionRemoveLine_actionPerformed(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                    logger.debug((Object)("RemoveLine error:" + e));
                }
            }
        });
    }

    public KDWorkButton getAddNewLineButton() {
        return this.btnAddnewLine;
    }

    public KDWorkButton getInsertLineButton() {
        return this.btnInsertLine;
    }

    public KDWorkButton getRemoveLinesButton() {
        return this.btnRemoveLines;
    }

    public KDTable getEntryTable() {
        return this.entryTable;
    }

    public void initKDWorkButtion() {
        this.btnAddnewLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_AddLine"));
        this.btnAddnewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_InsertLine"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLines.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_RemoveLine"));
        this.btnRemoveLines.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public void initUIContentLayout() {
        this.setBounds(this.entryTable.getBounds());
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, this.rect.width, this.rect.height));
        this.setBounds(this.entryTable.getBounds());
        Rectangle controlRect = new Rectangle(0, 0, this.rect.width, 24);
        this.controlPanel.setBounds(controlRect);
        this.controlPanel.putClientProperty((Object)"OriginalBounds", (Object)controlRect);
        Rectangle entryRect = new Rectangle(0, 29, this.rect.width, this.rect.height - 29);
        this.entryPanel.setBounds(entryRect);
        this.entryPanel.putClientProperty((Object)"OriginalBounds", (Object)entryRect);
        this.add((Component)this.controlPanel, new KDLayout.Constraints(13, controlRect));
        this.add((Component)this.entryPanel, new KDLayout.Constraints(15, entryRect));
        this.controlPanel.setLayout((LayoutManager)new KDLayout());
        this.controlPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.rect.width, 24));
        this.controlPanel.add((Component)this.btnAddnewLine, (Object)new KDLayout.Constraints(this.rect.width - 86, 5, 22, 19, 9));
        this.controlPanel.add((Component)this.btnInsertLine, (Object)new KDLayout.Constraints(this.rect.width - 59, 5, 22, 19, 9));
        this.controlPanel.add((Component)this.btnRemoveLines, (Object)new KDLayout.Constraints(this.rect.width - 32, 5, 22, 19, 9));
        this.entryPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.entryTable.setBounds(entryRect);
        this.entryPanel.add((Component)this.entryTable, (Object)"Center");
    }

    public void actionAddnewLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(this.entryTable);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.insertLine(this.entryTable);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.entryTable);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (table == null) {
            return null;
        }
        if (this.isAgent) {
            EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.newDetailInfo.getBOSType());
            try {
                Class<?> agentClz = Class.forName(entity.getBusinessAgent());
                Method method = agentClz.getMethod("copyOvAsNewAgent", IObjectValue.class);
                Object obj = method.invoke(agentClz, this.newDetailInfo);
                if (obj instanceof IObjectValue) {
                    return (IObjectValue)obj;
                }
                return null;
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e);
                throw new AgentException((Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new AgentException("Exception at creating agent instance from BOS value object:" + this.newDetailInfo, (Throwable)e);
            }
        }
        return (IObjectValue)this.newDetailInfo.clone();
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void addLine(KDTable table) throws Exception {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = table.addRow();
        this.loadLineFields(table, row, detailData);
    }

    protected void insertLine(KDTable table) throws Exception {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.loadLineFields(table, row, detailData);
    }

    protected void removeLine(KDTable table) throws Exception {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = table.getSelectManager().get().getTop();
        if (table.getRow(top) == null) {
            MsgBox.showInfo((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        IObjectValue detailData = (IObjectValue)table.getRow(top).getUserObject();
        table.removeRow(top);
        IObjectCollection collection = (IObjectCollection)table.getUserObject();
        if (collection == null) {
            logger.error((Object)"collection not be binded to table");
        } else if (detailData != null) {
            collection.removeObject(top);
        }
    }

    protected IObjectCollection getBindData(KDTable table) {
        return (IObjectCollection)table.getUserObject();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.storeLineFields(table, row, obj);
    }

    class UILifeListener
    extends UILifeCycleImp {
        UILifeListener() {
        }

        public void beforeOnload(UILifeCycleEvent event) {
            CoreUI ui = (CoreUI)event.getSource();
            DetailPanelNoCon.this.initStatus(ui.getOprtState());
        }

        public void onSetDataObject(UILifeCycleEvent event) {
            this.beforeOnload(event);
        }
    }
}

