/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.def.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.def.DefCompanyFilterUtil;
import com.kingdee.eas.fi.fa.def.FaDefCommonFacadeFactory;
import com.kingdee.eas.fi.fa.def.FaDefStyleFactory;
import com.kingdee.eas.fi.fa.def.client.AbstractFaDefStyleListUI;
import com.kingdee.eas.fi.fa.def.client.FaDefStyleEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FaDefStyleListUI
extends AbstractFaDefStyleListUI {
    private static final Logger logger = CoreUIObject.getLogger(FaDefStyleListUI.class);

    public FaDefStyleListUI() throws Exception {
        this.tblMain.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                FaDefStyleListUI.this.lockAction();
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.lockAction();
    }

    protected void execQuery() {
        super.execQuery();
        this.lockAction();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.execQuery();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FaDefStyleFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return FaDefStyleEditUI.class.getName();
    }

    protected void lockAction() {
        String cpName = SysContext.getSysContext().getCurrentFIUnit().getName();
        boolean falg = false;
        boolean isUserdByAssetCat = false;
        int[] selects = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selects.length; ++i) {
            if (this.tblMain.getRow(selects[i]) != null) {
                Object value = this.tblMain.getRow(selects[i]).getCell("company").getValue();
                if (!cpName.equalsIgnoreCase(value.toString())) {
                    falg = true;
                }
                Object styleId = this.tblMain.getRow(selects[i]).getCell("id").getValue();
                try {
                    isUserdByAssetCat = FaDefCommonFacadeFactory.getRemoteInstance().isUsedStyleByAssetCat(styleId.toString()) || isUserdByAssetCat;
                }
                catch (Exception e1) {
                    this.handleException(e1);
                }
                continue;
            }
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            return;
        }
        if (falg) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            if (isUserdByAssetCat) {
                this.actionRemove.setEnabled(false);
            } else {
                this.actionRemove.setEnabled(true);
            }
            this.actionEdit.setEnabled(selects.length == 1);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return DefCompanyFilterUtil.createDefFilter(SysContext.getSysContext().getCurrentFIUnit().getLongNumber());
    }
}

