/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.def.client.design;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.fi.fa.def.client.design.layout.DesignPanel;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class PropertyDragHelper {
    private KDTree tree;

    public PropertyDragHelper(KDTree c) {
        this.tree = c;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer((Component)c, 3, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                TreePath path = PropertyDragHelper.this.tree.getSelectionPath();
                if (path != null) {
                    DefaultMutableTreeNode selection = (DefaultMutableTreeNode)path.getLastPathComponent();
                    DragAndDropTransferable object = new DragAndDropTransferable(selection);
                    dge.startDrag(DragSource.DefaultCopyDrop, object, new DragAndDropDragSourceListener());
                }
            }
        });
    }

    public void addTarget(Component c) {
        new DropTarget(c, new DragAndDropDropTargetListener());
    }

    class DragAndDropDropTargetListener
    implements DropTargetListener {
        DragAndDropDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            DropTarget target = (DropTarget)dtde.getSource();
            Component c = target.getComponent();
            if (c instanceof DesignPanel) {
                DesignPanel dp = (DesignPanel)((Object)c);
                TreePath path = PropertyDragHelper.this.tree.getSelectionPath();
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                if (node.getUserObject() instanceof FaDefPropertyInfo) {
                    dtde.dropComplete(true);
                    FaDefPropertyInfo p = (FaDefPropertyInfo)node.getUserObject();
                    dp.addProperty(dtde.getLocation(), p);
                } else {
                    dtde.dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        }
    }

    class DragAndDropDragSourceListener
    implements DragSourceListener {
        DragAndDropDragSourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext context = dragSourceDragEvent.getDragSourceContext();
            int dropAction = dragSourceDragEvent.getDropAction();
            if ((dropAction & 1) != 0) {
                context.setCursor(DragSource.DefaultCopyDrop);
            } else if ((dropAction & 2) != 0) {
                context.setCursor(DragSource.DefaultMoveDrop);
            } else {
                context.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    class DragAndDropTransferable
    implements Transferable {
        private DefaultMutableTreeNode treeNode;
        private DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor};

        private DragAndDropTransferable(DefaultMutableTreeNode treeNode) {
            this.treeNode = treeNode;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.treeNode.getChildCount() == 0;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.treeNode;
        }
    }
}

