/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.def.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.fa.def.FaDefPropertyCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;

public class SplitPropertyValue {
    private SplitPropertyValue() {
    }

    public static FaDefPropertyValueCollection splitByAvg(FaDefPropertyValueInfo info, int count) throws BOSException {
        int[] weight = new int[count];
        Arrays.fill(weight, 1);
        return SplitPropertyValue.split(info, weight);
    }

    public static FaDefPropertyValueCollection splitByRateMap(FaDefPropertyValueInfo info, Map map) throws BOSException {
        int[] weight = new int[map.size()];
        for (int i = 0; i < weight.length; ++i) {
            String v = (String)map.get(String.valueOf(i + 1));
            weight[i] = v != null && v.matches("\\d+") ? Integer.parseInt(v) : 0;
        }
        return SplitPropertyValue.split(info, weight);
    }

    public static FaDefPropertyValueCollection split(FaDefPropertyValueInfo info, int[] weight) throws BOSException {
        FaDefPropertyValueCollection sc = new FaDefPropertyValueCollection();
        float total = 0.0f;
        for (int i = 0; i < weight.length; ++i) {
            total += (float)weight[i];
        }
        FaDefPropertyCollection pc = FaDefPropertyFactory.getRemoteInstance().getFaDefPropertyCollection();
        int n = weight.length;
        for (int i = 0; i < n; ++i) {
            float percent = total == 0.0f ? 0.0f : (float)weight[i] / total;
            sc.add(SplitPropertyValue.split(info, pc, percent, i == n - 1, sc));
        }
        return sc;
    }

    private static FaDefPropertyValueInfo split(FaDefPropertyValueInfo info, FaDefPropertyCollection pc, float percent, boolean lastItem, FaDefPropertyValueCollection sc) {
        if (info != null) {
            FaDefPropertyValueInfo ret = (FaDefPropertyValueInfo)info.clone();
            ret.setId(null);
            int n = pc.size();
            for (int i = 0; i < n; ++i) {
                BigDecimal splitValue;
                BigDecimal value;
                FaDefPropertyInfo p = pc.get(i);
                if (p.getType().getValue() != 2 || !p.isIsAttendSplitBill() || (value = (BigDecimal)info.get(p.getNumber())) == null || value.doubleValue() == 0.0) continue;
                if (lastItem) {
                    splitValue = value;
                    for (int j = 0; j < sc.size(); ++j) {
                        splitValue = splitValue.subtract((BigDecimal)sc.get(j).get(p.getNumber()));
                    }
                } else {
                    splitValue = value.multiply(new BigDecimal(Float.toString(percent)));
                }
                ret.put(p.getNumber(), splitValue);
                ret.getPropertyValueMap().put("f" + p.getNumber(), splitValue);
            }
            return ret;
        }
        return new FaDefPropertyValueInfo();
    }
}

