/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FALeaseContractInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCombinBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.FaMortagBillInfo;
import com.kingdee.eas.fi.fa.manage.FaSplitBillInfo;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillInfo;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FaBillBizProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.FaBillBizProcessor");
    private static HashMap querySqlCache = new HashMap();
    public static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";

    public static void lockTable(Context ctx, String pk) throws BOSException {
        if (pk == null) {
            return;
        }
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)pk, (boolean)true);
        if (bosType == null) {
            return;
        }
        String querySql = FaBillBizProcessor.getSqlByPK(ctx, bosType);
        if (bosType.toString().equals(new FaCurCardInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaChangeBillInfo().getBOSType().toString()) || bosType.toString().equals(new FaBizCardInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_fachangebill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaClearBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_clearbill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaSplitBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_fasplitbill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
            boolean is_mssql = FaBillBizProcessor.isMsSqlServer(ctx);
            if (is_mssql) {
                String updateSql = "/*dialect*/ update T_FA_FASPLITBILL WITH (TABLOCK) set fcreatetime = fcreatetime where fid= ?";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{pk});
            }
        } else if (bosType.toString().equals(new FaCombinBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_facombinbill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
            boolean is_mssql = FaBillBizProcessor.isMsSqlServer(ctx);
            if (is_mssql) {
                String updateSql = "/*dialect*/ update T_FA_FACOMBINBILL WITH (TABLOCK) set fcreatetime = fcreatetime where fid= ?";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{pk});
            }
        } else if (bosType.toString().equals(new FaDispatchBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_fadispatchbill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaEvaluateBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_faevaluatebill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaLeaseBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_faleasebill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaMortagBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_famortagbill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaStocktakingTaskBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update T_FA_StocktakingTaskBill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaDecValueInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_fadecvalue set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaLeaseInBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_faleaseinbill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FALeaseContractInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_faleasecontract set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaLeaseInBillNewInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_faleaseinbillnew set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        } else if (bosType.toString().equals(new FaLeaseChangeBillInfo().getBOSType().toString())) {
            DbUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{pk});
            DbUtil.execute((Context)ctx, (String)"update t_fa_faleasechangebill set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
        }
    }

    private static String getSqlByPK(Context ctx, BOSObjectType bosType) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(bosType);
        return "select FID  from " + entity.getTable().getName() + " where FID=?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMsSqlServer(Context ctx) {
        Connection conn = null;
        try {
            boolean i;
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            boolean bl = i = 3 == dbType;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return false;
    }

    public static void clearCache() {
        querySqlCache.clear();
    }

    public static void lockFaCurCard(Context ctx, String pk) throws BOSException {
        if (pk == null) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)"select fid from t_fa_facurcard where fid = ?", (Object[])new Object[]{pk});
        DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
    }

    public static Timestamp lockCurCard(Context ctx, String pk) throws BOSException {
        Timestamp timestamp = null;
        if (pk != null) {
            String sql = "select fnumber, flastupdatetime from t_fa_facurcard where fid = ?";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk});
                if (rs.next()) {
                    timestamp = rs.getTimestamp("flastupdatetime");
                }
                DbUtil.execute((Context)ctx, (String)"select fid from t_fa_facurcard where fid = ?", (Object[])new Object[]{pk});
                DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set fcompanyid = fcompanyid where fid = ?", (Object[])new Object[]{pk});
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return timestamp;
    }

    public static void checkFaCurCardVersion(Context ctx, String pk, Timestamp updateTime) throws BOSException, EASBizException {
        if (pk == null || updateTime == null) {
            return;
        }
        String sql = "select fnumber, flastupdatetime from t_fa_facurcard where fid = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk});
            while (rs.next()) {
                Timestamp time = rs.getTimestamp("flastupdatetime");
                if (time == null) continue;
                String number = rs.getString("fnumber");
                if (time.getTime() == updateTime.getTime()) continue;
                String faCardChanged = FaLocalUtils.getResource((Context)ctx, (String)FACARDRESOURCE, (String)"FACARD_HASCHANGED");
                throw new EASBizException(new NumericExceptionSubItem("1", faCardChanged), (Object[])new String[]{number});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

