/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeCollection;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaEconomicPurpFactory;
import com.kingdee.eas.fi.fa.basedata.FaEconomicPurpInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusFactory;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FaCardCache {
    private static final ThreadLocal<FaCardCache> caches = new ThreadLocal();
    private String cacheId;
    private Map<String, Object> datas = new HashMap<String, Object>();

    private FaCardCache(String cacheId) {
        this.cacheId = cacheId;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public static boolean isCache(Context ctx) {
        return caches.get() != null;
    }

    public static FaCardCache getCache() {
        return caches.get();
    }

    public static void initCache(String cacheId) {
        FaCardCache cache = FaCardCache.getCache();
        if (cache == null) {
            cache = new FaCardCache(cacheId);
            caches.set(cache);
        }
    }

    public static void clearCache(String cacheId) {
        FaCardCache cache = FaCardCache.getCache();
        if (cache != null && cacheId.equals(cache.getCacheId())) {
            caches.set(null);
        }
    }

    public static HashMap getFAParameter(BOSUuid id, Context ctx) throws EASBizException, BOSException {
        FaCardCache cache = FaCardCache.getCache();
        if (cache != null) {
            return cache.getFAParameterFromCache(id, ctx);
        }
        return FaManageUtils.getFAParameter(id, ctx);
    }

    public HashMap getFAParameterFromCache(BOSUuid id, Context ctx) throws EASBizException, BOSException {
        String key = "FAParameter_" + id.toString();
        if (this.datas.containsKey(key)) {
            return (HashMap)this.datas.get(key);
        }
        HashMap params = FaManageUtils.getFAParameter(id, ctx);
        this.datas.put(key, params);
        return params;
    }

    public static PeriodInfo getCurrentPeriod(Context ctx) throws BOSException, EASBizException {
        return FaCardCache.getCurrentPeriod(ctx, FaLocalUtils.getCurrentCompanyId((Context)ctx));
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, String companyID) throws BOSException, EASBizException {
        FaCardCache cache = FaCardCache.getCache();
        if (cache != null) {
            return cache.getCurrentPeriodFromCache(ctx, companyID);
        }
        return FaLocalUtils.getCurrentPeriod((Context)ctx, (String)companyID);
    }

    public PeriodInfo getCurrentPeriodFromCache(Context ctx, String companyID) throws BOSException, EASBizException {
        String key = "CurrentPeriod_" + companyID;
        if (this.datas.containsKey(key)) {
            return (PeriodInfo)this.datas.get(key);
        }
        PeriodInfo period = FaLocalUtils.getCurrentPeriod((Context)ctx, (String)companyID);
        this.datas.put(key, period);
        return period;
    }

    public void cacheMonCardNum(String number) {
        HashSet<String> monCardNums = (HashSet<String>)this.datas.get("monCardNums");
        if (monCardNums == null) {
            monCardNums = new HashSet<String>();
            this.datas.put("monCardNums", monCardNums);
        }
        monCardNums.add(number);
    }

    public boolean hasMonCardNum(String number) {
        Set monCardNums = (Set)this.datas.get("monCardNums");
        if (monCardNums == null) {
            return false;
        }
        return monCardNums.contains(number);
    }

    public void cacheCurCard(FaCurCardInfo info) {
        HashMap<String, FaCurCardInfo> curCards = (HashMap<String, FaCurCardInfo>)this.datas.get("curCards");
        if (curCards == null) {
            curCards = new HashMap<String, FaCurCardInfo>();
            this.datas.put("curCards", curCards);
        }
        curCards.put(info.getNumber(), info);
    }

    public FaCurCardInfo getCurCard(String number) {
        Map curCards = (Map)this.datas.get("curCards");
        if (curCards == null) {
            return null;
        }
        return (FaCurCardInfo)curCards.get(number);
    }

    public void cacheInfos(Context ctx, String dataType, String prefix, Set<String> numbers, Map<String, Object> params) throws BOSException {
        Set<String> subNumbers;
        String key = prefix == null ? dataType : prefix + "_" + dataType;
        HashMap<String, Object> infos = (HashMap<String, Object>)this.datas.get(key);
        if (infos == null) {
            infos = new HashMap<String, Object>();
            this.datas.put(key, infos);
        }
        if (infos.size() > 0) {
            subNumbers = new HashSet<String>();
            for (String number : numbers) {
                if (infos.containsKey(number)) continue;
                subNumbers.add(number);
            }
        } else {
            subNumbers = numbers;
        }
        if (subNumbers.size() <= 0) {
            return;
        }
        if (subNumbers.size() <= 50) {
            this.doCacheInfos(ctx, dataType, infos, subNumbers, params);
        } else {
            HashSet<String> sonNumbers = new HashSet<String>();
            for (String number : subNumbers) {
                sonNumbers.add(number);
                if (sonNumbers.size() < 50) continue;
                this.doCacheInfos(ctx, dataType, infos, sonNumbers, params);
                sonNumbers = new HashSet();
            }
            if (sonNumbers.size() > 0) {
                this.doCacheInfos(ctx, dataType, infos, sonNumbers, params);
            }
        }
    }

    private void doCacheInfos(Context ctx, String dataType, Map<String, Object> infos, Set<String> subNumbers, Map<String, Object> params) throws BOSException {
        block13: {
            EntityViewInfo view;
            block18: {
                FaDepreciationModeCollection coll;
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block12: {
                                    for (String number : subNumbers) {
                                        infos.put(number, null);
                                    }
                                    if (!"deprModes".equals(dataType)) break block12;
                                    view = this.getBaseDataView(subNumbers, true, false, params);
                                    coll = FaDepreciationModeFactory.getLocalInstance((Context)ctx).getFaDepreciationModeCollection(view);
                                    for (int i = 0; i < coll.size(); ++i) {
                                        infos.put(coll.get(i).getNumber(), coll.get(i));
                                    }
                                    break block13;
                                }
                                if (!"assetCats".equals(dataType)) break block14;
                                view = this.getOuIsolateView(subNumbers, true, true, params);
                                view.getSelector().add("DepreciationPolicy.DeprRule");
                                coll = FaCatFactory.getLocalInstance((Context)ctx).getFaCatCollection(view);
                                for (int i = 0; i < coll.size(); ++i) {
                                    infos.put(coll.get(i).getNumber(), coll.get(i));
                                }
                                break block13;
                            }
                            if (!"measureUnits".equals(dataType)) break block15;
                            view = this.getBaseDataView(subNumbers, false, false, params);
                            coll = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(view);
                            for (int i = 0; i < coll.size(); ++i) {
                                infos.put(coll.get(i).getNumber(), coll.get(i));
                            }
                            break block13;
                        }
                        if (!"origins".equals(dataType)) break block16;
                        view = this.getOuIsolateView(subNumbers, true, true, params);
                        coll = FaAlterModeFactory.getLocalInstance((Context)ctx).getFaAlterModeCollection(view);
                        for (int i = 0; i < coll.size(); ++i) {
                            infos.put(coll.get(i).getNumber(), coll.get(i));
                        }
                        break block13;
                    }
                    if (!"usestatuses".equals(dataType)) break block17;
                    view = this.getOuIsolateView(subNumbers, true, true, params);
                    coll = FaUseStatusFactory.getLocalInstance((Context)ctx).getFaUseStatusCollection(view);
                    for (int i = 0; i < coll.size(); ++i) {
                        infos.put(coll.get(i).getNumber(), coll.get(i));
                    }
                    break block13;
                }
                if (!"economyPurposes".equals(dataType)) break block18;
                view = this.getOuIsolateView(subNumbers, true, true, params);
                coll = FaEconomicPurpFactory.getLocalInstance((Context)ctx).getFaEconomicPurpCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    infos.put(coll.get(i).getNumber(), coll.get(i));
                }
                break block13;
            }
            if ("storeCitys".equals(dataType)) {
                String sql = "SELECT ADDRESS.FID,ADDRESS.FNUMBER FROM T_BD_Address ADDRESS INNER JOIN T_ORG_CtrlUnit CU ON ADDRESS.FControlUnitID = CU.FID WHERE (ADDRESS.FAdminCUID = ? OR ADDRESS.FID IN (SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE (FBOSObjectType = 'A8E556C9' AND FAssignCUID = ?))) AND ADDRESS.FNUMBER ";
                sql = subNumbers.size() == 1 ? sql + "= ?" : sql + "in " + this.toInSql(subNumbers);
                String cuId = (String)params.get("cuId");
                try {
                    IRowSet rs = subNumbers.size() == 1 ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{cuId, cuId, subNumbers.iterator().next()}) : DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{cuId, cuId});
                    while (rs.next()) {
                        AddressInfo addressInfo = new AddressInfo();
                        String addressId = rs.getString("FID");
                        addressInfo.setId(BOSUuid.read((String)addressId));
                        String number = rs.getString("FNUMBER");
                        addressInfo.setNumber(number);
                        infos.put(number, addressInfo);
                    }
                }
                catch (Exception e) {
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
            }
            if (!"accounts".equals(dataType)) break block13;
            view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", subNumbers, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", params.get("companyId")));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", params.get("tableId")));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            view.setSelector(selector);
            AccountViewCollection coll = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                infos.put(coll.get(i).getNumber(), coll.get(i));
            }
        }
    }

    private String toInSql(Set<String> numbers) {
        StringBuffer sql = new StringBuffer();
        for (String number : numbers) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append("'").append(number).append("'");
        }
        return "(" + sql.toString() + ")";
    }

    private EntityViewInfo getBaseDataView(Set<String> numbers, boolean getAll, boolean isCuIsoluate, Map<String, Object> params) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        if (isCuIsoluate) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", params.get("cuId")));
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        if (getAll) {
            selector.add("*");
        } else {
            selector.add("id");
            selector.add("number");
        }
        return view;
    }

    private EntityViewInfo getOuIsolateView(Set<String> numbers, boolean getAll, boolean isOuIsoluate, Map<String, Object> params) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        if (isOuIsoluate) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", params.get("companyId")));
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        if (getAll) {
            selector.add("*");
        } else {
            selector.add("id");
            selector.add("number");
        }
        return view;
    }

    public FaDepreciationModeInfo getDeprModeInfo(Context ctx, String number) throws TaskExternalException {
        if (number == null || number.length() == 0) {
            return null;
        }
        Map infos = (Map)this.datas.get("deprModes");
        FaDepreciationModeInfo info = (FaDepreciationModeInfo)infos.get(number);
        if (info == null) {
            FaCardCache.procException(ctx, FaResUtil.getRes((String)"dprMethod", (Locale)ctx.getOriginLocale()), number);
        }
        return info;
    }

    public FaCatInfo getFaCatInfo(Context ctx, String companyId, String number) throws TaskExternalException {
        if (number == null || number.length() == 0) {
            return null;
        }
        Map infos = (Map)this.datas.get(companyId + "_assetCats");
        FaCatInfo info = (FaCatInfo)infos.get(number);
        if (info == null) {
            FaCardCache.procException(ctx, FaResUtil.getRes((String)"assetCat", (Locale)ctx.getOriginLocale()), number);
        }
        return info;
    }

    public MeasureUnitInfo getMeasureUnitInfo(Context ctx, String number) throws TaskExternalException {
        if (number == null || number.length() == 0) {
            return null;
        }
        Map infos = (Map)this.datas.get("measureUnits");
        MeasureUnitInfo info = (MeasureUnitInfo)infos.get(number);
        if (info == null) {
            FaCardCache.procException(ctx, FaResUtil.getRes((String)"measureunitInfo", (Locale)ctx.getOriginLocale()), number);
        }
        return info;
    }

    public FaAlterModeInfo getFaAlterModeInfo(Context ctx, String companyId, String number) throws TaskExternalException {
        if (number == null || number.length() == 0) {
            return null;
        }
        Map infos = (Map)this.datas.get(companyId + "_origins");
        FaAlterModeInfo info = (FaAlterModeInfo)infos.get(number);
        if (info == null) {
            FaCardCache.procException(ctx, FaResUtil.getRes((String)"OriginMethod", (Locale)ctx.getOriginLocale()), number);
        }
        return info;
    }

    public FaUseStatusInfo getFaUseStatusInfo(Context ctx, String companyId, String number) throws TaskExternalException {
        if (number == null || number.length() == 0) {
            return null;
        }
        Map infos = (Map)this.datas.get(companyId + "_usestatuses");
        FaUseStatusInfo info = (FaUseStatusInfo)infos.get(number);
        if (info == null) {
            FaCardCache.procException(ctx, FaResUtil.getRes((String)"statusInfo", (Locale)ctx.getOriginLocale()), number);
        }
        return info;
    }

    public FaEconomicPurpInfo getFaEconomicPurpInfo(Context ctx, String companyId, String number) throws TaskExternalException {
        if (number == null || number.length() == 0) {
            return null;
        }
        Map infos = (Map)this.datas.get(companyId + "_economyPurposes");
        FaEconomicPurpInfo info = (FaEconomicPurpInfo)infos.get(number);
        if (info == null) {
            FaCardCache.procException(ctx, FaResUtil.getRes((String)"economicPurp", (Locale)ctx.getOriginLocale()), number);
        }
        return info;
    }

    public AddressInfo getAddressInfo(Context ctx, String cuId, String number) throws TaskExternalException {
        if (number == null || number.length() == 0) {
            return null;
        }
        Map infos = (Map)this.datas.get(cuId + "_storeCitys");
        AddressInfo info = (AddressInfo)infos.get(number);
        if (info == null) {
            FaCardCache.procException(ctx, FaResUtil.getRes((String)"noAddress", (Locale)ctx.getOriginLocale()), number);
        }
        return info;
    }

    public MeasureUnitInfo getWLMeasureUnitInfo(Context ctx, String number) throws TaskExternalException {
        if (number == null || number.length() == 0) {
            return null;
        }
        Map infos = (Map)this.datas.get("measureUnits");
        MeasureUnitInfo info = (MeasureUnitInfo)infos.get(number);
        if (info == null) {
            FaCardCache.procException(ctx, FaResUtil.getRes((String)"wlMeasureunitInfo", (Locale)ctx.getOriginLocale()), number);
        }
        return info;
    }

    public AccountViewInfo getAcctViewInfo(Context ctx, String companyId, String number) throws TaskExternalException {
        if (number == null || number.length() == 0) {
            return null;
        }
        Map infos = (Map)this.datas.get(companyId + "_accounts");
        AccountViewInfo info = (AccountViewInfo)infos.get(number);
        if (info == null) {
            FaCardCache.procException(ctx, FaResUtil.getRes((String)"accountView", (Locale)ctx.getOriginLocale()), number);
        }
        return info;
    }

    private static void procException(Context ctx, String title, String number) throws TaskExternalException {
        StringBuffer buffer = new StringBuffer();
        Locale locale = ctx.getOriginLocale();
        buffer.append("[" + FaResUtil.getRes((String)"number5", (Locale)locale) + number + "]");
        throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"noMatchPassBy", (Locale)locale), buffer, title));
    }

    public boolean isGgoupFirstCardNumber(Context ctx, IObjectValue caller, String org, String bindingproperty) throws EASBizException, BOSException {
        String key = "GgoupFirst_" + org;
        if (this.datas.containsKey(key)) {
            return (Boolean)this.datas.get(key);
        }
        boolean isGgoupFirst = FaLocalUtils.isGgoupFirstCardNumber((Context)ctx, (IObjectValue)caller, (String)org, (String)bindingproperty);
        this.datas.put(key, isGgoupFirst);
        return isGgoupFirst;
    }
}

